/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.TagTester;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.wms.web.data.ExternalGraphicPanel;
import org.geoserver.wms.web.data.StyleEditPage;
import org.geoserver.wms.web.data.StyleFormatsModel;
import org.geoserver.wms.web.data.StyleNewPage;
import org.geoserver.wms.web.data.StylePage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StyleNewPageTest
extends GeoServerWicketTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        File file = this.getResourceLoader().createFile(new String[]{"styles", "legend.png"});
        this.getResourceLoader().copyFromClassPath("legend.png", file, ((Object)((Object)this)).getClass());
    }

    @Before
    public void setUp() throws Exception {
        this.login();
        tester.startPage(StyleNewPage.class);
    }

    @Test
    public void testLoad() throws Exception {
        tester.assertRenderedPage(StyleNewPage.class);
        tester.assertNoErrorMessage();
        tester.assertComponent("styleForm:context:panel:name", TextField.class);
        tester.assertComponent("styleForm:styleEditor:editorContainer:editorParent:editor", TextArea.class);
        tester.assertComponent("styleForm:context:panel:filename", FileUploadField.class);
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:showhide:show", "click");
        tester.assertComponent("styleForm:context:panel:legendPanel", ExternalGraphicPanel.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:onlineResource", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:width", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:height", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:format", TextField.class);
        tester.assertModelValue("styleForm:context:panel:name", (Object)"");
    }

    @Test
    public void testCopyFormat() {
        FormTester form = tester.newFormTester("styleForm");
        form.select("context:panel:format", ((List)new StyleFormatsModel().getObject()).indexOf("zip"));
        tester.executeAjaxEvent("styleForm:context:panel:format", "change");
        form.select("context:panel:existingStyles", 0);
        tester.executeAjaxEvent("styleForm:context:panel:existingStyles", "change");
        tester.assertModelValue("styleForm:context:panel:format", (Object)"zip");
        tester.clickLink("styleForm:context:panel:copy", true);
        tester.assertModelValue("styleForm:context:panel:format", (Object)"sld");
        String doc = tester.getLastResponse().getDocument();
        TagTester tag = TagTester.createTagByAttribute((String)doc, (String)"name", (String)"context:panel:format");
        tag = tag.getChild("selected", "selected");
        Assert.assertEquals((Object)"sld", (Object)tag.getAttribute("value"));
    }

    @Test
    public void testUpload() throws Exception {
        FormTester upload = tester.newFormTester("styleForm");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        upload.setFile("context:panel:filename", styleFile, "application/xml");
        tester.clickLink("styleForm:context:panel:upload", true);
        tester.assertRenderedPage(StyleNewPage.class);
        tester.assertModelValue("styleForm:styleEditor", (Object)sld);
    }

    @Test
    public void testPreviewNoLegendSLD() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.setValue("context:panel:name", "previewsld");
        form.setValue("context:panel:format", "sld");
        form.submit();
        tester.executeAjaxEvent("styleForm:context:panel:preview", "click");
        tester.assertNoErrorMessage();
    }

    @Test
    public void testPreviewNoLegendZIP() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.setValue("context:panel:name", "previewzip");
        form.setValue("context:panel:format", "zip");
        form.submit();
        tester.executeAjaxEvent("styleForm:context:panel:preview", "click");
        tester.assertErrorMessages(new Serializable[]{"Failed to build legend preview. Check to see if the style is valid."});
    }

    @Test
    public void testNoLegend() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.setValue("context:panel:name", "nolegendtest");
        form.submit();
        tester.assertRenderedPage(StyleNewPage.class);
        tester.executeAjaxEvent("submit", "click");
        tester.assertRenderedPage(StylePage.class);
        StyleInfo style = this.getCatalog().getStyleByName("nolegendtest");
        Assert.assertNotNull((Object)style);
        Assert.assertNull((Object)style.getLegend());
    }

    @Test
    public void testLegend() throws Exception {
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:showhide:show", "click");
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:onlineResource", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:width", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:height", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:format", TextField.class);
        FormTester form = tester.newFormTester("styleForm", false);
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.setValue("context:panel:name", "legendtest");
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:onlineResource", "legend.png");
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:width", "100");
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:height", "100");
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:format", "image/png");
        form.setValue("context:panel:format", "sld");
        form.submit();
        tester.assertNoErrorMessage();
        tester.assertRenderedPage(StyleNewPage.class);
        tester.executeAjaxEvent("submit", "click");
        tester.assertRenderedPage(StylePage.class);
        StyleInfo style = this.getCatalog().getStyleByName("legendtest");
        Assert.assertNotNull((Object)style);
        Assert.assertNotNull((Object)style.getLegend());
    }

    @Test
    public void testLegendWrongValues() throws Exception {
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:showhide:show", "click");
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:onlineResource", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:width", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:height", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:format", TextField.class);
        FormTester form = tester.newFormTester("styleForm", false);
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.setValue("context:panel:name", "legendwrongvaluestest");
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:onlineResource", "thisisnotavalidurl");
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:width", "-1");
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:height", "-1");
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:format", "image/png");
        form.submit();
        tester.assertErrorMessages(new Serializable[]{"Graphic resource must be a png, gif or jpeg", "The value of 'Width' must be at least 0.", "The value of 'Height' must be at least 0."});
    }

    @Test
    public void testLegendAutoFillEmpty() throws Exception {
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:showhide:show", "click");
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:onlineResource", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:autoFill", GeoServerAjaxFormLink.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:width", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:height", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:format", TextField.class);
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:autoFill", "click");
    }

    @Test
    public void testPreviewExternalLegendWithSlash() throws Exception {
        Resource resource = this.getResourceLoader().get("styles/legend.png");
        String url = resource.file().getParentFile().getParentFile().toURI().toURL().toString();
        if (!url.endsWith("/")) {
            url = url + '/';
        }
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl(url);
        this.getGeoServer().save(global);
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:showhide:show", "click");
        FormTester form = tester.newFormTester("styleForm", false);
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:onlineResource", "legend.png");
        tester.executeAjaxEvent("styleForm:context:panel:preview", "click");
        tester.assertNoErrorMessage();
    }

    @Test
    public void testPreviewExternalLegendWithoutSlash() throws Exception {
        Resource resource = this.getResourceLoader().get("styles/legend.png");
        String url = resource.file().getParentFile().getParentFile().toURI().toURL().toString();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl(url);
        this.getGeoServer().save(global);
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:showhide:show", "click");
        FormTester form = tester.newFormTester("styleForm", false);
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:onlineResource", "legend.png");
        tester.executeAjaxEvent("styleForm:context:panel:preview", "click");
        tester.assertNoErrorMessage();
    }

    @Test
    public void testMissingName() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.submit();
        tester.assertRenderedPage(StyleNewPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Field 'Name' is required."});
    }

    @Test
    public void testMissingStyle() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        form.setValue("context:panel:name", "test");
        form.submit();
        tester.assertRenderedPage(StyleNewPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Field 'styleEditor' is required."});
    }

    @Test
    public void testNewStyleRepeatedName() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.setValue("context:panel:name", "repeatedname");
        form.submit();
        tester.assertRenderedPage(StyleNewPage.class);
        tester.executeAjaxEvent("submit", "click");
        tester.assertRenderedPage(StylePage.class);
        tester.startPage(StyleNewPage.class);
        form = tester.newFormTester("styleForm");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.setValue("context:panel:name", "repeatedname");
        form.submit();
        tester.assertRenderedPage(StyleNewPage.class);
        tester.assertErrorMessages(new Serializable[]{"Style named 'repeatedname' already exists"});
    }

    @Test
    public void testNewStyle() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.setValue("context:panel:name", "test");
        form.submit();
        tester.assertRenderedPage(StyleNewPage.class);
        Assert.assertNotNull((Object)this.getCatalog().getStyleByName("test"));
        tester.executeAjaxEvent("submit", "click");
        tester.assertRenderedPage(StylePage.class);
    }

    @Test
    public void testNewStyleApply() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.setValue("context:panel:name", "test");
        tester.executeAjaxEvent("apply", "click");
        tester.assertRenderedPage(StyleEditPage.class);
        Assert.assertNotNull((Object)this.getCatalog().getStyleByName("test"));
    }

    @Test
    public void testNewStyleSubmit() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        org.apache.wicket.util.file.File styleFile = new org.apache.wicket.util.file.File(new File(((Object)((Object)this)).getClass().getResource("default_point.sld").toURI()));
        String sld = IOUtils.toString((Reader)new FileReader((File)styleFile)).replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        form.setValue("styleEditor:editorContainer:editorParent:editor", sld);
        form.setValue("context:panel:name", "test");
        tester.executeAjaxEvent("submit", "click");
        tester.assertRenderedPage(StylePage.class);
        Assert.assertNotNull((Object)this.getCatalog().getStyleByName("test"));
    }

    @Test
    public void testNewStyleNoSLD() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        form.setValue("context:panel:name", "test");
        form.submit();
        tester.assertRenderedPage(StyleNewPage.class);
        Assert.assertTrue((tester.getMessages(400).size() > 0 ? 1 : 0) != 0);
    }
}

