/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.file.File;
import org.apache.wicket.util.tester.FormTester;
import org.apache.wicket.util.tester.WicketTester;
import org.apache.wicket.util.tester.WicketTesterHelper;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.TestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.wms.web.data.AbstractStylePage;
import org.geoserver.wms.web.data.ExternalGraphicPanel;
import org.geoserver.wms.web.data.OpenLayersPreviewPanel;
import org.geoserver.wms.web.data.StyleAdminPanel;
import org.geoserver.wms.web.data.StyleEditPage;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.URLs;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.w3c.dom.Document;

public class StyleEditPageTest
extends GeoServerWicketTestSupport {
    StyleInfo buildingsStyle;
    StyleEditPage edit;

    @Before
    public void setUp() throws Exception {
        WMSStoreInfo wms;
        Catalog catalog = this.getCatalog();
        this.login();
        this.buildingsStyle = catalog.getStyleByName(MockData.BUILDINGS.getLocalPart());
        if (this.buildingsStyle == null) {
            StyleInfo si = catalog.getStyleByName("BuildingsNew");
            if (si != null) {
                si.setName(MockData.BUILDINGS.getLocalPart());
                catalog.save(si);
            }
            this.buildingsStyle = catalog.getStyleByName(MockData.BUILDINGS.getLocalPart());
        }
        LayerInfo layer0 = (LayerInfo)catalog.getLayers().get(0);
        StyleInfo defaultStyle = catalog.getStyleByName("Default");
        layer0.setDefaultStyle(defaultStyle);
        catalog.save(layer0);
        DataStoreInfo ds = (DataStoreInfo)catalog.getStoreByName("sf", "unstore", DataStoreInfo.class);
        if (ds == null) {
            CatalogBuilder cb = new CatalogBuilder(catalog);
            cb.setWorkspace(catalog.getWorkspaceByName("sf"));
            ds = cb.buildDataStore("unstore");
            catalog.add((StoreInfo)ds);
            FeatureTypeInfo ft = catalog.getFactory().createFeatureType();
            ft.setName("unlayer");
            ft.setStore(catalog.getStoreByName("unstore", DataStoreInfo.class));
            ft.setCatalog(catalog);
            ft.setNamespace(catalog.getNamespaceByPrefix("sf"));
            ft.setSRS("EPSG:4326");
            CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326");
            ft.setNativeCRS(wgs84);
            ft.setLatLonBoundingBox(new ReferencedEnvelope(-110.0, 0.0, -60.0, 50.0, wgs84));
            ft.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
            catalog.add((ResourceInfo)ft);
            LayerInfo ftl = catalog.getFactory().createLayer();
            ftl.setResource((ResourceInfo)ft);
            ftl.setDefaultStyle(this.getCatalog().getStyleByName("Default"));
            catalog.add(ftl);
        }
        if ((wms = (WMSStoreInfo)catalog.getStoreByName("sf", "wmsstore", WMSStoreInfo.class)) == null) {
            CatalogBuilder cb = new CatalogBuilder(catalog);
            cb.setWorkspace(catalog.getWorkspaceByName("sf"));
            wms = cb.buildWMSStore("wmsstore");
            wms.setCapabilitiesURL("http://demo.opengeo.org/geoserver/wms?");
            catalog.add((StoreInfo)wms);
            WMSLayerInfo wmr = catalog.getFactory().createWMSLayer();
            wmr.setName("states");
            wmr.setNativeName("topp:states");
            wmr.setStore(catalog.getStoreByName("wmsstore", WMSStoreInfo.class));
            wmr.setCatalog(catalog);
            wmr.setNamespace(catalog.getNamespaceByPrefix("sf"));
            wmr.setSRS("EPSG:4326");
            CoordinateReferenceSystem wgs84 = CRS.decode((String)"EPSG:4326");
            wmr.setNativeCRS(wgs84);
            wmr.setLatLonBoundingBox(new ReferencedEnvelope(-110.0, 0.0, -60.0, 50.0, wgs84));
            wmr.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
            catalog.add((ResourceInfo)wmr);
            LayerInfo wml = catalog.getFactory().createLayer();
            wml.setResource((ResourceInfo)wmr);
            wml.setDefaultStyle(this.getCatalog().getStyleByName("Default"));
            catalog.add(wml);
        }
        this.edit = new StyleEditPage(this.buildingsStyle);
        tester.startPage((Page)this.edit);
    }

    @Test
    public void testLoad() throws Exception {
        tester.assertRenderedPage(StyleEditPage.class);
        tester.assertNoErrorMessage();
        tester.debugComponentTrees();
        tester.assertComponent("styleForm:context:panel:name", TextField.class);
        tester.assertComponent("styleForm:styleEditor:editorContainer:editorParent:editor", TextArea.class);
        tester.assertVisible("styleForm:context:panel:upload");
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:showhide:show", "click");
        tester.assertComponent("styleForm:context:panel:legendPanel", ExternalGraphicPanel.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:onlineResource", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:width", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:height", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:format", TextField.class);
        tester.assertModelValue("styleForm:context:panel:name", (Object)"Buildings");
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        Assert.assertNotNull((Object)loader);
        String path = Paths.path((String[])new String[]{"styles", Paths.convert((String)this.buildingsStyle.getFilename())});
        Resource styleFile = loader.get(path);
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document d1 = db.parse(styleFile.in());
        String xml = tester.getComponentFromLastRenderedPage("styleForm:styleEditor").getDefaultModelObjectAsString();
        xml = xml.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"");
        Document d2 = db.parse(new ByteArrayInputStream(xml.getBytes()));
        XMLAssert.assertXMLEqual((Document)d1, (Document)d2);
    }

    @Test
    public void testInsertImage() throws Exception {
        GeoServerDataDirectory dd = (GeoServerDataDirectory)GeoServerApplication.get().getBeanOfType(GeoServerDataDirectory.class);
        dd.getStyles(new String[0]).get("somepicture.png").out().close();
        dd.getStyles(new String[0]).get("otherpicture.jpg").out().close();
        dd.getStyles(new String[0]).get("vector.svg").out().close();
        tester.getComponentFromLastRenderedPage("styleForm:styleEditor:editorContainer:toolbar", false).setVisible(true);
        tester.assertComponent("styleForm:styleEditor:editorContainer:toolbar:custom-buttons:1", AjaxLink.class);
        tester.clickLink("styleForm:styleEditor:editorContainer:toolbar:custom-buttons:1");
        tester.assertComponent("dialog:dialog:content:form:userPanel", AbstractStylePage.ChooseImagePanel.class);
        tester.assertComponent("dialog:dialog:content:form:userPanel:image", DropDownChoice.class);
        tester.assertInvisible("dialog:dialog:content:form:userPanel:display");
        List choices = ((DropDownChoice)tester.getComponentFromLastRenderedPage("dialog:dialog:content:form:userPanel:image")).getChoices();
        Assert.assertEquals((long)3L, (long)choices.size());
        Assert.assertEquals((Object)"otherpicture.jpg", choices.get(0));
        Assert.assertEquals((Object)"somepicture.png", choices.get(1));
        Assert.assertEquals((Object)"vector.svg", choices.get(2));
        FormTester formTester = tester.newFormTester("dialog:dialog:content:form");
        formTester.select("userPanel:image", 1);
        tester.executeAjaxEvent("dialog:dialog:content:form:userPanel:image", "change");
        tester.assertVisible("dialog:dialog:content:form:userPanel:display");
        Assert.assertTrue((boolean)((ResourceReference)((Image)tester.getComponentFromLastRenderedPage("dialog:dialog:content:form:userPanel:display")).getDefaultModelObject()).getName().equals("somepicture.png"));
        formTester.submit("submit");
        Pattern pattern = Pattern.compile("replaceSelection\\('<ExternalGraphic>\\\\n<OnlineResource xlink:type=\"simple\" xlink:href=\"(.*)\" />\\\\n<Format>(.*)</Format>\\\\n</ExternalGraphic>\\\\n'\\)");
        Matcher matcher = pattern.matcher(tester.getLastResponse().getDocument());
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"somepicture.png", (Object)matcher.group(1));
        Assert.assertEquals((Object)"image/png", (Object)matcher.group(2));
        tester.clickLink("styleForm:styleEditor:editorContainer:toolbar:custom-buttons:1");
        formTester = tester.newFormTester("dialog:dialog:content:form");
        File file = new File(URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("GeoServer_75.png")));
        formTester.setFile("userPanel:upload", file, "image/png");
        formTester.submit("submit");
        Assert.assertTrue((boolean)Resources.exists((Resource)dd.getStyles(new String[0]).get("GeoServer_75.png")));
        matcher = pattern.matcher(tester.getLastResponse().getDocument());
        Assert.assertTrue((boolean)matcher.find());
        Assert.assertEquals((Object)"GeoServer_75.png", (Object)matcher.group(1));
        Assert.assertEquals((Object)"image/png", (Object)matcher.group(2));
    }

    @Test
    public void testLoadLegend() {
    }

    @Test
    public void testLayerAssociationsTab() {
        LayerInfo l = (LayerInfo)this.getCatalog().getLayers().get(0);
        Assert.assertFalse((l.getDefaultStyle() == this.buildingsStyle ? 1 : 0) != 0);
        tester.executeAjaxEvent("styleForm:context:tabs-container:tabs:1:link", "click");
        tester.assertComponent("styleForm:context:panel:layer.table", GeoServerTablePanel.class);
        FormTester form = tester.newFormTester("styleForm");
        form.setValue("context:panel:layer.table:listContainer:items:1:itemProperties:2:component:default.selected", true);
        AbstractAjaxBehavior behavior = (AbstractAjaxBehavior)WicketTesterHelper.findBehavior((Component)tester.getComponentFromLastRenderedPage("styleForm:context:panel:layer.table:listContainer:items:1:itemProperties:2:component:default.selected"), AjaxFormComponentUpdatingBehavior.class);
        tester.executeBehavior(behavior);
        l = (LayerInfo)this.getCatalog().getLayers().get(0);
        Assert.assertEquals((Object)this.buildingsStyle, (Object)l.getDefaultStyle());
    }

    @Test
    public void testLayerAssociationsMissingStyle() {
        LayerInfo l = (LayerInfo)this.getCatalog().getLayers().get(0);
        StyleInfo s = l.getDefaultStyle();
        l.setDefaultStyle(null);
        this.getCatalog().getFacade().save(l);
        try {
            this.edit = new StyleEditPage(this.buildingsStyle);
            tester.startPage((Page)this.edit);
            tester.executeAjaxEvent("styleForm:context:tabs-container:tabs:1:link", "click");
            tester.assertComponent("styleForm:context:panel:layer.table", GeoServerTablePanel.class);
        }
        finally {
            l.setDefaultStyle(s);
            this.getCatalog().save(l);
        }
    }

    @Test
    public void testLayerAttributesUnreachableLayer() throws Exception {
        tester.executeAjaxEvent("styleForm:context:tabs-container:tabs:3:link", "click");
        tester.executeAjaxEvent("styleForm:context:panel:changeLayer:link", "click");
        tester.assertComponent("styleForm:popup:content:layer.table", GeoServerTablePanel.class);
        tester.executeAjaxEvent("styleForm:popup:content:layer.table:navigatorBottom:navigator:last", "click");
        tester.assertLabel("styleForm:popup:content:layer.table:listContainer:items:30:itemProperties:2:component:link:layer.name", "unlayer");
        tester.executeAjaxEvent("styleForm:popup:content:layer.table:listContainer:items:30:itemProperties:2:component:link", "click");
        tester.assertContains("Failed to load attribute list, internal error is:");
    }

    @Test
    public void testLayerAttributesTabWMS() {
        tester.executeAjaxEvent("styleForm:context:tabs-container:tabs:3:link", "click");
        tester.executeAjaxEvent("styleForm:context:panel:changeLayer:link", "click");
        tester.assertComponent("styleForm:popup:content:layer.table", GeoServerTablePanel.class);
        tester.assertContainsNot("wmsstore");
        tester.executeAjaxEvent("styleForm:popup:content:layer.table:navigatorBottom:navigator:last", "click");
        tester.assertContainsNot("wmsstore");
    }

    @Test
    public void testMissingName() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        form.setValue("context:panel:name", "");
        form.submit();
        tester.assertRenderedPage(StyleEditPage.class);
        tester.assertErrorMessages((Serializable[])new String[]{"Field 'Name' is required."});
    }

    @Test
    public void testChangeName() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        form.setValue("context:panel:name", "BuildingsNew");
        form.submit();
        Assert.assertNull((Object)this.getCatalog().getStyleByName("Buildings"));
        Assert.assertNotNull((Object)this.getCatalog().getStyleByName("BuildingsNew"));
    }

    @Test
    public void testChangeNameAlreadyExists() throws Exception {
        FormTester form = tester.newFormTester("styleForm");
        form.setValue("context:panel:name", "Default");
        tester.executeAjaxEvent("submit", "click");
        tester.assertContains("java.lang.IllegalArgumentException: Style named &#039;Default&#039; already exists");
        tester.debugComponentTrees();
    }

    @Test
    public void testValidate() throws Exception {
        String xml = "<StyledLayerDescriptor version='1.0.0'  xsi:schemaLocation='http://www.opengis.net/sld StyledLayerDescriptor.xsd'  xmlns='http://www.opengis.net/sld'  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <NamedLayer>    <Name>Style</Name>  </NamedLayer></StyledLayerDescriptor>";
        tester.newFormTester("styleForm").setValue("styleEditor:editorContainer:editorParent:editor", xml);
        tester.executeAjaxEvent("validate", "click");
        tester.assertNoErrorMessage();
    }

    @Test
    public void testValidateEntityExpansion() throws Exception {
        String xml = IOUtils.toString((URL)TestData.class.getResource("externalEntities.sld"), (String)"UTF-8");
        tester.newFormTester("styleForm").setValue("styleEditor:editorContainer:editorParent:editor", xml);
        tester.executeAjaxEvent("validate", "click");
        List messages = tester.getMessages(400);
        Assert.assertEquals((long)1L, (long)messages.size());
        String message = ((Serializable)messages.get(0)).toString();
        Assert.assertThat((Object)message, (org.hamcrest.Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
        Assert.assertThat((Object)message, (org.hamcrest.Matcher)CoreMatchers.containsString((String)"/this/file/does/not/exist"));
    }

    @Test
    public void testValidateNamedLayers() throws Exception {
        String xml = "<StyledLayerDescriptor version='1.0.0'  xsi:schemaLocation='http://www.opengis.net/sld StyledLayerDescriptor.xsd'  xmlns='http://www.opengis.net/sld'  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <NamedLayer>\n    <Name>Streams</Name>\n  </NamedLayer>\n  <NamedLayer>\n    <Name>RoadSegments</Name>\n  </NamedLayer>\n</StyledLayerDescriptor>";
        tester.newFormTester("styleForm").setValue("styleEditor:editorContainer:editorParent:editor", xml);
        tester.executeAjaxEvent("validate", "click");
        tester.assertNoErrorMessage();
    }

    @Test
    public void testValidateNamedLayersInvalid() throws Exception {
        String xml = "<StyledLayerDescriptor version='1.0.0'  xsi:schemaLocation='http://www.opengis.net/sld StyledLayerDescriptor.xsd'  xmlns='http://www.opengis.net/sld'  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'>  <NamedLayer>\n    <Name>Streams</Name>\n  </NamedLayer>\n  <NamedLayer>\n    <Name>Stream</Name>\n  </NamedLayer>\n</StyledLayerDescriptor>";
        tester.newFormTester("styleForm").setValue("styleEditor:editorContainer:editorParent:editor", xml);
        tester.executeAjaxEvent("validate", "click");
        tester.assertErrorMessages((Serializable[])new String[]{"No layer or layer group named 'Stream' found in the catalog"});
    }

    @Test
    public void testDiscardNewLegendInfo() {
        tester.assertRenderedPage(StyleEditPage.class);
        tester.assertNoErrorMessage();
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:showhide:show", "click");
        tester.assertComponent("styleForm:context:panel:legendPanel", ExternalGraphicPanel.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:onlineResource", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:width", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:height", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:format", TextField.class);
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:showhide:hide", "click");
        tester.assertNoErrorMessage();
        tester.executeAjaxEvent("submit", "click");
        StyleInfo style = this.getCatalog().getStyleByName(MockData.BUILDINGS.getLocalPart());
        Assert.assertNotNull((Object)style);
        Assert.assertNull((Object)style.getLegend());
    }

    @Test
    public void testDiscardExistingLegend() throws IOException, URISyntaxException {
        StyleInfo style = this.getCatalog().getStyleByName(MockData.BUILDINGS.getLocalPart());
        LegendInfo legendInfo = this.getCatalog().getFactory().createLegend();
        legendInfo.setFormat("jpg");
        legendInfo.setOnlineResource("test.jpg");
        legendInfo.setHeight(100);
        legendInfo.setWidth(100);
        style.setLegend(legendInfo);
        this.getCatalog().save(style);
        tester.startPage((Page)new StyleEditPage(this.getCatalog().getStyleByName(MockData.BUILDINGS.getLocalPart())));
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:onlineResource", TextField.class);
        tester.assertModelValue("styleForm:context:panel:legendPanel:externalGraphicContainer:list:onlineResource", (Object)"test.jpg");
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:width", TextField.class);
        tester.assertModelValue("styleForm:context:panel:legendPanel:externalGraphicContainer:list:width", (Object)100);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:height", TextField.class);
        tester.assertModelValue("styleForm:context:panel:legendPanel:externalGraphicContainer:list:height", (Object)100);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:format", TextField.class);
        tester.assertModelValue("styleForm:context:panel:legendPanel:externalGraphicContainer:list:format", (Object)"jpg");
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:showhide:hide", "click");
        FormTester form = tester.newFormTester("styleForm", false);
        form.submit();
        tester.assertNoErrorMessage();
        style = this.getCatalog().getStyleByName(MockData.BUILDINGS.getLocalPart());
        Assert.assertNotNull((Object)style);
        Assert.assertNull((Object)style.getLegend());
    }

    @Test
    public void testDiscardLegendWithBadValues() throws IOException, URISyntaxException {
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:showhide:show", "click");
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:onlineResource", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:width", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:height", TextField.class);
        tester.assertComponent("styleForm:context:panel:legendPanel:externalGraphicContainer:list:format", TextField.class);
        FormTester form = tester.newFormTester("styleForm", false);
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:onlineResource", "missing.ong");
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:width", "-100");
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:height", "");
        form.setValue("context:panel:legendPanel:externalGraphicContainer:list:format", "bad/value");
        tester.executeAjaxEvent("styleForm:context:panel:legendPanel:externalGraphicContainer:showhide:hide", "click");
        form = tester.newFormTester("styleForm", false);
        form.submit();
        tester.assertNoErrorMessage();
        StyleInfo style = this.getCatalog().getStyleByName(MockData.BUILDINGS.getLocalPart());
        Assert.assertNotNull((Object)style);
        Assert.assertNull((Object)style.getLegend());
    }

    @Test
    public void applyThenSubmit() throws Exception {
        tester.executeAjaxEvent("apply", "click");
        tester.executeAjaxEvent("submit", "click");
        tester.assertNoErrorMessage();
    }

    @Test
    public void testLayerPreviewTab() {
        LayerInfo l = (LayerInfo)this.getCatalog().getLayers().get(0);
        Assert.assertFalse((l.getDefaultStyle() == this.buildingsStyle ? 1 : 0) != 0);
        tester.executeAjaxEvent("styleForm:context:tabs-container:tabs:2:link", "click");
        this.print((Component)tester.getLastRenderedPage(), true, true);
        tester.assertComponent("styleForm:context:panel", OpenLayersPreviewPanel.class);
    }

    @Test
    public void testLayerPreviewTabStyleGroup() {
        LayerInfo l = (LayerInfo)this.getCatalog().getLayers().get(0);
        Assert.assertFalse((l.getDefaultStyle() == this.buildingsStyle ? 1 : 0) != 0);
        tester.executeAjaxEvent("styleForm:context:tabs-container:tabs:2:link", "click");
        tester.assertComponent("styleForm:context:panel", OpenLayersPreviewPanel.class);
        OpenLayersPreviewPanel previewPanel = (OpenLayersPreviewPanel)tester.getComponentFromLastRenderedPage("styleForm:context:panel");
        Assert.assertFalse((boolean)previewPanel.isPreviewStyleGroup);
        FormTester form = tester.newFormTester("styleForm");
        form.setValue("context:panel:previewStyleGroup", true);
        form.submit();
        Assert.assertTrue((boolean)previewPanel.isPreviewStyleGroup);
    }

    @Test
    public void testRenameDefaultStyle() {
        StyleInfoImpl styleInfo = new StyleInfoImpl(null);
        styleInfo.setName("point");
        styleInfo.setFilename("test.sld");
        GeoServerApplication app = (GeoServerApplication)applicationContext.getBean("webApplication");
        WicketTester styleTest = new WicketTester((WebApplication)app, false);
        StyleEditPage page = new StyleEditPage((StyleInfo)styleInfo);
        styleTest.startPage((Page)page);
        styleTest.assertDisabled("styleForm:context:panel:name");
    }

    @Test
    public void testChangeWsDefaultStyle() {
        StyleInfoImpl styleInfo = new StyleInfoImpl(null);
        styleInfo.setName("point");
        styleInfo.setFilename("test.sld");
        GeoServerApplication app = (GeoServerApplication)applicationContext.getBean("webApplication");
        WicketTester styleTest = new WicketTester((WebApplication)app, false);
        StyleEditPage page = new StyleEditPage((StyleInfo)styleInfo);
        styleTest.startPage((Page)page);
        styleTest.assertDisabled("styleForm:context:panel:workspace");
    }

    @Test
    public void testPreviewSLD11Legend() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\" version=\"1.1.0\" xmlns:se=\"http://www.opengis.net/se\">\n  <NamedLayer>\n    <se:Name>ne_110m_admin_0_countries</se:Name>\n    <UserStyle>\n      <se:Name>ne_110m_admin_0_countries</se:Name>\n      <se:FeatureTypeStyle>\n        <se:Rule>\n          <se:Name>Single symbol</se:Name>\n          <se:PolygonSymbolizer>\n            <se:Fill>\n              <se:SvgParameter name=\"fill\">#ff0000</se:SvgParameter>\n            </se:Fill>\n          </se:PolygonSymbolizer>\n        </se:Rule>\n      </se:FeatureTypeStyle>\n    </UserStyle>\n  </NamedLayer>\n</StyledLayerDescriptor>";
        tester.newFormTester("styleForm").setValue("styleEditor:editorContainer:editorParent:editor", xml);
        tester.clickLink("styleForm:context:panel:preview", true);
        StyleAdminPanel panel = (StyleAdminPanel)tester.getComponentFromLastRenderedPage("styleForm:context:panel");
        this.assertPixel(panel.legendImage, 10, 10, Color.RED);
    }
}

