/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.data;

import java.io.Serializable;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.data.StyleEditPage;
import org.junit.Before;
import org.junit.Test;

public class StyleEditPageNoLayersTest
extends GeoServerWicketTestSupport {
    StyleInfo buildingsStyle;
    StyleEditPage edit;

    @Before
    public void setUp() throws Exception {
        Catalog catalog = this.getCatalog();
        this.login();
        this.buildingsStyle = catalog.getStyleByName(MockData.BUILDINGS.getLocalPart());
        if (this.buildingsStyle == null) {
            StyleInfo si = catalog.getStyleByName("BuildingsNew");
            if (si != null) {
                si.setName(MockData.BUILDINGS.getLocalPart());
                catalog.save(si);
            }
            this.buildingsStyle = catalog.getStyleByName(MockData.BUILDINGS.getLocalPart());
        }
        catalog.getLayers().forEach(arg_0 -> ((Catalog)catalog).remove(arg_0));
        this.edit = new StyleEditPage(this.buildingsStyle);
        tester.startPage((Page)this.edit);
    }

    @Test
    public void testLoad() throws Exception {
        tester.assertRenderedPage(StyleEditPage.class);
        tester.assertNoErrorMessage();
        tester.debugComponentTrees();
        tester.assertComponent("styleForm:context:panel:name", TextField.class);
        tester.assertComponent("styleForm:styleEditor:editorContainer:editorParent:editor", TextArea.class);
    }

    @Test
    public void testPublishingTab() {
        tester.executeAjaxEvent("styleForm:context:tabs-container:tabs:1:link", "click");
        tester.assertErrorMessages((Serializable[])new String[]{"Cannot show Publishing options: No Layers available."});
    }

    @Test
    public void testLayerPreviewTab() {
        tester.executeAjaxEvent("styleForm:context:tabs-container:tabs:2:link", "click");
        tester.assertErrorMessages((Serializable[])new String[]{"Cannot show Layer Preview: No Layers available."});
    }

    @Test
    public void testLayerAttributesTab() {
        tester.executeAjaxEvent("styleForm:context:tabs-container:tabs:3:link", "click");
        tester.assertErrorMessages((Serializable[])new String[]{"Cannot show Attribute Preview: No Layers available."});
    }
}

