/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web.demo;

import java.awt.geom.AffineTransform;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class AffineTransformPanel
extends FormComponentPanel<AffineTransform> {
    Double scaleX;
    Double shearX;
    Double originX;
    Double scaleY;
    Double shearY;
    Double originY;
    private WebMarkupContainer originXContainer;
    private WebMarkupContainer shearXContainer;
    private WebMarkupContainer originYContainer;
    private WebMarkupContainer shearYContainer;
    private WebMarkupContainer newline;

    public AffineTransformPanel(String id) {
        super(id);
        this.initComponents();
    }

    public AffineTransformPanel(String id, AffineTransform e) {
        this(id, (IModel)new Model((Serializable)e));
    }

    public AffineTransformPanel(String id, IModel model) {
        super(id, model);
        this.initComponents();
    }

    void initComponents() {
        this.updateFields();
        this.originXContainer = new WebMarkupContainer("originXContainer");
        this.add(new Component[]{this.originXContainer});
        this.newline = new WebMarkupContainer("newline");
        this.add(new Component[]{this.newline});
        this.shearXContainer = new WebMarkupContainer("shearXContainer");
        this.add(new Component[]{this.shearXContainer});
        this.originYContainer = new WebMarkupContainer("originYContainer");
        this.add(new Component[]{this.originYContainer});
        this.shearYContainer = new WebMarkupContainer("shearYContainer");
        this.add(new Component[]{this.shearYContainer});
        this.add(new Component[]{new TextField("scaleX", (IModel)new PropertyModel((Object)this, "scaleX"))});
        this.shearXContainer.add(new Component[]{new TextField("shearX", (IModel)new PropertyModel((Object)this, "shearX"))});
        this.originXContainer.add(new Component[]{new TextField("originX", (IModel)new PropertyModel((Object)this, "originX"))});
        this.add(new Component[]{new TextField("scaleY", (IModel)new PropertyModel((Object)this, "scaleY"))});
        this.shearYContainer.add(new Component[]{new TextField("shearY", (IModel)new PropertyModel((Object)this, "shearY"))});
        this.originYContainer.add(new Component[]{new TextField("originY", (IModel)new PropertyModel((Object)this, "originY"))});
    }

    protected void onBeforeRender() {
        this.updateFields();
        super.onBeforeRender();
    }

    private void updateFields() {
        AffineTransform at = (AffineTransform)this.getModelObject();
        if (at != null) {
            this.scaleX = at.getScaleX();
            this.shearX = at.getShearX();
            this.originX = at.getTranslateX();
            this.scaleY = at.getScaleY();
            this.shearY = at.getShearY();
            this.originY = at.getTranslateY();
        }
    }

    public AffineTransformPanel setReadOnly(boolean readOnly) {
        this.visitChildren(TextField.class, (component, visit) -> component.setEnabled(!readOnly));
        return this;
    }

    public void convertInput() {
        this.visitChildren(TextField.class, (component, visit) -> ((TextField)component).processInput());
        if (this.isResolutionModeEnabled() && this.scaleX != null && this.scaleY != null) {
            this.setConvertedInput(AffineTransform.getScaleInstance(this.scaleX, this.scaleY));
        } else if (this.scaleX != null && this.shearX != null && this.originX != null && this.scaleY != null && this.shearY != null && this.originY != null) {
            this.setConvertedInput(new AffineTransform(this.scaleX, this.shearX, this.shearY, this.scaleY, this.originX, this.originY));
        } else {
            this.setConvertedInput(null);
        }
    }

    protected void onModelChanged() {
        this.updateFields();
        this.visitChildren(TextField.class, (component, visit) -> ((TextField)component).clearInput());
    }

    public void setResolutionModeEnabled(boolean enabled) {
        this.shearXContainer.setVisible(!enabled);
        this.shearYContainer.setVisible(!enabled);
        this.originXContainer.setVisible(!enabled);
        this.originYContainer.setVisible(!enabled);
        this.newline.setVisible(!enabled);
    }

    public boolean isResolutionModeEnabled() {
        return !this.shearXContainer.isVisible();
    }
}

