/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.event.UserGroupLoadedEvent;
import org.geoserver.security.event.UserGroupLoadedListener;
import org.geoserver.security.impl.AbstractUserGroupServiceTest;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.Util;
import org.geoserver.security.password.GeoServerMultiplexingPasswordEncoder;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.security.xml.XMLUserGroupServiceConfig;
import org.geoserver.test.SystemTest;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class XMLUserGroupServiceTest
extends AbstractUserGroupServiceTest {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.xml");

    public GeoServerUserGroupService createUserGroupService(String serviceName) throws Exception {
        return this.createUserGroupService(serviceName, "users.xml");
    }

    @Before
    public void clearUserGroupService() throws Exception {
        this.store.clear();
        this.store.store();
    }

    protected XMLUserGroupServiceConfig createConfigObject(String name) {
        XMLUserGroupServiceConfig config = new XMLUserGroupServiceConfig();
        config.setName(name);
        config.setPasswordEncoderName(this.getPBEPasswordEncoder().getName());
        config.setPasswordPolicyName("default");
        config.setClassName(XMLUserGroupService.class.getName());
        config.setCheckInterval(1000L);
        config.setFileName("users.xml");
        config.setValidating(true);
        config.setPasswordEncoderName(this.getPlainTextPasswordEncoder().getName());
        config.setPasswordPolicyName("default");
        return config;
    }

    protected GeoServerUserGroupService createUserGroupService(String serviceName, String xmlFileName) throws Exception {
        XMLUserGroupServiceConfig ugConfig = (XMLUserGroupServiceConfig)this.getSecurityManager().loadUserGroupServiceConfig(serviceName);
        if (ugConfig == null) {
            ugConfig = this.createConfigObject(serviceName);
            ugConfig.setName(serviceName);
        }
        ugConfig.setClassName(XMLUserGroupService.class.getName());
        ugConfig.setCheckInterval(1000L);
        ugConfig.setFileName(xmlFileName);
        ugConfig.setValidating(true);
        ugConfig.setPasswordEncoderName(this.getDigestPasswordEncoder().getName());
        ugConfig.setPasswordPolicyName("default");
        this.getSecurityManager().saveUserGroupService((SecurityUserGroupServiceConfig)ugConfig);
        GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService(serviceName);
        service.initializeFromConfig((SecurityNamedServiceConfig)ugConfig);
        return service;
    }

    @Test
    public void testCopyFrom() throws Exception {
        GeoServerUserGroupService service1 = this.createUserGroupService("copyFrom");
        GeoServerUserGroupService service2 = this.createUserGroupService("copyTo");
        GeoServerUserGroupStore store1 = this.createStore(service1);
        GeoServerUserGroupStore store2 = this.createStore(service2);
        store1.clear();
        this.checkEmpty((GeoServerUserGroupService)store1);
        this.insertValues(store1);
        Util.copyFrom((GeoServerUserGroupService)store1, (GeoServerUserGroupStore)store2);
        store1.clear();
        this.checkEmpty((GeoServerUserGroupService)store1);
        this.checkValuesInserted((GeoServerUserGroupService)store2);
    }

    @Test
    public void testDefault() throws Exception {
        GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService(XMLUserGroupService.DEFAULT_NAME);
        Assert.assertEquals((long)1L, (long)service.getUsers().size());
        Assert.assertEquals((long)1L, (long)service.getUserCount());
        Assert.assertEquals((long)0L, (long)service.getUserGroups().size());
        Assert.assertEquals((long)0L, (long)service.getGroupCount());
        GeoServerUser admin = service.getUserByUsername("admin");
        Assert.assertNotNull((Object)admin);
        Assert.assertEquals((Object)true, (Object)admin.isEnabled());
        GeoServerMultiplexingPasswordEncoder enc = this.getEncoder(service);
        Assert.assertTrue((boolean)enc.isPasswordValid(admin.getPassword(), "geoserver", null));
        Assert.assertEquals((long)admin.getProperties().size(), (long)0L);
        Assert.assertEquals((long)0L, (long)service.getGroupsForUser(admin).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocking() throws Exception {
        File xmlFile = File.createTempFile("users", ".xml");
        try {
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("usersTemplate.xml"), (File)xmlFile);
            GeoServerUserGroupService service1 = this.createUserGroupService("locking1", xmlFile.getCanonicalPath());
            GeoServerUserGroupService service2 = this.createUserGroupService("locking2", xmlFile.getCanonicalPath());
            GeoServerUserGroupStore store1 = this.createStore(service1);
            GeoServerUserGroupStore store2 = this.createStore(service2);
            GeoServerUser user = store1.createUserObject("user", "ps", true);
            GeoServerUserGroup group = store2.createGroupObject("group", true);
            store1.addUser(user);
            String failMessage = "Concurrent lock not allowed";
            boolean fail = true;
            try {
                store2.clear();
            }
            catch (IOException ex) {
                fail = false;
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
            store1.load();
            store2.addUser(user);
            fail = true;
            try {
                store1.clear();
            }
            catch (IOException ex) {
                fail = false;
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
            store2.store();
            store1.clear();
            store1.store();
            store1.addUser(user);
            fail = true;
            try {
                store2.associateUserToGroup(user, group);
            }
            catch (IOException ex) {
                try {
                    store2.disAssociateUserFromGroup(user, group);
                }
                catch (IOException e) {
                    fail = false;
                }
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
            fail = true;
            try {
                store2.updateUser(user);
            }
            catch (IOException ex) {
                try {
                    store2.removeUser(user);
                }
                catch (IOException ex1) {
                    try {
                        store2.addUser(user);
                    }
                    catch (IOException ex2) {
                        fail = false;
                    }
                }
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
            fail = true;
            try {
                store2.updateGroup(group);
            }
            catch (IOException ex) {
                try {
                    store2.removeGroup(group);
                }
                catch (IOException ex1) {
                    try {
                        store2.addGroup(group);
                    }
                    catch (IOException ex2) {
                        fail = false;
                    }
                }
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
            fail = true;
            try {
                store2.clear();
            }
            catch (IOException ex) {
                try {
                    store2.store();
                }
                catch (IOException e) {
                    fail = false;
                }
            }
            if (fail) {
                Assert.fail((String)failMessage);
            }
        }
        finally {
            xmlFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDynamicReload() throws Exception {
        File xmlFile = File.createTempFile("users", ".xml");
        try {
            FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("usersTemplate.xml"), (File)xmlFile);
            GeoServerUserGroupService service1 = this.createUserGroupService("reload1", xmlFile.getCanonicalPath());
            GeoServerUserGroupService service2 = this.createUserGroupService("reload2", xmlFile.getCanonicalPath());
            GeoServerUserGroupStore store1 = this.createStore(service1);
            GeoServerUserGroup group = store1.createGroupObject("group", true);
            this.checkEmpty(service1);
            this.checkEmpty(service2);
            UserGroupLoadedListener listener = new UserGroupLoadedListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void usersAndGroupsChanged(UserGroupLoadedEvent event) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        this.notifyAll();
                    }
                }
            };
            service2.registerUserGroupLoadedListener(listener);
            store1.addGroup(group);
            store1.store();
            Assert.assertTrue((service1.getUserGroups().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((service1.getGroupCount() == 1 ? 1 : 0) != 0);
            xmlFile.setLastModified(xmlFile.lastModified() + 2000L);
            UserGroupLoadedListener userGroupLoadedListener = listener;
            synchronized (userGroupLoadedListener) {
                listener.wait();
            }
            Assert.assertTrue((service2.getUserGroups().size() == 1 ? 1 : 0) != 0);
            Assert.assertTrue((service2.getGroupCount() == 1 ? 1 : 0) != 0);
        }
        finally {
            xmlFile.delete();
        }
    }
}

