/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.xml;

import java.io.File;
import java.io.IOException;
import org.geoserver.data.test.LiveSystemTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.impl.AbstractUserDetailsServiceTest;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.password.GeoServerMultiplexingPasswordEncoder;
import org.geoserver.security.xml.XMLRoleService;
import org.geoserver.security.xml.XMLRoleServiceConfig;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.security.xml.XMLUserGroupServiceConfig;
import org.geoserver.test.SystemTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class XMLUserDetailsServiceTest
extends AbstractUserDetailsServiceTest {
    protected SystemTestData createTestData() throws Exception {
        return new LiveSystemTestData(new File("./src/test/resources/data_dir/legacy"));
    }

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    public GeoServerUserGroupService createUserGroupService(String serviceName) throws Exception {
        XMLUserGroupServiceConfig ugConfig = new XMLUserGroupServiceConfig();
        ugConfig.setName(serviceName);
        ugConfig.setClassName(XMLUserGroupService.class.getName());
        ugConfig.setCheckInterval(1000L);
        ugConfig.setFileName("users.xml");
        ugConfig.setValidating(true);
        ugConfig.setPasswordEncoderName(this.getDigestPasswordEncoder().getName());
        ugConfig.setPasswordPolicyName("default");
        this.getSecurityManager().saveUserGroupService((SecurityUserGroupServiceConfig)ugConfig);
        GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService(serviceName);
        service.initializeFromConfig((SecurityNamedServiceConfig)ugConfig);
        return service;
    }

    public GeoServerRoleService createRoleService(String serviceName) throws Exception {
        XMLRoleServiceConfig gaConfig = new XMLRoleServiceConfig();
        gaConfig.setName(serviceName);
        gaConfig.setClassName(XMLRoleService.class.getName());
        gaConfig.setCheckInterval(1000L);
        gaConfig.setFileName("roles.xml");
        gaConfig.setValidating(true);
        this.getSecurityManager().saveRoleService((SecurityRoleServiceConfig)gaConfig);
        GeoServerRoleService service = this.getSecurityManager().loadRoleService(serviceName);
        service.initializeFromConfig((SecurityNamedServiceConfig)gaConfig);
        return service;
    }

    @Test
    public void testMigration() throws IOException {
        GeoServerUserGroupService userService = this.getSecurityManager().loadUserGroupService(XMLUserGroupService.DEFAULT_NAME);
        GeoServerRoleService roleService = this.getSecurityManager().loadRoleService(XMLRoleService.DEFAULT_NAME);
        Assert.assertEquals((long)3L, (long)userService.getUsers().size());
        Assert.assertEquals((long)3L, (long)userService.getUserCount());
        Assert.assertEquals((long)0L, (long)userService.getUserGroups().size());
        Assert.assertEquals((long)0L, (long)userService.getGroupCount());
        Assert.assertEquals((long)9L, (long)roleService.getRoles().size());
        GeoServerUser admin = (GeoServerUser)userService.loadUserByUsername("admin");
        Assert.assertNotNull((Object)admin);
        GeoServerMultiplexingPasswordEncoder enc = this.getEncoder(userService);
        Assert.assertTrue((boolean)enc.isPasswordValid(admin.getPassword(), "gs", null));
        Assert.assertTrue((boolean)admin.isEnabled());
        GeoServerUser wfs = (GeoServerUser)userService.loadUserByUsername("wfs");
        Assert.assertNotNull((Object)wfs);
        Assert.assertTrue((boolean)enc.isPasswordValid(wfs.getPassword(), "webFeatureService", null));
        Assert.assertTrue((boolean)wfs.isEnabled());
        GeoServerUser disabledUser = (GeoServerUser)userService.loadUserByUsername("disabledUser");
        Assert.assertNotNull((Object)disabledUser);
        Assert.assertTrue((boolean)enc.isPasswordValid(disabledUser.getPassword(), "nah", null));
        Assert.assertFalse((boolean)disabledUser.isEnabled());
        GeoServerRole role_admin = roleService.getRoleByName(XMLRoleService.DEFAULT_LOCAL_ADMIN_ROLE);
        Assert.assertNotNull((Object)role_admin);
        GeoServerRole role_wfs_read = roleService.getRoleByName("ROLE_WFS_READ");
        Assert.assertNotNull((Object)role_wfs_read);
        GeoServerRole role_wfs_write = roleService.getRoleByName("ROLE_WFS_WRITE");
        Assert.assertNotNull((Object)role_wfs_write);
        GeoServerRole role_test = roleService.getRoleByName("ROLE_TEST");
        Assert.assertNotNull((Object)role_test);
        Assert.assertNotNull((Object)roleService.getRoleByName("NO_ONE"));
        Assert.assertNotNull((Object)roleService.getRoleByName("TRUSTED_ROLE"));
        Assert.assertNotNull((Object)roleService.getRoleByName("ROLE_SERVICE_1"));
        Assert.assertNotNull((Object)roleService.getRoleByName("ROLE_SERVICE_2"));
        Assert.assertEquals((long)2L, (long)admin.getAuthorities().size());
        Assert.assertTrue((boolean)admin.getAuthorities().contains(role_admin));
        Assert.assertTrue((boolean)admin.getAuthorities().contains(GeoServerRole.ADMIN_ROLE));
        Assert.assertEquals((long)2L, (long)wfs.getAuthorities().size());
        Assert.assertTrue((boolean)wfs.getAuthorities().contains(role_wfs_read));
        Assert.assertTrue((boolean)wfs.getAuthorities().contains(role_wfs_write));
        Assert.assertEquals((long)1L, (long)disabledUser.getAuthorities().size());
        Assert.assertTrue((boolean)disabledUser.getAuthorities().contains(role_test));
        GeoServerSecurityManager securityManager = this.getSecurityManager();
        File userfile = new File(securityManager.get("security").dir(), "users.properties");
        Assert.assertFalse((boolean)userfile.exists());
        File userfileOld = new File(securityManager.get("security").dir(), "users.properties.old");
        Assert.assertTrue((boolean)userfileOld.exists());
        File roleXSD = new File(new File(securityManager.get("security/role").dir(), roleService.getName()), "roles.xsd");
        Assert.assertTrue((boolean)roleXSD.exists());
        File userXSD = new File(new File(securityManager.get("security/usergroup").dir(), userService.getName()), "users.xsd");
        Assert.assertTrue((boolean)userXSD.exists());
    }
}

