/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.io.IOException;
import java.util.logging.Logger;
import org.geoserver.security.GeoServerSecurityTestSupport;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.impl.MemoryUserGroupServiceConfigImpl;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.MemoryUserGroupService;
import org.geoserver.security.validation.AbstractSecurityException;
import org.geoserver.security.validation.UserGroupStoreValidationWrapper;
import org.geoserver.test.SystemTest;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class UserGroupStoreValidationWrapperTest
extends GeoServerSecurityTestSupport {
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");

    protected UserGroupStoreValidationWrapper createStore(String name) throws IOException {
        MemoryUserGroupServiceConfigImpl config = new MemoryUserGroupServiceConfigImpl();
        config.setName(name);
        config.setPasswordEncoderName(this.getPBEPasswordEncoder().getName());
        config.setPasswordPolicyName("default");
        MemoryUserGroupService service = new MemoryUserGroupService();
        service.setSecurityManager(this.getSecurityManager());
        service.initializeFromConfig((SecurityNamedServiceConfig)config);
        return new UserGroupStoreValidationWrapper(service.createStore());
    }

    protected void assertSecurityException(IOException ex, String id, Object ... params) {
        Assert.assertTrue((boolean)(ex.getCause() instanceof AbstractSecurityException));
        AbstractSecurityException secEx = (AbstractSecurityException)ex.getCause();
        Assert.assertEquals((Object)id, (Object)secEx.getId());
        for (int i = 0; i < params.length; ++i) {
            Assert.assertEquals((Object)params[i], (Object)secEx.getArgs()[i]);
        }
    }

    @Test
    public void testUserGroupStoreWrapper() throws Exception {
        UserGroupStoreValidationWrapper store = this.createStore("test");
        boolean failed = false;
        try {
            store.addUser(store.createUserObject("", "", true));
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "USERNAME_REQUIRED", new Object[0]);
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        failed = false;
        try {
            store.addGroup(store.createGroupObject(null, true));
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUPNAME_REQUIRED", new Object[0]);
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        store.addUser(store.createUserObject("user1", "abc", true));
        store.addGroup(store.createGroupObject("group1", true));
        Assert.assertEquals((long)1L, (long)store.getUsers().size());
        Assert.assertEquals((long)1L, (long)store.getUserCount());
        Assert.assertEquals((long)1L, (long)store.getUserGroups().size());
        Assert.assertEquals((long)1L, (long)store.getGroupCount());
        failed = false;
        try {
            store.addUser(store.createUserObject("user1", "abc", true));
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "USER_ALREADY_EXISTS", "user1");
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        failed = false;
        try {
            store.addGroup(store.createGroupObject("group1", true));
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUP_ALREADY_EXISTS", "group1");
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        store.updateUser(store.createUserObject("user1", "abc", false));
        store.updateGroup(store.createGroupObject("group1", false));
        failed = false;
        try {
            store.updateUser(store.createUserObject("user1xxxx", "abc", true));
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "USER_NOT_FOUND", "user1xxxx");
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        failed = false;
        try {
            store.updateGroup(store.createGroupObject("group1xxx", true));
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUP_NOT_FOUND", "group1xxx");
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        GeoServerUser user1 = store.getUserByUsername("user1");
        GeoServerUserGroup group1 = store.getGroupByGroupname("group1");
        failed = false;
        try {
            store.associateUserToGroup(store.createUserObject("xxx", "abc", true), group1);
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "USER_NOT_FOUND", "xxx");
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        failed = false;
        try {
            store.associateUserToGroup(user1, store.createGroupObject("yyy", true));
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUP_NOT_FOUND", "yyy");
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        store.associateUserToGroup(user1, group1);
        Assert.assertEquals((long)1L, (long)store.getUsersForGroup(group1).size());
        Assert.assertEquals((long)1L, (long)store.getGroupsForUser(user1).size());
        failed = false;
        try {
            store.getGroupsForUser(store.createUserObject("xxx", "abc", true));
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "USER_NOT_FOUND", "xxx");
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        failed = false;
        try {
            store.getUsersForGroup(store.createGroupObject("yyy", true));
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUP_NOT_FOUND", "yyy");
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        failed = false;
        try {
            store.disAssociateUserFromGroup(store.createUserObject("xxx", "abc", true), group1);
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "USER_NOT_FOUND", "xxx");
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        failed = false;
        try {
            store.disAssociateUserFromGroup(user1, store.createGroupObject("yyy", true));
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUP_NOT_FOUND", "yyy");
            failed = true;
        }
        Assert.assertTrue((boolean)failed);
        store.disAssociateUserFromGroup(user1, group1);
        store.removeUser(user1);
        store.removeGroup(group1);
    }
}

