/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.validation;

import java.io.IOException;
import java.util.Arrays;
import java.util.TreeSet;
import org.easymock.classextension.EasyMock;
import org.geoserver.data.test.MockCreator;
import org.geoserver.data.test.MockTestData;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.ServiceAccessRuleDAO;
import org.geoserver.security.validation.AbstractSecurityException;
import org.geoserver.security.validation.RoleStoreValidationWrapper;
import org.geoserver.test.GeoServerMockTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class RoleStoreValidationWrapperTest
extends GeoServerMockTestSupport {
    protected void assertSecurityException(IOException ex, String id, Object ... params) {
        Assert.assertTrue((boolean)(ex.getCause() instanceof AbstractSecurityException));
        AbstractSecurityException secEx = (AbstractSecurityException)ex.getCause();
        Assert.assertEquals((Object)id, (Object)secEx.getId());
        for (int i = 0; i < params.length; ++i) {
            Assert.assertEquals((Object)params[i], (Object)secEx.getArgs()[i]);
        }
    }

    @Test
    public void testRoleStoreWrapper() throws Exception {
        this.setMockCreator(new MockCreator(){

            public GeoServerSecurityManager createSecurityManager(MockTestData testData) throws Exception {
                GeoServerSecurityManager secMgr = (GeoServerSecurityManager)EasyMock.createMock(GeoServerSecurityManager.class);
                GeoServerRoleStore roleStore1 = this.createRoleStore("test", secMgr, new String[]{"role1", "parent1"});
                this.addRolesToCreate(roleStore1, new String[]{"", "duplicated", "xxx"});
                GeoServerRoleStore roleStore2 = this.createRoleStore("test1", secMgr, new String[]{"duplicated"});
                org.easymock.EasyMock.expect((Object)secMgr.listRoleServices()).andReturn(new TreeSet<String>(Arrays.asList("test", "test1"))).anyTimes();
                EasyMock.replay((Object[])new Object[]{roleStore1, roleStore2, secMgr});
                return secMgr;
            }
        });
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        GeoServerRoleStore roleStore = (GeoServerRoleStore)secMgr.loadRoleService("test");
        RoleStoreValidationWrapper store = new RoleStoreValidationWrapper(roleStore, new GeoServerUserGroupService[0]);
        try {
            store.addRole(store.createRoleObject(""));
            Assert.fail((String)"empty role name should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "NAME_REQUIRED", new Object[0]);
        }
        try {
            store.addRole(store.createRoleObject(""));
            Assert.fail((String)"empty role name should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "NAME_REQUIRED", new Object[0]);
        }
        GeoServerRole role1 = store.getRoleByName("role1");
        try {
            store.addRole(role1);
            Assert.fail((String)"already existing role name should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "ALREADY_EXISTS", "role1");
        }
        for (GeoServerRole srole : GeoServerRole.SystemRoles) {
            try {
                store.addRole(store.createRoleObject(srole.getAuthority()));
                Assert.fail((String)"reserved role name should throw exception");
            }
            catch (IOException ex) {
                this.assertSecurityException(ex, "RESERVED_NAME", srole.getAuthority());
            }
        }
        GeoServerRoleStore roleStore1 = (GeoServerRoleStore)secMgr.loadRoleService("test1");
        RoleStoreValidationWrapper store1 = new RoleStoreValidationWrapper(roleStore1, new GeoServerUserGroupService[0]);
        try {
            store.addRole(store.createRoleObject("duplicated"));
            Assert.fail((String)"reserved role name should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "ALREADY_EXISTS_IN", "duplicated", store1.getName());
        }
        try {
            String authRole = GeoServerRole.AUTHENTICATED_ROLE.getAuthority();
            store.addRole(store.createRoleObject(authRole));
            Assert.fail((String)(authRole + " is reserved and should throw exception"));
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "RESERVED_NAME", GeoServerRole.AUTHENTICATED_ROLE.getAuthority());
        }
        try {
            store.updateRole(store.createRoleObject("xxx"));
            Assert.fail((String)"update role object that does not exist should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "NOT_FOUND", "xxx");
        }
        try {
            store.setParentRole(role1, store.createRoleObject("xxx"));
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "NOT_FOUND", "xxx");
        }
        try {
            store.associateRoleToGroup(role1, "");
            Assert.fail((String)"empty group name should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUPNAME_REQUIRED", new Object[0]);
        }
        try {
            store.disAssociateRoleFromGroup(role1, "");
            Assert.fail((String)"empty group name should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUPNAME_REQUIRED", new Object[0]);
        }
        try {
            store.associateRoleToUser(role1, "");
            Assert.fail((String)"empty user name should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "USERNAME_REQUIRED", new Object[0]);
        }
        try {
            store.disAssociateRoleFromUser(role1, "");
            Assert.fail((String)"empty user name should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "USERNAME_REQUIRED", new Object[0]);
        }
        try {
            store.getRolesForUser(null);
            Assert.fail((String)"null user name should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "USERNAME_REQUIRED", new Object[0]);
        }
        try {
            store.getRolesForGroup(null);
            Assert.fail((String)"null group name should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUPNAME_REQUIRED", new Object[0]);
        }
    }

    @Test
    public void testRoleServiceWrapperAccessRules() throws Exception {
        this.setMockCreator(new MockCreator(){

            public GeoServerSecurityManager createSecurityManager(MockTestData testData) throws Exception {
                GeoServerSecurityManager secMgr = (GeoServerSecurityManager)EasyMock.createNiceMock(GeoServerSecurityManager.class);
                GeoServerRoleStore roleStore = this.createRoleStore("test", secMgr, new String[]{"role1", "parent1"});
                org.easymock.EasyMock.expect((Object)roleStore.removeRole(new GeoServerRole("unused"))).andReturn((Object)true);
                DataAccessRule dataAccessRule = (DataAccessRule)EasyMock.createNiceMock(DataAccessRule.class);
                org.easymock.EasyMock.expect((Object)dataAccessRule.compareTo(dataAccessRule)).andReturn((Object)0).anyTimes();
                org.easymock.EasyMock.expect((Object)dataAccessRule.getKey()).andReturn((Object)"foo").anyTimes();
                org.easymock.EasyMock.expect((Object)dataAccessRule.getRoles()).andReturn(new TreeSet<String>(Arrays.asList("role1"))).anyTimes();
                EasyMock.replay((Object[])new Object[]{dataAccessRule});
                DataAccessRuleDAO dataAccessDAO = (DataAccessRuleDAO)EasyMock.createNiceMock(DataAccessRuleDAO.class);
                org.easymock.EasyMock.expect((Object)dataAccessDAO.getRulesAssociatedWithRole("role1")).andReturn(new TreeSet<DataAccessRule>(Arrays.asList(dataAccessRule))).anyTimes();
                org.easymock.EasyMock.expect((Object)dataAccessDAO.getRulesAssociatedWithRole("parent1")).andReturn(new TreeSet()).anyTimes();
                org.easymock.EasyMock.expect((Object)secMgr.getDataAccessRuleDAO()).andReturn((Object)dataAccessDAO).anyTimes();
                ServiceAccessRuleDAO serviceAccessDAO = (ServiceAccessRuleDAO)EasyMock.createNiceMock(ServiceAccessRuleDAO.class);
                org.easymock.EasyMock.expect((Object)serviceAccessDAO.getRulesAssociatedWithRole((String)org.easymock.EasyMock.anyObject())).andReturn(new TreeSet()).anyTimes();
                org.easymock.EasyMock.expect((Object)secMgr.getServiceAccessRuleDAO()).andReturn((Object)serviceAccessDAO).anyTimes();
                EasyMock.replay((Object[])new Object[]{dataAccessDAO, serviceAccessDAO, roleStore, secMgr});
                return secMgr;
            }
        });
        RoleStoreValidationWrapper store = new RoleStoreValidationWrapper((GeoServerRoleStore)this.getSecurityManager().loadRoleService("test"), true, new GeoServerUserGroupService[0]);
        GeoServerRole role = store.getRoleByName("role1");
        GeoServerRole parent = store.getRoleByName("parent1");
        store.removeRole(parent);
        try {
            store.removeRole(role);
            Assert.fail((String)"used role should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "ROLE_IN_USE", role.getAuthority(), "foo");
        }
    }

    @Test
    public void testRoleStoreWrapperWithUGServices() throws Exception {
        this.setMockCreator(new MockCreator(){

            public GeoServerSecurityManager createSecurityManager(MockTestData testData) throws Exception {
                GeoServerSecurityManager secMgr = (GeoServerSecurityManager)EasyMock.createNiceMock(GeoServerSecurityManager.class);
                GeoServerUserGroupStore ugStore1 = this.createUserGroupStore("test1", secMgr);
                this.addUsers(ugStore1, new String[]{"user1", "abc"});
                this.addGroups(ugStore1, new String[]{"group1"});
                GeoServerUserGroupStore ugStore2 = this.createUserGroupStore("test2", secMgr);
                this.addUsers(ugStore1, new String[]{"user2", "abc"});
                this.addGroups(ugStore1, new String[]{"group2"});
                GeoServerRoleStore roleStore = this.createRoleStore("test", secMgr, new String[]{"role1"});
                org.easymock.EasyMock.expect((Object)roleStore.getGroupNamesForRole(new GeoServerRole("role1"))).andReturn(new TreeSet<String>(Arrays.asList("group1", "group2"))).anyTimes();
                EasyMock.replay((Object[])new Object[]{ugStore1, ugStore2, roleStore, secMgr});
                return secMgr;
            }
        });
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        GeoServerUserGroupStore ugStore1 = (GeoServerUserGroupStore)secMgr.loadUserGroupService("test1");
        GeoServerUserGroupStore ugStore2 = (GeoServerUserGroupStore)secMgr.loadUserGroupService("test2");
        RoleStoreValidationWrapper store = new RoleStoreValidationWrapper((GeoServerRoleStore)secMgr.loadRoleService("test"), new GeoServerUserGroupService[]{ugStore1, ugStore2});
        GeoServerRole role1 = store.getRoleByName("role1");
        try {
            store.associateRoleToGroup(role1, "group3");
            Assert.fail((String)"unkown group should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUPNAME_NOT_FOUND", "group3");
        }
        try {
            store.associateRoleToUser(role1, "user3");
            Assert.fail((String)"unkown user should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "USERNAME_NOT_FOUND", "user3");
        }
        try {
            store.getRolesForGroup("group3");
            Assert.fail((String)"unkown group should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUPNAME_NOT_FOUND", "group3");
        }
        try {
            store.getRolesForUser("user3");
            Assert.fail((String)"unkown user should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "USERNAME_NOT_FOUND", "user3");
        }
        store.disAssociateRoleFromGroup(role1, "group1");
        store.disAssociateRoleFromGroup(role1, "group2");
        try {
            store.disAssociateRoleFromGroup(role1, "group3");
            Assert.fail((String)"unkown group should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUPNAME_NOT_FOUND", "group3");
        }
        store.disAssociateRoleFromUser(role1, "user1");
        store.disAssociateRoleFromUser(role1, "user1");
        try {
            store.disAssociateRoleFromUser(role1, "user3");
            Assert.fail((String)"unkown user should throw exception");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "USERNAME_NOT_FOUND", "user3");
        }
    }

    @Test
    public void testMappedRoles() throws Exception {
        this.setMockCreator(new MockCreator(){

            public GeoServerSecurityManager createSecurityManager(MockTestData testData) throws Exception {
                GeoServerSecurityManager secMgr = (GeoServerSecurityManager)EasyMock.createNiceMock(GeoServerSecurityManager.class);
                GeoServerRoleStore roleStore = this.createRoleStore("test", secMgr, new String[]{"admin", "groupAdmin", "role1"});
                this.addRolesToCreate(roleStore, new String[]{"admin", "groupAdmin"});
                org.easymock.EasyMock.expect((Object)roleStore.getAdminRole()).andReturn((Object)new GeoServerRole("admin")).anyTimes();
                org.easymock.EasyMock.expect((Object)roleStore.getGroupAdminRole()).andReturn((Object)new GeoServerRole("groupAdmin")).anyTimes();
                EasyMock.replay((Object[])new Object[]{roleStore, secMgr});
                return secMgr;
            }
        });
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        RoleStoreValidationWrapper store = new RoleStoreValidationWrapper((GeoServerRoleStore)secMgr.loadRoleService("test"), new GeoServerUserGroupService[0]);
        try {
            store.removeRole(store.createRoleObject("admin"));
            Assert.fail((String)"removing admin role should fail");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "ADMIN_ROLE_NOT_REMOVABLE", "admin");
        }
        try {
            store.removeRole(store.createRoleObject("groupAdmin"));
            Assert.fail((String)"removing group admin role should fail");
        }
        catch (IOException ex) {
            this.assertSecurityException(ex, "GROUP_ADMIN_ROLE_NOT_REMOVABLE", "groupAdmin");
        }
    }
}

