/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.rememberme;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerSecurityFilterChainProxy;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.GeoServerSecurityTestSupport;
import org.geoserver.security.config.BaseSecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerAuthenticationFilter;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.test.SystemTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Category(value={SystemTest.class})
public class RememberMeTest
extends GeoServerSecurityTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        BaseSecurityNamedServiceConfig filterCfg = new BaseSecurityNamedServiceConfig();
        filterCfg.setName("custom");
        filterCfg.setClassName(AuthCapturingFilter.class.getName());
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        secMgr.saveFilter((SecurityNamedServiceConfig)filterCfg);
        SecurityManagerConfig cfg = secMgr.getSecurityConfig();
        cfg.getFilterChain().insertAfter("/web/**", filterCfg.getName(), "rememberme");
        secMgr.saveSecurityConfig(cfg);
    }

    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add(((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + "-context.xml").toString());
    }

    protected List<Filter> getFilters() {
        return Arrays.asList((Filter)applicationContext.getBean(GeoServerSecurityFilterChainProxy.class));
    }

    @Test
    public void testRememberMeLogin() throws Exception {
        MockHttpServletRequest request = this.createRequest("/login");
        request.addParameter("username", "admin");
        request.addParameter("password", "geoserver");
        request.setMethod("POST");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        this.assertLoginOk(response);
        Assert.assertEquals((long)0L, (long)response.getCookies().length);
        request = this.createRequest("/login");
        request.addParameter("username", "admin");
        request.addParameter("password", "geoserver");
        request.addParameter("_spring_security_remember_me", "yes");
        request.setMethod("POST");
        response = this.dispatch((HttpServletRequest)request);
        this.assertLoginOk(response);
        Assert.assertEquals((long)1L, (long)response.getCookies().length);
        Cookie cookie = response.getCookies()[0];
        request = this.createRequest("/web/");
        response = this.dispatch((HttpServletRequest)request);
        Assert.assertNull((Object)request.getAttribute("auth"));
        request = this.createRequest("/web/");
        request.setCookies(new Cookie[]{cookie});
        response = this.dispatch((HttpServletRequest)request);
        Assert.assertTrue((boolean)(request.getAttribute("auth") instanceof RememberMeAuthenticationToken));
    }

    @Test
    public void testRememberMeOtherUserGroupService() throws Exception {
    }

    void assertLoginOk(MockHttpServletResponse resp) {
        Assert.assertEquals((Object)"/geoserver/web", (Object)resp.getHeader("Location"));
    }

    void assertLoginFailed(MockHttpServletResponse resp) {
        Assert.assertTrue((boolean)resp.getHeader("Location").endsWith("GeoServerLoginPage&error=true"));
    }

    static class SecurityProvider
    extends GeoServerSecurityProvider {
        SecurityProvider() {
        }

        public Class<? extends GeoServerSecurityFilter> getFilterClass() {
            return AuthCapturingFilter.class;
        }

        public GeoServerSecurityFilter createFilter(SecurityNamedServiceConfig config) {
            return new AuthCapturingFilter();
        }
    }

    static class AuthCapturingFilter
    extends GeoServerSecurityFilter
    implements GeoServerAuthenticationFilter {
        AuthCapturingFilter() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            request.setAttribute("auth", (Object)auth);
            chain.doFilter(request, response);
        }

        public boolean applicableForHtml() {
            return true;
        }

        public boolean applicableForServices() {
            return true;
        }
    }
}

