/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.GeoServerSecurityTestSupport;
import org.geoserver.security.auth.GeoServerRootAuthenticationProvider;
import org.geoserver.security.password.MasterPasswordConfig;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.security.password.TestMasterPasswordProvider;
import org.geoserver.security.password.URLMasterPasswordProvider;
import org.geoserver.security.password.URLMasterPasswordProviderConfig;
import org.geoserver.security.validation.MasterPasswordChangeException;
import org.geoserver.test.SystemTest;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

@Category(value={SystemTest.class})
public class MasterPasswordChangeTest
extends GeoServerSecurityTestSupport {
    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add(((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + "-context.xml").toString());
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        applicationContext.getBeanFactory().registerSingleton("testMasterPasswordProvider", (Object)new TestMasterPasswordProvider());
    }

    @Test
    public void testMasterPasswordChange() throws Exception {
        MasterPasswordProviderConfig masterPasswordConfig = this.getSecurityManager().loadMasterPassswordProviderConfig(this.getSecurityManager().getMasterPasswordConfig().getProviderName());
        masterPasswordConfig.setLoginEnabled(true);
        this.getSecurityManager().saveMasterPasswordProviderConfig(masterPasswordConfig);
        String masterPWAsString = this.getMasterPassword();
        MasterPasswordConfig config = this.getSecurityManager().getMasterPasswordConfig();
        URLMasterPasswordProviderConfig mpConfig = (URLMasterPasswordProviderConfig)this.getSecurityManager().loadMasterPassswordProviderConfig(config.getProviderName());
        Assert.assertTrue((boolean)mpConfig.getURL().toString().endsWith("passwd"));
        this.getSecurityManager().getKeyStoreProvider().reloadKeyStore();
        try {
            this.getSecurityManager().saveMasterPasswordConfig(config, null, null, null);
            Assert.fail();
        }
        catch (MasterPasswordChangeException masterPasswordChangeException) {
            // empty catch block
        }
        mpConfig = new URLMasterPasswordProviderConfig();
        mpConfig.setName("rw");
        mpConfig.setClassName(URLMasterPasswordProvider.class.getCanonicalName());
        mpConfig.setReadOnly(false);
        File tmp = new File(this.getSecurityManager().get("security").dir(), "mpw1.properties");
        mpConfig.setURL(URLs.fileToUrl((File)tmp));
        this.getSecurityManager().saveMasterPasswordProviderConfig((MasterPasswordProviderConfig)mpConfig);
        config = this.getSecurityManager().getMasterPasswordConfig();
        config.setProviderName(mpConfig.getName());
        this.getSecurityManager().saveMasterPasswordConfig(config, masterPWAsString.toCharArray(), "geoserver1".toCharArray(), "geoserver1".toCharArray());
        Assert.assertEquals((Object)"geoserver1", (Object)this.getMasterPassword());
        this.getSecurityManager().getKeyStoreProvider().getConfigPasswordKey();
        mpConfig = new URLMasterPasswordProviderConfig();
        mpConfig.setName("ro");
        mpConfig.setClassName(URLMasterPasswordProvider.class.getCanonicalName());
        mpConfig.setReadOnly(true);
        tmp = new File(this.getSecurityManager().get("security").dir(), "mpw2.properties");
        mpConfig.setURL(URLs.fileToUrl((File)tmp));
        FileUtils.writeStringToFile((File)tmp, (String)"geoserver2");
        this.getSecurityManager().saveMasterPasswordProviderConfig((MasterPasswordProviderConfig)mpConfig);
        config = this.getSecurityManager().getMasterPasswordConfig();
        config.setProviderName("ro");
        this.getSecurityManager().saveMasterPasswordConfig(config, "geoserver1".toCharArray(), null, "geoserver2".toCharArray());
        Assert.assertEquals((Object)"geoserver2", (Object)this.getMasterPassword());
        this.getSecurityManager().getKeyStoreProvider().getConfigPasswordKey();
        MasterPasswordProviderConfig mpConfig2 = new MasterPasswordProviderConfig();
        mpConfig2.setLoginEnabled(true);
        mpConfig2.setName("test");
        mpConfig2.setClassName(TestMasterPasswordProvider.class.getCanonicalName());
        this.getSecurityManager().saveMasterPasswordProviderConfig(mpConfig2);
        config = this.getSecurityManager().getMasterPasswordConfig();
        config.setProviderName("test");
        this.getSecurityManager().saveMasterPasswordConfig(config, "geoserver2".toCharArray(), "geoserver3".toCharArray(), "geoserver3".toCharArray());
        this.getSecurityManager().getKeyStoreProvider().commitMasterPasswordChange();
        Assert.assertEquals((Object)"geoserver3", (Object)this.getMasterPassword());
        this.getSecurityManager().getKeyStoreProvider().getConfigPasswordKey();
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"root", (Object)"geoserver3");
        GeoServerRootAuthenticationProvider authProvider = new GeoServerRootAuthenticationProvider();
        authProvider.setSecurityManager(this.getSecurityManager());
        auth = authProvider.authenticate((Authentication)auth);
        Assert.assertTrue((boolean)auth.isAuthenticated());
        auth = new UsernamePasswordAuthenticationToken((Object)"root", (Object)"abcdefghijk");
        Assert.assertNull((Object)authProvider.authenticate((Authentication)auth));
        Assert.assertFalse((boolean)auth.isAuthenticated());
    }
}

