/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.KeyStoreProvider;
import org.geoserver.security.password.GeoServerDigestPasswordEncoder;
import org.geoserver.security.password.GeoServerEmptyPasswordEncoder;
import org.geoserver.security.password.GeoServerMultiplexingPasswordEncoder;
import org.geoserver.security.password.GeoServerPBEPasswordEncoder;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.password.GeoServerPlainTextPasswordEncoder;
import org.geoserver.security.password.PasswordEncodingType;
import org.geoserver.security.xml.XMLUserGroupService;
import org.geoserver.test.GeoServerMockTestSupport;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class GeoserverPasswordEncoderTest
extends GeoServerMockTestSupport {
    protected String testPassword = "geoserver";
    protected char[] testPasswordArray = this.testPassword.toCharArray();
    protected char[] emptyArray = new char[0];
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");

    @Test
    public void testPlainTextEncoder() {
        GeoServerPlainTextPasswordEncoder encoder = this.getPlainTextPasswordEncoder();
        Assert.assertEquals((Object)PasswordEncodingType.PLAIN, (Object)encoder.getEncodingType());
        Assert.assertEquals((Object)("plain:" + this.testPassword), (Object)encoder.encodePassword(this.testPassword, null));
        Assert.assertTrue((boolean)encoder.isResponsibleForEncoding("plain:123"));
        Assert.assertFalse((boolean)encoder.isResponsibleForEncoding("digest1:123"));
        String enc = encoder.encodePassword(this.testPassword, null);
        String enc2 = encoder.encodePassword(this.testPasswordArray, null);
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, this.testPassword, null));
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, this.testPasswordArray, null));
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc2, this.testPassword, null));
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc2, this.testPasswordArray, null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(enc, "plain:blabla", null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(enc, "plain:blabla".toCharArray(), null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(enc2, "plain:blabla", null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(enc2, "plain:blabla".toCharArray(), null));
        Assert.assertEquals((Object)this.testPassword, (Object)encoder.decode(enc));
        Assert.assertTrue((boolean)Arrays.equals(this.testPasswordArray, encoder.decodeToCharArray(enc)));
        Assert.assertEquals((Object)this.testPassword, (Object)encoder.decode(enc2));
        Assert.assertTrue((boolean)Arrays.equals(this.testPasswordArray, encoder.decodeToCharArray(enc2)));
        enc = encoder.encodePassword("", null);
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, "", null));
        enc2 = encoder.encodePassword(this.emptyArray, null);
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, this.emptyArray, null));
    }

    @Test
    public void testConfigPlainTextEncoder() {
        GeoServerPlainTextPasswordEncoder encoder = this.getPlainTextPasswordEncoder();
        GeoServerMultiplexingPasswordEncoder encoder2 = new GeoServerMultiplexingPasswordEncoder(this.getSecurityManager());
        Assert.assertEquals((Object)PasswordEncodingType.PLAIN, (Object)encoder.getEncodingType());
        Assert.assertEquals((Object)("plain:" + this.testPassword), (Object)encoder.encodePassword(this.testPassword, null));
        Assert.assertTrue((boolean)encoder.isResponsibleForEncoding("plain:123"));
        Assert.assertFalse((boolean)encoder.isResponsibleForEncoding("digest1:123"));
        String enc = encoder.encodePassword(this.testPassword, null);
        String enc2 = encoder.encodePassword(this.testPasswordArray, null);
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, this.testPassword, null));
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, this.testPasswordArray, null));
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc2, this.testPassword, null));
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc2, this.testPasswordArray, null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, this.testPassword, null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, this.testPasswordArray, null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid(enc2, this.testPassword, null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid(enc2, this.testPasswordArray, null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(enc, "plain:blabla", null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(enc, "plain:blabla".toCharArray(), null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(enc2, "plain:blabla", null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(enc2, "plain:blabla".toCharArray(), null));
        Assert.assertFalse((boolean)encoder2.isPasswordValid(enc, "plain:blabla", null));
        Assert.assertFalse((boolean)encoder2.isPasswordValid(enc, "plain:blabla".toCharArray(), null));
        Assert.assertFalse((boolean)encoder2.isPasswordValid(enc2, "plain:blabla", null));
        Assert.assertFalse((boolean)encoder2.isPasswordValid(enc2, "plain:blabla".toCharArray(), null));
        Assert.assertEquals((Object)this.testPassword, (Object)encoder.decode(enc));
        Assert.assertTrue((boolean)Arrays.equals(this.testPasswordArray, encoder.decodeToCharArray(enc)));
        Assert.assertEquals((Object)this.testPassword, (Object)encoder.decode(enc2));
        Assert.assertTrue((boolean)Arrays.equals(this.testPasswordArray, encoder.decodeToCharArray(enc2)));
        Assert.assertEquals((Object)this.testPassword, (Object)encoder2.decode(enc));
        Assert.assertTrue((boolean)Arrays.equals(this.testPasswordArray, encoder2.decodeToCharArray(enc)));
        Assert.assertEquals((Object)this.testPassword, (Object)encoder2.decode(enc2));
        Assert.assertTrue((boolean)Arrays.equals(this.testPasswordArray, encoder2.decodeToCharArray(enc2)));
        enc = encoder.encodePassword("", null);
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, "", null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, "", null));
        enc2 = encoder.encodePassword(this.emptyArray, null);
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, this.emptyArray, null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, this.emptyArray, null));
    }

    @Test
    public void testDigestEncoder() {
        GeoServerDigestPasswordEncoder encoder = this.getDigestPasswordEncoder();
        GeoServerMultiplexingPasswordEncoder encoder2 = new GeoServerMultiplexingPasswordEncoder(this.getSecurityManager());
        Assert.assertEquals((Object)PasswordEncodingType.DIGEST, (Object)encoder.getEncodingType());
        Assert.assertTrue((boolean)encoder.encodePassword(this.testPassword, null).startsWith("digest1:"));
        String enc = encoder.encodePassword(this.testPassword, null);
        String enc2 = encoder.encodePassword(this.testPasswordArray, null);
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, this.testPassword, null));
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, this.testPasswordArray, null));
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc2, this.testPassword, null));
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc2, this.testPasswordArray, null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, this.testPassword, null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, this.testPasswordArray, null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid(enc2, this.testPassword, null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid(enc2, this.testPasswordArray, null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(enc, "plain:blabla", null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(enc, "plain:blabla".toCharArray(), null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(enc2, "plain:blabla", null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(enc2, "plain:blabla".toCharArray(), null));
        Assert.assertFalse((boolean)encoder2.isPasswordValid(enc, "plain:blabla", null));
        Assert.assertFalse((boolean)encoder2.isPasswordValid(enc, "plain:blabla".toCharArray(), null));
        Assert.assertFalse((boolean)encoder2.isPasswordValid(enc2, "plain:blabla", null));
        Assert.assertFalse((boolean)encoder2.isPasswordValid(enc2, "plain:blabla".toCharArray(), null));
        enc = encoder.encodePassword("", null);
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, "", null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, "", null));
        enc2 = encoder.encodePassword(this.emptyArray, null);
        Assert.assertTrue((boolean)encoder.isPasswordValid(enc, this.emptyArray, null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, this.emptyArray, null));
        try {
            encoder.decode(enc);
            Assert.fail((String)"Must fail, digested passwords cannot be decoded");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            encoder2.decode(enc);
            Assert.fail((String)"Must fail, digested passwords cannot be decoded");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)encoder.isPasswordValid("digest1:CTBPxdfHvqy0K0M6uoYlb3+fPFrfMhpTm7+ey5rL/1xGI4s6g8n/OrkXdcyqzJ3D", this.testPassword, null));
        Assert.assertTrue((boolean)encoder2.isPasswordValid("digest1:CTBPxdfHvqy0K0M6uoYlb3+fPFrfMhpTm7+ey5rL/1xGI4s6g8n/OrkXdcyqzJ3D", this.testPassword, null));
    }

    @Test
    public void testEmptyEncoder() {
        GeoServerPasswordEncoder encoder = this.getSecurityManager().loadPasswordEncoder(GeoServerEmptyPasswordEncoder.class);
        Assert.assertEquals((Object)PasswordEncodingType.EMPTY, (Object)encoder.getEncodingType());
        String encodedPassword = encoder.getPrefix() + ":";
        Assert.assertEquals((Object)encodedPassword, (Object)encoder.encodePassword((String)null, null));
        Assert.assertEquals((Object)encodedPassword, (Object)encoder.encodePassword((char[])null, null));
        Assert.assertEquals((Object)encodedPassword, (Object)encoder.encodePassword("", null));
        Assert.assertEquals((Object)encodedPassword, (Object)encoder.encodePassword(new char[0], null));
        Assert.assertEquals((Object)encodedPassword, (Object)encoder.encodePassword("blbal", null));
        Assert.assertEquals((Object)encodedPassword, (Object)encoder.encodePassword("blbal".toCharArray(), null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(encodedPassword, "blabla", null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(encodedPassword, "blabla".toCharArray(), null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(encodedPassword, "", null));
        Assert.assertFalse((boolean)encoder.isPasswordValid(encodedPassword, "".toCharArray(), null));
        try {
            encoder.decode("");
            Assert.fail((String)"Must fail, empty passwords cannot be decoded");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        GeoServerMultiplexingPasswordEncoder encoder2 = new GeoServerMultiplexingPasswordEncoder(this.getSecurityManager());
        Assert.assertFalse((boolean)encoder2.isPasswordValid(encodedPassword, "blabla", null));
        Assert.assertFalse((boolean)encoder2.isPasswordValid(encodedPassword, "blabla".toCharArray(), null));
        Assert.assertFalse((boolean)encoder2.isPasswordValid(encodedPassword, "", null));
        Assert.assertFalse((boolean)encoder2.isPasswordValid(encodedPassword, "".toCharArray(), null));
        try {
            encoder2.decode("");
            Assert.fail((String)"Must fail, empty passwords cannot be decoded");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    protected List<GeoServerPasswordEncoder> getConfigPBEEncoders() {
        ArrayList<GeoServerPasswordEncoder> result = new ArrayList<GeoServerPasswordEncoder>();
        result.add((GeoServerPasswordEncoder)this.getPBEPasswordEncoder());
        if (this.getSecurityManager().isStrongEncryptionAvailable()) {
            result.add((GeoServerPasswordEncoder)this.getStrongPBEPasswordEncoder());
        } else {
            LOGGER.warning("Skipping strong encryption tests for configuration passwords");
        }
        return result;
    }

    @Test
    public void testConfigPBEEncoder() throws Exception {
        GeoServerMultiplexingPasswordEncoder encoder2 = new GeoServerMultiplexingPasswordEncoder(this.getSecurityManager());
        for (GeoServerPasswordEncoder encoder : this.getConfigPBEEncoders()) {
            encoder.initialize(this.getSecurityManager());
            Assert.assertEquals((Object)PasswordEncodingType.ENCRYPT, (Object)encoder.getEncodingType());
            Assert.assertTrue((boolean)encoder.encodePassword(this.testPassword, null).startsWith(encoder.getPrefix() + ":"));
            String enc = encoder.encodePassword(this.testPassword, null);
            String enc2 = encoder.encodePassword(this.testPasswordArray, null);
            Assert.assertTrue((boolean)encoder.isPasswordValid(enc, this.testPassword, null));
            Assert.assertTrue((boolean)encoder.isPasswordValid(enc, this.testPasswordArray, null));
            Assert.assertTrue((boolean)encoder.isPasswordValid(enc2, this.testPassword, null));
            Assert.assertTrue((boolean)encoder.isPasswordValid(enc2, this.testPasswordArray, null));
            Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, this.testPassword, null));
            Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, this.testPasswordArray, null));
            Assert.assertTrue((boolean)encoder2.isPasswordValid(enc2, this.testPassword, null));
            Assert.assertTrue((boolean)encoder2.isPasswordValid(enc2, this.testPasswordArray, null));
            Assert.assertFalse((boolean)encoder.isPasswordValid(enc, "crypt1:blabla", null));
            Assert.assertFalse((boolean)encoder.isPasswordValid(enc, "crypt1:blabla".toCharArray(), null));
            Assert.assertFalse((boolean)encoder.isPasswordValid(enc2, "crypt1:blabla", null));
            Assert.assertFalse((boolean)encoder.isPasswordValid(enc2, "crypt1:blabla".toCharArray(), null));
            Assert.assertFalse((boolean)encoder2.isPasswordValid(enc, "crypt1:blabla", null));
            Assert.assertFalse((boolean)encoder2.isPasswordValid(enc, "crypt1:blabla".toCharArray(), null));
            Assert.assertFalse((boolean)encoder2.isPasswordValid(enc2, "crypt1:blabla", null));
            Assert.assertFalse((boolean)encoder2.isPasswordValid(enc2, "crypt1:blabla".toCharArray(), null));
            Assert.assertEquals((Object)this.testPassword, (Object)encoder.decode(enc));
            Assert.assertTrue((boolean)Arrays.equals(this.testPasswordArray, encoder.decodeToCharArray(enc)));
            Assert.assertEquals((Object)this.testPassword, (Object)encoder.decode(enc2));
            Assert.assertTrue((boolean)Arrays.equals(this.testPasswordArray, encoder.decodeToCharArray(enc2)));
            Assert.assertEquals((Object)this.testPassword, (Object)encoder2.decode(enc));
            Assert.assertTrue((boolean)Arrays.equals(this.testPasswordArray, encoder2.decodeToCharArray(enc)));
            Assert.assertEquals((Object)this.testPassword, (Object)encoder2.decode(enc2));
            Assert.assertTrue((boolean)Arrays.equals(this.testPasswordArray, encoder2.decodeToCharArray(enc2)));
            enc = encoder.encodePassword("", null);
            Assert.assertTrue((boolean)encoder.isPasswordValid(enc, "", null));
            Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, "", null));
            enc2 = encoder.encodePassword(this.emptyArray, null);
            Assert.assertTrue((boolean)encoder.isPasswordValid(enc, this.emptyArray, null));
            Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, this.emptyArray, null));
        }
    }

    protected List<GeoServerPBEPasswordEncoder> getPBEEncoders() {
        ArrayList<GeoServerPBEPasswordEncoder> result = new ArrayList<GeoServerPBEPasswordEncoder>();
        result.add(this.getPBEPasswordEncoder());
        if (this.getSecurityManager().isStrongEncryptionAvailable()) {
            result.add(this.getStrongPBEPasswordEncoder());
        } else {
            LOGGER.warning("Skipping strong encryption tests for user passwords");
        }
        return result;
    }

    @Test
    public void testUserGroupServiceEncoder() throws Exception {
        GeoServerUserGroupService service = this.getSecurityManager().loadUserGroupService(XMLUserGroupService.DEFAULT_NAME);
        String password = "testpassword";
        char[] passwordArray = password.toCharArray();
        KeyStoreProvider keyStoreProvider = this.getSecurityManager().getKeyStoreProvider();
        keyStoreProvider.setUserGroupKey(service.getName(), password.toCharArray());
        GeoServerMultiplexingPasswordEncoder encoder3 = new GeoServerMultiplexingPasswordEncoder(this.getSecurityManager(), service);
        for (GeoServerPBEPasswordEncoder encoder : this.getPBEEncoders()) {
            encoder.initializeFor(service);
            Assert.assertEquals((Object)PasswordEncodingType.ENCRYPT, (Object)encoder.getEncodingType());
            Assert.assertEquals((Object)encoder.getKeyAliasInKeyStore(), (Object)keyStoreProvider.aliasForGroupService(service.getName()));
            GeoServerPBEPasswordEncoder encoder2 = (GeoServerPBEPasswordEncoder)this.getSecurityManager().loadPasswordEncoder(encoder.getName());
            encoder2.initializeFor(service);
            Assert.assertFalse((encoder == encoder2 ? 1 : 0) != 0);
            String enc = encoder.encodePassword(password, null);
            Assert.assertTrue((boolean)enc.startsWith(encoder.getPrefix() + ":"));
            String encFromArray = encoder.encodePassword(passwordArray, null);
            Assert.assertTrue((boolean)encFromArray.startsWith(encoder.getPrefix() + ":"));
            Assert.assertFalse((boolean)enc.equals(password));
            Assert.assertFalse((boolean)Arrays.equals(encFromArray.toCharArray(), passwordArray));
            Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, password, null));
            Assert.assertTrue((boolean)encoder2.isPasswordValid(encFromArray, password, null));
            Assert.assertTrue((boolean)encoder2.isPasswordValid(enc, passwordArray, null));
            Assert.assertTrue((boolean)encoder2.isPasswordValid(encFromArray, passwordArray, null));
            Assert.assertTrue((boolean)encoder3.isPasswordValid(enc, password, null));
            Assert.assertTrue((boolean)encoder3.isPasswordValid(encFromArray, password, null));
            Assert.assertTrue((boolean)encoder3.isPasswordValid(enc, passwordArray, null));
            Assert.assertTrue((boolean)encoder3.isPasswordValid(encFromArray, passwordArray, null));
            Assert.assertEquals((Object)password, (Object)encoder2.decode(enc));
            Assert.assertEquals((Object)password, (Object)encoder3.decode(enc));
            Assert.assertEquals((Object)password, (Object)encoder.decode(enc));
            Assert.assertEquals((Object)password, (Object)encoder.decode(encFromArray));
            Assert.assertTrue((boolean)Arrays.equals(passwordArray, encoder.decodeToCharArray(enc)));
            Assert.assertTrue((boolean)Arrays.equals(passwordArray, encoder.decodeToCharArray(encFromArray)));
        }
    }

    @Test
    public void testCustomPasswordProvider() {
        ClassPathXmlApplicationContext appContext = new ClassPathXmlApplicationContext("classpath*:/passwordSecurityContext.xml");
        appContext.refresh();
        List encoders = GeoServerExtensions.extensions(GeoServerPasswordEncoder.class, (ApplicationContext)appContext);
        boolean found = false;
        for (GeoServerPasswordEncoder enc : encoders) {
            if (enc.getPrefix() == null || !enc.getPrefix().equals("plain4711")) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }
}

