/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.InputStream;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.decorators.ReadOnlyDataStoreTest;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.geoserver.util.IOUtils;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.opengis.filter.Filter;

@Category(value={SystemTest.class})
public class SecureCatalogIntegrationTest
extends GeoServerSystemTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        File security = new File(testData.getDataDirectoryRoot(), "security");
        File layers = new File(security, "layers.properties");
        IOUtils.copy((InputStream)SecureCatalogIntegrationTest.class.getResourceAsStream("functional.properties"), (File)layers);
    }

    @Test
    public void testFullAccess() throws Exception {
        SimpleFeatureSource source = this.getFeatureSource(MockData.LINES);
        FeatureCollection fc = source.getFeatures();
        FeatureStore store = (FeatureStore)source;
        store.removeFeatures((Filter)Filter.INCLUDE);
    }

    @Test
    public void testCannotRead() throws Exception {
        block2: {
            try {
                this.getFeatureSource(MockData.BUILDINGS);
                Assert.fail((String)"This should have failed with a security exception!");
            }
            catch (Exception e) {
                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block2;
                Assert.fail((String)"Should have failed with a security exception");
            }
        }
    }

    @Test
    public void testCannotWrite() throws Exception {
        block2: {
            FeatureStore fs = (FeatureStore)this.getFeatureSource(MockData.DELETES);
            try {
                fs.removeFeatures((Filter)Filter.INCLUDE);
                Assert.fail((String)"This should have failed with a security exception!");
            }
            catch (Exception e) {
                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block2;
                Assert.fail((String)"Should have failed with a security exception");
            }
        }
    }
}

