/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.AbstractCatalogDecorator;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.security.AbstractCatalogFilter;
import org.geoserver.security.CatalogFilterAccessManager;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.ResourceAccessManagerWrapper;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ReadOnlyDataStoreTest;
import org.geoserver.security.decorators.SecuredCoverageInfo;
import org.geoserver.security.decorators.SecuredDataStoreInfo;
import org.geoserver.security.decorators.SecuredFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredLayerGroupInfo;
import org.geoserver.security.decorators.SecuredLayerInfo;
import org.geoserver.security.decorators.SecuredWMSLayerInfo;
import org.geoserver.security.decorators.SecuredWMTSLayerInfo;
import org.geoserver.security.impl.AbstractAuthorizationTest;
import org.geotools.util.logging.Logging;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecureCatalogImplTest
extends AbstractAuthorizationTest {
    public static final Logger LOGGER = Logging.getLogger(SecureCatalogImplTest.class);
    @Rule
    public GeoServerExtensionsHelper.ExtensionsHelperRule extensions = new GeoServerExtensionsHelper.ExtensionsHelperRule();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.populateCatalog();
        SecurityContextHolder.getContext().setAuthentication(null);
        Dispatcher.REQUEST.remove();
    }

    @After
    public void cleanup() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    @Test
    public void testWideOpen() throws Exception {
        this.buildManager("wideOpen.properties");
        SecurityContextHolder.getContext().setAuthentication(this.anonymous);
        Assert.assertSame((Object)this.states, (Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertSame((Object)this.arcGrid, (Object)this.sc.getCoverageByName("nurc:arcgrid"));
        Assert.assertSame((Object)this.states, (Object)this.sc.getResourceByName("topp:states", FeatureTypeInfo.class));
        Assert.assertSame((Object)this.arcGrid, (Object)this.sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        Assert.assertSame((Object)this.cascaded, (Object)this.sc.getResourceByName("topp:cascaded", WMSLayerInfo.class));
        Assert.assertSame((Object)this.cascadedWmts, (Object)this.sc.getResourceByName("topp:cascadedWmts", WMTSLayerInfo.class));
        Assert.assertEquals((Object)this.toppWs, (Object)this.sc.getWorkspaceByName("topp"));
        Assert.assertSame((Object)this.statesStore, (Object)this.sc.getDataStoreByName("states"));
        Assert.assertSame((Object)this.roadsStore, (Object)this.sc.getDataStoreByName("roads"));
        Assert.assertSame((Object)this.arcGridStore, (Object)this.sc.getCoverageStoreByName("arcGrid"));
        SecureCatalogImplTest.assertThatBoth(this.sc.getFeatureTypes(), this.sc.list(FeatureTypeInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.featureTypes));
        SecureCatalogImplTest.assertThatBoth(this.sc.getCoverages(), this.sc.list(CoverageInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.coverages));
        SecureCatalogImplTest.assertThatBoth(this.sc.getWorkspaces(), this.sc.list(WorkspaceInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.workspaces));
    }

    @Test
    public void testLockedDown() throws Exception {
        this.buildManager("lockedDown.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertNull((Object)this.sc.getCoverageByName("nurc:arcgrid"));
        Assert.assertNull((Object)this.sc.getResourceByName("topp:states", FeatureTypeInfo.class));
        Assert.assertNull((Object)this.sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        Assert.assertNull((Object)this.sc.getWorkspaceByName("topp"));
        Assert.assertNull((Object)this.sc.getDataStoreByName("states"));
        Assert.assertNull((Object)this.sc.getDataStoreByName("roads"));
        Assert.assertNull((Object)this.sc.getCoverageStoreByName("arcGrid"));
        SecureCatalogImplTest.assertThatBoth(this.sc.getFeatureTypes(), this.sc.list(FeatureTypeInfo.class, Predicates.acceptAll()), Matchers.empty());
        SecureCatalogImplTest.assertThatBoth(this.sc.getCoverages(), this.sc.list(CoverageInfo.class, Predicates.acceptAll()), Matchers.empty());
        SecureCatalogImplTest.assertThatBoth(this.sc.getWorkspaces(), this.sc.list(WorkspaceInfo.class, Predicates.acceptAll()), Matchers.empty());
        SecurityContextHolder.getContext().setAuthentication(this.rwUser);
        Assert.assertSame((Object)this.states, (Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertSame((Object)this.arcGrid, (Object)this.sc.getCoverageByName("nurc:arcgrid"));
        Assert.assertSame((Object)this.states, (Object)this.sc.getResourceByName("topp:states", FeatureTypeInfo.class));
        Assert.assertSame((Object)this.arcGrid, (Object)this.sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        Assert.assertEquals((Object)this.toppWs, (Object)this.sc.getWorkspaceByName("topp"));
        Assert.assertSame((Object)this.statesStore, (Object)this.sc.getDataStoreByName("states"));
        Assert.assertSame((Object)this.roadsStore, (Object)this.sc.getDataStoreByName("roads"));
        Assert.assertSame((Object)this.arcGridStore, (Object)this.sc.getCoverageStoreByName("arcGrid"));
        SecureCatalogImplTest.assertThatBoth(this.sc.getFeatureTypes(), this.sc.list(FeatureTypeInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.featureTypes));
        SecureCatalogImplTest.assertThatBoth(this.sc.getCoverages(), this.sc.list(CoverageInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.coverages));
        SecureCatalogImplTest.assertThatBoth(this.sc.getWorkspaces(), this.sc.list(WorkspaceInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.workspaces));
    }

    @Test
    public void testLockedChallenge() throws Exception {
        block20: {
            block19: {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    this.buildManager("lockedDownChallenge.properties");
                                    SecurityContextHolder.getContext().setAuthentication(this.roUser);
                                    try {
                                        this.sc.getFeatureTypeByName("topp:states").getFeatureSource(null, null);
                                        Assert.fail((String)"Should have failed with a security exception");
                                    }
                                    catch (Exception e) {
                                        if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block14;
                                        Assert.fail((String)"Should have failed with a security exception");
                                    }
                                }
                                try {
                                    this.sc.getCoverageByName("nurc:arcgrid").getGridCoverage(null, null);
                                    Assert.fail((String)"Should have failed with a security exception");
                                }
                                catch (Exception e) {
                                    if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block15;
                                    Assert.fail((String)"Should have failed with a security exception");
                                }
                            }
                            try {
                                ((FeatureTypeInfo)this.sc.getResourceByName("topp:states", FeatureTypeInfo.class)).getFeatureSource(null, null);
                                Assert.fail((String)"Should have failed with a security exception");
                            }
                            catch (Exception e) {
                                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block16;
                                Assert.fail((String)"Should have failed with a security exception");
                            }
                        }
                        try {
                            ((CoverageInfo)this.sc.getResourceByName("nurc:arcgrid", CoverageInfo.class)).getGridCoverage(null, null);
                            Assert.fail((String)"Should have failed with a security exception");
                        }
                        catch (Exception e) {
                            if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block17;
                            Assert.fail((String)"Should have failed with a security exception");
                        }
                    }
                    this.sc.getWorkspaceByName("topp");
                    try {
                        this.sc.getDataStoreByName("states").getDataStore(null);
                        Assert.fail((String)"Should have failed with a security exception");
                    }
                    catch (Exception e) {
                        if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block18;
                        Assert.fail((String)"Should have failed with a security exception");
                    }
                }
                try {
                    this.sc.getDataStoreByName("roads").getDataStore(null);
                    Assert.fail((String)"Should have failed with a security exception");
                }
                catch (Exception e) {
                    if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block19;
                    Assert.fail((String)"Should have failed with a security exception");
                }
            }
            try {
                this.sc.getCoverageStoreByName("arcGrid").getFormat();
                Assert.fail((String)"Should have failed with a security exception");
            }
            catch (Exception e) {
                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block20;
                Assert.fail((String)"Should have failed with a security exception");
            }
        }
        SecureCatalogImplTest.assertThatBoth(this.sc.getFeatureTypes(), this.sc.list(FeatureTypeInfo.class, Predicates.acceptAll()), Matchers.allOf((Matcher)Matchers.hasSize((int)this.featureTypes.size()), (Matcher)Matchers.everyItem((Matcher)Matchers.instanceOf(SecuredFeatureTypeInfo.class))));
        SecureCatalogImplTest.assertThatBoth(this.sc.getCoverages(), this.sc.list(CoverageInfo.class, Predicates.acceptAll()), Matchers.allOf((Matcher)Matchers.hasSize((int)this.coverages.size()), (Matcher)Matchers.everyItem((Matcher)Matchers.instanceOf(SecuredCoverageInfo.class))));
        SecureCatalogImplTest.assertThatBoth(this.sc.getWorkspaces(), this.sc.list(WorkspaceInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.workspaces));
        SecurityContextHolder.getContext().setAuthentication(this.rwUser);
        Assert.assertSame((Object)this.states, (Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertSame((Object)this.arcGrid, (Object)this.sc.getCoverageByName("nurc:arcgrid"));
        Assert.assertSame((Object)this.states, (Object)this.sc.getResourceByName("topp:states", FeatureTypeInfo.class));
        Assert.assertSame((Object)this.arcGrid, (Object)this.sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        Assert.assertEquals((Object)this.toppWs, (Object)this.sc.getWorkspaceByName("topp"));
        Assert.assertSame((Object)this.statesStore, (Object)this.sc.getDataStoreByName("states"));
        Assert.assertSame((Object)this.roadsStore, (Object)this.sc.getDataStoreByName("roads"));
        Assert.assertSame((Object)this.arcGridStore, (Object)this.sc.getCoverageStoreByName("arcGrid"));
        SecureCatalogImplTest.assertThatBoth(this.sc.getFeatureTypes(), this.sc.list(FeatureTypeInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.featureTypes));
        SecureCatalogImplTest.assertThatBoth(this.sc.getCoverages(), this.sc.list(CoverageInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.coverages));
        SecureCatalogImplTest.assertThatBoth(this.sc.getWorkspaces(), this.sc.list(WorkspaceInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.workspaces));
    }

    @Test
    public void testLockedMixed() throws Exception {
        Request request;
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    block16: {
                                        this.buildManager("lockedDownMixed.properties");
                                        SecurityContextHolder.getContext().setAuthentication(this.roUser);
                                        request = (Request)org.easymock.classextension.EasyMock.createNiceMock(Request.class);
                                        org.easymock.classextension.EasyMock.expect((Object)request.getRequest()).andReturn((Object)"GetFeatures").anyTimes();
                                        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{request});
                                        Dispatcher.REQUEST.set(request);
                                        try {
                                            this.sc.getFeatureTypeByName("topp:states");
                                            Assert.fail((String)"Should have failed with a security exception");
                                        }
                                        catch (Exception e) {
                                            if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block16;
                                            Assert.fail((String)"Should have failed with a security exception");
                                        }
                                    }
                                    try {
                                        this.sc.getCoverageByName("nurc:arcgrid");
                                        Assert.fail((String)"Should have failed with a security exception");
                                    }
                                    catch (Exception e) {
                                        if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block17;
                                        Assert.fail((String)"Should have failed with a security exception");
                                    }
                                }
                                try {
                                    this.sc.getResourceByName("topp:states", FeatureTypeInfo.class);
                                    Assert.fail((String)"Should have failed with a security exception");
                                }
                                catch (Exception e) {
                                    if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block18;
                                    Assert.fail((String)"Should have failed with a security exception");
                                }
                            }
                            try {
                                this.sc.getResourceByName("nurc:arcgrid", CoverageInfo.class);
                                Assert.fail((String)"Should have failed with a security exception");
                            }
                            catch (Exception e) {
                                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block19;
                                Assert.fail((String)"Should have failed with a security exception");
                            }
                        }
                        try {
                            this.sc.getWorkspaceByName("topp");
                            Assert.fail((String)"Should have failed with a security exception");
                        }
                        catch (Exception e) {
                            if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block20;
                            Assert.fail((String)"Should have failed with a security exception");
                        }
                    }
                    try {
                        this.sc.getDataStoreByName("states");
                        Assert.fail((String)"Should have failed with a security exception");
                    }
                    catch (Exception e) {
                        if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block21;
                        Assert.fail((String)"Should have failed with a security exception");
                    }
                }
                try {
                    this.sc.getDataStoreByName("roads");
                    Assert.fail((String)"Should have failed with a security exception");
                }
                catch (Exception e) {
                    if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block22;
                    Assert.fail((String)"Should have failed with a security exception");
                }
            }
            try {
                this.sc.getCoverageStoreByName("arcGrid");
                Assert.fail((String)"Should have failed with a security exception");
            }
            catch (Exception e) {
                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block23;
                Assert.fail((String)"Should have failed with a security exception");
            }
        }
        request = (Request)org.easymock.classextension.EasyMock.createNiceMock(Request.class);
        org.easymock.classextension.EasyMock.expect((Object)request.getRequest()).andReturn((Object)"GetCapabilities").anyTimes();
        org.easymock.classextension.EasyMock.replay((Object[])new Object[]{request});
        Dispatcher.REQUEST.set(request);
        SecureCatalogImplTest.assertThatBoth(this.sc.getFeatureTypes(), this.sc.list(FeatureTypeInfo.class, Predicates.acceptAll()), Matchers.empty());
        SecureCatalogImplTest.assertThatBoth(this.sc.getCoverages(), this.sc.list(CoverageInfo.class, Predicates.acceptAll()), Matchers.empty());
        SecureCatalogImplTest.assertThatBoth(this.sc.getWorkspaces(), this.sc.list(WorkspaceInfo.class, Predicates.acceptAll()), Matchers.empty());
        SecurityContextHolder.getContext().setAuthentication(this.rwUser);
        Assert.assertSame((Object)this.states, (Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertSame((Object)this.arcGrid, (Object)this.sc.getCoverageByName("nurc:arcgrid"));
        Assert.assertSame((Object)this.states, (Object)this.sc.getResourceByName("topp:states", FeatureTypeInfo.class));
        Assert.assertSame((Object)this.arcGrid, (Object)this.sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        Assert.assertEquals((Object)this.toppWs, (Object)this.sc.getWorkspaceByName("topp"));
        Assert.assertSame((Object)this.statesStore, (Object)this.sc.getDataStoreByName("states"));
        Assert.assertSame((Object)this.roadsStore, (Object)this.sc.getDataStoreByName("roads"));
        Assert.assertSame((Object)this.arcGridStore, (Object)this.sc.getCoverageStoreByName("arcGrid"));
        SecureCatalogImplTest.assertThatBoth(this.sc.getFeatureTypes(), this.sc.list(FeatureTypeInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.featureTypes));
        SecureCatalogImplTest.assertThatBoth(this.sc.getCoverages(), this.sc.list(CoverageInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.coverages));
        SecureCatalogImplTest.assertThatBoth(this.sc.getWorkspaces(), this.sc.list(WorkspaceInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.workspaces));
    }

    @Test
    public void testPublicRead() throws Exception {
        this.buildManager("publicRead.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertSame((Object)this.arcGrid, (Object)this.sc.getCoverageByName("nurc:arcgrid"));
        Assert.assertSame((Object)this.arcGrid, (Object)this.sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        Assert.assertEquals((Object)this.toppWs, (Object)this.sc.getWorkspaceByName("topp"));
        Assert.assertSame((Object)this.arcGridStore, (Object)this.sc.getCoverageStoreByName("arcGrid"));
        Assert.assertNotNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertTrue((boolean)(this.sc.getFeatureTypeByName("topp:states") instanceof SecuredFeatureTypeInfo));
        Assert.assertTrue((boolean)(this.sc.getResourceByName("topp:states", FeatureTypeInfo.class) instanceof SecuredFeatureTypeInfo));
        SecureCatalogImplTest.assertThatBoth(this.sc.getFeatureTypes(), this.sc.list(FeatureTypeInfo.class, Predicates.acceptAll()), Matchers.allOf((Matcher)Matchers.hasSize((int)this.featureTypes.size()), (Matcher)Matchers.everyItem((Matcher)Matchers.instanceOf(SecuredFeatureTypeInfo.class))));
        SecureCatalogImplTest.assertThatBoth(this.sc.getCoverages(), this.sc.list(CoverageInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.coverages));
        SecureCatalogImplTest.assertThatBoth(this.sc.getWorkspaces(), this.sc.list(WorkspaceInfo.class, Predicates.acceptAll()), Matchers.equalTo((Object)this.workspaces));
        Assert.assertNotNull((Object)this.sc.getLayerByName("topp:states"));
        Assert.assertTrue((boolean)(this.sc.getLayerByName("topp:states") instanceof SecuredLayerInfo));
        Assert.assertTrue((boolean)(this.sc.getDataStoreByName("states") instanceof SecuredDataStoreInfo));
        Assert.assertTrue((boolean)(this.sc.getDataStoreByName("roads") instanceof SecuredDataStoreInfo));
        SecurityContextHolder.getContext().setAuthentication(this.rwUser);
        Assert.assertSame((Object)this.states, (Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertSame((Object)this.arcGrid, (Object)this.sc.getCoverageByName("nurc:arcgrid"));
        Assert.assertSame((Object)this.states, (Object)this.sc.getResourceByName("topp:states", FeatureTypeInfo.class));
        Assert.assertSame((Object)this.arcGrid, (Object)this.sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        Assert.assertEquals((Object)this.featureTypes, (Object)this.sc.getFeatureTypes());
        Assert.assertEquals((Object)this.coverages, (Object)this.sc.getCoverages());
        Assert.assertEquals((Object)this.workspaces, (Object)this.sc.getWorkspaces());
        Assert.assertEquals((Object)this.toppWs, (Object)this.sc.getWorkspaceByName("topp"));
        Assert.assertSame((Object)this.statesStore, (Object)this.sc.getDataStoreByName("states"));
        Assert.assertSame((Object)this.roadsStore, (Object)this.sc.getDataStoreByName("roads"));
        Assert.assertSame((Object)this.arcGridStore, (Object)this.sc.getCoverageStoreByName("arcGrid"));
    }

    @Test
    public void testCatalogFilteredGetLayers() throws Exception {
        CatalogFilterAccessManager filter = new CatalogFilterAccessManager();
        AbstractCatalogDecorator withLayers = new AbstractCatalogDecorator(this.catalog){

            public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter, Integer offset, Integer count, SortBy sortBy) {
                return new CloseableIteratorAdapter(SecureCatalogImplTest.this.layers.iterator());
            }
        };
        this.catalog = withLayers;
        this.extensions.singleton("catalog", (Object)this.catalog, new Class[]{Catalog.class});
        this.buildManager("publicRead.properties", (ResourceAccessManagerWrapper)filter);
        Assert.assertTrue((this.layers.size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((this.sc.getLayers().size() > 1 ? 1 : 0) != 0);
        filter.setCatalogFilters(Collections.singletonList(new AbstractCatalogFilter(){

            public boolean hideLayer(LayerInfo layer) {
                return layer != SecureCatalogImplTest.this.statesLayer;
            }
        }));
        Assert.assertEquals((long)1L, (long)this.sc.getLayers().size());
        Assert.assertEquals((Object)this.statesLayer.getName(), (Object)((LayerInfo)this.sc.getLayers().get(0)).getName());
    }

    @Test
    public void testCatalogCloseWrappedIterator() throws Exception {
        final CloseableIterator mockIterator = (CloseableIterator)EasyMock.createNiceMock(CloseableIterator.class);
        mockIterator.close();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{mockIterator});
        AbstractCatalogDecorator withLayers = new AbstractCatalogDecorator(this.catalog){

            public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter, Integer offset, Integer count, SortBy sortBy) {
                return mockIterator;
            }
        };
        this.catalog = withLayers;
        GeoServerExtensionsHelper.singleton((String)"catalog", (Object)this.catalog, (Class[])new Class[]{Catalog.class});
        this.buildManager("publicRead.properties");
        CloseableIterator iterator = this.sc.list(LayerInfo.class, Predicates.acceptAll());
        iterator.close();
        EasyMock.verify((Object[])new Object[]{mockIterator});
    }

    @Test
    public void testComplex() throws Exception {
        this.buildManager("complex.properties");
        SecurityContextHolder.getContext().setAuthentication(this.anonymous);
        Assert.assertTrue((boolean)(this.sc.getFeatureTypeByName("topp:roads") instanceof SecuredFeatureTypeInfo));
        Assert.assertTrue((boolean)(this.sc.getDataStoreByName("roads") instanceof SecuredDataStoreInfo));
        Assert.assertNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertTrue((boolean)(this.sc.getDataStoreByName("states") instanceof SecuredDataStoreInfo));
        Assert.assertTrue((boolean)(this.sc.getFeatureTypeByName("topp:landmarks") instanceof SecuredFeatureTypeInfo));
        Assert.assertNull((Object)this.sc.getFeatureTypeByName("topp:bases"));
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertTrue((boolean)(this.sc.getFeatureTypeByName("topp:roads") instanceof SecuredFeatureTypeInfo));
        Assert.assertTrue((boolean)(this.sc.getDataStoreByName("roads") instanceof SecuredDataStoreInfo));
        Assert.assertTrue((boolean)(this.sc.getFeatureTypeByName("topp:states") instanceof SecuredFeatureTypeInfo));
        Assert.assertTrue((boolean)(this.sc.getDataStoreByName("states") instanceof SecuredDataStoreInfo));
        Assert.assertTrue((boolean)(this.sc.getFeatureTypeByName("topp:landmarks") instanceof SecuredFeatureTypeInfo));
        Assert.assertNull((Object)this.sc.getFeatureTypeByName("topp:bases"));
        SecurityContextHolder.getContext().setAuthentication(this.rwUser);
        Assert.assertTrue((boolean)(this.sc.getFeatureTypeByName("topp:roads") instanceof SecuredFeatureTypeInfo));
        Assert.assertTrue((boolean)(this.sc.getDataStoreByName("roads") instanceof SecuredDataStoreInfo));
        Assert.assertSame((Object)this.states, (Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertTrue((boolean)(this.sc.getDataStoreByName("states") instanceof SecuredDataStoreInfo));
        Assert.assertSame((Object)this.landmarks, (Object)this.sc.getFeatureTypeByName("topp:landmarks"));
        Assert.assertNull((Object)this.sc.getFeatureTypeByName("topp:bases"));
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertTrue((boolean)(this.sc.getFeatureTypeByName("topp:roads") instanceof SecuredFeatureTypeInfo));
        Assert.assertTrue((boolean)(this.sc.getDataStoreByName("roads") instanceof SecuredDataStoreInfo));
        Assert.assertNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertTrue((boolean)(this.sc.getDataStoreByName("states") instanceof SecuredDataStoreInfo));
        Assert.assertTrue((boolean)(this.sc.getFeatureTypeByName("topp:landmarks") instanceof SecuredFeatureTypeInfo));
        Assert.assertSame((Object)this.bases, (Object)this.sc.getFeatureTypeByName("topp:bases"));
    }

    @Test
    public void testLockedLayerInGroupMustNotHideGroup() throws Exception {
        this.buildManager("lockedLayerInLayerGroup.properties");
        SecurityContextHolder.getContext().setAuthentication(this.rwUser);
        Assert.assertSame((Object)this.states, (Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertSame((Object)this.roads, (Object)this.sc.getFeatureTypeByName("topp:roads"));
        LayerGroupInfo layerGroup = this.sc.getLayerGroupByName("topp", "layerGroupWithSomeLockedLayer");
        Assert.assertEquals((long)2L, (long)layerGroup.getLayers().size());
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertSame((Object)this.roads, (Object)this.sc.getFeatureTypeByName("topp:roads"));
        layerGroup = this.sc.getLayerGroupByName("topp", "layerGroupWithSomeLockedLayer");
        Assert.assertNotNull((Object)layerGroup);
        Assert.assertTrue((boolean)(layerGroup instanceof SecuredLayerGroupInfo));
        Assert.assertEquals((long)1L, (long)layerGroup.getLayers().size());
        SecurityContextHolder.getContext().setAuthentication(this.anonymous);
        Assert.assertNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertNull((Object)this.sc.getFeatureTypeByName("topp:roads"));
        layerGroup = this.sc.getLayerGroupByName("topp", "layerGroupWithSomeLockedLayer");
        Assert.assertNotNull((Object)layerGroup);
        Assert.assertTrue((boolean)(layerGroup instanceof SecuredLayerGroupInfo));
        Assert.assertEquals((long)0L, (long)layerGroup.getLayers().size());
    }

    @Test
    public void testEoLayerGroupMustBeHiddenIfItsRootLayerIsHidden() throws Exception {
        LayerGroupInfo eoRoadsLayerGroup = this.buildEOLayerGroup("eoRoadsLayerGroup", this.roadsLayer, this.lineStyle, this.toppWs, new PublishedInfo[]{this.statesLayer});
        LayerGroupInfo eoStatesLayerGroup = this.buildEOLayerGroup("eoStatesLayerGroup", this.statesLayer, this.lineStyle, this.toppWs, new PublishedInfo[]{this.roadsLayer});
        Catalog eoCatalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)eoCatalog.getLayerGroupByName("topp", eoRoadsLayerGroup.getName())).andReturn((Object)eoRoadsLayerGroup).anyTimes();
        EasyMock.expect((Object)eoCatalog.getLayerGroupByName("topp", eoStatesLayerGroup.getName())).andReturn((Object)eoStatesLayerGroup).anyTimes();
        EasyMock.expect((Object)eoCatalog.getLayerGroups()).andReturn(Arrays.asList(eoRoadsLayerGroup, eoStatesLayerGroup));
        EasyMock.expect((Object)eoCatalog.list((Class)EasyMock.eq(LayerGroupInfo.class), (Filter)EasyMock.anyObject(Filter.class))).andReturn((Object)new CloseableIteratorAdapter(Collections.emptyIterator())).anyTimes();
        EasyMock.replay((Object[])new Object[]{eoCatalog});
        this.catalog = eoCatalog;
        this.extensions.singleton("catalog", (Object)eoCatalog, new Class[]{Catalog.class});
        this.buildManager("lockedLayerInLayerGroup.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        LayerGroupInfo layerGroup = this.sc.getLayerGroupByName("topp", "eoRoadsLayerGroup");
        Assert.assertNotNull((Object)layerGroup);
        Assert.assertNotNull((Object)layerGroup.getRootLayer());
        layerGroup = this.sc.getLayerGroupByName("topp", "eoStatesLayerGroup");
        Assert.assertNull((Object)layerGroup);
    }

    @Test
    public void testSecurityFilterWideOpen() throws Exception {
        ResourceAccessManager resourceManager = this.getResourceAccessManager((DataAccessManager)this.buildAccessManager("wideOpen.properties"));
        Class<WorkspaceInfo> clazz = WorkspaceInfo.class;
        Filter security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        Filter security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        Assert.assertSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        clazz = PublishedInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        Assert.assertSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        clazz = StyleInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        Assert.assertSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        clazz = ResourceInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        Assert.assertSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        clazz = CoverageInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        Assert.assertSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
    }

    @Test
    public void testSecurityFilterLockedDown() throws Exception {
        ResourceAccessManager resourceManager = this.getResourceAccessManager((DataAccessManager)this.buildAccessManager("lockedDown.properties"));
        Class<WorkspaceInfo> clazz = WorkspaceInfo.class;
        Filter security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        Filter security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        Filter security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security3, (Object)Filter.INCLUDE);
        clazz = PublishedInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security3, (Object)Filter.INCLUDE);
        clazz = StyleInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security3, (Object)Filter.INCLUDE);
        clazz = ResourceInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security3, (Object)Filter.INCLUDE);
        clazz = CoverageInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security3, (Object)Filter.INCLUDE);
    }

    @Test
    public void testSecurityFilterWsLock() throws Exception {
        String name;
        CoverageInfo next;
        String name2;
        FeatureTypeInfo next2;
        String wsName;
        WorkspaceInfo wsi;
        StyleInfo next3;
        String wsName2;
        LayerInfo next4;
        ResourceAccessManager resourceManager = this.getResourceAccessManager((DataAccessManager)this.buildAccessManager("wsLock.properties"));
        Class<WorkspaceInfo> clazz = WorkspaceInfo.class;
        Filter security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        Filter security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        Filter security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertNotSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.EXCLUDE);
        List ws = this.catalog.getWorkspaces();
        UnmodifiableIterator it = Iterators.filter(ws.iterator(), (Predicate)new PredicateFilter(security));
        while (it.hasNext()) {
            Assert.assertSame(it.next(), (Object)this.nurcWs);
        }
        it = Iterators.filter(ws.iterator(), (Predicate)new PredicateFilter(security3));
        while (it.hasNext()) {
            Assert.assertSame(it.next(), (Object)this.nurcWs);
        }
        clazz = PublishedInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertNotSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.EXCLUDE);
        List ly = this.catalog.getLayers();
        UnmodifiableIterator it1 = Iterators.filter(ly.iterator(), (Predicate)new PredicateFilter(security));
        while (it1.hasNext()) {
            next4 = (LayerInfo)it1.next();
            wsName2 = next4.getResource().getNamespace().getName();
            Assert.assertTrue((boolean)wsName2.equalsIgnoreCase("nurc"));
        }
        it1 = Iterators.filter(ly.iterator(), (Predicate)new PredicateFilter(security3));
        while (it1.hasNext()) {
            next4 = (LayerInfo)it1.next();
            wsName2 = next4.getResource().getNamespace().getName();
            Assert.assertTrue((boolean)wsName2.equalsIgnoreCase("nurc"));
        }
        clazz = StyleInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertNotSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.EXCLUDE);
        List sy = this.catalog.getStyles();
        UnmodifiableIterator it3 = Iterators.filter(sy.iterator(), (Predicate)new PredicateFilter(security));
        while (it3.hasNext()) {
            next3 = (StyleInfo)it3.next();
            wsi = next3.getWorkspace();
            if (wsi == null) continue;
            wsName = wsi.getName();
            Assert.assertTrue((boolean)wsName.equalsIgnoreCase("nurc"));
        }
        it3 = Iterators.filter(sy.iterator(), (Predicate)new PredicateFilter(security3));
        while (it3.hasNext()) {
            next3 = (StyleInfo)it3.next();
            wsi = next3.getWorkspace();
            if (wsi == null) continue;
            wsName = wsi.getName();
            Assert.assertTrue((boolean)wsName.equalsIgnoreCase("nurc"));
        }
        clazz = ResourceInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertNotSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.EXCLUDE);
        List fy = this.catalog.getFeatureTypes();
        UnmodifiableIterator it4 = Iterators.filter(fy.iterator(), (Predicate)new PredicateFilter(security));
        while (it4.hasNext()) {
            next2 = (FeatureTypeInfo)it4.next();
            name2 = next2.getNamespace().getName();
            Assert.assertTrue((boolean)name2.equalsIgnoreCase("nurc"));
        }
        it4 = Iterators.filter(fy.iterator(), (Predicate)new PredicateFilter(security3));
        while (it4.hasNext()) {
            next2 = (FeatureTypeInfo)it4.next();
            name2 = next2.getNamespace().getName();
            Assert.assertTrue((boolean)name2.equalsIgnoreCase("nurc"));
        }
        clazz = CoverageInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.milUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertNotSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.EXCLUDE);
        List cy = this.catalog.getCoverages();
        UnmodifiableIterator it5 = Iterators.filter(cy.iterator(), (Predicate)new PredicateFilter(security));
        while (it5.hasNext()) {
            next = (CoverageInfo)it5.next();
            name = next.getNamespace().getName();
            Assert.assertTrue((boolean)name.equalsIgnoreCase("nurc"));
        }
        it5 = Iterators.filter(cy.iterator(), (Predicate)new PredicateFilter(security3));
        while (it5.hasNext()) {
            next = (CoverageInfo)it5.next();
            name = next.getNamespace().getName();
            Assert.assertTrue((boolean)name.equalsIgnoreCase("nurc"));
        }
    }

    @Test
    public void testSecurityFilterLayerLock() throws Exception {
        FeatureTypeInfo next;
        LayerInfo next2;
        ResourceAccessManager resourceManager = this.getResourceAccessManager((DataAccessManager)this.buildAccessManager("layerLock.properties"));
        Class<WorkspaceInfo> clazz = WorkspaceInfo.class;
        Filter security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        Filter security2 = resourceManager.getSecurityFilter(this.roUser, clazz);
        Filter security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertSame((Object)security3, (Object)Filter.INCLUDE);
        clazz = PublishedInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.roUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertNotSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertNotSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security2, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security3, (Object)Filter.INCLUDE);
        List ly = this.catalog.getLayers();
        UnmodifiableIterator it1 = Iterators.filter(ly.iterator(), (Predicate)new PredicateFilter(security));
        boolean hasRoadsLayer = false;
        boolean hasBasesLayer = false;
        while (it1.hasNext()) {
            next2 = (LayerInfo)it1.next();
            Assert.assertNotSame((Object)next2, (Object)this.roadsLayer);
            Assert.assertNotSame((Object)next2, (Object)this.statesLayer);
            hasBasesLayer |= next2.equals(this.basesLayer);
        }
        Assert.assertTrue((boolean)hasBasesLayer);
        hasRoadsLayer = false;
        hasBasesLayer = false;
        it1 = Iterators.filter(ly.iterator(), (Predicate)new PredicateFilter(security2));
        while (it1.hasNext()) {
            next2 = (LayerInfo)it1.next();
            Assert.assertNotSame((Object)next2, (Object)this.statesLayer);
            hasRoadsLayer |= next2.equals(this.roadsLayer);
            hasBasesLayer |= next2.equals(this.basesLayer);
        }
        Assert.assertTrue((boolean)hasRoadsLayer);
        Assert.assertTrue((boolean)hasRoadsLayer);
        clazz = StyleInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.roUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertSame((Object)security3, (Object)Filter.INCLUDE);
        clazz = ResourceInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.roUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Assert.assertNotSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertNotSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security2, (Object)Filter.EXCLUDE);
        Assert.assertSame((Object)security3, (Object)Filter.INCLUDE);
        List fy = this.catalog.getFeatureTypes();
        UnmodifiableIterator it3 = Iterators.filter(fy.iterator(), (Predicate)new PredicateFilter(security));
        hasBasesLayer = false;
        while (it3.hasNext()) {
            next = (FeatureTypeInfo)it3.next();
            Assert.assertNotSame((Object)next, (Object)this.roads);
            Assert.assertNotSame((Object)next, (Object)this.states);
            hasBasesLayer |= next.equals(this.bases);
        }
        Assert.assertTrue((boolean)hasBasesLayer);
        hasRoadsLayer = false;
        hasBasesLayer = false;
        it3 = Iterators.filter(fy.iterator(), (Predicate)new PredicateFilter(security2));
        while (it3.hasNext()) {
            next = (FeatureTypeInfo)it3.next();
            hasRoadsLayer |= next.equals(this.roads);
            hasBasesLayer |= next.equals(this.bases);
            Assert.assertNotSame((Object)next, (Object)this.states);
        }
        Assert.assertTrue((boolean)hasBasesLayer);
        Assert.assertTrue((boolean)hasRoadsLayer);
    }

    @Test
    public void testSecurityFilterComplex() throws Exception {
        CoverageInfo next;
        FeatureTypeInfo next2;
        String wsName;
        WorkspaceInfo wsi;
        StyleInfo next3;
        ResourceAccessManager resourceManager = this.getResourceAccessManager((DataAccessManager)this.buildAccessManager("complex.properties"));
        Class<WorkspaceInfo> clazz = WorkspaceInfo.class;
        Filter security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        Filter security2 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        Filter security3 = resourceManager.getSecurityFilter(this.milUser, clazz);
        Assert.assertNotSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertNotSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.EXCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.INCLUDE);
        List ws = this.catalog.getWorkspaces();
        UnmodifiableIterator it = Iterators.filter(ws.iterator(), (Predicate)new PredicateFilter(security));
        while (it.hasNext()) {
            Assert.assertSame(it.next(), (Object)this.toppWs);
        }
        it = Iterators.filter(ws.iterator(), (Predicate)new PredicateFilter(security3));
        while (it.hasNext()) {
            Assert.assertSame(it.next(), (Object)this.toppWs);
        }
        clazz = PublishedInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.milUser, clazz);
        Assert.assertNotSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertNotSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security2, (Object)Filter.EXCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.EXCLUDE);
        List ly = this.catalog.getLayers();
        UnmodifiableIterator it1 = Iterators.filter(ly.iterator(), (Predicate)new PredicateFilter(security));
        boolean hasRoadsLayer = false;
        boolean hasLandmLayer = false;
        while (it1.hasNext()) {
            LayerInfo next4 = (LayerInfo)it1.next();
            Assert.assertNotSame((String)("Unexpectedly found bases with security filter " + security), (Object)next4, (Object)this.basesLayer);
            Assert.assertNotSame((String)("Unexpectedly found states with security filter " + security), (Object)next4, (Object)this.statesLayer);
            hasLandmLayer |= next4.equals(this.landmarksLayer);
            hasRoadsLayer |= next4.equals(this.roadsLayer);
            Assert.assertNotSame((Object)next4, (Object)this.arcGridLayer);
        }
        Assert.assertTrue((boolean)hasRoadsLayer);
        Assert.assertTrue((boolean)hasLandmLayer);
        hasRoadsLayer = false;
        boolean hasStatesLayer = false;
        hasLandmLayer = false;
        it1 = Iterators.filter(ly.iterator(), (Predicate)new PredicateFilter(security2));
        while (it1.hasNext()) {
            LayerInfo next5 = (LayerInfo)it1.next();
            Assert.assertNotSame((Object)next5, (Object)this.basesLayer);
            hasStatesLayer |= next5.equals(this.statesLayer);
            hasLandmLayer |= next5.equals(this.landmarksLayer);
            hasRoadsLayer |= next5.equals(this.roadsLayer);
            Assert.assertNotSame((Object)next5, (Object)this.arcGridLayer);
        }
        Assert.assertTrue((boolean)hasLandmLayer);
        Assert.assertTrue((boolean)hasStatesLayer);
        Assert.assertTrue((boolean)hasRoadsLayer);
        boolean hasArcGridLayer = false;
        boolean hasBasesLayer = false;
        hasLandmLayer = false;
        hasRoadsLayer = false;
        it1 = Iterators.filter(ly.iterator(), (Predicate)new PredicateFilter(security3));
        while (it1.hasNext()) {
            LayerInfo next6 = (LayerInfo)it1.next();
            Assert.assertNotSame((Object)next6, (Object)this.statesLayer);
            hasLandmLayer |= next6.equals(this.landmarksLayer);
            hasRoadsLayer |= next6.equals(this.roadsLayer);
            hasBasesLayer |= next6.equals(this.basesLayer);
            hasArcGridLayer |= next6.equals(this.arcGridLayer);
        }
        Assert.assertTrue((boolean)hasLandmLayer);
        Assert.assertTrue((boolean)hasBasesLayer);
        Assert.assertTrue((boolean)hasArcGridLayer);
        Assert.assertTrue((boolean)hasRoadsLayer);
        clazz = StyleInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.milUser, clazz);
        Assert.assertNotSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertNotSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.EXCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.INCLUDE);
        List sy = this.catalog.getStyles();
        UnmodifiableIterator it2 = Iterators.filter(sy.iterator(), (Predicate)new PredicateFilter(security));
        while (it2.hasNext()) {
            next3 = (StyleInfo)it2.next();
            wsi = next3.getWorkspace();
            if (wsi == null) continue;
            wsName = wsi.getName();
            Assert.assertTrue((boolean)wsName.equalsIgnoreCase("topp"));
        }
        it2 = Iterators.filter(sy.iterator(), (Predicate)new PredicateFilter(security3));
        while (it2.hasNext()) {
            next3 = (StyleInfo)it2.next();
            wsi = next3.getWorkspace();
            if (wsi == null) continue;
            wsName = wsi.getName();
            Assert.assertTrue((boolean)wsName.equalsIgnoreCase("topp"));
        }
        clazz = ResourceInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.milUser, clazz);
        Assert.assertNotSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertNotSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security2, (Object)Filter.EXCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.EXCLUDE);
        List fy = this.catalog.getFeatureTypes();
        UnmodifiableIterator it3 = Iterators.filter(fy.iterator(), (Predicate)new PredicateFilter(security));
        hasRoadsLayer = false;
        hasLandmLayer = false;
        while (it3.hasNext()) {
            next2 = (FeatureTypeInfo)it3.next();
            Assert.assertNotSame((Object)next2, (Object)this.bases);
            Assert.assertNotSame((Object)next2, (Object)this.states);
            hasLandmLayer |= next2.equals(this.landmarks);
            hasRoadsLayer |= next2.equals(this.roads);
            Assert.assertNotSame((Object)next2, (Object)this.arcGrid);
        }
        Assert.assertTrue((boolean)hasRoadsLayer);
        Assert.assertTrue((boolean)hasLandmLayer);
        hasRoadsLayer = false;
        hasStatesLayer = false;
        hasLandmLayer = false;
        it3 = Iterators.filter(fy.iterator(), (Predicate)new PredicateFilter(security2));
        while (it3.hasNext()) {
            next2 = (FeatureTypeInfo)it3.next();
            Assert.assertNotSame((Object)next2, (Object)this.bases);
            hasStatesLayer |= next2.equals(this.states);
            hasLandmLayer |= next2.equals(this.landmarks);
            hasRoadsLayer |= next2.equals(this.roads);
            Assert.assertNotSame((Object)next2, (Object)this.arcGrid);
        }
        Assert.assertTrue((boolean)hasLandmLayer);
        Assert.assertTrue((boolean)hasStatesLayer);
        Assert.assertTrue((boolean)hasRoadsLayer);
        hasBasesLayer = false;
        hasLandmLayer = false;
        hasRoadsLayer = false;
        it3 = Iterators.filter(fy.iterator(), (Predicate)new PredicateFilter(security3));
        while (it3.hasNext()) {
            next2 = (FeatureTypeInfo)it3.next();
            Assert.assertNotSame((Object)next2, (Object)this.states);
            hasLandmLayer |= next2.equals(this.landmarks);
            hasRoadsLayer |= next2.equals(this.roads);
            hasBasesLayer |= next2.equals(this.bases);
        }
        Assert.assertTrue((boolean)hasLandmLayer);
        Assert.assertTrue((boolean)hasBasesLayer);
        Assert.assertTrue((boolean)hasRoadsLayer);
        clazz = CoverageInfo.class;
        security = resourceManager.getSecurityFilter(this.anonymous, clazz);
        security2 = resourceManager.getSecurityFilter(this.rwUser, clazz);
        security3 = resourceManager.getSecurityFilter(this.milUser, clazz);
        Assert.assertNotSame((Object)security, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security, (Object)Filter.EXCLUDE);
        Assert.assertNotSame((Object)security2, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security2, (Object)Filter.EXCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.INCLUDE);
        Assert.assertNotSame((Object)security3, (Object)Filter.EXCLUDE);
        List cy = this.catalog.getCoverages();
        UnmodifiableIterator it4 = Iterators.filter(cy.iterator(), (Predicate)new PredicateFilter(security));
        while (it4.hasNext()) {
            next = (CoverageInfo)it4.next();
            Assert.assertNotSame((Object)next, (Object)this.arcGrid);
        }
        it4 = Iterators.filter(cy.iterator(), (Predicate)new PredicateFilter(security2));
        while (it4.hasNext()) {
            next = (CoverageInfo)it4.next();
            Assert.assertNotSame((Object)next, (Object)this.arcGrid);
        }
        hasArcGridLayer = false;
        it4 = Iterators.filter(cy.iterator(), (Predicate)new PredicateFilter(security3));
        while (it4.hasNext()) {
            next = (CoverageInfo)it4.next();
            hasArcGridLayer |= next.equals(this.arcGrid);
        }
        Assert.assertTrue((boolean)hasArcGridLayer);
    }

    protected ResourceAccessManager getResourceAccessManager(DataAccessManager manager) throws Exception {
        if (!(manager instanceof ResourceAccessManager)) {
            throw new IllegalArgumentException("We should have a ResourceAccessManager");
        }
        ResourceAccessManager resourceManager = (ResourceAccessManager)manager;
        return resourceManager;
    }

    static <T> void assertThatBoth(List<T> result1, CloseableIterator<T> result2, Matcher<?> expected) throws IOException {
        Assert.assertThat(result1, expected);
        Assert.assertThat(SecureCatalogImplTest.collectAndClose(result2), expected);
    }

    static <T> List<T> collectAndClose(CloseableIterator<T> it) throws IOException {
        if (it == null) {
            return null;
        }
        try {
            LinkedList<Object> list = new LinkedList<Object>();
            while (it.hasNext()) {
                list.add(it.next());
            }
            LinkedList<Object> linkedList = list;
            return linkedList;
        }
        finally {
            it.close();
        }
    }

    @Test
    public void testUnwrapping() {
        WrapperPolicy policy = (WrapperPolicy)EasyMock.createNiceMock(WrapperPolicy.class);
        Assert.assertThat((Object)SecureCatalogImpl.unwrap((Object)new SecuredCoverageInfo(this.arcGrid, policy)), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(SecuredCoverageInfo.class)));
        Assert.assertThat((Object)SecureCatalogImpl.unwrap((Object)new SecuredFeatureTypeInfo(this.states, policy)), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(SecuredFeatureTypeInfo.class)));
        Assert.assertThat((Object)SecureCatalogImpl.unwrap((Object)new SecuredWMSLayerInfo(this.cascaded, policy)), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(SecuredWMSLayerInfo.class)));
        Assert.assertThat((Object)SecureCatalogImpl.unwrap((Object)new SecuredWMTSLayerInfo(this.cascadedWmts, policy)), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(SecuredWMTSLayerInfo.class)));
    }

    @Test
    public void testSettingResourceOnSecureLayerInfo() {
        WrapperPolicy policy = (WrapperPolicy)EasyMock.createNiceMock(WrapperPolicy.class);
        LayerInfoImpl coverageLayerInfo = new LayerInfoImpl();
        SecuredLayerInfo secureCoverageLayerInfo = new SecuredLayerInfo((LayerInfo)coverageLayerInfo, policy);
        secureCoverageLayerInfo.setResource((ResourceInfo)new SecuredCoverageInfo(this.arcGrid, policy));
        Assert.assertThat((Object)coverageLayerInfo.getResource(), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(SecuredCoverageInfo.class)));
        Assert.assertThat((Object)coverageLayerInfo.getResource(), (Matcher)Matchers.instanceOf(CoverageInfo.class));
        LayerInfoImpl featureLayerInfo = new LayerInfoImpl();
        SecuredLayerInfo secureFeatureLayerInfo = new SecuredLayerInfo((LayerInfo)featureLayerInfo, policy);
        secureFeatureLayerInfo.setResource((ResourceInfo)new SecuredFeatureTypeInfo(this.states, policy));
        Assert.assertThat((Object)featureLayerInfo.getResource(), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(SecuredFeatureTypeInfo.class)));
        Assert.assertThat((Object)featureLayerInfo.getResource(), (Matcher)Matchers.instanceOf(FeatureTypeInfo.class));
        LayerInfoImpl wmsLayerInfo = new LayerInfoImpl();
        SecuredLayerInfo secureWmsLayerInfo = new SecuredLayerInfo((LayerInfo)wmsLayerInfo, policy);
        secureWmsLayerInfo.setResource((ResourceInfo)new SecuredWMSLayerInfo(this.cascaded, policy));
        Assert.assertThat((Object)wmsLayerInfo.getResource(), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(SecuredWMSLayerInfo.class)));
        Assert.assertThat((Object)wmsLayerInfo.getResource(), (Matcher)Matchers.instanceOf(WMSLayerInfo.class));
        LayerInfoImpl wmtsLayerInfo = new LayerInfoImpl();
        SecuredLayerInfo secureWmtsLayerInfo = new SecuredLayerInfo((LayerInfo)wmtsLayerInfo, policy);
        secureWmtsLayerInfo.setResource((ResourceInfo)new SecuredWMTSLayerInfo(this.cascadedWmts, policy));
        Assert.assertThat((Object)wmtsLayerInfo.getResource(), (Matcher)Matchers.not((Matcher)Matchers.instanceOf(SecuredWMTSLayerInfo.class)));
        Assert.assertThat((Object)wmtsLayerInfo.getResource(), (Matcher)Matchers.instanceOf(WMTSLayerInfo.class));
    }

    @Test
    public void testWmsNamedTreeAMilitaryOnly() throws Exception {
        this.setupRequestThreadLocal("WMS");
        this.buildManager("namedTreeAMilitaryOnly.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.citiesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.nestedContainerE.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        LayerGroupInfo securedSingleGroup = this.sc.getLayerGroupByName(this.singleGroupC.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)1L, (long)securedSingleGroup.layers().size());
        Assert.assertEquals((Object)this.basesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(0)).prefixedName());
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertNotNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        securedSingleGroup = this.sc.getLayerGroupByName(this.singleGroupC.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.layers().size());
        Assert.assertEquals((Object)this.statesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(0)).prefixedName());
        Assert.assertEquals((Object)this.basesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(1)).prefixedName());
    }

    @Test
    public void testWmsNamedTreeAMilitaryOnlyGroupContents() throws Exception {
        this.setupRequestThreadLocal("WMS");
        this.buildManager("lockDownStates.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        LayerGroupInfo group = this.sc.getLayerGroupByName(this.namedTreeA.getName());
        Assert.assertNotNull((Object)group);
        List layers = group.layers();
        Assert.assertEquals((long)2L, (long)layers.size());
        List styles = group.styles();
        Assert.assertEquals((long)2L, (long)styles.size());
        Assert.assertEquals((Object)"roads", (Object)((LayerInfo)layers.get(0)).getName());
        Assert.assertEquals((Object)"topp-roads-style", (Object)((StyleInfo)styles.get(0)).getName());
        Assert.assertEquals((Object)"cities", (Object)((LayerInfo)layers.get(1)).getName());
        Assert.assertEquals((Object)"nurc-cities-style", (Object)((StyleInfo)styles.get(1)).getName());
    }

    @Test
    public void testWfsNamedTreeAMilitaryOnly() throws Exception {
        this.setupRequestThreadLocal("WFS");
        this.buildManager("namedTreeAMilitaryOnly.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNotNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.citiesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.landmarksLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.nestedContainerE.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        LayerGroupInfo securedSingleGroup = this.sc.getLayerGroupByName(this.singleGroupC.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.layers().size());
        Assert.assertEquals((Object)this.statesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(0)).prefixedName());
        Assert.assertEquals((Object)this.basesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(1)).prefixedName());
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertNotNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        securedSingleGroup = this.sc.getLayerGroupByName(this.singleGroupC.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.layers().size());
        Assert.assertEquals((Object)this.statesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(0)).prefixedName());
        Assert.assertEquals((Object)this.basesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(1)).prefixedName());
    }

    @Test
    public void testWmsContainerTreeBMilitaryOnly() throws Exception {
        this.setupRequestThreadLocal("WMS");
        this.buildManager("containerTreeGroupBMilitaryOnly.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.citiesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.landmarksLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.nestedContainerE.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        LayerGroupInfo securedSingleGroup = this.sc.getLayerGroupByName(this.singleGroupC.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.layers().size());
        Assert.assertEquals((Object)this.statesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(0)).prefixedName());
        Assert.assertEquals((Object)this.basesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(1)).prefixedName());
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertNotNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        securedSingleGroup = this.sc.getLayerGroupByName(this.singleGroupC.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.layers().size());
        Assert.assertEquals((Object)this.statesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(0)).prefixedName());
        Assert.assertEquals((Object)this.basesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(1)).prefixedName());
    }

    @Test
    public void testWmsBothGroupABMilitaryOnlyMilitaryOnly() throws Exception {
        this.setupRequestThreadLocal("WMS");
        this.buildManager("bothGroupABMilitaryOnly.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.citiesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.landmarksLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.nestedContainerE.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        LayerGroupInfo securedSingleGroup = this.sc.getLayerGroupByName(this.singleGroupC.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)1L, (long)securedSingleGroup.layers().size());
        Assert.assertEquals((Object)this.basesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(0)).prefixedName());
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertNotNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.landmarksLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        securedSingleGroup = this.sc.getLayerGroupByName(this.singleGroupC.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.layers().size());
        Assert.assertEquals((Object)this.statesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(0)).prefixedName());
        Assert.assertEquals((Object)this.basesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(1)).prefixedName());
    }

    @Test
    public void testWmsSingleGroupCMilitaryOnly() throws Exception {
        this.setupRequestThreadLocal("WMS");
        this.buildManager("singleGroupCMilitaryOnly.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.citiesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.landmarksLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.singleGroupC.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.basesLayer.prefixedName()));
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertNotNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        LayerGroupInfo securedSingleGroup = this.sc.getLayerGroupByName(this.singleGroupC.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.layers().size());
        Assert.assertEquals((Object)this.statesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(0)).prefixedName());
        Assert.assertEquals((Object)this.basesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(1)).prefixedName());
    }

    @Test
    public void testWmsWsContainerGroupDMilitaryOnly() throws Exception {
        this.setupRequestThreadLocal("WMS");
        this.buildManager("wsContainerGroupDMilitaryOnly.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.citiesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.landmarksLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.singleGroupC.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.basesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName("nurc", "wsContainerD"));
        Assert.assertNull((Object)this.sc.getLayerByName(this.arcGridLayer.prefixedName()));
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertNotNull((Object)this.sc.getFeatureTypeByName("topp:states"));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        LayerGroupInfo securedSingleGroup = this.sc.getLayerGroupByName(this.singleGroupC.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.layers().size());
        Assert.assertEquals((Object)this.statesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(0)).prefixedName());
        Assert.assertEquals((Object)this.basesLayer.prefixedName(), (Object)((LayerInfo)securedSingleGroup.layers().get(1)).prefixedName());
        LayerGroupInfo wsSpecificGroup = this.sc.getLayerGroupByName("nurc", "wsContainerD");
        Assert.assertNotNull((Object)wsSpecificGroup);
        Assert.assertEquals((long)1L, (long)wsSpecificGroup.getLayers().size());
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.arcGridLayer.prefixedName()));
    }

    @Test
    public void testWMSLayerGroupAllowsAccess() throws Exception {
        this.setupRequestThreadLocal("WMS");
        this.buildManager("namedTreeAllow.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.citiesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.landmarksLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.singleGroupC.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.basesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName("nurc", "wsContainerD"));
        Assert.assertNull((Object)this.sc.getLayerByName(this.arcGridLayer.prefixedName()));
    }

    @Test
    public void testWMSLayerGroupAllowLayerOverride() throws Exception {
        this.setupRequestThreadLocal("WMS");
        this.buildManager("namedTreeAllowLayerOverride.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.citiesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.landmarksLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.singleGroupC.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.basesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName("nurc", "wsContainerD"));
        Assert.assertNull((Object)this.sc.getLayerByName(this.arcGridLayer.prefixedName()));
    }

    @Test
    public void testWMSLayerGroupAllowWorkspaceOverride() throws Exception {
        this.setupRequestThreadLocal("WMS");
        this.buildManager("namedTreeAllowWorkspaceOverride.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.citiesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.landmarksLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.singleGroupC.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.basesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName("nurc", "wsContainerD"));
        Assert.assertNull((Object)this.sc.getLayerByName(this.arcGridLayer.prefixedName()));
    }

    @Test
    public void testWMSLayerGroupDenyWSAllow() throws Exception {
        this.setupRequestThreadLocal("WMS");
        this.buildManager("namedTreeDenyWSAllow.properties");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.namedTreeA.getName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.citiesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.containerTreeB.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.landmarksLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(this.singleGroupC.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.basesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName("nurc", "wsContainerD"));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.arcGridLayer.prefixedName()));
    }

    static class PredicateFilter
    implements Predicate<CatalogInfo> {
        private Filter f;

        public PredicateFilter(Filter f) {
            this.f = f;
        }

        public boolean apply(@Nullable CatalogInfo input) {
            if (input != null) {
                return this.f.evaluate((Object)input);
            }
            return false;
        }
    }
}

