/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.StringReader;
import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.impl.AbstractAuthorizationTest;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.DefaultResourceAccessManager;
import org.geoserver.security.impl.MemoryDataAccessRuleDAO;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecureCatalogImplGroupsTest
extends AbstractAuthorizationTest {
    private static final String NAMED_GROUP_NAME = "named";
    private static final String OPAQUE_GROUP_NAME = "opaque";
    private static final String SINGLE_GROUP_NAME = "single";
    private static final String NESTED_GROUP_NAME = "nested";
    private static final String[] DEFAULT_RULES = new String[]{"*.*.r=*", "*.*.w=*"};

    @Override
    public void setUp() throws Exception {
        super.setUp();
        SecurityContextHolder.getContext().setAuthentication(null);
        Dispatcher.REQUEST.remove();
    }

    protected ResourceAccessManager buildManager(String ... theRules) throws Exception {
        Properties props = new Properties();
        props.load(new StringReader(Stream.of(theRules).collect(Collectors.joining("\n"))));
        DefaultResourceAccessManager manager = new DefaultResourceAccessManager((DataAccessRuleDAO)new MemoryDataAccessRuleDAO(this.catalog, props), this.catalog);
        this.sc = new SecureCatalogImpl(this.catalog, (ResourceAccessManager)manager){

            protected boolean isAdmin(Authentication authentication) {
                return false;
            }
        };
        GeoServerExtensionsHelper.singleton((String)"secureCatalog", (Object)this.sc, (Class[])new Class[]{SecureCatalogImpl.class});
        return manager;
    }

    private LayerGroupInfo prepareStandaloneOpaqueGroup() throws Exception {
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer});
        this.layerGroups = Arrays.asList(opaque);
        this.populateCatalog();
        this.buildManager(DEFAULT_RULES);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        return opaque;
    }

    @Test
    public void testWmsStandaloneOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo opaque = this.prepareStandaloneOpaqueGroup();
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo securedGroup = this.sc.getLayerGroupByName(opaque.prefixedName());
        Assert.assertNotNull((Object)securedGroup);
        Assert.assertEquals((long)2L, (long)securedGroup.getLayers().size());
    }

    @Test
    public void testWfsStandaloneOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WFS");
        LayerGroupInfo opaque = this.prepareStandaloneOpaqueGroup();
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo securedGroup = this.sc.getLayerGroupByName(opaque.prefixedName());
        Assert.assertNotNull((Object)securedGroup);
        Assert.assertEquals((long)2L, (long)securedGroup.getLayers().size());
    }

    private LayerGroupInfo prepareNamedAndOpaqueGroup() throws Exception {
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer});
        LayerGroupInfo named = this.buildLayerGroup(NAMED_GROUP_NAME, LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer});
        this.layerGroups = Arrays.asList(named, opaque);
        this.populateCatalog();
        this.buildManager(DEFAULT_RULES);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        return opaque;
    }

    @Test
    public void testWmsNamedOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo opaque = this.prepareNamedAndOpaqueGroup();
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo securedGroup = this.sc.getLayerGroupByName(opaque.prefixedName());
        Assert.assertNotNull((Object)securedGroup);
        Assert.assertEquals((long)2L, (long)securedGroup.getLayers().size());
    }

    @Test
    public void testWfsNamedOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WFS");
        LayerGroupInfo opaque = this.prepareNamedAndOpaqueGroup();
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo securedGroup = this.sc.getLayerGroupByName(opaque.prefixedName());
        Assert.assertNotNull((Object)securedGroup);
        Assert.assertEquals((long)2L, (long)securedGroup.getLayers().size());
    }

    @Test
    public void testWmsSingleAndOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer});
        LayerGroupInfo single = this.buildLayerGroup(SINGLE_GROUP_NAME, LayerGroupInfo.Mode.SINGLE, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer});
        this.layerGroups = Arrays.asList(single, opaque);
        this.populateCatalog();
        this.buildManager(DEFAULT_RULES);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo opaqueSecuredGroup = this.sc.getLayerGroupByName(opaque.prefixedName());
        Assert.assertNotNull((Object)opaqueSecuredGroup);
        Assert.assertEquals((long)2L, (long)opaqueSecuredGroup.getLayers().size());
        LayerGroupInfo securedSingleGroup = this.sc.getLayerGroupByName(single.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.getLayers().size());
    }

    @Test
    public void testWmsMilitaryNamedAndPublicOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer});
        LayerGroupInfo named = this.buildLayerGroup(NAMED_GROUP_NAME, LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer});
        this.layerGroups = Arrays.asList(named, opaque);
        this.populateCatalog();
        this.buildManager(new String[]{"named.r=MILITARY"});
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo securedGroup = this.sc.getLayerGroupByName(OPAQUE_GROUP_NAME);
        Assert.assertNotNull((Object)securedGroup);
        Assert.assertEquals((long)2L, (long)securedGroup.getLayers().size());
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
    }

    @Test
    public void testWmsPublicSingleAndSecuredOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{this.forestsLayer, this.roadsLayer});
        LayerGroupInfo single = this.buildLayerGroup(SINGLE_GROUP_NAME, LayerGroupInfo.Mode.SINGLE, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer});
        this.layerGroups = Arrays.asList(single, opaque);
        this.populateCatalog();
        this.buildManager("single.r=*", "opaque.r=MILITARY");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(opaque.prefixedName()));
        LayerGroupInfo securedSingleGroup = this.sc.getLayerGroupByName(single.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)1L, (long)securedSingleGroup.getLayers().size());
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        securedSingleGroup = this.sc.getLayerGroupByName(single.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.getLayers().size());
        LayerGroupInfo securedOpaqueGroup = this.sc.getLayerGroupByName(opaque.prefixedName());
        Assert.assertNotNull((Object)securedOpaqueGroup);
        Assert.assertEquals((long)2L, (long)securedOpaqueGroup.getLayers().size());
    }

    @Test
    public void testWmsSecuredSingleAndPublicOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{this.forestsLayer, this.roadsLayer});
        LayerGroupInfo single = this.buildLayerGroup(SINGLE_GROUP_NAME, LayerGroupInfo.Mode.SINGLE, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer});
        this.layerGroups = Arrays.asList(single, opaque);
        this.populateCatalog();
        this.buildManager("single.r=MILITARY", "opaque.r=*");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(single.prefixedName()));
        LayerGroupInfo securedOpaqueGroup = this.sc.getLayerGroupByName(opaque.prefixedName());
        Assert.assertNotNull((Object)securedOpaqueGroup);
        Assert.assertEquals((long)2L, (long)securedOpaqueGroup.getLayers().size());
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo securedSingleGroup = this.sc.getLayerGroupByName(single.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.getLayers().size());
        securedOpaqueGroup = this.sc.getLayerGroupByName(opaque.prefixedName());
        Assert.assertNotNull((Object)securedOpaqueGroup);
        Assert.assertEquals((long)2L, (long)securedOpaqueGroup.getLayers().size());
    }

    @Test
    public void testNestedOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer});
        LayerGroupInfo named = this.buildLayerGroup(NAMED_GROUP_NAME, LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{this.forestsLayer, opaque});
        this.layerGroups = Arrays.asList(named, opaque);
        this.populateCatalog();
        this.buildManager(DEFAULT_RULES);
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo securedNamedGroup = this.sc.getLayerGroupByName(NAMED_GROUP_NAME);
        Assert.assertEquals((long)3L, (long)securedNamedGroup.layers().size());
        LayerGroupInfo securedOpaqueGroup = this.sc.getLayerGroupByName(OPAQUE_GROUP_NAME);
        Assert.assertEquals((long)2L, (long)securedOpaqueGroup.layers().size());
    }

    @Test
    public void testNestedOpaqueDenyNestedGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer});
        LayerGroupInfo named = this.buildLayerGroup(NAMED_GROUP_NAME, LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{this.forestsLayer, opaque});
        this.layerGroups = Arrays.asList(named, opaque);
        this.populateCatalog();
        this.buildManager(new String[]{"opaque.r=MILITARY"});
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo securedNamedGroup = this.sc.getLayerGroupByName(NAMED_GROUP_NAME);
        Assert.assertEquals((long)1L, (long)securedNamedGroup.layers().size());
        Assert.assertEquals((Object)this.forestsLayer.getName(), (Object)((PublishedInfo)securedNamedGroup.getLayers().get(0)).getName());
        Assert.assertNull((Object)this.sc.getLayerGroupByName(OPAQUE_GROUP_NAME));
    }

    @Test
    public void testNestedOpaqueDenyContainerGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{this.statesLayer, this.roadsLayer});
        LayerGroupInfo named = this.buildLayerGroup(NAMED_GROUP_NAME, LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{this.forestsLayer, opaque});
        this.layerGroups = Arrays.asList(named, opaque);
        this.populateCatalog();
        this.buildManager(new String[]{"named.r=MILITARY"});
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(NAMED_GROUP_NAME));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(OPAQUE_GROUP_NAME));
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo securedNamedGroup = this.sc.getLayerGroupByName(NAMED_GROUP_NAME);
        Assert.assertEquals((long)3L, (long)securedNamedGroup.layers().size());
        LayerGroupInfo securedOpaqueGroup = this.sc.getLayerGroupByName(OPAQUE_GROUP_NAME);
        Assert.assertEquals((long)2L, (long)securedOpaqueGroup.layers().size());
    }

    @Test
    public void testWmsNestedInStandaloneOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo nested = this.buildLayerGroup(NESTED_GROUP_NAME, LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{this.statesLayer});
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{nested, this.roadsLayer});
        this.layerGroups = Arrays.asList(nested, opaque);
        this.populateCatalog();
        this.buildManager(DEFAULT_RULES);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNull((Object)this.sc.getLayerGroupByName(NESTED_GROUP_NAME));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo securedGroup = this.sc.getLayerGroupByName(opaque.prefixedName());
        Assert.assertNotNull((Object)securedGroup);
        Assert.assertEquals((long)2L, (long)securedGroup.getLayers().size());
        Assert.assertThat((Object)securedGroup.getLayers(), (Matcher)Matchers.contains((Object[])new PublishedInfo[]{nested, this.roadsLayer}));
        Assert.assertThat((Object)securedGroup.layers(), (Matcher)Matchers.contains((Object[])new LayerInfo[]{this.statesLayer, this.roadsLayer}));
    }

    @Test
    public void testWmsNestedInNamedOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo nested = this.buildLayerGroup(NESTED_GROUP_NAME, LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{this.statesLayer});
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{nested, this.roadsLayer});
        LayerGroupInfo named = this.buildLayerGroup(NAMED_GROUP_NAME, LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{nested, this.roadsLayer});
        this.layerGroups = Arrays.asList(nested, named, opaque);
        this.populateCatalog();
        this.buildManager(DEFAULT_RULES);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(nested.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo securedOpaqueGroup = this.sc.getLayerGroupByName(opaque.prefixedName());
        Assert.assertNotNull((Object)securedOpaqueGroup);
        Assert.assertEquals((long)2L, (long)securedOpaqueGroup.getLayers().size());
        Assert.assertThat((Object)securedOpaqueGroup.getLayers(), (Matcher)Matchers.contains((Object[])new PublishedInfo[]{nested, this.roadsLayer}));
        LayerGroupInfo securedNamedGroup = this.sc.getLayerGroupByName(named.prefixedName());
        Assert.assertNotNull((Object)securedNamedGroup);
        Assert.assertEquals((long)2L, (long)securedNamedGroup.getLayers().size());
        Assert.assertThat((Object)securedNamedGroup.getLayers(), (Matcher)Matchers.contains((Object[])new PublishedInfo[]{nested, this.roadsLayer}));
    }

    @Test
    public void testWmsNestedInSingleAndOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo nested = this.buildLayerGroup(NESTED_GROUP_NAME, LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{this.statesLayer});
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{nested, this.roadsLayer});
        LayerGroupInfo single = this.buildLayerGroup(SINGLE_GROUP_NAME, LayerGroupInfo.Mode.SINGLE, null, new PublishedInfo[]{nested, this.roadsLayer});
        this.layerGroups = Arrays.asList(nested, single, opaque);
        this.populateCatalog();
        this.buildManager(DEFAULT_RULES);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNull((Object)this.sc.getLayerGroupByName(nested.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo opaqueSecuredGroup = this.sc.getLayerGroupByName(opaque.prefixedName());
        Assert.assertNotNull((Object)opaqueSecuredGroup);
        Assert.assertEquals((long)2L, (long)opaqueSecuredGroup.getLayers().size());
        Assert.assertThat((Object)opaqueSecuredGroup.getLayers(), (Matcher)Matchers.contains((Object[])new PublishedInfo[]{nested, this.roadsLayer}));
        LayerGroupInfo securedSingleGroup = this.sc.getLayerGroupByName(single.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.getLayers().size());
        Assert.assertThat((Object)securedSingleGroup.getLayers(), (Matcher)Matchers.contains((Object[])new PublishedInfo[]{nested, this.roadsLayer}));
    }

    @Test
    public void testWmsNestedInMilitaryNamedAndPublicOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo nested = this.buildLayerGroup(NESTED_GROUP_NAME, LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{this.statesLayer});
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{nested, this.roadsLayer});
        LayerGroupInfo named = this.buildLayerGroup(NAMED_GROUP_NAME, LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{nested, this.roadsLayer});
        this.layerGroups = Arrays.asList(nested, opaque, named);
        this.populateCatalog();
        this.buildManager(new String[]{"named.r=MILITARY"});
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNull((Object)this.sc.getLayerGroupByName(nested.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        LayerGroupInfo securedGroup = this.sc.getLayerGroupByName(OPAQUE_GROUP_NAME);
        Assert.assertNotNull((Object)securedGroup);
        Assert.assertEquals((long)2L, (long)securedGroup.getLayers().size());
        Assert.assertThat((Object)securedGroup.getLayers(), (Matcher)Matchers.contains((Object[])new PublishedInfo[]{nested, this.roadsLayer}));
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertNotNull((Object)this.sc.getLayerGroupByName(nested.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
    }

    @Test
    public void testWmsNestedInPublicSingleAndSecuredOpaqueGroup() throws Exception {
        this.setupRequestThreadLocal("WMS");
        LayerGroupInfo nested = this.buildLayerGroup(NESTED_GROUP_NAME, LayerGroupInfo.Mode.NAMED, null, new PublishedInfo[]{this.statesLayer});
        LayerGroupInfo opaque = this.buildLayerGroup(OPAQUE_GROUP_NAME, LayerGroupInfo.Mode.OPAQUE_CONTAINER, null, new PublishedInfo[]{this.forestsLayer, nested});
        LayerGroupInfo single = this.buildLayerGroup(SINGLE_GROUP_NAME, LayerGroupInfo.Mode.SINGLE, null, new PublishedInfo[]{this.roadsLayer, nested});
        this.layerGroups = Arrays.asList(nested, single, opaque);
        this.populateCatalog();
        this.buildManager("single.r=*", "opaque.r=MILITARY");
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(nested.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(opaque.prefixedName()));
        LayerGroupInfo securedSingleGroup = this.sc.getLayerGroupByName(single.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)1L, (long)securedSingleGroup.getLayers().size());
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        Assert.assertNotNull((Object)this.sc.getLayerByName(this.roadsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.forestsLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerByName(this.statesLayer.prefixedName()));
        Assert.assertNull((Object)this.sc.getLayerGroupByName(nested.prefixedName()));
        securedSingleGroup = this.sc.getLayerGroupByName(single.prefixedName());
        Assert.assertNotNull((Object)securedSingleGroup);
        Assert.assertEquals((long)2L, (long)securedSingleGroup.getLayers().size());
        Assert.assertThat((Object)securedSingleGroup.getLayers(), (Matcher)Matchers.contains((Object[])new PublishedInfo[]{this.roadsLayer, nested}));
        LayerGroupInfo nestedInSingle = (LayerGroupInfo)securedSingleGroup.getLayers().get(1);
        Assert.assertEquals((long)1L, (long)nestedInSingle.getLayers().size());
        Assert.assertThat((Object)nestedInSingle.getLayers(), (Matcher)Matchers.contains((Object[])new PublishedInfo[]{this.statesLayer}));
        LayerGroupInfo securedOpaqueGroup = this.sc.getLayerGroupByName(opaque.prefixedName());
        Assert.assertNotNull((Object)securedOpaqueGroup);
        Assert.assertEquals((long)2L, (long)securedOpaqueGroup.getLayers().size());
        Assert.assertThat((Object)securedOpaqueGroup.getLayers(), (Matcher)Matchers.contains((Object[])new PublishedInfo[]{this.forestsLayer, nested}));
        LayerGroupInfo nestedInOpaque = (LayerGroupInfo)securedSingleGroup.getLayers().get(1);
        Assert.assertEquals((long)1L, (long)nestedInOpaque.getLayers().size());
        Assert.assertThat((Object)nestedInOpaque.getLayers(), (Matcher)Matchers.contains((Object[])new PublishedInfo[]{this.statesLayer}));
    }
}

