/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.easymock.Capture;
import org.easymock.IAnswer;
import org.easymock.classextension.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecureCatalogImplFilterTest {
    Authentication anonymous = new TestingAuthenticationToken((Object)"anonymous", null);
    ResourceAccessManager manager;

    static <T> List<T> collectAndClose(CloseableIterator<T> it) throws IOException {
        if (it == null) {
            return null;
        }
        try {
            LinkedList<Object> list = new LinkedList<Object>();
            while (it.hasNext()) {
                list.add(it.next());
            }
            LinkedList<Object> linkedList = list;
            return linkedList;
        }
        finally {
            it.close();
        }
    }

    static <T> CloseableIterator<T> makeCIterator(List<T> source, Filter f) {
        return CloseableIteratorAdapter.filter(source.iterator(), (Filter)f);
    }

    FeatureTypeInfo createMockFeatureType(String name, WorkspaceInfo ws, CatalogMode mode, Filter mockFilter, boolean read, boolean write) {
        DataStoreInfo mockStoreInfo = (DataStoreInfo)EasyMock.createMock(DataStoreInfo.class);
        FeatureTypeInfo mockFTInfo = (FeatureTypeInfo)EasyMock.createMock(FeatureTypeInfo.class);
        EasyMock.expect((Object)mockFTInfo.getName()).andStubReturn((Object)name);
        EasyMock.expect((Object)mockFTInfo.getStore()).andStubReturn((Object)mockStoreInfo);
        EasyMock.expect((Object)mockStoreInfo.getWorkspace()).andStubReturn((Object)ws);
        EasyMock.replay((Object[])new Object[]{mockStoreInfo});
        EasyMock.expect((Object)this.manager.getAccessLimits((Authentication)EasyMock.eq((Object)this.anonymous), (ResourceInfo)EasyMock.eq((Object)mockFTInfo))).andStubReturn((Object)new VectorAccessLimits(mode, null, null, null, null));
        EasyMock.expect((Object)mockFilter.evaluate((Object)mockFTInfo)).andStubReturn((Object)(read || mode == CatalogMode.CHALLENGE ? 1 : 0));
        return mockFTInfo;
    }

    static Matcher<FeatureTypeInfo> matchFT(String name, WorkspaceInfo ws) {
        return Matchers.allOf((Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)name)), (Matcher)Matchers.hasProperty((String)"store", (Matcher)Matchers.hasProperty((String)"workspace", (Matcher)Matchers.is((Object)ws))));
    }

    @Test
    public void testFeatureTypeList() throws Exception {
        Catalog catalog = (Catalog)EasyMock.createMock(Catalog.class);
        this.manager = (ResourceAccessManager)EasyMock.createMock(ResourceAccessManager.class);
        Filter mockFilter = (Filter)EasyMock.createMock(Filter.class);
        EasyMock.expect((Object)this.manager.getSecurityFilter((Authentication)EasyMock.eq((Object)this.anonymous), (Class)EasyMock.eq(FeatureTypeInfo.class))).andStubReturn((Object)mockFilter);
        final Capture filterCapture = new Capture();
        final ArrayList<FeatureTypeInfo> source = new ArrayList<FeatureTypeInfo>();
        WorkspaceInfo mockWSInfo = (WorkspaceInfo)EasyMock.createMock(WorkspaceInfo.class);
        EasyMock.expect((Object)this.manager.getAccessLimits((Authentication)EasyMock.eq((Object)this.anonymous), (WorkspaceInfo)EasyMock.eq((Object)mockWSInfo))).andStubReturn((Object)new WorkspaceAccessLimits(CatalogMode.HIDE, true, false, false));
        FeatureTypeInfo mockFTInfo = this.createMockFeatureType("foo", mockWSInfo, CatalogMode.HIDE, mockFilter, true, false);
        source.add(mockFTInfo);
        EasyMock.replay((Object[])new Object[]{mockFTInfo});
        mockFTInfo = this.createMockFeatureType("bar", mockWSInfo, CatalogMode.HIDE, mockFilter, false, false);
        source.add(mockFTInfo);
        EasyMock.replay((Object[])new Object[]{mockFTInfo});
        mockFTInfo = this.createMockFeatureType("baz", mockWSInfo, CatalogMode.CHALLENGE, mockFilter, false, false);
        source.add(mockFTInfo);
        EasyMock.replay((Object[])new Object[]{mockFTInfo});
        EasyMock.expect((Object)catalog.list((Class)EasyMock.eq(FeatureTypeInfo.class), (Filter)EasyMock.capture((Capture)filterCapture), (Integer)EasyMock.isNull(), (Integer)EasyMock.isNull(), (SortBy)EasyMock.isNull())).andStubAnswer((IAnswer)new IAnswer<CloseableIterator<FeatureTypeInfo>>(){

            public CloseableIterator<FeatureTypeInfo> answer() throws Throwable {
                Filter filter = (Filter)filterCapture.getValue();
                return CloseableIteratorAdapter.filter(source.iterator(), (Filter)filter);
            }
        });
        EasyMock.replay((Object[])new Object[]{catalog, this.manager, mockFilter});
        SecureCatalogImpl sc = new SecureCatalogImpl(catalog, this.manager){

            protected boolean isAdmin(Authentication authentication) {
                return false;
            }

            protected <T extends CatalogInfo> T checkAccess(Authentication user, T info, SecureCatalogImpl.MixedModeBehavior mixedModeBehavior) {
                return info;
            }
        };
        SecurityContextHolder.getContext().setAuthentication(this.anonymous);
        List ftResult = SecureCatalogImplFilterTest.collectAndClose(sc.list(FeatureTypeInfo.class, Predicates.acceptAll()));
        WorkspaceInfo foo = ((FeatureTypeInfo)ftResult.get(0)).getStore().getWorkspace();
        Assert.assertThat(ftResult, (Matcher)Matchers.contains((Matcher[])new Matcher[]{SecureCatalogImplFilterTest.matchFT("foo", mockWSInfo), SecureCatalogImplFilterTest.matchFT("baz", mockWSInfo)}));
        EasyMock.verify((Object[])new Object[]{catalog, this.manager});
    }
}

