/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.security.impl.RoleHierarchyHelper;
import org.junit.Assert;
import org.junit.Test;

public class RoleHierarchyHelperTest {
    protected Map<String, String> createFromArray(String[][] array) {
        HashMap<String, String> mappings = new HashMap<String, String>();
        for (int i = 0; i < array.length; ++i) {
            mappings.put(array[i][0], array[i][1]);
        }
        return mappings;
    }

    @Test
    public void testValidTree() throws Exception {
        Map<String, String> map = this.createFromArray(new String[][]{{"node1", null}, {"node11", "node1"}, {"node12", "node1"}, {"node111", "node11"}, {"node112", "node11"}});
        RoleHierarchyHelper helper = new RoleHierarchyHelper(map);
        Assert.assertFalse((boolean)helper.containsRole("abc"));
        Assert.assertTrue((boolean)helper.containsRole("node11"));
        Assert.assertFalse((boolean)helper.isRoot("node11"));
        Assert.assertTrue((boolean)helper.isRoot("node1"));
        Assert.assertEquals((long)1L, (long)helper.getRootRoles().size());
        Assert.assertTrue((boolean)helper.getRootRoles().contains("node1"));
        Assert.assertEquals((long)3L, (long)helper.getLeafRoles().size());
        Assert.assertTrue((boolean)helper.getLeafRoles().contains("node111"));
        Assert.assertTrue((boolean)helper.getLeafRoles().contains("node112"));
        Assert.assertTrue((boolean)helper.getLeafRoles().contains("node12"));
        Assert.assertEquals((Object)"node1", (Object)helper.getParent("node11"));
        Assert.assertNull((Object)helper.getParent("node1"));
        Assert.assertEquals((long)0L, (long)helper.getAncestors("node1").size());
        Assert.assertEquals((long)1L, (long)helper.getAncestors("node12").size());
        Assert.assertTrue((boolean)helper.getAncestors("node12").contains("node1"));
        Assert.assertEquals((long)2L, (long)helper.getAncestors("node112").size());
        Assert.assertTrue((boolean)helper.getAncestors("node112").contains("node11"));
        Assert.assertTrue((boolean)helper.getAncestors("node112").contains("node1"));
        Assert.assertEquals((long)2L, (long)helper.getChildren("node1").size());
        Assert.assertTrue((boolean)helper.getChildren("node1").contains("node11"));
        Assert.assertTrue((boolean)helper.getChildren("node1").contains("node12"));
        Assert.assertEquals((long)0L, (long)helper.getChildren("node12").size());
        Assert.assertEquals((long)2L, (long)helper.getChildren("node11").size());
        Assert.assertTrue((boolean)helper.getChildren("node11").contains("node111"));
        Assert.assertTrue((boolean)helper.getChildren("node11").contains("node112"));
        Assert.assertEquals((long)4L, (long)helper.getDescendants("node1").size());
        Assert.assertTrue((boolean)helper.getDescendants("node1").contains("node11"));
        Assert.assertTrue((boolean)helper.getDescendants("node1").contains("node12"));
        Assert.assertTrue((boolean)helper.getDescendants("node1").contains("node111"));
        Assert.assertTrue((boolean)helper.getDescendants("node1").contains("node112"));
        Assert.assertEquals((long)0L, (long)helper.getDescendants("node12").size());
        Assert.assertEquals((long)2L, (long)helper.getDescendants("node11").size());
        Assert.assertTrue((boolean)helper.getDescendants("node11").contains("node111"));
        Assert.assertTrue((boolean)helper.getDescendants("node11").contains("node112"));
        Assert.assertTrue((boolean)helper.isValidParent("node11", null));
        Assert.assertTrue((boolean)helper.isValidParent("node11", "node12"));
        Assert.assertFalse((boolean)helper.isValidParent("node11", "node11"));
        Assert.assertFalse((boolean)helper.isValidParent("node1", "node111"));
        boolean fail = true;
        try {
            helper.isRoot("abc");
        }
        catch (RuntimeException e) {
            fail = false;
        }
        if (fail) {
            Assert.fail((String)"No Exception");
        }
    }

    @Test
    public void testInValidTree1() throws Exception {
        Map<String, String> map = this.createFromArray(new String[][]{{"node1", "node1"}});
        RoleHierarchyHelper helper = new RoleHierarchyHelper(map);
        boolean fail = true;
        try {
            helper.getParent("node1");
        }
        catch (RuntimeException e) {
            fail = false;
        }
        if (fail) {
            Assert.fail((String)"No Exception");
        }
        fail = true;
        try {
            helper.getAncestors("node1");
        }
        catch (RuntimeException e) {
            fail = false;
        }
        if (fail) {
            Assert.fail((String)"No Exception");
        }
        fail = true;
        try {
            helper.getChildren("node1");
        }
        catch (RuntimeException e) {
            fail = false;
        }
        if (fail) {
            Assert.fail((String)"No Exception");
        }
        fail = true;
        try {
            helper.getDescendants("node1");
        }
        catch (RuntimeException e) {
            fail = false;
        }
        if (fail) {
            Assert.fail((String)"No Exception");
        }
    }

    @Test
    public void testInValidTree2() throws Exception {
        Map<String, String> map = this.createFromArray(new String[][]{{"node1", "node2"}, {"node2", "node1"}});
        RoleHierarchyHelper helper = new RoleHierarchyHelper(map);
        helper.getParent("node1");
        boolean fail = true;
        try {
            helper.getAncestors("node1");
        }
        catch (RuntimeException e) {
            fail = false;
        }
        if (fail) {
            Assert.fail((String)"No Exception");
        }
        helper.getChildren("node1");
        fail = true;
        try {
            helper.getDescendants("node1");
        }
        catch (RuntimeException e) {
            fail = false;
        }
        if (fail) {
            Assert.fail((String)"No Exception");
        }
    }
}

