/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.config.impl.MemoryUserGroupServiceConfigImpl;
import org.geoserver.security.impl.AbstractUserGroupServiceTest;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.MemoryGeoserverUser;
import org.geoserver.security.impl.MemoryGeoserverUserGroup;
import org.geoserver.security.impl.MemoryUserGroupService;
import org.geoserver.test.SystemTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class MemoryUserGroupServiceTest
extends AbstractUserGroupServiceTest {
    @After
    public void clearUserGroupService() throws IOException {
        this.store.clear();
        this.store.store();
    }

    public GeoServerUserGroupService createUserGroupService(String name) throws Exception {
        MemoryUserGroupServiceConfigImpl config = (MemoryUserGroupServiceConfigImpl)this.createConfigObject(name);
        this.getSecurityManager().saveUserGroupService((SecurityUserGroupServiceConfig)config);
        return this.getSecurityManager().loadUserGroupService(name);
    }

    @Override
    protected SecurityUserGroupServiceConfig createConfigObject(String name) {
        MemoryUserGroupServiceConfigImpl config = new MemoryUserGroupServiceConfigImpl();
        config.setClassName(MemoryUserGroupService.class.getName());
        config.setName(name);
        config.setPasswordEncoderName(this.getPBEPasswordEncoder().getName());
        config.setPasswordPolicyName("default");
        return config;
    }

    @Override
    @Test
    public void testInsert() throws Exception {
        super.testInsert();
        for (GeoServerUser user : this.store.getUsers()) {
            Assert.assertTrue((user.getClass() == MemoryGeoserverUser.class ? 1 : 0) != 0);
        }
        for (GeoServerUserGroup group : this.store.getUserGroups()) {
            Assert.assertTrue((group.getClass() == MemoryGeoserverUserGroup.class ? 1 : 0) != 0);
        }
    }
}

