/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.SortedSet;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityRoleServiceConfig;
import org.geoserver.security.config.impl.MemoryRoleServiceConfigImpl;
import org.geoserver.security.config.impl.MemoryUserGroupServiceConfigImpl;
import org.geoserver.security.impl.AbstractRoleServiceTest;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.MemoryGeoserverRole;
import org.geoserver.security.impl.MemoryRoleService;
import org.geoserver.security.impl.MemoryUserGroupService;
import org.geoserver.security.impl.RoleCalculator;
import org.geoserver.test.SystemTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class MemoryRoleServiceTest
extends AbstractRoleServiceTest {
    public GeoServerRoleService createRoleService(String name) throws IOException {
        MemoryRoleServiceConfigImpl config = new MemoryRoleServiceConfigImpl();
        config.setName(name);
        MemoryRoleService service = new MemoryRoleService();
        service.initializeFromConfig((SecurityNamedServiceConfig)config);
        service.setSecurityManager(this.getSecurityManager());
        return service;
    }

    @Before
    public void init() throws IOException {
        this.service = this.createRoleService("test");
        this.store = this.service.createStore();
    }

    @Test
    public void testInsert() throws Exception {
        super.testInsert();
        for (GeoServerRole role : this.store.getRoles()) {
            Assert.assertTrue((role.getClass() == MemoryGeoserverRole.class ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMappedAdminRoles() throws Exception {
        MemoryRoleServiceConfigImpl config = new MemoryRoleServiceConfigImpl();
        config.setName("testAdminRole");
        config.setAdminRoleName("adminRole");
        config.setGroupAdminRoleName("groupAdminRole");
        config.setClassName(MemoryRoleService.class.getName());
        MemoryRoleService service = new MemoryRoleService();
        service.initializeFromConfig((SecurityNamedServiceConfig)config);
        GeoServerSecurityManager manager = (GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class);
        service.setSecurityManager(manager);
        manager.setActiveRoleService((GeoServerRoleService)service);
        manager.saveRoleService((SecurityRoleServiceConfig)config);
        GeoServerRoleStore store = service.createStore();
        GeoServerRole adminRole = store.createRoleObject("adminRole");
        GeoServerRole groupAdminRole = store.createRoleObject("groupAdminRole");
        GeoServerRole role1 = store.createRoleObject("role1");
        store.addRole(adminRole);
        store.addRole(groupAdminRole);
        store.addRole(role1);
        store.associateRoleToUser(adminRole, "user1");
        store.associateRoleToUser(groupAdminRole, "user1");
        store.associateRoleToUser(adminRole, "user2");
        store.associateRoleToUser(role1, "user3");
        store.store();
        MemoryUserGroupServiceConfigImpl ugconfig = new MemoryUserGroupServiceConfigImpl();
        ugconfig.setName("testAdminRole");
        ugconfig.setClassName(MemoryUserGroupService.class.getName());
        ugconfig.setPasswordEncoderName(this.getPBEPasswordEncoder().getName());
        ugconfig.setPasswordPolicyName("default");
        MemoryUserGroupService ugService = new MemoryUserGroupService();
        ugService.setSecurityManager((GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class));
        ugService.initializeFromConfig((SecurityNamedServiceConfig)ugconfig);
        RoleCalculator calc = new RoleCalculator((GeoServerUserGroupService)ugService, (GeoServerRoleService)service);
        SortedSet roles = calc.calculateRoles(ugService.createUserObject("user1", "abc", true));
        Assert.assertTrue((roles.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)roles.contains(adminRole));
        Assert.assertTrue((boolean)roles.contains(GeoServerRole.ADMIN_ROLE));
        Assert.assertTrue((boolean)roles.contains(groupAdminRole));
        Assert.assertTrue((boolean)roles.contains(GeoServerRole.GROUP_ADMIN_ROLE));
        roles = calc.calculateRoles(ugService.createUserObject("user2", "abc", true));
        Assert.assertTrue((roles.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)roles.contains(adminRole));
        Assert.assertTrue((boolean)roles.contains(GeoServerRole.ADMIN_ROLE));
        roles = calc.calculateRoles(ugService.createUserObject("user3", "abc", true));
        Assert.assertTrue((roles.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)roles.contains(role1));
    }
}

