/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.ArrayList;
import java.util.Collection;
import org.geoserver.security.GeoServerRoleConverter;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerRoleConverterImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.core.GrantedAuthority;

public class GeoServerRoleConverterImplTest {
    private GeoServerRoleConverter converter;

    @Before
    public void setUp() throws Exception {
        this.converter = new GeoServerRoleConverterImpl();
    }

    @Test
    public void testConverter() {
        GeoServerRole r1 = new GeoServerRole("r1");
        r1.getProperties().setProperty("r1_p1", "r1_v1");
        r1.getProperties().setProperty("r1_p2", "r1_v2");
        GeoServerRole r2 = new GeoServerRole("r2");
        r2.getProperties().setProperty("r2_p1", "r2_v1");
        GeoServerRole r3 = new GeoServerRole("r3");
        GeoServerRole r = this.converter.convertRoleFromString(this.converter.convertRoleToString(r1), "testuser");
        Assert.assertEquals((Object)"r1", (Object)r.getAuthority());
        Assert.assertEquals((long)2L, (long)r.getProperties().size());
        Assert.assertEquals((Object)"r1_v1", (Object)r.getProperties().get("r1_p1"));
        Assert.assertEquals((Object)"r1_v2", (Object)r.getProperties().get("r1_p2"));
        Assert.assertEquals((Object)"testuser", (Object)r.getUserName());
        ArrayList<GeoServerRole> list = new ArrayList<GeoServerRole>();
        list.add(r1);
        list.add(r2);
        list.add(r3);
        Collection resColl = this.converter.convertRolesFromString(this.converter.convertRolesToString(list), null);
        Assert.assertEquals((long)3L, (long)resColl.size());
        for (GrantedAuthority auth : resColl) {
            r = (GeoServerRole)auth;
            Assert.assertNull((Object)r.getUserName());
            if ("r3".equals(r.getAuthority())) continue;
            if ("r2".equals(r.getAuthority())) {
                Assert.assertEquals((long)1L, (long)r.getProperties().size());
                Assert.assertEquals((Object)"r2_v1", (Object)r.getProperties().get("r2_p1"));
                continue;
            }
            if ("r1".equals(r.getAuthority())) {
                Assert.assertEquals((long)2L, (long)r.getProperties().size());
                Assert.assertEquals((Object)"r1_v1", (Object)r.getProperties().get("r1_p1"));
                Assert.assertEquals((Object)"r1_v2", (Object)r.getProperties().get("r1_p2"));
                continue;
            }
            Assert.fail((String)("Unexpected role: " + r.getAuthority()));
        }
        Assert.assertNull((Object)this.converter.convertRoleFromString("  ", null));
        Assert.assertEquals((long)0L, (long)this.converter.convertRolesFromString("  ", null).size());
        resColl.clear();
        Assert.assertEquals((long)0L, (long)this.converter.convertRolesToString(resColl).length());
    }
}

