/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.AccessMode;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.LayerGroupAccessLimits;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.security.impl.AbstractAuthorizationTest;
import org.geoserver.security.impl.DefaultResourceAccessManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.filter.Filter;
import org.springframework.security.core.Authentication;

public class DefaultResourceAccessManagerAuthTest
extends AbstractAuthorizationTest {
    @Before
    public void setupCatalog() {
        this.populateCatalog();
    }

    @Test
    public void testWideOpen() throws Exception {
        DefaultResourceAccessManager manager = this.buildAccessManager("wideOpen.properties");
        this.checkUserAccessFlat((ResourceAccessManager)manager, this.anonymous, true, true);
    }

    @Test
    public void testLockedDown() throws Exception {
        DefaultResourceAccessManager manager = this.buildAccessManager("lockedDown.properties");
        this.checkUserAccessFlat((ResourceAccessManager)manager, this.anonymous, false, false);
        this.checkUserAccessFlat((ResourceAccessManager)manager, this.roUser, false, false);
        this.checkUserAccessFlat((ResourceAccessManager)manager, this.rwUser, true, true);
        this.checkUserAccessFlat((ResourceAccessManager)manager, (Authentication)this.root, true, true);
    }

    @Test
    public void testPublicRead() throws Exception {
        DefaultResourceAccessManager manager = this.buildAccessManager("publicRead.properties");
        this.checkUserAccessFlat((ResourceAccessManager)manager, this.anonymous, true, false);
        this.checkUserAccessFlat((ResourceAccessManager)manager, this.roUser, true, false);
        this.checkUserAccessFlat((ResourceAccessManager)manager, this.rwUser, true, true);
        this.checkUserAccessFlat((ResourceAccessManager)manager, (Authentication)this.root, true, true);
    }

    private void checkUserAccessFlat(ResourceAccessManager manager, Authentication user, boolean expectedRead, boolean expectedWrite) {
        Assert.assertEquals((Object)expectedRead, (Object)this.canAccess(manager, user, this.statesLayer, AccessMode.READ));
        Assert.assertEquals((Object)expectedWrite, (Object)this.canAccess(manager, user, this.statesLayer, AccessMode.WRITE));
        ResourceInfo resource = this.statesLayer.getResource();
        Assert.assertEquals((Object)expectedRead, (Object)this.canAccess(manager, user, resource, AccessMode.READ));
        Assert.assertEquals((Object)expectedWrite, (Object)this.canAccess(manager, user, resource, AccessMode.WRITE));
        Assert.assertEquals((Object)expectedRead, (Object)this.canAccess(manager, user, this.toppWs, AccessMode.READ));
        Assert.assertEquals((Object)expectedWrite, (Object)this.canAccess(manager, user, this.toppWs, AccessMode.WRITE));
    }

    @Test
    public void testComplex() throws Exception {
        DefaultResourceAccessManager wo = this.buildAccessManager("complex.properties");
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.nurcWs, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.nurcWs, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.roUser, this.nurcWs, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.rwUser, this.nurcWs, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, (Authentication)this.root, this.nurcWs, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.toppWs, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.toppWs, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.roUser, this.toppWs, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.rwUser, this.toppWs, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.roadsLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.roadsLayer, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.roUser, this.roadsLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.rwUser, this.roadsLayer, AccessMode.WRITE));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.statesLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.statesLayer, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.roUser, this.statesLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.roUser, this.statesLayer, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.rwUser, this.statesLayer, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.rwUser, this.statesLayer, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.landmarksLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.landmarksLayer, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.roUser, this.landmarksLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.roUser, this.landmarksLayer, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.rwUser, this.landmarksLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.rwUser, this.statesLayer, AccessMode.WRITE));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.basesLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.basesLayer, AccessMode.WRITE));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.roUser, this.basesLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.roUser, this.basesLayer, AccessMode.WRITE));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.rwUser, this.basesLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.rwUser, this.basesLayer, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.milUser, this.basesLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.milUser, this.basesLayer, AccessMode.WRITE));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.arcGridLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.anonymous, this.arcGridLayer, AccessMode.WRITE));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.roUser, this.arcGridLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.roUser, this.arcGridLayer, AccessMode.WRITE));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.rwUser, this.arcGridLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)wo, this.rwUser, this.arcGridLayer, AccessMode.WRITE));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.milUser, this.arcGridLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)wo, this.milUser, this.arcGridLayer, AccessMode.WRITE));
    }

    @Test
    public void testDefaultMode() throws Exception {
        DefaultResourceAccessManager wo = this.buildAccessManager("lockedDown.properties");
        Assert.assertEquals((Object)CatalogMode.HIDE, (Object)wo.getMode());
    }

    @Test
    public void testHideMode() throws Exception {
        DefaultResourceAccessManager wo = this.buildAccessManager("lockedDownHide.properties");
        Assert.assertEquals((Object)CatalogMode.HIDE, (Object)wo.getMode());
    }

    @Test
    public void testChallengeMode() throws Exception {
        DefaultResourceAccessManager wo = this.buildAccessManager("lockedDownChallenge.properties");
        Assert.assertEquals((Object)CatalogMode.CHALLENGE, (Object)wo.getMode());
    }

    @Test
    public void testMixedMode() throws Exception {
        DefaultResourceAccessManager wo = this.buildAccessManager("lockedDownMixed.properties");
        Assert.assertEquals((Object)CatalogMode.MIXED, (Object)wo.getMode());
    }

    @Test
    public void testUnknownMode() throws Exception {
        DefaultResourceAccessManager wo = this.buildAccessManager("lockedDownUnknown.properties");
        Assert.assertEquals((Object)CatalogMode.HIDE, (Object)wo.getMode());
    }

    @Test
    public void testOverride() throws Exception {
        DefaultResourceAccessManager manager = this.buildAccessManager("override-ws.properties");
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.statesLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.toppWs, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.statesLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.toppWs, AccessMode.READ));
    }

    @Test
    public void testWmsNamedTreeAMilitaryOnly() throws Exception {
        this.setupRequestThreadLocal("WMS");
        DefaultResourceAccessManager manager = this.buildAccessManager("namedTreeAMilitaryOnly.properties");
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.namedTreeA, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.statesLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.roadsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.containerTreeB, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.nestedContainerE, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.forestsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.singleGroupC, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.namedTreeA, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.statesLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.roadsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.containerTreeB, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.nestedContainerE, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.forestsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.singleGroupC, AccessMode.READ));
    }

    @Test
    public void testContainerGroupBMilitaryOnly() throws Exception {
        this.setupRequestThreadLocal("WMS");
        DefaultResourceAccessManager manager = this.buildAccessManager("containerTreeGroupBMilitaryOnly.properties");
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.namedTreeA, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.statesLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.roadsLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.containerTreeB, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.landmarksLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.nestedContainerE, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.forestsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.singleGroupC, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.namedTreeA, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.statesLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.roadsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.containerTreeB, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.nestedContainerE, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.forestsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.singleGroupC, AccessMode.READ));
    }

    @Test
    public void testWmsbothGroupABMilitaryOnly() throws Exception {
        this.setupRequestThreadLocal("WMS");
        DefaultResourceAccessManager manager = this.buildAccessManager("bothGroupABMilitaryOnly.properties");
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.namedTreeA, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.statesLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.roadsLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.containerTreeB, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.landmarksLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.nestedContainerE, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.forestsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.singleGroupC, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.namedTreeA, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.statesLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.roadsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.landmarksLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.containerTreeB, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.nestedContainerE, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.forestsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.singleGroupC, AccessMode.READ));
    }

    @Test
    public void testSingleGroupCMilitaryOnly() throws Exception {
        this.setupRequestThreadLocal("WMS");
        DefaultResourceAccessManager manager = this.buildAccessManager("singleGroupCMilitaryOnly.properties");
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.namedTreeA, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.statesLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.roadsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.containerTreeB, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.landmarksLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.singleGroupC, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.basesLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.namedTreeA, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.statesLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.roadsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.containerTreeB, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.singleGroupC, AccessMode.READ));
    }

    @Test
    public void testWsContainerGroupDMilitaryOnly() throws Exception {
        this.setupRequestThreadLocal("WMS");
        DefaultResourceAccessManager manager = this.buildAccessManager("wsContainerGroupDMilitaryOnly.properties");
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.namedTreeA, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.statesLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.roadsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.containerTreeB, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.landmarksLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.singleGroupC, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.basesLayer, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.wsContainerD, AccessMode.READ));
        Assert.assertFalse((boolean)this.canAccess((ResourceAccessManager)manager, this.roUser, this.arcGridLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.namedTreeA, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.statesLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.roadsLayer, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.containerTreeB, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.singleGroupC, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.wsContainerD, AccessMode.READ));
        Assert.assertTrue((boolean)this.canAccess((ResourceAccessManager)manager, this.milUser, this.arcGridLayer, AccessMode.READ));
    }

    private boolean canAccess(ResourceAccessManager manager, Authentication user, LayerInfo catalogInfo, AccessMode mode) {
        DataAccessLimits limits = manager.getAccessLimits(user, catalogInfo);
        return this.canAccess(mode, limits);
    }

    private boolean canAccess(ResourceAccessManager manager, Authentication user, LayerGroupInfo catalogInfo, AccessMode mode) {
        LayerGroupAccessLimits limits = manager.getAccessLimits(user, catalogInfo);
        return limits == null;
    }

    private boolean canAccess(AccessMode mode, DataAccessLimits limits) {
        if (limits == null) {
            return true;
        }
        if (mode == AccessMode.READ) {
            return limits.getReadFilter() != Filter.EXCLUDE;
        }
        if (mode == AccessMode.WRITE) {
            if (limits instanceof VectorAccessLimits) {
                return ((VectorAccessLimits)limits).getWriteFilter() != Filter.EXCLUDE;
            }
            return false;
        }
        throw new RuntimeException("Unknown access mode " + mode);
    }

    private boolean canAccess(ResourceAccessManager manager, Authentication user, ResourceInfo catalogInfo, AccessMode mode) {
        DataAccessLimits limits = manager.getAccessLimits(user, catalogInfo);
        return this.canAccess(mode, limits);
    }

    private boolean canAccess(ResourceAccessManager manager, Authentication user, WorkspaceInfo catalogInfo, AccessMode mode) {
        WorkspaceAccessLimits limits = manager.getAccessLimits(user, catalogInfo);
        if (limits == null) {
            return true;
        }
        if (mode == AccessMode.READ) {
            return limits.isReadable();
        }
        if (mode == AccessMode.WRITE) {
            return limits.isWritable();
        }
        if (mode == AccessMode.ADMIN) {
            return limits.isAdminable();
        }
        throw new RuntimeException("Unknown access mode " + mode);
    }
}

