/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.Properties;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.AbstractAuthorizationTest;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.DefaultResourceAccessManager;
import org.geoserver.security.impl.MemoryDataAccessRuleDAO;
import org.geoserver.security.impl.SecureTreeNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultDataAccessManagerTreeTest
extends AbstractAuthorizationTest {
    @Before
    public void setupCatalog() {
        this.populateCatalog();
    }

    private SecureTreeNode buildTree(String propertyFile) throws Exception {
        Properties props = new Properties();
        props.load(this.getClass().getResourceAsStream(propertyFile));
        return new DefaultResourceAccessManager((DataAccessRuleDAO)new MemoryDataAccessRuleDAO((Catalog)this.catalog, (Properties)props), (Catalog)this.catalog).root;
    }

    @Test
    public void testWideOpen() throws Exception {
        SecureTreeNode root = this.buildTree("wideOpen.properties");
        Assert.assertEquals((long)0L, (long)root.children.size());
        Assert.assertEquals((long)1L, (long)root.getAuthorizedRoles(AccessMode.READ).size());
        Assert.assertEquals((long)1L, (long)root.getAuthorizedRoles(AccessMode.WRITE).size());
        Assert.assertTrue((boolean)root.canAccess(this.anonymous, AccessMode.READ));
        Assert.assertTrue((boolean)root.canAccess(this.anonymous, AccessMode.WRITE));
    }

    @Test
    public void testLockedDown() throws Exception {
        SecureTreeNode root = this.buildTree("lockedDown.properties");
        Assert.assertEquals((long)0L, (long)root.children.size());
        Set readRoles = root.getAuthorizedRoles(AccessMode.READ);
        Assert.assertEquals((long)1L, (long)readRoles.size());
        Assert.assertTrue((boolean)readRoles.contains("WRITER"));
        Set writeRoles = root.getAuthorizedRoles(AccessMode.WRITE);
        Assert.assertEquals((long)1L, (long)writeRoles.size());
        Assert.assertTrue((boolean)writeRoles.contains("WRITER"));
        Assert.assertFalse((boolean)root.canAccess(this.anonymous, AccessMode.READ));
        Assert.assertFalse((boolean)root.canAccess(this.anonymous, AccessMode.WRITE));
        Assert.assertFalse((boolean)root.canAccess(this.roUser, AccessMode.READ));
        Assert.assertFalse((boolean)root.canAccess(this.roUser, AccessMode.WRITE));
        Assert.assertTrue((boolean)root.canAccess(this.rwUser, AccessMode.READ));
        Assert.assertTrue((boolean)root.canAccess(this.rwUser, AccessMode.WRITE));
    }

    @Test
    public void testPublicRead() throws Exception {
        SecureTreeNode root = this.buildTree("publicRead.properties");
        Assert.assertEquals((long)0L, (long)root.children.size());
        Assert.assertEquals((Object)SecureTreeNode.EVERYBODY, (Object)root.getAuthorizedRoles(AccessMode.READ));
        Set writeRoles = root.getAuthorizedRoles(AccessMode.WRITE);
        Assert.assertEquals((long)1L, (long)writeRoles.size());
        Assert.assertTrue((boolean)writeRoles.contains("WRITER"));
        Assert.assertTrue((boolean)root.canAccess(this.anonymous, AccessMode.READ));
        Assert.assertFalse((boolean)root.canAccess(this.anonymous, AccessMode.WRITE));
        Assert.assertTrue((boolean)root.canAccess(this.roUser, AccessMode.READ));
        Assert.assertFalse((boolean)root.canAccess(this.roUser, AccessMode.WRITE));
        Assert.assertTrue((boolean)root.canAccess(this.rwUser, AccessMode.READ));
        Assert.assertTrue((boolean)root.canAccess(this.rwUser, AccessMode.WRITE));
    }

    @Test
    public void testComplex() throws Exception {
        SecureTreeNode root = this.buildTree("complex.properties");
        Assert.assertEquals((long)2L, (long)root.children.size());
        SecureTreeNode topp = root.getChild("topp");
        Assert.assertNotNull((Object)topp);
        Assert.assertEquals((long)3L, (long)topp.children.size());
        SecureTreeNode states = topp.getChild("states");
        SecureTreeNode landmarks = topp.getChild("landmarks");
        SecureTreeNode bases = topp.getChild("bases");
        Assert.assertNotNull((Object)states);
        Assert.assertNotNull((Object)landmarks);
        Assert.assertNotNull((Object)bases);
        Assert.assertFalse((boolean)root.canAccess(this.anonymous, AccessMode.READ));
        Assert.assertFalse((boolean)root.canAccess(this.anonymous, AccessMode.WRITE));
        Assert.assertTrue((boolean)topp.canAccess(this.anonymous, AccessMode.READ));
        Assert.assertFalse((boolean)states.canAccess(this.anonymous, AccessMode.READ));
        Assert.assertTrue((boolean)landmarks.canAccess(this.anonymous, AccessMode.READ));
        Assert.assertFalse((boolean)landmarks.canAccess(this.anonymous, AccessMode.WRITE));
        Assert.assertFalse((boolean)bases.canAccess(this.anonymous, AccessMode.READ));
        Assert.assertTrue((boolean)root.canAccess(this.roUser, AccessMode.READ));
        Assert.assertFalse((boolean)root.canAccess(this.roUser, AccessMode.WRITE));
        Assert.assertTrue((boolean)topp.canAccess(this.roUser, AccessMode.READ));
        Assert.assertTrue((boolean)states.canAccess(this.roUser, AccessMode.READ));
        Assert.assertTrue((boolean)landmarks.canAccess(this.roUser, AccessMode.READ));
        Assert.assertFalse((boolean)landmarks.canAccess(this.roUser, AccessMode.WRITE));
        Assert.assertFalse((boolean)bases.canAccess(this.roUser, AccessMode.READ));
        Assert.assertTrue((boolean)root.canAccess(this.rwUser, AccessMode.READ));
        Assert.assertFalse((boolean)root.canAccess(this.rwUser, AccessMode.WRITE));
        Assert.assertTrue((boolean)topp.canAccess(this.rwUser, AccessMode.READ));
        Assert.assertTrue((boolean)states.canAccess(this.rwUser, AccessMode.WRITE));
        Assert.assertTrue((boolean)landmarks.canAccess(this.rwUser, AccessMode.READ));
        Assert.assertTrue((boolean)landmarks.canAccess(this.rwUser, AccessMode.WRITE));
        Assert.assertFalse((boolean)bases.canAccess(this.rwUser, AccessMode.READ));
        Assert.assertFalse((boolean)root.canAccess(this.milUser, AccessMode.READ));
        Assert.assertFalse((boolean)root.canAccess(this.milUser, AccessMode.WRITE));
        Assert.assertTrue((boolean)topp.canAccess(this.milUser, AccessMode.READ));
        Assert.assertFalse((boolean)states.canAccess(this.milUser, AccessMode.WRITE));
        Assert.assertTrue((boolean)landmarks.canAccess(this.milUser, AccessMode.READ));
        Assert.assertFalse((boolean)landmarks.canAccess(this.milUser, AccessMode.WRITE));
        Assert.assertTrue((boolean)bases.canAccess(this.milUser, AccessMode.READ));
        Assert.assertTrue((boolean)bases.canAccess(this.milUser, AccessMode.WRITE));
    }
}

