/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.Properties;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.WorkspaceInfoImpl;
import org.geoserver.security.AccessMode;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.MemoryDataAccessRuleDAO;
import org.junit.Before;
import org.junit.Test;

public class DataAccessRuleDAOTest
extends TestCase {
    DataAccessRuleDAO dao;
    Properties props;

    @Before
    public void setUp() throws Exception {
        Catalog catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)catalog.getWorkspaceByName((String)EasyMock.anyObject())).andReturn((Object)new WorkspaceInfoImpl()).anyTimes();
        EasyMock.expect((Object)catalog.getLayerByName((String)EasyMock.anyObject())).andReturn((Object)new LayerInfoImpl()).anyTimes();
        EasyMock.replay((Object[])new Object[]{catalog});
        this.props = new Properties();
        this.props.put("mode", "CHALLENGE");
        this.props.put("topp.states.w", "ROLE_TSW");
        this.props.put("topp.*.w", "ROLE_TW");
        this.props.put("*.*.r", "*");
        this.props.put("group.r", "ROLE_GROUP");
        this.dao = new MemoryDataAccessRuleDAO(catalog, this.props);
    }

    @Test
    public void testRulesForRole() {
        DataAccessRuleDAOTest.assertEquals((int)0, (int)this.dao.getRulesAssociatedWithRole("CHALLENGE").size());
        DataAccessRuleDAOTest.assertEquals((int)0, (int)this.dao.getRulesAssociatedWithRole("NOTEXISTEND").size());
        DataAccessRuleDAOTest.assertEquals((int)1, (int)this.dao.getRulesAssociatedWithRole("ROLE_TSW").size());
        DataAccessRuleDAOTest.assertEquals((int)1, (int)this.dao.getRulesAssociatedWithRole("ROLE_TW").size());
        DataAccessRuleDAOTest.assertEquals((int)1, (int)this.dao.getRulesAssociatedWithRole("ROLE_GROUP").size());
    }

    @Test
    public void testParseGlobalLayerGroupRule() {
        DataAccessRule r = this.dao.parseDataAccessRule("group.r", "ROLE_GROUP_OWNER");
        DataAccessRuleDAOTest.assertEquals((String)r.getRoot(), (String)"group");
        DataAccessRuleDAOTest.assertNull((Object)r.getLayer());
        DataAccessRuleDAOTest.assertTrue((boolean)r.isGlobalGroupRule());
        DataAccessRuleDAOTest.assertEquals((Object)AccessMode.READ, (Object)r.getAccessMode());
    }

    @Test
    public void testParse() {
        DataAccessRuleDAOTest.assertEquals((int)4, (int)this.dao.getRules().size());
        DataAccessRule rule = (DataAccessRule)this.dao.getRules().get(0);
        DataAccessRuleDAOTest.assertEquals((String)"*.*.r", (String)rule.getKey());
        DataAccessRuleDAOTest.assertEquals((int)1, (int)rule.getRoles().size());
        DataAccessRuleDAOTest.assertEquals((String)"*", (String)((String)rule.getRoles().iterator().next()));
    }

    @Test
    public void testAdd() {
        DataAccessRuleDAOTest.assertEquals((int)4, (int)this.dao.getRules().size());
        DataAccessRule newRule = this.dao.parseDataAccessRule("*.*.w", "ROLE_GENERIC_W");
        DataAccessRuleDAOTest.assertTrue((boolean)this.dao.addRule((Comparable)newRule));
        DataAccessRuleDAOTest.assertEquals((int)5, (int)this.dao.getRules().size());
        DataAccessRuleDAOTest.assertEquals((Object)newRule, this.dao.getRules().get(1));
        DataAccessRuleDAOTest.assertFalse((boolean)this.dao.addRule((Comparable)newRule));
    }

    @Test
    public void testRemove() {
        DataAccessRuleDAOTest.assertEquals((int)4, (int)this.dao.getRules().size());
        DataAccessRule newRule = this.dao.parseDataAccessRule("*.*.w", "ROLE_GENERIC_W");
        DataAccessRuleDAOTest.assertFalse((boolean)this.dao.removeRule((Comparable)newRule));
        DataAccessRule first = (DataAccessRule)this.dao.getRules().get(0);
        DataAccessRuleDAOTest.assertTrue((boolean)this.dao.removeRule((Comparable)first));
        DataAccessRuleDAOTest.assertFalse((boolean)this.dao.removeRule((Comparable)first));
        DataAccessRuleDAOTest.assertEquals((int)3, (int)this.dao.getRules().size());
    }

    @Test
    public void testStore() {
        Properties newProps = this.dao.toProperties();
        DataAccessRuleDAOTest.assertEquals((int)newProps.size(), (int)this.props.size());
        for (Object key : newProps.keySet()) {
            Object newValue = newProps.get(key);
            Object oldValue = newProps.get(key);
            DataAccessRuleDAOTest.assertEquals((Object)newValue, (Object)oldValue);
        }
    }

    @Test
    public void testParsePlain() {
        DataAccessRule rule = this.dao.parseDataAccessRule("a.b.r", "ROLE_WHO_CARES");
        DataAccessRuleDAOTest.assertEquals((String)"a", (String)rule.getRoot());
        DataAccessRuleDAOTest.assertEquals((String)"b", (String)rule.getLayer());
        DataAccessRuleDAOTest.assertFalse((boolean)rule.isGlobalGroupRule());
        DataAccessRuleDAOTest.assertEquals((Object)AccessMode.READ, (Object)rule.getAccessMode());
    }

    @Test
    public void testParseSpaces() {
        DataAccessRule rule = this.dao.parseDataAccessRule(" a  . b . r ", "ROLE_WHO_CARES");
        DataAccessRuleDAOTest.assertEquals((String)"a", (String)rule.getRoot());
        DataAccessRuleDAOTest.assertEquals((String)"b", (String)rule.getLayer());
        DataAccessRuleDAOTest.assertFalse((boolean)rule.isGlobalGroupRule());
        DataAccessRuleDAOTest.assertEquals((Object)AccessMode.READ, (Object)rule.getAccessMode());
    }

    @Test
    public void testParseEscapedDots() {
        DataAccessRule rule = this.dao.parseDataAccessRule("w. a\\.b . r ", "ROLE_WHO_CARES");
        DataAccessRuleDAOTest.assertEquals((String)"w", (String)rule.getRoot());
        DataAccessRuleDAOTest.assertEquals((String)"a.b", (String)rule.getLayer());
        DataAccessRuleDAOTest.assertFalse((boolean)rule.isGlobalGroupRule());
        DataAccessRuleDAOTest.assertEquals((Object)AccessMode.READ, (Object)rule.getAccessMode());
    }

    @Test
    public void testStoreEscapedDots() throws Exception {
        this.dao.clear();
        this.dao.addRule((Comparable)new DataAccessRule("it.geosolutions", "layer.dots", AccessMode.READ, Collections.singleton("ROLE_ABC")));
        Properties ps = this.dao.toProperties();
        DataAccessRuleDAOTest.assertEquals((int)2, (int)ps.size());
        DataAccessRuleDAOTest.assertEquals((String)"ROLE_ABC", (String)ps.getProperty("it\\.geosolutions.layer\\.dots.r"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ps.store(bos, null);
    }
}

