/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.File;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.BasicAuthenticationFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerBasicAuthenticationFilter;
import org.geoserver.test.GeoServerAbstractTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.crypto.codec.Hex;

public class GeoServerBasicAuthenticationFilterTest {
    public static final String USERNAME = "admin:";
    public static final String PASSWORD = "geoserver";
    private static final int NTHREADS = 8;
    private String expected;
    private GeoServerBasicAuthenticationFilter authenticationFilter;

    @Before
    public void setUp() throws Exception {
        this.authenticationFilter = this.createAuthenticationFilter();
        StringBuffer buff = new StringBuffer(PASSWORD);
        buff.append(":");
        buff.append(this.authenticationFilter.getName());
        MessageDigest digest = MessageDigest.getInstance("MD5");
        String digestString = new String(Hex.encode((byte[])digest.digest(buff.toString().getBytes("utf-8"))));
        this.expected = USERNAME + digestString;
    }

    @Test
    public void testMultiThreadGetCacheKey() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(8);
        ArrayList<Future<Boolean>> list = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < 600; ++i) {
            AuthenticationCallable authenticationCallable = new AuthenticationCallable(this.authenticationFilter);
            Future<Boolean> submit = executor.submit(authenticationCallable);
            list.add(submit);
        }
        for (Future future : list) {
            future.get();
        }
        executor.shutdown();
    }

    private GeoServerBasicAuthenticationFilter createAuthenticationFilter() {
        GeoServerBasicAuthenticationFilter authenticationFilter = new GeoServerBasicAuthenticationFilter();
        GeoServerSecurityManager sm = null;
        try {
            sm = new GeoServerSecurityManager(new GeoServerDataDirectory(new File("target")));
            authenticationFilter.setSecurityManager(sm);
            BasicAuthenticationFilterConfig config = new BasicAuthenticationFilterConfig();
            authenticationFilter.initializeFromConfig((SecurityNamedServiceConfig)config);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize authentication authenticationFilter.");
        }
        return authenticationFilter;
    }

    private MockHttpServletRequest createRequest() {
        GeoServerAbstractTestSupport.GeoServerMockHttpServletRequest request = new GeoServerAbstractTestSupport.GeoServerMockHttpServletRequest();
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setRemoteAddr("127.0.0.1");
        String token = "admin:geoserver";
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])token.getBytes()))));
        return request;
    }

    private class AuthenticationCallable
    implements Callable<Boolean> {
        private GeoServerBasicAuthenticationFilter authenticationFilter;

        private AuthenticationCallable(GeoServerBasicAuthenticationFilter authenticationFilter) {
            this.authenticationFilter = authenticationFilter;
        }

        @Override
        public Boolean call() throws Exception {
            MockHttpServletRequest request = GeoServerBasicAuthenticationFilterTest.this.createRequest();
            String result = this.authenticationFilter.getCacheKey((HttpServletRequest)request);
            Assert.assertEquals((Object)GeoServerBasicAuthenticationFilterTest.this.expected, (Object)result);
            return true;
        }
    }
}

