/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import java.util.Arrays;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DefaultSecureDataFactory;
import org.geoserver.security.decorators.SecuredObjectFactory;
import org.geoserver.security.decorators.SecuredSimpleFeatureCollection;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.util.ProgressListener;

public class SecuredSimpleFeatureCollectionTest {
    FeatureVisitor lastVisitor = null;
    private ListFeatureCollection collection;

    @Before
    public void setup() throws SchemaException {
        GeoServerExtensionsHelper.singleton((String)"secureDataFactory", (Object)new DefaultSecureDataFactory(), (Class[])new Class[]{SecuredObjectFactory.class});
        this.lastVisitor = null;
        SimpleFeatureType originalSchema = DataUtilities.createType((String)"BasicPolygons", (String)"the_geom:MultiPolygon:srid=4326,ID:String,value:int");
        this.collection = new ListFeatureCollection(originalSchema){

            public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
                SecuredSimpleFeatureCollectionTest.this.lastVisitor = visitor;
            }
        };
    }

    @Test
    public void testMaxVisitorDelegation() throws SchemaException, IOException {
        MaxVisitor visitor = new MaxVisitor((Expression)CommonFactoryFinder.getFilterFactory2().property("value"));
        WrapperPolicy policy = WrapperPolicy.hide((AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, null, null, null));
        this.assertOptimalVisit((FeatureVisitor)visitor, policy);
    }

    @Test
    public void testMaxOnHiddenField() throws SchemaException, IOException {
        MaxVisitor visitor = new MaxVisitor((Expression)CommonFactoryFinder.getFilterFactory2().property("value"));
        PropertyName geom = CommonFactoryFinder.getFilterFactory2().property("the_geom");
        WrapperPolicy policy = WrapperPolicy.hide((AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, Arrays.asList(geom), null, null, null));
        SecuredSimpleFeatureCollection secured = new SecuredSimpleFeatureCollection((FeatureCollection)this.collection, policy);
        secured.accepts((FeatureVisitor)visitor, null);
        Assert.assertNull((Object)this.lastVisitor);
    }

    @Test
    public void testCountVisitorDelegation() throws SchemaException, IOException {
        CountVisitor visitor = new CountVisitor();
        WrapperPolicy policy = WrapperPolicy.hide((AccessLimits)new VectorAccessLimits(CatalogMode.HIDE, null, null, null, null));
        this.assertOptimalVisit((FeatureVisitor)visitor, policy);
    }

    private void assertOptimalVisit(FeatureVisitor visitor, WrapperPolicy policy) throws IOException {
        SecuredSimpleFeatureCollection secured = new SecuredSimpleFeatureCollection((FeatureCollection)this.collection, policy);
        secured.accepts(visitor, null);
        Assert.assertSame((Object)this.lastVisitor, (Object)visitor);
    }
}

