/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.easymock.IAnswer;
import org.easymock.classextension.EasyMock;
import org.geoserver.catalog.Predicates;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.DefaultSecureDataFactory;
import org.geoserver.security.decorators.SecuredGridCoverage2DReader;
import org.geoserver.security.decorators.SecuredStructuredGridCoverage2DReader;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.coverage.grid.Format;
import org.opengis.filter.Filter;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;

public class SecuredGridCoverage2DReaderTest
extends SecureObjectsTest {
    @Test
    public void testFilter() throws Exception {
        Filter securityFilter = ECQL.toFilter((String)"A > 10");
        Filter requestFilter = ECQL.toFilter((String)"B < 10");
        Format format = this.setupFormat();
        GridCoverage2DReader reader = (GridCoverage2DReader)EasyMock.createNiceMock(GridCoverage2DReader.class);
        org.easymock.EasyMock.expect((Object)reader.getFormat()).andReturn((Object)format).anyTimes();
        SecuredGridCoverage2DReaderTest.setupReadAssertion(reader, requestFilter, securityFilter);
        CoverageAccessLimits accessLimits = new CoverageAccessLimits(CatalogMode.HIDE, securityFilter, null, null);
        SecuredGridCoverage2DReader secured = new SecuredGridCoverage2DReader(reader, WrapperPolicy.readOnlyHide((AccessLimits)accessLimits));
        ParameterValue pv = ImageMosaicFormat.FILTER.createValue();
        pv.setValue((Object)requestFilter);
        secured.read(new GeneralParameterValue[]{pv});
    }

    @Test
    public void testFilterOnStructured() throws Exception {
        Filter securityFilter = ECQL.toFilter((String)"A > 10");
        Filter requestFilter = ECQL.toFilter((String)"B < 10");
        DefaultSecureDataFactory factory = new DefaultSecureDataFactory();
        Format format = this.setupFormat();
        StructuredGridCoverage2DReader reader = (StructuredGridCoverage2DReader)EasyMock.createNiceMock(StructuredGridCoverage2DReader.class);
        org.easymock.EasyMock.expect((Object)reader.getFormat()).andReturn((Object)format).anyTimes();
        SecuredGridCoverage2DReaderTest.setupReadAssertion((GridCoverage2DReader)reader, requestFilter, securityFilter);
        CoverageAccessLimits accessLimits = new CoverageAccessLimits(CatalogMode.HIDE, securityFilter, null, null);
        Object securedObject = factory.secure((Object)reader, WrapperPolicy.readOnlyHide((AccessLimits)accessLimits));
        Assert.assertTrue((boolean)(securedObject instanceof SecuredStructuredGridCoverage2DReader));
        SecuredStructuredGridCoverage2DReader secured = (SecuredStructuredGridCoverage2DReader)securedObject;
        ParameterValue pv = ImageMosaicFormat.FILTER.createValue();
        pv.setValue((Object)requestFilter);
        secured.read(new GeneralParameterValue[]{pv});
    }

    private static void setupReadAssertion(GridCoverage2DReader reader, final Filter requestFilter, final Filter securityFilter) throws IOException {
        org.easymock.EasyMock.expect((Object)reader.read((GeneralParameterValue[])org.easymock.EasyMock.isA(GeneralParameterValue[].class))).andAnswer((IAnswer)new IAnswer<GridCoverage2D>(){

            public GridCoverage2D answer() throws Throwable {
                GeneralParameterValue[] params = (GeneralParameterValue[])EasyMock.getCurrentArguments()[0];
                ParameterValue param = (ParameterValue)params[0];
                Filter filter = (Filter)param.getValue();
                Assert.assertEquals((Object)Predicates.and((Filter)requestFilter, (Filter)securityFilter), (Object)filter);
                return null;
            }
        });
        EasyMock.replay((Object[])new Object[]{reader});
    }

    private Format setupFormat() {
        Format format = (Format)EasyMock.createNiceMock(Format.class);
        org.easymock.EasyMock.expect((Object)format.getReadParameters()).andReturn((Object)new ImageMosaicFormat().getReadParameters()).anyTimes();
        EasyMock.replay((Object[])new Object[]{format});
        return format;
    }
}

