/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.net.URL;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredGetMapRequest;
import org.geoserver.security.decorators.SecuredWMSLayer;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.data.ows.Layer;
import org.geotools.data.wms.WMS1_0_0;
import org.geotools.data.wms.request.GetMapRequest;
import org.junit.Assert;
import org.junit.Test;

public class SecuredGetMapRequestTest
extends SecureObjectsTest {
    @Test
    public void testNoSideEffectsOnGetFinalUrl() throws Exception {
        GetMapRequest request = new WMS1_0_0().createGetMapRequest(new URL("http://test?"));
        SecuredGetMapRequest securedRequest = new SecuredGetMapRequest(request);
        Layer wmsLayer = new Layer();
        wmsLayer.setName("layer1");
        SecuredWMSLayer layer = new SecuredWMSLayer(wmsLayer, WrapperPolicy.hide(null));
        securedRequest.addLayer((Layer)layer);
        String firstCallURL = securedRequest.getFinalURL().toExternalForm();
        String secondCallURL = securedRequest.getFinalURL().toExternalForm();
        Assert.assertEquals((Object)firstCallURL, (Object)secondCallURL);
    }
}

