/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.easymock.EasyMock;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ReadOnlyDataAccess;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.decorators.ReadOnlyDataStoreTest;
import org.geoserver.security.decorators.SecuredFeatureCollection;
import org.geoserver.security.decorators.SecuredFeatureSource;
import org.geoserver.security.decorators.SecuredFeatureStore;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class SecuredFeatureSourceTest
extends SecureObjectsTest {
    @Test
    public void testReadOnlyFeatureSourceDataStore() throws Exception {
        DataStore ds = (DataStore)EasyMock.createNiceMock(DataStore.class);
        EasyMock.replay((Object[])new Object[]{ds});
        FeatureSource fs = (FeatureSource)EasyMock.createNiceMock(FeatureSource.class);
        FeatureCollection fc = (FeatureCollection)EasyMock.createNiceMock(FeatureCollection.class);
        EasyMock.expect((Object)fs.getDataStore()).andReturn((Object)ds);
        EasyMock.expect((Object)fs.getFeatures()).andReturn((Object)fc).anyTimes();
        EasyMock.expect((Object)fs.getFeatures((Filter)EasyMock.anyObject())).andReturn((Object)fc).anyTimes();
        EasyMock.expect((Object)fs.getFeatures((Query)EasyMock.anyObject())).andReturn((Object)fc).anyTimes();
        EasyMock.replay((Object[])new Object[]{fs});
        SecuredFeatureSource ro = new SecuredFeatureSource(fs, WrapperPolicy.hide(null));
        Assert.assertTrue((boolean)(ro.getDataStore() instanceof ReadOnlyDataStore));
        SecuredFeatureCollection collection = (SecuredFeatureCollection)ro.getFeatures();
        Assert.assertTrue((boolean)ro.policy.isHide());
        Assert.assertTrue((boolean)(ro.getFeatures((Filter)Filter.INCLUDE) instanceof SecuredFeatureCollection));
        Assert.assertTrue((boolean)(ro.getFeatures(new Query()) instanceof SecuredFeatureCollection));
    }

    @Test
    public void testReadOnlyFeatureStore() throws Exception {
        block2: {
            SimpleFeatureType schema = (SimpleFeatureType)EasyMock.createNiceMock(SimpleFeatureType.class);
            EasyMock.expect((Object)schema.getName()).andReturn((Object)new NameImpl("testFT"));
            EasyMock.replay((Object[])new Object[]{schema});
            FeatureStore fs = (FeatureStore)EasyMock.createNiceMock(FeatureStore.class);
            EasyMock.expect((Object)fs.getSchema()).andReturn((Object)schema);
            EasyMock.replay((Object[])new Object[]{fs});
            SecuredFeatureStore ro = new SecuredFeatureStore(fs, WrapperPolicy.readOnlyChallenge(null));
            try {
                ro.addFeatures((FeatureCollection)EasyMock.createNiceMock(FeatureCollection.class));
                Assert.fail((String)"This should have thrown a security exception");
            }
            catch (Exception e) {
                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block2;
                Assert.fail((String)"Should have failed with a security exception");
            }
        }
    }

    @Test
    public void testReadOnlyFeatureSourceDataAccess() throws Exception {
        DataAccess da = (DataAccess)EasyMock.createNiceMock(DataAccess.class);
        EasyMock.replay((Object[])new Object[]{da});
        FeatureSource fs = (FeatureSource)EasyMock.createNiceMock(FeatureSource.class);
        EasyMock.expect((Object)fs.getDataStore()).andReturn((Object)da);
        EasyMock.replay((Object[])new Object[]{fs});
        SecuredFeatureSource ro = new SecuredFeatureSource(fs, WrapperPolicy.readOnlyChallenge(null));
        Assert.assertTrue((boolean)(ro.getDataStore() instanceof ReadOnlyDataAccess));
    }
}

