/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.easymock.EasyMock;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ReadOnlyDataStoreTest;
import org.geoserver.security.decorators.SecuredFeatureCollection;
import org.geoserver.security.decorators.SecuredFeatureStore;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.filter.text.ecql.ECQL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class SecuredFeatureCollectionTest
extends SecureObjectsTest {
    private FeatureStore store;
    private SimpleFeature feature;

    @Before
    public void setUp() throws Exception {
        SimpleFeatureType schema = (SimpleFeatureType)EasyMock.createNiceMock(SimpleFeatureType.class);
        EasyMock.expect((Object)schema.getTypeName()).andReturn((Object)"testSchema").anyTimes();
        EasyMock.expect((Object)schema.getName()).andReturn((Object)new NameImpl("testSchema")).anyTimes();
        EasyMock.replay((Object[])new Object[]{schema});
        this.feature = (SimpleFeature)EasyMock.createNiceMock(SimpleFeature.class);
        EasyMock.expect((Object)this.feature.getID()).andReturn((Object)"testSchema.1").anyTimes();
        EasyMock.expect((Object)this.feature.getType()).andReturn((Object)schema).anyTimes();
        EasyMock.expect((Object)this.feature.getFeatureType()).andReturn((Object)schema).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.feature});
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        fc.add(this.feature);
        this.store = (FeatureStore)EasyMock.createNiceMock(FeatureStore.class);
        EasyMock.expect((Object)this.store.getSchema()).andReturn((Object)schema).anyTimes();
        EasyMock.expect((Object)this.store.getFeatures()).andReturn((Object)fc).anyTimes();
        EasyMock.expect((Object)this.store.getFeatures((Filter)EasyMock.anyObject())).andReturn((Object)fc).anyTimes();
        EasyMock.expect((Object)this.store.getFeatures((Query)EasyMock.anyObject())).andReturn((Object)fc).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.store});
    }

    @Test
    public void testHide() throws Exception {
        SecuredFeatureStore ro = new SecuredFeatureStore(this.store, WrapperPolicy.hide(null));
        DefaultFeatureCollection fc = new DefaultFeatureCollection();
        fc.add(this.feature);
        try {
            ro.addFeatures((FeatureCollection)fc);
            Assert.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.removeFeatures((Filter)Filter.INCLUDE);
            Assert.fail((String)"Should have failed with an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testReadOnly() throws Exception {
        SecuredFeatureStore ro = new SecuredFeatureStore(this.store, WrapperPolicy.readOnlyHide(null));
        FeatureCollection rofc = ro.getFeatures();
        FeatureIterator roit = rofc.features();
        roit.hasNext();
        roit.next();
        SecuredFeatureCollection sorted = (SecuredFeatureCollection)rofc.sort(SortBy.NATURAL_ORDER);
        Assert.assertEquals((Object)ro.policy, (Object)sorted.policy);
        SecuredFeatureCollection sub = (SecuredFeatureCollection)rofc.subCollection((Filter)Filter.INCLUDE);
        Assert.assertEquals((Object)ro.policy, (Object)sorted.policy);
    }

    @Test
    public void testChallenge() throws Exception {
        SecuredFeatureStore ro;
        block11: {
            block10: {
                block9: {
                    block8: {
                        ro = new SecuredFeatureStore(this.store, WrapperPolicy.readOnlyChallenge(null));
                        DefaultFeatureCollection fc = new DefaultFeatureCollection();
                        fc.add(this.feature);
                        try {
                            ro.addFeatures((FeatureCollection)fc);
                            Assert.fail((String)"Should have failed with a spring security exception");
                        }
                        catch (Exception e) {
                            if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block8;
                            Assert.fail((String)"Should have failed with a security exception");
                        }
                    }
                    try {
                        ro.removeFeatures((Filter)Filter.INCLUDE);
                        Assert.fail((String)"Should have failed with a spring security exception");
                    }
                    catch (Exception e) {
                        if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block9;
                        Assert.fail((String)"Should have failed with a security exception");
                    }
                }
                try {
                    ro.removeFeatures(ECQL.toFilter((String)"IN ('testSchema.1')"));
                    Assert.fail((String)"Should have failed with a spring security exception");
                }
                catch (Exception e) {
                    if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block10;
                    Assert.fail((String)"Should have failed with a security exception");
                }
            }
            try {
                ro.removeFeatures((Filter)Filter.EXCLUDE);
                Assert.fail((String)"Should have failed with a spring security exception");
            }
            catch (Exception e) {
                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block11;
                Assert.fail((String)"Should have failed with a security exception");
            }
        }
        FeatureCollection rofc = ro.getFeatures();
        FeatureIterator roit = rofc.features();
        roit.hasNext();
        roit.next();
        SecuredFeatureCollection sorted = (SecuredFeatureCollection)rofc.sort(SortBy.NATURAL_ORDER);
        Assert.assertEquals((Object)ro.policy, (Object)sorted.policy);
        SecuredFeatureCollection sub = (SecuredFeatureCollection)rofc.subCollection((Filter)Filter.INCLUDE);
        Assert.assertEquals((Object)ro.policy, (Object)sorted.policy);
    }
}

