/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.decorators.ReadOnlyDataStoreTest;
import org.geoserver.security.decorators.SecuredCoverageInfo;
import org.geoserver.security.decorators.SecuredDataStoreInfo;
import org.geoserver.security.decorators.SecuredFeatureSource;
import org.geoserver.security.decorators.SecuredFeatureStore;
import org.geoserver.security.decorators.SecuredFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredLayerInfo;
import org.geoserver.security.impl.AbstractAuthorizationTest;
import org.junit.Assert;
import org.junit.Test;

public class ReadSecuredCatalogDecoratorsTest
extends AbstractAuthorizationTest {
    @Test
    public void testSecuredLayerInfoFeatures() {
        SecuredLayerInfo ro = new SecuredLayerInfo(this.statesLayer, WrapperPolicy.hide(null));
        Assert.assertFalse((boolean)(this.statesLayer.getResource() instanceof SecuredFeatureTypeInfo));
        Assert.assertTrue((boolean)(ro.getResource() instanceof SecuredFeatureTypeInfo));
        Assert.assertSame((Object)ro.policy, (Object)((SecuredFeatureTypeInfo)ro.getResource()).policy);
    }

    @Test
    public void testSecuredLayerInfoCoverages() {
        SecuredLayerInfo ro = new SecuredLayerInfo(this.arcGridLayer, WrapperPolicy.hide(null));
        Assert.assertFalse((boolean)(this.arcGridLayer.getResource() instanceof SecuredCoverageInfo));
        Assert.assertTrue((boolean)(ro.getResource() instanceof SecuredCoverageInfo));
        Assert.assertSame((Object)ro.policy, (Object)((SecuredCoverageInfo)ro.getResource()).policy);
    }

    @Test
    public void testSecuredFeatureTypeInfoHide() throws Exception {
        SecuredFeatureTypeInfo ro = new SecuredFeatureTypeInfo(this.states, WrapperPolicy.hide(null));
        SecuredFeatureSource fs = (SecuredFeatureSource)ro.getFeatureSource(null, null);
        Assert.assertEquals(SecuredFeatureSource.class, fs.getClass());
        Assert.assertTrue((boolean)fs.policy.isHide());
        SecuredDataStoreInfo store = (SecuredDataStoreInfo)ro.getStore();
        Assert.assertTrue((boolean)store.policy.isHide());
    }

    @Test
    public void testSecuredFeatureTypeInfoMetadata() throws Exception {
        SecuredFeatureTypeInfo ro;
        block2: {
            ro = new SecuredFeatureTypeInfo(this.states, WrapperPolicy.metadata(null));
            try {
                ro.getFeatureSource(null, null);
                Assert.fail((String)"This should have failed with a security exception");
            }
            catch (Exception e) {
                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block2;
                Assert.fail((String)"Should have failed with a security exception");
            }
        }
        SecuredDataStoreInfo store = (SecuredDataStoreInfo)ro.getStore();
        Assert.assertTrue((boolean)store.policy.isMetadata());
    }

    @Test
    public void testSecuredTypeInfoReadOnly() throws Exception {
        SecuredFeatureTypeInfo ro = new SecuredFeatureTypeInfo(this.states, WrapperPolicy.readOnlyChallenge(null));
        SecuredFeatureStore fs = (SecuredFeatureStore)ro.getFeatureSource(null, null);
        Assert.assertTrue((boolean)fs.policy.isReadOnlyChallenge());
        SecuredDataStoreInfo store = (SecuredDataStoreInfo)ro.getStore();
        Assert.assertTrue((boolean)store.policy.isReadOnlyChallenge());
    }

    @Test
    public void testSecuredDataStoreInfoHide() throws Exception {
        SecuredDataStoreInfo ro = new SecuredDataStoreInfo(this.statesStore, WrapperPolicy.hide(null));
        ReadOnlyDataStore dataStore = (ReadOnlyDataStore)ro.getDataStore(null);
        Assert.assertTrue((boolean)dataStore.policy.isHide());
    }

    @Test
    public void testSecuredDataStoreInfoMetadata() throws Exception {
        block2: {
            SecuredDataStoreInfo ro = new SecuredDataStoreInfo(this.statesStore, WrapperPolicy.metadata(null));
            try {
                ReadOnlyDataStore dataStore = (ReadOnlyDataStore)ro.getDataStore(null);
                Assert.fail((String)"This should have failed with a security exception");
            }
            catch (Exception e) {
                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block2;
                Assert.fail((String)"Should have failed with a security exception");
            }
        }
    }
}

