/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.easymock.EasyMock;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.SecurityUtils;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.DefaultFeatureCollection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class ReadOnlyDataStoreTest
extends SecureObjectsTest {
    private DataStore ds;

    @Before
    public void setUp() throws Exception {
        SimpleFeatureStore fs = (SimpleFeatureStore)EasyMock.createNiceMock(SimpleFeatureStore.class);
        EasyMock.expect((Object)fs.getSchema()).andReturn((Object)DataUtilities.createType((String)"test", (String)"g:Polygon,name:String")).anyTimes();
        EasyMock.expect((Object)fs.getFeatures(Query.ALL)).andReturn((Object)new DefaultFeatureCollection());
        EasyMock.replay((Object[])new Object[]{fs});
        this.ds = (DataStore)EasyMock.createNiceMock(DataStore.class);
        EasyMock.expect((Object)this.ds.getFeatureSource("blah")).andReturn((Object)fs);
        EasyMock.replay((Object[])new Object[]{this.ds});
    }

    @Test
    public void testDisallowedAPI() throws Exception {
        ReadOnlyDataStore ro = new ReadOnlyDataStore(this.ds, WrapperPolicy.hide(null));
        try {
            ro.createSchema(null);
            Assert.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.updateSchema((String)null, null);
            Assert.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.updateSchema((Name)null, null);
            Assert.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.getFeatureWriter("states", Transaction.AUTO_COMMIT);
            Assert.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.getFeatureWriter("states", (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
            Assert.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            ro.getFeatureWriterAppend("states", Transaction.AUTO_COMMIT);
            Assert.fail((String)"Should have failed with an unsupported operation exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testChallenge() throws Exception {
        block17: {
            ReadOnlyDataStore ro;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                ro = new ReadOnlyDataStore(this.ds, WrapperPolicy.readOnlyChallenge(null));
                                try {
                                    ro.createSchema(null);
                                    Assert.fail((String)"Should have failed with a security exception");
                                }
                                catch (Exception e) {
                                    if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block12;
                                    Assert.fail((String)"Should have failed with a security exception");
                                }
                            }
                            try {
                                ro.updateSchema((String)null, null);
                                Assert.fail((String)"Should have failed with a security exception");
                            }
                            catch (Exception e) {
                                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block13;
                                Assert.fail((String)"Should have failed with a security exception");
                            }
                        }
                        try {
                            ro.updateSchema((Name)null, null);
                            Assert.fail((String)"Should have failed with a security exception");
                        }
                        catch (Exception e) {
                            if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block14;
                            Assert.fail((String)"Should have failed with a security exception");
                        }
                    }
                    try {
                        ro.getFeatureWriter("states", Transaction.AUTO_COMMIT);
                        Assert.fail((String)"Should have failed with a security exception");
                    }
                    catch (Exception e) {
                        if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block15;
                        Assert.fail((String)"Should have failed with a security exception");
                    }
                }
                try {
                    ro.getFeatureWriter("states", (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
                    Assert.fail((String)"Should have failed with a security exception");
                }
                catch (Exception e) {
                    if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block16;
                    Assert.fail((String)"Should have failed with a security exception");
                }
            }
            try {
                ro.getFeatureWriterAppend("states", Transaction.AUTO_COMMIT);
                Assert.fail((String)"Should have failed with a security exception");
            }
            catch (Exception e) {
                if (ReadOnlyDataStoreTest.isSpringSecurityException(e)) break block17;
                Assert.fail((String)"Should have failed with a security exception");
            }
        }
    }

    @Test
    public void testReadOnlySource() throws Exception {
        ReadOnlyDataStore ro = new ReadOnlyDataStore(this.ds, WrapperPolicy.readOnlyHide((AccessLimits)new WorkspaceAccessLimits(CatalogMode.HIDE, true, false, false)));
        SimpleFeatureSource fs = ro.getFeatureSource("blah");
        SimpleFeatureCollection fc = fs.getFeatures(Query.ALL);
        Assert.assertEquals((long)0L, (long)fc.size());
    }

    public static boolean isSpringSecurityException(Exception ex) {
        return SecurityUtils.isSecurityException((Throwable)ex);
    }
}

