/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import org.geoserver.security.auth.AuthenticationCache;
import org.geoserver.security.auth.AuthenticationCacheEntry;
import org.geoserver.security.auth.AuthenticationCacheKey;
import org.geoserver.security.auth.BaseAuthenticationCacheTest;
import org.geoserver.security.auth.LRUAuthenticationCacheImpl;
import org.geoserver.security.auth.LRUCache;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public class LRUAuthenticationCacheTest
extends BaseAuthenticationCacheTest {
    @Test
    public void testLRUCache() {
        LRUCache cache = new LRUCache(3);
        cache.put((Object)"key1", (Object)"value1");
        cache.put((Object)"key2", (Object)"value2");
        cache.put((Object)"key3", (Object)"value3");
        cache.put((Object)"key4", (Object)"value4");
        LRUAuthenticationCacheTest.assertEquals((String)"value2", (String)((String)cache.get((Object)"key2")));
        LRUAuthenticationCacheTest.assertEquals((String)"value3", (String)((String)cache.get((Object)"key3")));
        LRUAuthenticationCacheTest.assertEquals((String)"value4", (String)((String)cache.get((Object)"key4")));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get((Object)"key1"));
    }

    @Test
    public void testAuthenticationKey() {
        AuthenticationCacheKey key11 = new AuthenticationCacheKey("f1", "k1");
        LRUAuthenticationCacheTest.assertTrue((boolean)key11.equals((Object)key11));
        LRUAuthenticationCacheTest.assertTrue((key11.hashCode() != 0 ? 1 : 0) != 0);
        AuthenticationCacheKey key12 = new AuthenticationCacheKey("f1", "k2");
        LRUAuthenticationCacheTest.assertFalse((boolean)key11.equals((Object)key12));
        LRUAuthenticationCacheTest.assertFalse((key11.hashCode() == key12.hashCode() ? 1 : 0) != 0);
        AuthenticationCacheKey key21 = new AuthenticationCacheKey("f2", "k1");
        LRUAuthenticationCacheTest.assertFalse((boolean)key11.equals((Object)key21));
        LRUAuthenticationCacheTest.assertFalse((key11.hashCode() == key21.hashCode() ? 1 : 0) != 0);
        AuthenticationCacheKey key22 = new AuthenticationCacheKey("f12", "k2");
        LRUAuthenticationCacheTest.assertFalse((boolean)key11.equals((Object)key22));
        LRUAuthenticationCacheTest.assertFalse((key11.hashCode() == key22.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testAuthenticationEntry() {
        UsernamePasswordAuthenticationToken t1 = new UsernamePasswordAuthenticationToken((Object)"user1", (Object)"password1");
        AuthenticationCacheEntry entry1 = new AuthenticationCacheEntry((Authentication)t1, 10, 10);
        LRUAuthenticationCacheTest.assertTrue((entry1.hashCode() != 0 ? 1 : 0) != 0);
        LRUAuthenticationCacheTest.assertEquals((int)t1.hashCode(), (int)entry1.hashCode());
        LRUAuthenticationCacheTest.assertTrue((boolean)entry1.equals((Object)entry1));
        AuthenticationCacheEntry entry1_1 = new AuthenticationCacheEntry((Authentication)t1, 20, 20);
        LRUAuthenticationCacheTest.assertEquals((int)t1.hashCode(), (int)entry1_1.hashCode());
        LRUAuthenticationCacheTest.assertTrue((boolean)entry1.equals((Object)entry1_1));
        UsernamePasswordAuthenticationToken t2 = new UsernamePasswordAuthenticationToken((Object)"user2", (Object)"password2");
        AuthenticationCacheEntry entry2 = new AuthenticationCacheEntry((Authentication)t2, 5, 10);
        LRUAuthenticationCacheTest.assertFalse((boolean)entry2.equals((Object)entry1));
        long currentTime = entry2.getCreated();
        entry2.setLastAccessed(currentTime + 6000L);
        LRUAuthenticationCacheTest.assertFalse((boolean)entry2.hasExpired(currentTime + 10000L));
        LRUAuthenticationCacheTest.assertTrue((boolean)entry2.hasExpired(currentTime + 10000L + 1L));
        entry2.setLastAccessed(currentTime + 2000L);
        LRUAuthenticationCacheTest.assertFalse((boolean)entry2.hasExpired(currentTime + 7000L));
        LRUAuthenticationCacheTest.assertTrue((boolean)entry2.hasExpired(currentTime + 70001L));
    }

    protected void fillCache(AuthenticationCache cache) {
        UsernamePasswordAuthenticationToken t1 = new UsernamePasswordAuthenticationToken((Object)"user1", (Object)"password1");
        UsernamePasswordAuthenticationToken t2 = new UsernamePasswordAuthenticationToken((Object)"user2", (Object)"password2");
        UsernamePasswordAuthenticationToken t3 = new UsernamePasswordAuthenticationToken((Object)"user3", (Object)"password3");
        UsernamePasswordAuthenticationToken t4 = new UsernamePasswordAuthenticationToken((Object)"user4", (Object)"password4");
        cache.put("filtera", "key1", (Authentication)t1);
        cache.put("filtera", "key2", (Authentication)t2);
        cache.put("filterb", "key3", (Authentication)t3);
        cache.put("filterb", "key4", (Authentication)t4);
    }

    protected void waitForMilliSecs(long milliSecs) {
        try {
            Thread.sleep(milliSecs);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testLRUAuthenticationCache() {
        LRUAuthenticationCacheImpl cache = new LRUAuthenticationCacheImpl(5, 10, 3);
        this.fillCache((AuthenticationCache)cache);
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filtera", "key1"));
        UsernamePasswordAuthenticationToken token = (UsernamePasswordAuthenticationToken)cache.get("filtera", "key2");
        LRUAuthenticationCacheTest.assertNotNull((Object)token);
        LRUAuthenticationCacheTest.assertEquals((Object)"user2", (Object)token.getPrincipal());
        token = (UsernamePasswordAuthenticationToken)cache.get("filterb", "key3");
        LRUAuthenticationCacheTest.assertNotNull((Object)token);
        LRUAuthenticationCacheTest.assertEquals((Object)"user3", (Object)token.getPrincipal());
        token = (UsernamePasswordAuthenticationToken)cache.get("filterb", "key4");
        LRUAuthenticationCacheTest.assertNotNull((Object)token);
        LRUAuthenticationCacheTest.assertEquals((Object)"user4", (Object)token.getPrincipal());
        cache = new LRUAuthenticationCacheImpl(5, 10, 4);
        this.fillCache((AuthenticationCache)cache);
        cache.removeAll();
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filtera", "key1"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filtera", "key2"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filterb", "key3"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filterb", "key4"));
        cache = new LRUAuthenticationCacheImpl(5, 10, 4);
        this.fillCache((AuthenticationCache)cache);
        cache.removeAll("filtera");
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filtera", "key1"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filtera", "key2"));
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filterb", "key3"));
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filterb", "key4"));
        cache = new LRUAuthenticationCacheImpl(5, 10, 4);
        this.fillCache((AuthenticationCache)cache);
        cache.remove("filtera", "key1");
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filtera", "key1"));
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filtera", "key2"));
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filterb", "key3"));
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filterb", "key4"));
        cache = new LRUAuthenticationCacheImpl(5, 10, 4);
        this.fillCache((AuthenticationCache)cache);
        cache.removeAll("filterz");
        cache.remove("filterz", "key999");
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filtera", "key1"));
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filtera", "key2"));
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filterb", "key3"));
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filterb", "key4"));
        cache = new LRUAuthenticationCacheImpl(5, 0, 4);
        this.fillCache((AuthenticationCache)cache);
        this.waitForMilliSecs(10L);
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filtera", "key1"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filtera", "key2"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filterb", "key3"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filterb", "key4"));
        cache = new LRUAuthenticationCacheImpl(0, 10, 4);
        this.fillCache((AuthenticationCache)cache);
        this.waitForMilliSecs(10L);
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filtera", "key1"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filtera", "key2"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filterb", "key3"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filterb", "key4"));
        cache = new LRUAuthenticationCacheImpl(1, 10, 4);
        this.fillCache((AuthenticationCache)cache);
        this.waitForMilliSecs(1L);
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filtera", "key1"));
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filtera", "key2"));
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filterb", "key3"));
        LRUAuthenticationCacheTest.assertNotNull((Object)cache.get("filterb", "key4"));
        this.waitForMilliSecs(1500L);
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filtera", "key1"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filtera", "key2"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filterb", "key3"));
        LRUAuthenticationCacheTest.assertNull((Object)cache.get("filterb", "key4"));
    }

    @Override
    protected AuthenticationCache createAuthenticationCache() {
        return new LRUAuthenticationCacheImpl(1, 2, 1000);
    }
}

