/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import junit.framework.TestCase;
import org.geoserver.security.auth.AuthenticationCache;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public abstract class BaseAuthenticationCacheTest
extends TestCase {
    protected static final int TIME_LIVE = 2;
    protected static final int TIME_IDLE = 1;
    protected static final int MAX_ENTRIES = 1000;
    protected static final String SAMPLE_CACHE_KEY = "SAMPLE_CACHE_KEY";
    protected static final String SAMPLE_FILTER = "SAMPLE_FILTER";
    protected static final String OTHER_CACHE_KEY = "WRONG_CACHE_KEY";
    AuthenticationCache cache;

    public void setUp() {
        this.cache = this.createAuthenticationCache();
    }

    protected abstract AuthenticationCache createAuthenticationCache();

    public void testWriteAndRead() {
        Authentication auth = this.putAuthenticationInCache();
        Authentication authenticationFromCache = this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY);
        BaseAuthenticationCacheTest.assertNotNull((Object)authenticationFromCache);
        BaseAuthenticationCacheTest.assertEquals((Object)auth, (Object)authenticationFromCache);
    }

    public void testExpireByAccess() throws InterruptedException {
        this.putAuthenticationInCache();
        Thread.sleep(500L);
        BaseAuthenticationCacheTest.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        Thread.sleep(2000L);
        BaseAuthenticationCacheTest.assertNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
    }

    public void testExpireByCreation() throws InterruptedException {
        this.putAuthenticationInCache();
        Thread.sleep(500L);
        BaseAuthenticationCacheTest.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        Thread.sleep(500L);
        BaseAuthenticationCacheTest.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        Thread.sleep(500L);
        BaseAuthenticationCacheTest.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        Thread.sleep(2000L);
        BaseAuthenticationCacheTest.assertNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
    }

    public void testRemoveAuthentication() {
        this.putAuthenticationInCache();
        this.cache.remove(SAMPLE_FILTER, SAMPLE_CACHE_KEY);
        BaseAuthenticationCacheTest.assertNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
    }

    public void testRemoveUnexistingAuthentication() {
        this.cache.remove(SAMPLE_FILTER, OTHER_CACHE_KEY);
        BaseAuthenticationCacheTest.assertNull((Object)this.cache.get(SAMPLE_FILTER, OTHER_CACHE_KEY));
    }

    public void testRemoveAll() {
        this.putAuthenticationInCache();
        this.putOtherAuthenticationInCache();
        BaseAuthenticationCacheTest.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        BaseAuthenticationCacheTest.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, OTHER_CACHE_KEY));
        this.cache.removeAll();
        BaseAuthenticationCacheTest.assertNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        BaseAuthenticationCacheTest.assertNull((Object)this.cache.get(SAMPLE_FILTER, OTHER_CACHE_KEY));
    }

    public void testRemoveAllByFilter() {
        this.putAuthenticationInCache();
        this.putOtherAuthenticationInCache();
        BaseAuthenticationCacheTest.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        BaseAuthenticationCacheTest.assertNotNull((Object)this.cache.get(SAMPLE_FILTER, OTHER_CACHE_KEY));
        this.cache.removeAll(SAMPLE_FILTER);
        BaseAuthenticationCacheTest.assertNull((Object)this.cache.get(SAMPLE_FILTER, SAMPLE_CACHE_KEY));
        BaseAuthenticationCacheTest.assertNull((Object)this.cache.get(SAMPLE_FILTER, OTHER_CACHE_KEY));
    }

    protected Authentication putAuthenticationInCache() {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password");
        this.cache.put(SAMPLE_FILTER, SAMPLE_CACHE_KEY, (Authentication)auth);
        return auth;
    }

    private Authentication putOtherAuthenticationInCache() {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"user", (Object)"password");
        this.cache.put(SAMPLE_FILTER, OTHER_CACHE_KEY, (Authentication)auth);
        return auth;
    }
}

