/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import java.net.URLEncoder;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.security.ConstantFilterChain;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.auth.AbstractAuthenticationProviderTest;
import org.geoserver.security.config.BasicAuthenticationFilterConfig;
import org.geoserver.security.config.CredentialsFromRequestHeaderFilterConfig;
import org.geoserver.security.config.DigestAuthenticationFilterConfig;
import org.geoserver.security.config.J2eeAuthenticationBaseFilterConfig;
import org.geoserver.security.config.J2eeAuthenticationFilterConfig;
import org.geoserver.security.config.LogoutFilterConfig;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RequestHeaderAuthenticationFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.config.SecurityFilterConfig;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.UsernamePasswordAuthenticationFilterConfig;
import org.geoserver.security.config.X509CertificateAuthenticationFilterConfig;
import org.geoserver.security.filter.GeoServerBasicAuthenticationFilter;
import org.geoserver.security.filter.GeoServerCredentialsFromRequestHeaderFilter;
import org.geoserver.security.filter.GeoServerDigestAuthenticationFilter;
import org.geoserver.security.filter.GeoServerJ2eeAuthenticationFilter;
import org.geoserver.security.filter.GeoServerLogoutFilter;
import org.geoserver.security.filter.GeoServerRequestHeaderAuthenticationFilter;
import org.geoserver.security.filter.GeoServerRoleFilter;
import org.geoserver.security.filter.GeoServerUserNamePasswordAuthenticationFilter;
import org.geoserver.security.filter.GeoServerX509CertificateAuthenticationFilter;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.password.MasterPasswordProviderConfig;
import org.geoserver.test.RunTestSetup;
import org.geoserver.test.SystemTest;
import org.geotools.data.Base64;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

@Category(value={SystemTest.class})
public class AuthenticationFilterTest
extends AbstractAuthenticationProviderTest {
    public static final String testFilterName = "basicAuthTestFilter";
    public static final String testFilterName2 = "digestAuthTestFilter";
    public static final String testFilterName3 = "j2eeAuthTestFilter";
    public static final String testFilterName4 = "requestHeaderTestFilter";
    public static final String testFilterName5 = "basicAuthTestFilterWithRememberMe";
    public static final String testFilterName6 = "formLoginTestFilter";
    public static final String testFilterName7 = "formLoginTestFilterWithRememberMe";
    public static final String testFilterName8 = "x509TestFilter";
    public static final String testFilterName9 = "logoutTestFilter";
    public static final String testFilterName10 = "credentialsFromHeaderTestFilter";

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        LogoutFilterConfig loConfig = new LogoutFilterConfig();
        loConfig.setClassName(GeoServerLogoutFilter.class.getName());
        loConfig.setName(testFilterName9);
        loConfig.setRedirectURL("/web/");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)loConfig);
        BasicAuthenticationFilterConfig bconfig = new BasicAuthenticationFilterConfig();
        bconfig.setClassName(GeoServerBasicAuthenticationFilter.class.getName());
        bconfig.setUseRememberMe(false);
        bconfig.setName(testFilterName);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)bconfig);
    }

    @Before
    public void revertFilters() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        if (secMgr.listFilters().contains(testFilterName2)) {
            SecurityFilterConfig config = secMgr.loadFilterConfig(testFilterName2);
            secMgr.removeFilter((SecurityNamedServiceConfig)config);
        }
    }

    @Test
    public void testBasicAuth() throws Exception {
        this.prepareFilterChain(this.pattern, new String[]{testFilterName});
        this.modifyChain(this.pattern, false, true, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        String tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.indexOf("GeoServer Realm") != -1);
        assert (tmp.indexOf("Basic") != -1);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        SecurityContext ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.modifyChain(this.pattern, false, true, "roleFilter");
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBytes((byte[])"user1:pw1".getBytes()))));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        Authentication auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        String roleString = response.getHeader(GeoServerRoleFilter.DEFAULT_HEADER_ATTRIBUTE);
        Assert.assertNotNull((Object)roleString);
        String[] roles = roleString.split(";");
        Assert.assertEquals((long)3L, (long)roles.length);
        List<String> roleList = Arrays.asList(roles);
        Assert.assertTrue((boolean)roleList.contains(GeoServerRole.AUTHENTICATED_ROLE.getAuthority()));
        Assert.assertTrue((boolean)roleList.contains("RootRole"));
        Assert.assertTrue((boolean)roleList.contains("DerivedRole"));
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBytes((byte[])"user1:wrongpass".getBytes()))));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.indexOf("GeoServer Realm") != -1);
        assert (tmp.indexOf("Basic") != -1);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBytes((byte[])"unknwon:pw1".getBytes()))));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.indexOf("GeoServer Realm") != -1);
        assert (tmp.indexOf("Basic") != -1);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        MasterPasswordProviderConfig masterPasswordConfig = this.getSecurityManager().loadMasterPassswordProviderConfig(this.getSecurityManager().getMasterPasswordConfig().getProviderName());
        masterPasswordConfig.setLoginEnabled(true);
        this.getSecurityManager().saveMasterPasswordProviderConfig(masterPasswordConfig);
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBytes((byte[])("root:" + this.getMasterPassword()).getBytes()))));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"root", (Object)auth.getPrincipal());
        Assert.assertTrue((auth.getAuthorities().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)auth.getAuthorities().contains(GeoServerRole.ADMIN_ROLE));
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBytes((byte[])"root:geoserver1".getBytes()))));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.indexOf("GeoServer Realm") != -1);
        assert (tmp.indexOf("Basic") != -1);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.getSecurityManager().getAuthenticationCache().removeAll();
        this.updateUser("ug1", "user1", false);
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBytes((byte[])"user1:pw1".getBytes()))));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.indexOf("GeoServer Realm") != -1);
        assert (tmp.indexOf("Basic") != -1);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", true);
        this.insertAnonymousFilter();
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    public void testCredentialsFromHeader() throws Exception {
        CredentialsFromRequestHeaderFilterConfig config = new CredentialsFromRequestHeaderFilterConfig();
        config.setClassName(GeoServerCredentialsFromRequestHeaderFilter.class.getName());
        config.setUserNameHeaderName("X-Credentials");
        config.setPasswordHeaderName("X-Credentials");
        config.setUserNameRegex("private-user=([^&]*)");
        config.setPasswordRegex("private-pw=([^&]*)");
        config.setParseAsUriComponents(true);
        config.setName(testFilterName10);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName10});
        this.modifyChain(this.pattern, false, true, null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        SecurityContext ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("X-Credentials", (Object)"private-user=user1&private-pw=pw1");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        Authentication auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("X-Credentials", (Object)"private-user=user1&private-pw=wrongpass");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("X-Credentials", (Object)"private-user=wronguser&private-pw=pw1");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        String masterPassword = URLEncoder.encode(this.getMasterPassword(), "UTF-8");
        request.addHeader("X-Credentials", (Object)("private-user=root&private-pw=" + masterPassword));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"root", (Object)auth.getPrincipal());
        Assert.assertTrue((auth.getAuthorities().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)auth.getAuthorities().contains(GeoServerRole.ADMIN_ROLE));
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("X-Credentials", (Object)"private-user=root&private-pw=geoserver1");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.getSecurityManager().getAuthenticationCache().removeAll();
        this.updateUser("ug1", "user1", false);
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("X-Credentials", (Object)"private-user=user1&private-pw=pw1");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", true);
        this.insertAnonymousFilter();
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    public void testJ2eeProxy() throws Exception {
        Authentication auth;
        J2eeAuthenticationFilterConfig config = new J2eeAuthenticationFilterConfig();
        config.setClassName(GeoServerJ2eeAuthenticationFilter.class.getName());
        config.setName(testFilterName3);
        config.setRoleSource((RoleSource)J2eeAuthenticationBaseFilterConfig.J2EERoleSource.J2EE);
        config.setRoleServiceName("rs1");
        config.setUserGroupServiceName("ug1");
        config.setRolesHeaderAttribute("roles");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName3});
        this.modifyChain(this.pattern, false, true, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        SecurityContext ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        for (J2eeAuthenticationBaseFilterConfig.J2EERoleSource rs : J2eeAuthenticationBaseFilterConfig.J2EERoleSource.values()) {
            config.setRoleSource((RoleSource)rs);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            request = this.createRequest("/foo/bar");
            response = new MockHttpServletResponse();
            chain = new MockFilterChain();
            request.setUserPrincipal(new Principal(){

                @Override
                public String getName() {
                    return "user1";
                }
            });
            if (rs == J2eeAuthenticationBaseFilterConfig.J2EERoleSource.Header) {
                request.addHeader("roles", (Object)"DerivedRole;RootRole");
            }
            if (rs == J2eeAuthenticationBaseFilterConfig.J2EERoleSource.J2EE) {
                request.addUserRole("DerivedRole");
            }
            this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
            Assert.assertNotNull((Object)ctx);
            auth = ctx.getAuthentication();
            Assert.assertNotNull((Object)auth);
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            this.checkForAuthenticatedRole(auth);
            Assert.assertEquals((Object)"user1", (Object)auth.getPrincipal());
            Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
            Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        }
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setUserPrincipal(new Principal(){

            @Override
            public String getName() {
                return "root";
            }
        });
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"root", (Object)auth.getPrincipal());
        Assert.assertTrue((auth.getAuthorities().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)auth.getAuthorities().contains(GeoServerRole.ADMIN_ROLE));
        config.setRoleServiceName(null);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setUserPrincipal(new Principal(){

            @Override
            public String getName() {
                return "user1";
            }
        });
        request.addUserRole("DerivedRole");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)auth.getPrincipal());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        this.insertAnonymousFilter();
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    public void testRequestHeaderProxy() throws Exception {
        Authentication auth;
        RequestHeaderAuthenticationFilterConfig config = new RequestHeaderAuthenticationFilterConfig();
        config.setClassName(GeoServerRequestHeaderAuthenticationFilter.class.getName());
        config.setName(testFilterName4);
        config.setRoleServiceName("rs1");
        config.setPrincipalHeaderAttribute("principal");
        config.setRoleSource((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.RoleService);
        config.setUserGroupServiceName("ug1");
        config.setPrincipalHeaderAttribute("principal");
        config.setRolesHeaderAttribute("roles");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName4});
        this.modifyChain(this.pattern, false, true, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        SecurityContext ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        for (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource rs : PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.values()) {
            config.setRoleSource((RoleSource)rs);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            request = this.createRequest("/foo/bar");
            response = new MockHttpServletResponse();
            chain = new MockFilterChain();
            request.addHeader("principal", (Object)"user1");
            if (rs.equals((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header)) {
                request.addHeader("roles", (Object)"DerivedRole;RootRole");
            }
            this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
            Assert.assertNotNull((Object)ctx);
            auth = ctx.getAuthentication();
            Assert.assertNotNull((Object)auth);
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            this.checkForAuthenticatedRole(auth);
            Assert.assertEquals((Object)"user1", (Object)auth.getPrincipal());
            Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
            Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        }
        for (PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource rs : PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.values()) {
            config.setRoleSource((RoleSource)rs);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            config.setRoleSource((RoleSource)rs);
            request = this.createRequest("/foo/bar");
            response = new MockHttpServletResponse();
            chain = new MockFilterChain();
            request.addHeader("principal", (Object)"unknwon");
            this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
            Assert.assertNotNull((Object)ctx);
            auth = ctx.getAuthentication();
            Assert.assertNotNull((Object)auth);
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            this.checkForAuthenticatedRole(auth);
            Assert.assertEquals((Object)"unknwon", (Object)auth.getPrincipal());
        }
        this.updateUser("ug1", "user1", false);
        config.setRoleSource((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.UserGroupService);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        request = this.createRequest("/foo/bar");
        request.addHeader("principal", (Object)"user1");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", true);
        this.insertAnonymousFilter();
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    public void testDigestAuth() throws Exception {
        DigestAuthenticationFilterConfig config = new DigestAuthenticationFilterConfig();
        config.setClassName(GeoServerDigestAuthenticationFilter.class.getName());
        config.setName(testFilterName2);
        config.setUserGroupServiceName("ug1");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName2});
        this.modifyChain(this.pattern, false, true, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        String tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.indexOf("GeoServer Realm") != -1);
        assert (tmp.indexOf("Digest") != -1);
        SecurityContext ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        String headerValue = this.clientDigestString(tmp, "user1", "pw1", request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        Authentication auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        headerValue = this.clientDigestString(tmp, "user1", "wrongpass", request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.indexOf("GeoServer Realm") != -1);
        assert (tmp.indexOf("Digest") != -1);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        headerValue = this.clientDigestString(tmp, "unknown", "pw1", request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.indexOf("GeoServer Realm") != -1);
        assert (tmp.indexOf("Digest") != -1);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        MasterPasswordProviderConfig masterPasswordConfig = this.getSecurityManager().loadMasterPassswordProviderConfig(this.getSecurityManager().getMasterPasswordConfig().getProviderName());
        masterPasswordConfig.setLoginEnabled(true);
        this.getSecurityManager().saveMasterPasswordProviderConfig(masterPasswordConfig);
        headerValue = this.clientDigestString(tmp, "root", this.getMasterPassword(), request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"root", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((auth.getAuthorities().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)auth.getAuthorities().contains(GeoServerRole.ADMIN_ROLE));
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        headerValue = this.clientDigestString(tmp, "root", "geoserver1", request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.indexOf("GeoServer Realm") != -1);
        assert (tmp.indexOf("Digest") != -1);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", false);
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        headerValue = this.clientDigestString(tmp, "unknown", "pw1", request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.indexOf("GeoServer Realm") != -1);
        assert (tmp.indexOf("Digest") != -1);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", true);
        this.insertAnonymousFilter();
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    public void testBasicAuthWithRememberMe() throws Exception {
        BasicAuthenticationFilterConfig config = new BasicAuthenticationFilterConfig();
        config.setClassName(GeoServerBasicAuthenticationFilter.class.getName());
        config.setUseRememberMe(true);
        config.setName(testFilterName5);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName5, "rememberme"});
        this.modifyChain(this.pattern, false, true, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        request.addParameter("_spring_security_remember_me", "yes");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)0L, (long)response.getCookies().length);
        String tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        request = this.createRequest("/foo/bar");
        request.addParameter("_spring_security_remember_me", "yes");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBytes((byte[])"abc@xyz.com:abc".getBytes()))));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        SecurityContext ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        Authentication auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((long)1L, (long)response.getCookies().length);
        Cookie cookie = response.getCookies()[0];
        request = this.createRequest("/foo/bar");
        request.addParameter("_spring_security_remember_me", "yes");
        request.setCookies(new Cookie[]{cookie});
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"abc@xyz.com", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        request = this.createRequest("/foo/bar");
        request.addParameter("_spring_security_remember_me", "yes");
        request.setCookies(new Cookie[]{cookie});
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBytes((byte[])"abc@xyz.com:abc".getBytes()))));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"abc@xyz.com", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        request = this.createRequest("/foo/bar");
        request.addParameter("_spring_security_remember_me", "yes");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        MasterPasswordProviderConfig masterPasswordConfig = this.getSecurityManager().loadMasterPassswordProviderConfig(this.getSecurityManager().getMasterPasswordConfig().getProviderName());
        masterPasswordConfig.setLoginEnabled(true);
        this.getSecurityManager().saveMasterPasswordProviderConfig(masterPasswordConfig);
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBytes((byte[])("root:" + this.getMasterPassword()).getBytes()))));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((long)0L, (long)response.getCookies().length);
        this.updateUser("ug1", "abc@xyz.com", false);
        request = this.createRequest("/foo/bar");
        request.addParameter("_spring_security_remember_me", "yes");
        request.setCookies(new Cookie[]{cookie});
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        Assert.assertEquals((long)1L, (long)response.getCookies().length);
        Cookie cancelCookie = response.getCookies()[0];
        Assert.assertNull((Object)cancelCookie.getValue());
        this.updateUser("ug1", "abc@xyz.com", true);
    }

    @Test
    public void testFormLogin() throws Exception {
        UsernamePasswordAuthenticationFilterConfig config = new UsernamePasswordAuthenticationFilterConfig();
        config.setClassName(GeoServerUserNamePasswordAuthenticationFilter.class.getName());
        config.setUsernameParameterName("username");
        config.setPasswordParameterName("password");
        config.setName(testFilterName6);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{"form"});
        this.modifyChain(this.pattern, false, true, null);
        this.prepareFilterChain(ConstantFilterChain.class, "/j_spring_security_check_foo/", new String[]{testFilterName6});
        this.modifyChain("/j_spring_security_check_foo/", false, true, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        String tmp = response.getHeader("Location");
        Assert.assertTrue((boolean)tmp.endsWith("/web/wicket/bookmarkable/org.geoserver.web.GeoServerLoginPage?error=false"));
        SecurityContext ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/j_spring_security_check_foo");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setMethod("POST");
        request.addParameter(config.getUsernameParameterName(), "user1");
        request.addParameter(config.getPasswordParameterName(), "pw1");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/web"));
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        Authentication auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        GeoServerLogoutFilter logoutFilter = (GeoServerLogoutFilter)this.getSecurityManager().loadFilter("formLogout");
        request = this.createRequest("/j_spring_security_logout_foo");
        HttpSession session = request.getSession(true);
        session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)ctx);
        SecurityContextHolder.getContext().setAuthentication(auth);
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        logoutFilter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        tmp = response.getHeader("Location");
        Assert.assertNotNull((Object)tmp);
        Assert.assertTrue((boolean)tmp.endsWith("/web/"));
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/j_spring_security_check_foo");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setMethod("POST");
        request.addParameter(config.getUsernameParameterName(), "user1");
        request.addParameter(config.getPasswordParameterName(), "wrongpass");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/web/wicket/bookmarkable/org.geoserver.web.GeoServerLoginPage?error=true"));
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/j_spring_security_check_foo");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setMethod("POST");
        request.addParameter(config.getUsernameParameterName(), "unknwon");
        request.addParameter(config.getPasswordParameterName(), "pw1");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/web/wicket/bookmarkable/org.geoserver.web.GeoServerLoginPage?error=true"));
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/j_spring_security_check_foo");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setMethod("POST");
        request.addParameter(config.getUsernameParameterName(), "root");
        request.addParameter(config.getPasswordParameterName(), this.getMasterPassword());
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/web"));
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)"root", (Object)auth.getPrincipal());
        Assert.assertTrue((auth.getAuthorities().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)auth.getAuthorities().contains(GeoServerRole.ADMIN_ROLE));
        request = this.createRequest("/j_spring_security_check_foo");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setMethod("POST");
        request.addParameter(config.getUsernameParameterName(), "root");
        request.addParameter(config.getPasswordParameterName(), "geoserver1");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/web/wicket/bookmarkable/org.geoserver.web.GeoServerLoginPage?error=true"));
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", false);
        request = this.createRequest("/j_spring_security_check_foo");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setMethod("POST");
        request.addParameter(config.getUsernameParameterName(), "user1");
        request.addParameter(config.getPasswordParameterName(), "pw1");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/web/wicket/bookmarkable/org.geoserver.web.GeoServerLoginPage?error=true"));
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", true);
        this.insertAnonymousFilter();
        request = this.createRequest("foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    public void testFormLoginWithRememberMe() throws Exception {
        UsernamePasswordAuthenticationFilterConfig config = new UsernamePasswordAuthenticationFilterConfig();
        config.setClassName(GeoServerUserNamePasswordAuthenticationFilter.class.getName());
        config.setUsernameParameterName("username");
        config.setPasswordParameterName("password");
        config.setName(testFilterName7);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{"rememberme", "form"});
        this.modifyChain(this.pattern, false, true, null);
        this.prepareFilterChain("/j_spring_security_check_foo/", new String[]{testFilterName7});
        this.modifyChain("/j_spring_security_check_foo/", false, true, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        request.addParameter("_spring_security_remember_me", "yes");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        String tmp = response.getHeader("Location");
        Assert.assertTrue((boolean)tmp.endsWith("/web/wicket/bookmarkable/org.geoserver.web.GeoServerLoginPage?error=false"));
        SecurityContext ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/j_spring_security_check_foo");
        request.addParameter("_spring_security_remember_me", "yes");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.setMethod("POST");
        request.addParameter(config.getUsernameParameterName(), "user1");
        request.addParameter(config.getPasswordParameterName(), "pw1");
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/web"));
        HttpSession session = request.getSession(true);
        ctx = (SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        Authentication auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        Assert.assertEquals((long)1L, (long)response.getCookies().length);
        Cookie cookie = response.getCookies()[0];
        Assert.assertNotNull((Object)cookie.getValue());
        GeoServerLogoutFilter logoutFilter = (GeoServerLogoutFilter)this.getSecurityManager().loadFilter("formLogout");
        request = this.createRequest("/j_spring_security_logout_foo");
        session = request.getSession(true);
        session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)ctx);
        SecurityContextHolder.getContext().setAuthentication(auth);
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        logoutFilter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        tmp = response.getHeader("Location");
        Assert.assertNotNull((Object)tmp);
        Assert.assertTrue((boolean)tmp.endsWith("/web/"));
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Cookie cancelCookie = response.getCookies()[0];
        Assert.assertNull((Object)cancelCookie.getValue());
        request = this.createRequest("/j_spring_security_check_foo");
        request.addParameter("_spring_security_remember_me", "yes");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        MasterPasswordProviderConfig masterPasswordConfig = this.getSecurityManager().loadMasterPassswordProviderConfig(this.getSecurityManager().getMasterPasswordConfig().getProviderName());
        masterPasswordConfig.setLoginEnabled(true);
        this.getSecurityManager().saveMasterPasswordProviderConfig(masterPasswordConfig);
        request.setMethod("POST");
        request.addParameter(config.getUsernameParameterName(), "root");
        request.addParameter(config.getPasswordParameterName(), this.getMasterPassword());
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)response.getHeader("Location").endsWith("/web"));
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertEquals((Object)"root", (Object)auth.getPrincipal());
        Assert.assertEquals((long)0L, (long)response.getCookies().length);
        this.updateUser("ug1", "user1", false);
        request = this.createRequest("/foo/bar");
        request.setCookies(new Cookie[]{cookie});
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        tmp = response.getHeader("Location");
        Assert.assertTrue((boolean)tmp.endsWith("/web/wicket/bookmarkable/org.geoserver.web.GeoServerLoginPage?error=false"));
        Assert.assertEquals((long)1L, (long)response.getCookies().length);
        cancelCookie = response.getCookies()[0];
        Assert.assertNull((Object)cancelCookie.getValue());
        this.updateUser("ug1", "user1", true);
    }

    @Test
    public void testX509Auth() throws Exception {
        Authentication auth;
        X509CertificateAuthenticationFilterConfig config = new X509CertificateAuthenticationFilterConfig();
        config.setClassName(GeoServerX509CertificateAuthenticationFilter.class.getName());
        config.setName(testFilterName8);
        config.setRoleServiceName("rs1");
        config.setRoleSource((RoleSource)J2eeAuthenticationBaseFilterConfig.J2EERoleSource.RoleService);
        config.setUserGroupServiceName("ug1");
        config.setRolesHeaderAttribute("roles");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName8});
        this.modifyChain(this.pattern, false, true, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        SecurityContext ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        for (J2eeAuthenticationBaseFilterConfig.J2EERoleSource rs : J2eeAuthenticationBaseFilterConfig.J2EERoleSource.values()) {
            config.setRoleSource((RoleSource)rs);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            request = this.createRequest("/foo/bar");
            response = new MockHttpServletResponse();
            chain = new MockFilterChain();
            if (rs == J2eeAuthenticationBaseFilterConfig.J2EERoleSource.Header) {
                request.addHeader("roles", (Object)"DerivedRole;RootRole");
            }
            if (rs == J2eeAuthenticationBaseFilterConfig.J2EERoleSource.J2EE) {
                request.addUserRole("DerivedRole");
            }
            this.setCertifacteForUser("user1", request);
            this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
            Assert.assertNotNull((Object)ctx);
            auth = ctx.getAuthentication();
            Assert.assertNotNull((Object)auth);
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            this.checkForAuthenticatedRole(auth);
            Assert.assertEquals((Object)"user1", (Object)auth.getPrincipal());
            Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
            Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        }
        for (J2eeAuthenticationBaseFilterConfig.J2EERoleSource rs : J2eeAuthenticationBaseFilterConfig.J2EERoleSource.values()) {
            config.setRoleSource((RoleSource)rs);
            this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
            config.setRoleSource((RoleSource)rs);
            request = this.createRequest("/foo/bar");
            response = new MockHttpServletResponse();
            chain = new MockFilterChain();
            if (rs == J2eeAuthenticationBaseFilterConfig.J2EERoleSource.J2EE) {
                // empty if block
            }
            this.setCertifacteForUser("unknown", request);
            this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
            Assert.assertNotNull((Object)ctx);
            auth = ctx.getAuthentication();
            Assert.assertNotNull((Object)auth);
            Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
            this.checkForAuthenticatedRole(auth);
            Assert.assertEquals((Object)"unknown", (Object)auth.getPrincipal());
        }
        this.updateUser("ug1", "user1", false);
        config.setRoleSource((RoleSource)J2eeAuthenticationBaseFilterConfig.J2EERoleSource.UserGroupService);
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.setCertifacteForUser("user1", request);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)403L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.updateUser("ug1", "user1", true);
        this.insertAnonymousFilter();
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.removeAnonymousFilter();
    }

    @Test
    @RunTestSetup
    public void testCascadingFilters() throws Exception {
        DigestAuthenticationFilterConfig config = new DigestAuthenticationFilterConfig();
        config.setClassName(GeoServerDigestAuthenticationFilter.class.getName());
        config.setName(testFilterName2);
        config.setUserGroupServiceName("ug1");
        this.getSecurityManager().saveFilter((SecurityNamedServiceConfig)config);
        this.prepareFilterChain(this.pattern, new String[]{testFilterName, testFilterName2});
        this.modifyChain(this.pattern, false, true, null);
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createRequest("/foo/bar");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        String tmp = response.getHeader("WWW-Authenticate");
        Assert.assertNotNull((Object)tmp);
        assert (tmp.indexOf("GeoServer Realm") != -1);
        assert (tmp.indexOf("Digest") != -1);
        SecurityContext ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNull((Object)ctx);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        String headerValue = this.clientDigestString(tmp, "user1", "pw1", request.getMethod());
        request.addHeader("Authorization", (Object)headerValue);
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        Authentication auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
        request = this.createRequest("/foo/bar");
        response = new MockHttpServletResponse();
        chain = new MockFilterChain();
        request.addHeader("Authorization", (Object)("Basic " + new String(Base64.encodeBytes((byte[])"user1:pw1".getBytes()))));
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ctx = (SecurityContext)request.getSession(true).getAttribute("SPRING_SECURITY_CONTEXT");
        Assert.assertNotNull((Object)ctx);
        auth = ctx.getAuthentication();
        Assert.assertNotNull((Object)auth);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
        this.checkForAuthenticatedRole(auth);
        Assert.assertEquals((Object)"user1", (Object)((UserDetails)auth.getPrincipal()).getUsername());
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("RootRole")));
        Assert.assertTrue((boolean)auth.getAuthorities().contains(new GeoServerRole("DerivedRole")));
    }

    public void testSSL() throws Exception {
        this.prepareFilterChain(this.pattern, new String[]{"anonymous"});
        this.modifyChain(this.pattern, false, true, null);
        SecurityManagerConfig secConfig = this.getSecurityManager().getSecurityConfig();
        RequestFilterChain chain = secConfig.getFilterChain().getRequestChainByName("testChain");
        chain.setRequireSSL(true);
        this.getSecurityManager().saveSecurityConfig(secConfig);
        MockHttpServletRequest request = this.createRequest("/foo/bar?request=getCapabilities&a=b");
        request.setProtocol("https");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain authchain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)authchain);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        request = this.createRequest("/foo/bar?request=getCapabilities&a=b");
        response = new MockHttpServletResponse();
        authchain = new MockFilterChain();
        this.getProxy().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)authchain);
        Assert.assertTrue((response.getStatus() == 302 ? 1 : 0) != 0);
        String urlString = response.getHeader("Location");
        Assert.assertNotNull((Object)urlString);
        Assert.assertTrue((boolean)urlString.startsWith("https"));
        Assert.assertTrue((urlString.indexOf("a=b") != -1 ? 1 : 0) != 0);
        Assert.assertTrue((urlString.indexOf("443") != -1 ? 1 : 0) != 0);
        chain.setRequireSSL(false);
        this.getSecurityManager().saveSecurityConfig(secConfig);
    }
}

