/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geotools.factory.CommonFactoryFinder;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.PropertyName;

public class TestAccessLimitsSerialization
extends TestCase {
    FilterFactory2 ff;
    Filter filter;
    MultiPolygon g;

    protected void setUp() throws Exception {
        this.ff = CommonFactoryFinder.getFilterFactory2(null);
        this.filter = this.ff.equal((Expression)this.ff.property("attribute"), (Expression)this.ff.literal(3), true);
        this.g = (MultiPolygon)new WKTReader().read("MULTIPOLYGON(((0 0, 0 10, 10 10, 10 0, 0 0)))");
    }

    public void testAccessLimits() throws Exception {
        AccessLimits limits = new AccessLimits(CatalogMode.MIXED);
        this.testObjectSerialization((Serializable)limits);
    }

    public void testSerializeWorkspaceAccessLimits() throws Exception {
        WorkspaceAccessLimits limits = new WorkspaceAccessLimits(CatalogMode.HIDE, true, true, true);
        this.testObjectSerialization((Serializable)limits);
    }

    public void testSerializeDataAccessLimits() throws Exception {
        DataAccessLimits limits = new DataAccessLimits(CatalogMode.CHALLENGE, this.filter);
        this.testObjectSerialization((Serializable)limits);
    }

    public void testCoverageAccessLimits() throws Exception {
        CoverageAccessLimits limits = new CoverageAccessLimits(CatalogMode.MIXED, this.filter, this.g, null);
        this.testObjectSerialization((Serializable)limits);
    }

    public void testVectorAccessLimits() throws Exception {
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>();
        properties.add(this.ff.property("test"));
        VectorAccessLimits limits = new VectorAccessLimits(CatalogMode.MIXED, properties, this.filter, properties, this.filter);
        this.testObjectSerialization((Serializable)limits);
    }

    public void testWMSAccessLimits() throws Exception {
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>();
        properties.add(this.ff.property("test"));
        WMSAccessLimits limits = new WMSAccessLimits(CatalogMode.MIXED, this.filter, this.g, true);
        this.testObjectSerialization((Serializable)limits);
    }

    private void testObjectSerialization(Serializable object) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream((OutputStream)bos);
        oos.writeObject(object);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
        Object clone = ois.readObject();
        TestAccessLimitsSerialization.assertNotSame((Object)object, (Object)clone);
        TestAccessLimitsSerialization.assertEquals((Object)object, (Object)clone);
    }
}

