/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import org.geoserver.security.KeyStoreProvider;
import org.geoserver.security.password.RandomPasswordProvider;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class KeyStoreProviderTest
extends GeoServerSystemTestSupport {
    @Test
    public void testKeyStoreProvider() throws Exception {
        KeyStoreProvider ksp = this.getSecurityManager().getKeyStoreProvider();
        ksp.removeKey("config:password:key");
        ksp.removeKey(ksp.aliasForGroupService("default"));
        ksp.storeKeyStore();
        ksp.reloadKeyStore();
        Assert.assertFalse((boolean)ksp.hasConfigPasswordKey());
        Assert.assertFalse((boolean)ksp.hasUserGroupKey("default"));
        ksp.setSecretKey("config:password:key", "configKey".toCharArray());
        ksp.storeKeyStore();
        Assert.assertTrue((boolean)ksp.hasConfigPasswordKey());
        Assert.assertEquals((Object)"configKey", (Object)new String(ksp.getConfigPasswordKey()));
        Assert.assertFalse((boolean)ksp.hasUserGroupKey("default"));
        RandomPasswordProvider rpp = this.getSecurityManager().getRandomPassworddProvider();
        char[] urlKey = rpp.getRandomPasswordWithDefaultLength();
        char[] urlKey2 = rpp.getRandomPasswordWithDefaultLength();
        Assert.assertFalse((boolean)urlKey.equals(urlKey2));
        ksp.setSecretKey("ug:default:key", "defaultKey".toCharArray());
        ksp.storeKeyStore();
        Assert.assertTrue((boolean)ksp.hasConfigPasswordKey());
        Assert.assertEquals((Object)"configKey", (Object)new String(ksp.getConfigPasswordKey()));
        Assert.assertTrue((boolean)ksp.hasUserGroupKey("default"));
        Assert.assertEquals((Object)"defaultKey", (Object)new String(ksp.getUserGroupKey("default")));
        Assert.assertTrue((boolean)ksp.isKeyStorePassword(this.getSecurityManager().getMasterPassword()));
        Assert.assertFalse((boolean)ksp.isKeyStorePassword("blabla".toCharArray()));
    }
}

