/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Properties;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.platform.resource.Files;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityTestSupport;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.config.SecurityManagerConfig;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.test.SystemTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

@Category(value={SystemTest.class})
public class GeoServerSecurityManagerTest
extends GeoServerSecurityTestSupport {
    @Test
    public void testAdminRole() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"admin", (Object)"geoserver", Arrays.asList(GeoServerRole.ADMIN_ROLE));
        auth.setAuthenticated(true);
        Assert.assertTrue((boolean)secMgr.checkAuthenticationForAdminRole((Authentication)auth));
    }

    @Test
    public void testMasterPasswordForMigration() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        char[] generatedPW = secMgr.extractMasterPasswordForMigration(null);
        Assert.assertTrue((generatedPW.length == 8 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.masterPWInfoFileContains(new String(generatedPW)));
        Properties props = new Properties();
        String adminUser = "user1";
        String noAdminUser = "user2";
        String defaultMasterePassword = new String(GeoServerSecurityManager.MASTER_PASSWD_DEFAULT);
        props.put("admin", defaultMasterePassword + "," + GeoServerRole.ADMIN_ROLE);
        props.put(adminUser, defaultMasterePassword + "," + GeoServerRole.ADMIN_ROLE);
        props.put(noAdminUser, defaultMasterePassword + ",ROLE_WFS");
        generatedPW = secMgr.extractMasterPasswordForMigration(props);
        Assert.assertTrue((generatedPW.length == 8 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.masterPWInfoFileContains(new String(generatedPW)));
        Assert.assertFalse((boolean)this.masterPWInfoFileContains("admin"));
        Assert.assertFalse((boolean)this.masterPWInfoFileContains(adminUser));
        Assert.assertFalse((boolean)this.masterPWInfoFileContains(noAdminUser));
        props.put(noAdminUser, "validPassword,ROLE_WFS");
        generatedPW = secMgr.extractMasterPasswordForMigration(props);
        Assert.assertTrue((generatedPW.length == 8 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.masterPWInfoFileContains(new String(generatedPW)));
        props.put(adminUser, "abc," + GeoServerRole.ADMIN_ROLE);
        generatedPW = secMgr.extractMasterPasswordForMigration(props);
        Assert.assertTrue((generatedPW.length == 8 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.masterPWInfoFileContains(new String(generatedPW)));
        String validPassword = "validPassword";
        props.put(adminUser, validPassword + "," + GeoServerRole.ADMIN_ROLE);
        generatedPW = secMgr.extractMasterPasswordForMigration(props);
        Assert.assertEquals((Object)validPassword, (Object)new String(generatedPW));
        Assert.assertFalse((boolean)this.masterPWInfoFileContains(validPassword));
        Assert.assertTrue((boolean)this.masterPWInfoFileContains(adminUser));
        props.put("admin", validPassword + "," + GeoServerRole.ADMIN_ROLE);
        generatedPW = secMgr.extractMasterPasswordForMigration(props);
        Assert.assertEquals((Object)validPassword, (Object)new String(generatedPW));
        Assert.assertFalse((boolean)this.masterPWInfoFileContains(validPassword));
        Assert.assertTrue((boolean)this.masterPWInfoFileContains("admin"));
        secMgr.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterPasswordDump() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        File f = File.createTempFile("masterpw", "info");
        f.delete();
        try {
            Assert.assertFalse((boolean)secMgr.dumpMasterPassword(Files.asResource((File)f)));
            TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"admin", (Object)"geoserver", Arrays.asList(GeoServerRole.ADMIN_ROLE));
            auth.setAuthenticated(true);
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            Assert.assertTrue((boolean)secMgr.dumpMasterPassword(Files.asResource((File)f)));
            this.dumpPWInfoFile(f);
            Assert.assertTrue((boolean)this.masterPWInfoFileContains(f, new String(secMgr.getMasterPassword())));
        }
        finally {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterPasswordDumpNotAuthorized() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        File f = File.createTempFile("masterpw", "info");
        try {
            Assert.assertFalse((boolean)secMgr.dumpMasterPassword(Files.asResource((File)f)));
            TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"admin", (Object)"geoserver", Arrays.asList(GeoServerRole.ADMIN_ROLE));
            auth.setAuthenticated(true);
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            Assert.assertFalse((boolean)secMgr.dumpMasterPassword(Files.asResource((File)f)));
        }
        finally {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMasterPasswordDumpNotOverwrite() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        File f = File.createTempFile("masterpw", "info");
        try (FileOutputStream os = new FileOutputStream(f);){
            os.write("This should not be overwritten!".getBytes(StandardCharsets.UTF_8));
        }
        try {
            Assert.assertFalse((boolean)secMgr.dumpMasterPassword(Files.asResource((File)f)));
            TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"admin", (Object)"geoserver", Arrays.asList(GeoServerRole.ADMIN_ROLE));
            auth.setAuthenticated(true);
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            Assert.assertFalse((boolean)secMgr.dumpMasterPassword(Files.asResource((File)f)));
            this.dumpPWInfoFile(f);
            Assert.assertTrue((boolean)this.masterPWInfoFileContains(f, "This should not be overwritten!"));
            Assert.assertFalse((boolean)this.masterPWInfoFileContains(f, new String(secMgr.getMasterPassword())));
        }
        finally {
            f.delete();
        }
    }

    void dumpPWInfoFile(File infoFile) throws Exception {
        String line;
        BufferedReader bf = new BufferedReader(new FileReader(infoFile));
        while ((line = bf.readLine()) != null) {
            System.out.println(line);
        }
        bf.close();
    }

    void dumpPWInfoFile() throws Exception {
        this.dumpPWInfoFile(new File(this.getSecurityManager().get("security").dir(), "masterpw.info"));
    }

    boolean masterPWInfoFileContains(File infoFile, String searchString) throws Exception {
        String line;
        BufferedReader bf = new BufferedReader(new FileReader(infoFile));
        while ((line = bf.readLine()) != null) {
            if (line.indexOf(searchString) == -1) continue;
            bf.close();
            return true;
        }
        bf.close();
        return false;
    }

    boolean masterPWInfoFileContains(String searchString) throws Exception {
        return this.masterPWInfoFileContains(new File(this.getSecurityManager().get("security").dir(), "masterpw.info"), searchString);
    }

    @Test
    public void testWebLoginChainSessionCreation() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        SecurityManagerConfig config = secMgr.loadSecurityConfig();
        RequestFilterChain chain = config.getFilterChain().getRequestChainByName("webLogin");
        Assert.assertTrue((boolean)chain.isAllowSessionCreation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGeoServerEnvParametrization() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        SecurityManagerConfig config = secMgr.loadSecurityConfig();
        String oldRoleServiceName = config.getRoleServiceName();
        try {
            if (GeoServerEnvironment.ALLOW_ENV_PARAMETRIZATION) {
                System.setProperty("TEST_SYS_PROPERTY", oldRoleServiceName);
                config.setRoleServiceName("${TEST_SYS_PROPERTY}");
                secMgr.saveSecurityConfig(config);
                SecurityManagerConfig config1 = secMgr.loadSecurityConfig();
                Assert.assertEquals((Object)config1.getRoleServiceName(), (Object)oldRoleServiceName);
            }
        }
        finally {
            config.setRoleServiceName(oldRoleServiceName);
            secMgr.saveSecurityConfig(config);
            System.clearProperty("TEST_SYS_PROPERTY");
        }
    }
}

