/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.easymock.EasyMock;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityFilterChainProxy;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityTestSupport;
import org.geoserver.security.config.RoleFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerRoleFilter;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.test.SystemTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@Category(value={SystemTest.class})
public class GeoServerRoleFilterTest
extends GeoServerSecurityTestSupport {
    @Test
    public void testFilterChainWithEnabled() throws Exception {
        GeoServerSecurityManager secMgr = this.getSecurityManager();
        RoleFilterConfig config = new RoleFilterConfig();
        config.setName("roleConverter");
        config.setClassName(GeoServerRoleFilter.class.getName());
        config.setRoleConverterName("roleConverter");
        config.setHttpResponseHeaderAttrForIncludedRoles("ROLES");
        secMgr.saveFilter((SecurityNamedServiceConfig)config);
        MockHttpServletRequest request = this.createRequest("/foo");
        MockHttpServletResponse response = new MockHttpServletResponse();
        Servlet servlet = (Servlet)EasyMock.createNiceMock(Servlet.class);
        MockFilterChain chain = new MockFilterChain(servlet, new Filter[]{this.getSecurityManager().loadFilter("roleConverter")});
        GeoServerSecurityFilterChainProxy filterChainProxy = (GeoServerSecurityFilterChainProxy)GeoServerExtensions.bean(GeoServerSecurityFilterChainProxy.class);
        filterChainProxy.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertEquals((Object)GeoServerRole.ANONYMOUS_ROLE.getAuthority(), (Object)response.getHeader("ROLES"));
    }

    @Test
    public void testFilterChainWithDisabled() throws Exception {
        MockHttpServletRequest request = this.createRequest("/foo");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        GeoServerSecurityFilterChainProxy filterChainProxy = (GeoServerSecurityFilterChainProxy)GeoServerExtensions.bean(GeoServerSecurityFilterChainProxy.class);
        filterChainProxy.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertNull((Object)response.getHeader("ROLES"));
    }
}

