/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.UserGroupLoadedListener;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.RoleCalculator;
import org.geoserver.security.ldap.LDAPBaseSecurityService;
import org.geoserver.security.ldap.LDAPUserGroupServiceConfig;
import org.geoserver.security.ldap.LDAPUtils;
import org.geotools.util.logging.Logging;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextCallback;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapEntryIdentification;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class LDAPUserGroupService
extends LDAPBaseSecurityService
implements GeoServerUserGroupService {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.ldap");
    private String passwordEncoderName;
    private String passwordValidatorName;
    private String[] populatedAttributes = new String[0];

    public LDAPUserGroupService(SecurityNamedServiceConfig config) throws IOException {
        this.initializeFromConfig(config);
    }

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        LDAPUserGroupServiceConfig ldapConfig = (LDAPUserGroupServiceConfig)config;
        this.passwordEncoderName = ldapConfig.getPasswordEncoderName();
        this.passwordValidatorName = ldapConfig.getPasswordPolicyName();
        if (!LDAPUserGroupService.isEmpty(ldapConfig.getPopulatedAttributes())) {
            this.populatedAttributes = ldapConfig.getPopulatedAttributes().trim().split("[\\s]*,[\\s]*");
        }
    }

    public GeoServerUserGroupStore createStore() throws IOException {
        return null;
    }

    public void load() throws IOException {
    }

    public void registerUserGroupLoadedListener(UserGroupLoadedListener listener) {
    }

    public void unregisterUserGroupLoadedListener(UserGroupLoadedListener listener) {
    }

    public String getPasswordEncoderName() {
        return this.passwordEncoderName;
    }

    public String getPasswordValidatorName() {
        return this.passwordValidatorName;
    }

    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        GeoServerUser user = new GeoServerUser(username);
        user.setEnabled(isEnabled);
        user.setPassword(password);
        return user;
    }

    public GeoServerUserGroup createGroupObject(String groupname, boolean isEnabled) throws IOException {
        GeoServerUserGroup group = new GeoServerUserGroup(groupname);
        group.setEnabled(isEnabled);
        return group;
    }

    public SortedSet<GeoServerUserGroup> getUserGroups() {
        final TreeSet groups = new TreeSet();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                Set groupNames = LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).searchForSingleAttributeValues(LDAPUserGroupService.this.groupSearchBase, LDAPUserGroupService.this.allGroupsSearchFilter, (Object[])new String[0], LDAPUserGroupService.this.groupNameAttribute);
                for (String groupName : groupNames) {
                    groups.add(new GeoServerUserGroup(groupName));
                }
            }
        });
        return Collections.unmodifiableSortedSet(groups);
    }

    protected GeoServerUser createUser(DirContextOperations dco) {
        GeoServerUser gsUser = new GeoServerUser(dco.getStringAttribute(this.userNameAttribute));
        for (String attName : this.populatedAttributes) {
            try {
                Object value;
                Attribute att = dco.getAttributes().get(attName.toLowerCase());
                if (att == null || !((value = att.get()) instanceof String)) continue;
                gsUser.getProperties().put(attName, value);
            }
            catch (NamingException e) {
                LOGGER.log(Level.WARNING, "Could not populate value for user attribute " + attName, e);
            }
        }
        return gsUser;
    }

    protected ContextMapper addToUsers(SortedSet<GeoServerUser> users) {
        return ctx -> {
            users.add(this.createUser((DirContextOperations)((DirContextAdapter)ctx)));
            return null;
        };
    }

    public SortedSet<GeoServerUser> getUsers() {
        final TreeSet users = new TreeSet();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).search(LDAPUserGroupService.this.userSearchBase, LDAPUserGroupService.this.allUsersSearchFilter, LDAPUserGroupService.this.addToUsers(users));
            }
        });
        return Collections.unmodifiableSortedSet(users);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        GeoServerUser user = null;
        try {
            user = this.getUserByUsername(username);
            if (user == null) {
                throw new UsernameNotFoundException(this.userNotFoundMessage(username));
            }
            RoleCalculator calculator = new RoleCalculator((GeoServerUserGroupService)this, this.getSecurityManager().getActiveRoleService());
            user.setAuthorities((Set)calculator.calculateRoles(user));
        }
        catch (IOException e) {
            throw new UsernameNotFoundException(this.userNotFoundMessage(username), (Throwable)e);
        }
        return user;
    }

    protected String userNotFoundMessage(String username) {
        return "User  " + username + " not found in usergroupservice: " + this.getName();
    }

    public GeoServerUserGroup getGroupByGroupname(final String groupname) {
        final AtomicReference group = new AtomicReference();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                try {
                    DirContextOperations dco = LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).searchForSingleEntry(LDAPUserGroupService.this.groupSearchBase, LDAPUserGroupService.this.groupNameFilter, (Object[])new String[]{groupname});
                    if (dco != null) {
                        group.set(new GeoServerUserGroup(dco.getStringAttribute(LDAPUserGroupService.this.groupNameAttribute)));
                    }
                }
                catch (IncorrectResultSizeDataAccessException incorrectResultSizeDataAccessException) {
                    // empty catch block
                }
            }
        });
        return (GeoServerUserGroup)group.get();
    }

    public GeoServerUser getUserByUsername(final String username) {
        final AtomicReference user = new AtomicReference();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                try {
                    DirContextOperations dco = LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).searchForSingleEntry(LDAPUserGroupService.this.userSearchBase, LDAPUserGroupService.this.userNameFilter, (Object[])new String[]{username});
                    if (dco != null) {
                        user.set(LDAPUserGroupService.this.createUser(dco));
                    }
                }
                catch (IncorrectResultSizeDataAccessException incorrectResultSizeDataAccessException) {
                    // empty catch block
                }
            }
        });
        return (GeoServerUser)user.get();
    }

    public SortedSet<GeoServerUser> getUsersForGroup(final GeoServerUserGroup group) {
        final TreeSet users = new TreeSet();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                try {
                    Object[] usernames;
                    DirContextOperations roleObj = LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).searchForSingleEntry(LDAPUserGroupService.this.groupSearchBase, LDAPUserGroupService.this.groupNameFilter, (Object[])new String[]{group.getGroupname()});
                    if (roleObj != null && (usernames = roleObj.getObjectAttributes(LDAPUserGroupService.this.groupMembershipAttribute)) != null) {
                        for (Object username : usernames) {
                            String user = username.toString();
                            Matcher m = LDAPUserGroupService.this.userMembershipPattern.matcher(user);
                            if (m.matches()) {
                                user = m.group(1);
                            }
                            users.add(LDAPUserGroupService.this.getUserByUsername(LDAPUserGroupService.this.getUserNameFromMembership(user)));
                        }
                    }
                }
                catch (IncorrectResultSizeDataAccessException incorrectResultSizeDataAccessException) {
                    // empty catch block
                }
            }
        });
        return Collections.unmodifiableSortedSet(users);
    }

    public SortedSet<GeoServerUserGroup> getGroupsForUser(final GeoServerUser user) {
        final TreeSet groups = new TreeSet();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                Set groupNames = LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).searchForSingleAttributeValues(LDAPUserGroupService.this.groupSearchBase, LDAPUserGroupService.this.groupMembershipFilter, (Object[])new String[]{user.getUsername(), LDAPUserGroupService.this.lookupDn(user.getUsername())}, LDAPUserGroupService.this.groupNameAttribute);
                for (String groupName : groupNames) {
                    groups.add(new GeoServerUserGroup(groupName));
                }
            }
        });
        return Collections.unmodifiableSortedSet(groups);
    }

    public int getUserCount() {
        final AtomicInteger size = new AtomicInteger(0);
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).search(LDAPUserGroupService.this.userSearchBase, LDAPUserGroupService.this.allUsersSearchFilter, LDAPUserGroupService.this.counter(size));
            }
        });
        return size.get();
    }

    public int getGroupCount() {
        final AtomicInteger size = new AtomicInteger(0);
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).search(LDAPUserGroupService.this.groupSearchBase, LDAPUserGroupService.this.allGroupsSearchFilter, LDAPUserGroupService.this.counter(size));
            }
        });
        return size.get();
    }

    public SortedSet<GeoServerUser> getUsersHavingProperty(final String propname) {
        final TreeSet<GeoServerUser> users = new TreeSet<GeoServerUser>();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).search(LDAPUserGroupService.this.userSearchBase, propname + "=*", LDAPUserGroupService.this.addToUsers(users));
            }
        });
        return users;
    }

    public int getUserCountHavingProperty(final String propname) {
        final AtomicInteger size = new AtomicInteger(0);
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).search(LDAPUserGroupService.this.userSearchBase, propname + "=*", LDAPUserGroupService.this.counter(size));
            }
        });
        return size.get();
    }

    public SortedSet<GeoServerUser> getUsersNotHavingProperty(final String propname) {
        final TreeSet<GeoServerUser> users = new TreeSet<GeoServerUser>();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).search(LDAPUserGroupService.this.userSearchBase, "(&(!(" + propname + "=*))(" + LDAPUserGroupService.this.allUsersSearchFilter + "))", LDAPUserGroupService.this.addToUsers(users));
            }
        });
        return users;
    }

    public int getUserCountNotHavingProperty(final String propname) {
        final AtomicInteger size = new AtomicInteger(0);
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).search(LDAPUserGroupService.this.userSearchBase, "(&(!(" + propname + "=*))(" + LDAPUserGroupService.this.allUsersSearchFilter + "))", LDAPUserGroupService.this.counter(size));
            }
        });
        return size.get();
    }

    public SortedSet<GeoServerUser> getUsersHavingPropertyValue(final String propname, final String propvalue) throws IOException {
        final TreeSet<GeoServerUser> users = new TreeSet<GeoServerUser>();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).search(LDAPUserGroupService.this.userSearchBase, propname + "=" + propvalue, LDAPUserGroupService.this.addToUsers(users));
            }
        });
        return users;
    }

    public int getUserCountHavingPropertyValue(final String propname, final String propvalue) throws IOException {
        final AtomicInteger size = new AtomicInteger(0);
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPUtils.getLdapTemplateInContext(ctx, LDAPUserGroupService.this.template).search(LDAPUserGroupService.this.userSearchBase, propname + "=" + propvalue, LDAPUserGroupService.this.counter(size));
            }
        });
        return size.get();
    }
}

