/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.ldap.BindingLdapAuthoritiesPopulator;
import org.geoserver.security.ldap.GeoserverLdapBindAuthenticator;
import org.geoserver.security.ldap.LDAPAuthenticationProvider;
import org.geoserver.security.ldap.LDAPRoleService;
import org.geoserver.security.ldap.LDAPSecurityServiceConfig;
import org.geoserver.security.ldap.LDAPUserGroupService;
import org.geoserver.security.ldap.LDAPUtils;
import org.geotools.util.logging.Logging;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.authentication.UserDetailsServiceLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.DefaultLdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;

public class LDAPSecurityProvider
extends GeoServerSecurityProvider {
    static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.ldap");
    GeoServerSecurityManager securityManager;

    public LDAPSecurityProvider(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public void configure(XStreamPersister xp) {
        xp.getXStream().alias("ldap", LDAPSecurityServiceConfig.class);
    }

    public Class<LDAPAuthenticationProvider> getAuthenticationProviderClass() {
        return LDAPAuthenticationProvider.class;
    }

    public Class<? extends GeoServerUserGroupService> getUserGroupServiceClass() {
        return LDAPUserGroupService.class;
    }

    public GeoServerAuthenticationProvider createAuthenticationProvider(SecurityNamedServiceConfig config) {
        LDAPSecurityServiceConfig ldapConfig = (LDAPSecurityServiceConfig)config;
        LdapContextSource ldapContext = LDAPUtils.createLdapContext(ldapConfig);
        GeoserverLdapBindAuthenticator authenticator = new GeoserverLdapBindAuthenticator((BaseLdapPathContextSource)ldapContext);
        authenticator.setUserFilter(ldapConfig.getUserFilter());
        authenticator.setUserFormat(ldapConfig.getUserFormat());
        if (ldapConfig.getUserDnPattern() != null) {
            authenticator.setUserDnPatterns(new String[]{ldapConfig.getUserDnPattern()});
        }
        Object authPopulator = null;
        LdapAuthenticationProvider provider = null;
        String ugServiceName = ldapConfig.getUserGroupServiceName();
        if (ugServiceName != null) {
            try {
                GeoServerUserGroupService ugService = this.securityManager.loadUserGroupService(ugServiceName);
                authPopulator = new UserDetailsServiceLdapAuthoritiesPopulator((UserDetailsService)ugService);
                provider = new LdapAuthenticationProvider((LdapAuthenticator)authenticator, (LdapAuthoritiesPopulator)authPopulator);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, String.format("Unable to load user group service '%s', will use LDAP server for calculating roles", ugServiceName), e);
            }
        }
        if (authPopulator == null) {
            if (ldapConfig.isBindBeforeGroupSearch().booleanValue()) {
                authPopulator = new BindingLdapAuthoritiesPopulator((ContextSource)ldapContext, ldapConfig.getGroupSearchBase());
                if (ldapConfig.getGroupSearchFilter() != null) {
                    ((BindingLdapAuthoritiesPopulator)authPopulator).setGroupSearchFilter(ldapConfig.getGroupSearchFilter());
                }
                provider = new LdapAuthenticationProvider((LdapAuthenticator)authenticator, (LdapAuthoritiesPopulator)authPopulator){

                    protected Collection<? extends GrantedAuthority> loadUserAuthorities(DirContextOperations userData, String username, String password) {
                        return ((BindingLdapAuthoritiesPopulator)this.getAuthoritiesPopulator()).getGrantedAuthorities(userData, username, password);
                    }
                };
            } else {
                ldapContext.setAnonymousReadOnly(true);
                authPopulator = new DefaultLdapAuthoritiesPopulator((ContextSource)ldapContext, ldapConfig.getGroupSearchBase());
                if (ldapConfig.getGroupSearchFilter() != null) {
                    ((DefaultLdapAuthoritiesPopulator)authPopulator).setGroupSearchFilter(ldapConfig.getGroupSearchFilter());
                }
                provider = new LdapAuthenticationProvider((LdapAuthenticator)authenticator, (LdapAuthoritiesPopulator)authPopulator);
            }
        }
        return new LDAPAuthenticationProvider((AuthenticationProvider)provider, ldapConfig.getAdminGroup(), ldapConfig.getGroupAdminGroup());
    }

    public Class<? extends GeoServerRoleService> getRoleServiceClass() {
        return LDAPRoleService.class;
    }

    public GeoServerRoleService createRoleService(SecurityNamedServiceConfig config) throws IOException {
        return new LDAPRoleService();
    }

    public GeoServerUserGroupService createUserGroupService(SecurityNamedServiceConfig config) throws IOException {
        return new LDAPUserGroupService(config);
    }
}

