/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.ldap;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.naming.directory.DirContext;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.event.RoleLoadedListener;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.ldap.LDAPBaseSecurityService;
import org.geoserver.security.ldap.LDAPRoleServiceConfig;
import org.geoserver.security.ldap.LDAPUtils;
import org.geotools.util.logging.Logging;
import org.springframework.ldap.core.AuthenticatedLdapEntryContextCallback;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.LdapEntryIdentification;

public class LDAPRoleService
extends LDAPBaseSecurityService
implements GeoServerRoleService {
    private static final SortedSet<String> emptyStringSet = Collections.unmodifiableSortedSet(new TreeSet());
    private static final Map<String, String> emptyMap = Collections.emptyMap();
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security.ldap");
    protected Set<RoleLoadedListener> listeners = Collections.synchronizedSet(new HashSet());
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;
    private String adminGroup;
    private String groupAdminGroup;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        LDAPRoleServiceConfig ldapConfig = (LDAPRoleServiceConfig)config;
        if (!LDAPRoleService.isEmpty(ldapConfig.getAdminGroup())) {
            this.adminGroup = ldapConfig.getAdminGroup();
        }
        if (!LDAPRoleService.isEmpty(ldapConfig.getGroupAdminGroup())) {
            this.groupAdminGroup = ldapConfig.getGroupAdminGroup();
        }
    }

    public boolean canCreateStore() {
        return false;
    }

    public GeoServerRoleStore createStore() throws IOException {
        return null;
    }

    public void registerRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterRoleLoadedListener(RoleLoadedListener listener) {
        this.listeners.remove(listener);
    }

    public SortedSet<String> getGroupNamesForRole(GeoServerRole role) throws IOException {
        return emptyStringSet;
    }

    public SortedSet<String> getUserNamesForRole(final GeoServerRole role) throws IOException {
        final TreeSet users = new TreeSet();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPRoleService.this.fillUsersForRole(ctx, users, role);
            }
        });
        return Collections.unmodifiableSortedSet(users);
    }

    public SortedSet<GeoServerRole> getRolesForUser(final String username) throws IOException {
        final TreeSet roles = new TreeSet();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPRoleService.this.fillRolesForUser(ctx, username, LDAPRoleService.this.lookupDn(username), roles);
            }
        });
        return Collections.unmodifiableSortedSet(roles);
    }

    public SortedSet<GeoServerRole> getRolesForGroup(String groupname) throws IOException {
        TreeSet<GeoServerRole> set = new TreeSet<GeoServerRole>();
        GeoServerRole role = this.getRoleByName(groupname);
        if (role != null) {
            set.add(role);
        }
        return Collections.unmodifiableSortedSet(set);
    }

    public SortedSet<GeoServerRole> getRoles() throws IOException {
        final TreeSet roles = new TreeSet();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPRoleService.this.fillAllRoles(ctx, roles);
            }
        });
        return Collections.unmodifiableSortedSet(roles);
    }

    private void fillAllRoles(DirContext ctx, SortedSet<GeoServerRole> roles) {
        Set roleNames = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleAttributeValues(this.groupSearchBase, this.allGroupsSearchFilter, (Object[])new String[0], this.groupNameAttribute);
        this.addRolesToSet(roles, roleNames);
    }

    private void fillUsersForRole(DirContext ctx, SortedSet<String> users, GeoServerRole role) {
        Object[] usernames;
        DirContextOperations roleObj;
        String roleStr = role.toString();
        if (roleStr.startsWith("ROLE_")) {
            roleStr = roleStr.substring(5);
        }
        if ((roleObj = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleEntry(this.groupSearchBase, this.groupNameFilter, (Object[])new String[]{roleStr})) != null && (usernames = roleObj.getObjectAttributes(this.groupMembershipAttribute)) != null) {
            for (Object username : usernames) {
                String user = username.toString();
                Matcher m = this.userMembershipPattern.matcher(user);
                if (m.matches()) {
                    user = m.group(1);
                }
                users.add(this.getUserNameFromMembership(user));
            }
        }
    }

    private void addRolesToSet(SortedSet<GeoServerRole> roles, Set<String> roleNames) {
        for (String roleName : roleNames) {
            try {
                roles.add(this.createRoleObject(roleName));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error adding a new role from LDAP", e);
            }
        }
    }

    private void fillRolesForUser(DirContext ctx, String username, String userDn, SortedSet<GeoServerRole> roles) {
        Set roleNames = LDAPUtils.getLdapTemplateInContext(ctx, this.template).searchForSingleAttributeValues(this.groupSearchBase, this.groupMembershipFilter, (Object[])new String[]{username, userDn}, this.groupNameAttribute);
        this.addRolesToSet(roles, roleNames);
    }

    public Map<String, String> getParentMappings() throws IOException {
        return emptyMap;
    }

    public GeoServerRole createRoleObject(String role) throws IOException {
        return new GeoServerRole(this.rolePrefix + (this.convertToUpperCase ? role.toUpperCase() : role));
    }

    public GeoServerRole getParentRole(GeoServerRole role) throws IOException {
        return null;
    }

    public GeoServerRole getRoleByName(String role) throws IOException {
        if (role.startsWith("ROLE_")) {
            role = role.substring(5);
        }
        final String roleName = role;
        final TreeSet roles = new TreeSet();
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                roles.addAll(LDAPUtils.getLdapTemplateInContext(ctx, LDAPRoleService.this.template).searchForSingleAttributeValues(LDAPRoleService.this.groupSearchBase, LDAPRoleService.this.groupNameFilter, (Object[])new String[]{roleName}, LDAPRoleService.this.groupNameAttribute));
            }
        });
        if (roles.size() == 1) {
            return this.createRoleObject(role);
        }
        return null;
    }

    public void load() throws IOException {
    }

    public Properties personalizeRoleParams(String roleName, Properties roleParams, String userName, Properties userProps) throws IOException {
        return null;
    }

    public GeoServerRole getAdminRole() {
        if (this.adminGroup == null) {
            return null;
        }
        try {
            return this.getRoleByName(this.adminGroup);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GeoServerRole getGroupAdminRole() {
        if (this.groupAdminGroup == null) {
            return null;
        }
        try {
            return this.getRoleByName(this.groupAdminGroup);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getRoleCount() throws IOException {
        final AtomicInteger count = new AtomicInteger(0);
        this.authenticateIfNeeded(new AuthenticatedLdapEntryContextCallback(){

            public void executeWithContext(DirContext ctx, LdapEntryIdentification ldapEntryIdentification) {
                LDAPUtils.getLdapTemplateInContext(ctx, LDAPRoleService.this.template).search(LDAPRoleService.this.groupSearchBase, LDAPRoleService.this.allGroupsSearchFilter, LDAPRoleService.this.counter(count));
            }
        });
        return count.get();
    }
}

