/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wfs.servlets;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.config.impl.SettingsInfoImpl;
import org.geoserver.ows.util.ResponseUtils;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;
import org.vfny.geoserver.wfs.servlets.TestWfsPost;

public class TestWfsPostTest {
    static final String PROXY_BASE_URL = "PROXY_BASE_URL";

    @Test
    public void testEscapeXMLReservedChars() throws Exception {
        TestWfsPost servlet = TestWfsPostTest.buildMockServlet();
        MockHttpServletRequest request = TestWfsPostTest.buildMockRequest();
        request.addHeader("Host", (Object)"localhost:8080");
        request.setQueryString(ResponseUtils.getQueryString((String)"form_hf_0=&url=vjoce<>:garbage"));
        request.setParameter("url", "vjoce<>:garbage");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        servlet.service((ServletRequest)request, (ServletResponse)response);
        Assert.assertTrue((boolean)response.getContentAsString().contains("java.net.MalformedURLException: no protocol: vjoce&lt;&gt;:garbage"));
    }

    @Test
    public void testDisallowOpenProxy() throws Exception {
        TestWfsPost servlet = TestWfsPostTest.buildMockServlet();
        MockHttpServletRequest request = TestWfsPostTest.buildMockRequest();
        request.setParameter("url", "http://www.google.com");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        servlet.service((ServletRequest)request, (ServletResponse)response);
        Assert.assertTrue((boolean)response.getContentAsString().contains("Invalid url requested, the demo requests should be hitting: http://localhost:8080/geoserver"));
    }

    @Test
    public void testDisallowOpenProxyWithProxyBase() throws Exception {
        TestWfsPost servlet = TestWfsPostTest.buildMockServlet("http://geoserver.org/geoserver");
        MockHttpServletRequest request = TestWfsPostTest.buildMockRequest();
        request.setParameter("url", "http://localhost:1234/internalApp");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        servlet.service((ServletRequest)request, (ServletResponse)response);
        Assert.assertTrue((boolean)response.getContentAsString().contains("Invalid url requested, the demo requests should be hitting: http://geoserver.org/geoserver"));
    }

    @Test
    public void testDisallowOpenProxyWithSupersetNameWithProxyBase() throws Exception {
        TestWfsPost servlet = TestWfsPostTest.buildMockServlet("http://geoserver.org");
        MockHttpServletRequest request = TestWfsPostTest.buildMockRequest();
        request.setParameter("url", "http://geoserver.org.other");
        request.setMethod("GET");
        MockHttpServletResponse response = new MockHttpServletResponse();
        servlet.service((ServletRequest)request, (ServletResponse)response);
        Assert.assertTrue((boolean)response.getContentAsString().contains("Invalid url requested, the demo requests should be hitting: http://geoserver.org"));
    }

    @Test
    public void testValidateURL() throws Exception {
        TestWfsPost servlet = TestWfsPostTest.buildMockServlet();
        MockHttpServletRequest request = TestWfsPostTest.buildMockRequest();
        request.setParameter("url", "http://localhost:1234/internalApp");
        request.setMethod("GET");
        try {
            servlet.validateURL((HttpServletRequest)request, "http://localhost:1234/internalApp", "http://geoserver.org/geoserver");
            Assert.fail((String)"Requests should be limited by proxyBaseURL");
        }
        catch (IllegalArgumentException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("Invalid url requested, the demo requests should be hitting: http://geoserver.org/geoserver"));
        }
    }

    @Test
    public void testGetProxyBaseURL() {
        SettingsInfoImpl settings = new SettingsInfoImpl();
        settings.setProxyBaseUrl("https://foo.com/geoserver");
        GeoServerInfoImpl info = new GeoServerInfoImpl();
        info.setSettings((SettingsInfo)settings);
        GeoServerImpl gs = new GeoServerImpl();
        gs.setGlobal((GeoServerInfo)info);
        TestWfsPost servlet = new TestWfsPost((GeoServer)gs){
            final /* synthetic */ GeoServer val$gs;
            {
                this.val$gs = geoServer;
            }

            protected GeoServer getGeoServer() {
                return this.val$gs;
            }
        };
        Assert.assertEquals((Object)"https://foo.com/geoserver", (Object)servlet.getProxyBaseURL());
    }

    protected static MockHttpServletRequest buildMockRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("http");
        request.setServerName("localhost");
        request.setServerPort(8080);
        request.setContextPath("/geoserver");
        request.setServletPath("/TestWfsPost");
        request.setRequestURI(ResponseUtils.stripQueryString((String)ResponseUtils.appendPath((String[])new String[]{"/geoserver/TestWfsPost"})));
        request.setRemoteAddr("127.0.0.1");
        return request;
    }

    protected static TestWfsPost buildMockServlet() throws ServletException {
        return TestWfsPostTest.buildMockServlet(null);
    }

    protected static TestWfsPost buildMockServlet(final String proxyBaseUrl) throws ServletException {
        TestWfsPost testWfsPost = proxyBaseUrl == null ? new TestWfsPost() : new TestWfsPost(){

            String getProxyBaseURL() {
                return proxyBaseUrl;
            }
        };
        MockServletContext servletContext = new MockServletContext();
        servletContext.setContextPath("/geoserver");
        MockServletConfig servletConfig = new MockServletConfig((ServletContext)servletContext);
        testWfsPost.init((ServletConfig)servletConfig);
        return testWfsPost;
    }
}

