/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.net.NetworkInterface;
import java.util.Collection;
import java.util.Collections;
import org.easymock.classextension.EasyMock;
import org.eclipse.emf.common.util.URI;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.util.PropertyRule;
import org.geoserver.wfs.xml.WFSURIHandler;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class WFSURIHandlerTest {
    @Rule
    public PropertyRule aliases = PropertyRule.system((String)"org.geoserver.wfs.xml.WFSURIHandler.additionalHostnames");
    WFSURIHandler.InitStrategy strategy;
    private GeoServer gs;
    private GeoServerInfo config;

    @Before
    public void setUp() {
        WFSURIHandler.ADDITIONAL_HOSTNAMES.clear();
        WFSURIHandler.ADDRESSES.clear();
        this.strategy = new WFSURIHandler.InitStrategy(){

            public Collection<NetworkInterface> getNetworkInterfaces() {
                return Collections.emptyList();
            }
        };
        this.gs = (GeoServer)EasyMock.createMock(GeoServer.class);
        this.config = (GeoServerInfo)EasyMock.createMock(GeoServerInfo.class);
        org.easymock.EasyMock.expect((Object)this.gs.getGlobal()).andStubReturn((Object)this.config);
        org.easymock.EasyMock.expect((Object)this.config.getProxyBaseUrl()).andStubReturn(null);
        EasyMock.replay((Object[])new Object[]{this.gs, this.config});
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.gs, this.config});
    }

    @Test
    @Ignore
    public void testFromNetworkInterfaces() {
    }

    @Test
    public void testDefaultAliases() {
        WFSURIHandler.init((WFSURIHandler.InitStrategy)this.strategy);
        Assert.assertThat((Object)WFSURIHandler.ADDRESSES, (Matcher)Matchers.empty());
        Assert.assertThat((Object)WFSURIHandler.ADDITIONAL_HOSTNAMES, (Matcher)Matchers.contains((Object[])new String[]{"localhost"}));
    }

    @Test
    public void testOverrideAliasesComma() {
        this.aliases.setValue("foo,bar , baz");
        WFSURIHandler.init((WFSURIHandler.InitStrategy)this.strategy);
        Assert.assertThat((Object)WFSURIHandler.ADDRESSES, (Matcher)Matchers.empty());
        Assert.assertThat((Object)WFSURIHandler.ADDITIONAL_HOSTNAMES, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo", "bar", "baz"}));
    }

    @Test
    public void testOverrideAliasesSpace() {
        this.aliases.setValue("foo bar  baz ");
        WFSURIHandler.init((WFSURIHandler.InitStrategy)this.strategy);
        Assert.assertThat((Object)WFSURIHandler.ADDRESSES, (Matcher)Matchers.empty());
        Assert.assertThat((Object)WFSURIHandler.ADDITIONAL_HOSTNAMES, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"foo", "bar", "baz"}));
    }

    protected void setProxyBase(String url) {
        EasyMock.reset((Object[])new Object[]{this.config});
        org.easymock.EasyMock.expect((Object)this.config.getProxyBaseUrl()).andStubReturn((Object)url);
        EasyMock.replay((Object[])new Object[]{this.config});
    }

    @Test
    public void testRecognizeReflexiveSimple() {
        WFSURIHandler.init((WFSURIHandler.InitStrategy)this.strategy);
        WFSURIHandler handler = new WFSURIHandler(this.gs);
        URI wrongHost = URI.createURI((String)"http://example.com/geoserver/wfs?service=wfs&version=2.0.0&request=DescribeFeatureType");
        URI notDFT = URI.createURI((String)"http://localhost/geoserver/wfs?service=wfs&version=2.0.0&request=GetCapabilities");
        URI localDFT = URI.createURI((String)"http://localhost/geoserver/wfs?service=wfs&version=2.0.0&request=DescribeFeatureType");
        Assert.assertThat((Object)handler.canHandle(wrongHost), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)handler.canHandle(notDFT), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)handler.canHandle(localDFT), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testRecognizeReflexiveUserAliases() {
        this.aliases.setValue("foo bar baz");
        WFSURIHandler.init((WFSURIHandler.InitStrategy)this.strategy);
        WFSURIHandler handler = new WFSURIHandler(this.gs);
        URI wrongHost = URI.createURI((String)"http://example.com/geoserver/wfs?service=wfs&version=2.0.0&request=DescribeFeatureType");
        URI notDFT = URI.createURI((String)"http://foo/geoserver/wfs?service=wfs&version=2.0.0&request=GetCapabilities");
        URI fooDFT = URI.createURI((String)"http://foo/geoserver/wfs?service=wfs&version=2.0.0&request=DescribeFeatureType");
        URI barDFT = URI.createURI((String)"http://bar/geoserver/wfs?service=wfs&version=2.0.0&request=DescribeFeatureType");
        URI bazDFT = URI.createURI((String)"http://baz/geoserver/wfs?service=wfs&version=2.0.0&request=DescribeFeatureType");
        URI localhostDFT = URI.createURI((String)"http://localhost/geoserver/wfs?service=wfs&version=2.0.0&request=DescribeFeatureType");
        Assert.assertThat((Object)handler.canHandle(wrongHost), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)handler.canHandle(notDFT), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)handler.canHandle(fooDFT), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)handler.canHandle(barDFT), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)handler.canHandle(bazDFT), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)handler.canHandle(localhostDFT), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testRecognizeReflexiveProxy() {
        this.setProxyBase("http://foo/geoserver");
        WFSURIHandler.init((WFSURIHandler.InitStrategy)this.strategy);
        WFSURIHandler handler = new WFSURIHandler(this.gs);
        URI wrongHost = URI.createURI((String)"http://example.com/geoserver/wfs?service=wfs&version=2.0.0&request=DescribeFeatureType");
        URI notDFT = URI.createURI((String)"http://foo/geoserver/wfs?service=wfs&version=2.0.0&request=GetCapabilities");
        URI fooDFT = URI.createURI((String)"http://foo/geoserver/wfs?service=wfs&version=2.0.0&request=DescribeFeatureType");
        URI uppercaseFooDFT = URI.createURI((String)"http://FOO/geoserver/wfs?service=wfs&version=2.0.0&request=DescribeFeatureType");
        Assert.assertThat((Object)handler.canHandle(wrongHost), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)handler.canHandle(notDFT), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)handler.canHandle(fooDFT), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)handler.canHandle(uppercaseFooDFT), (Matcher)Matchers.is((Object)true));
    }
}

