/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.feature.NameImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.feature.type.Name;
import org.w3c.dom.Document;

public class GMLOutputFormatTest
extends WFSTestSupport {
    private int defaultNumDecimals = -1;
    private boolean defaultForceDecimal = false;
    private boolean defaultPadWithZeros = false;

    @Before
    public void saveDefaultFormattingOptions() {
        if (this.defaultNumDecimals < 0) {
            FeatureTypeInfo info = (FeatureTypeInfo)this.getGeoServer().getCatalog().getResourceByName((Name)new NameImpl(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()), FeatureTypeInfo.class);
            this.defaultNumDecimals = info.getNumDecimals();
            this.defaultForceDecimal = info.getForcedDecimal();
            this.defaultPadWithZeros = info.getPadWithZeros();
        }
    }

    @After
    public void restoreDefaultFormattingOptions() {
        FeatureTypeInfo info = (FeatureTypeInfo)this.getGeoServer().getCatalog().getResourceByName((Name)new NameImpl(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()), FeatureTypeInfo.class);
        info.setNumDecimals(this.defaultNumDecimals);
        info.setForcedDecimal(this.defaultForceDecimal);
        info.setPadWithZeros(this.defaultPadWithZeros);
    }

    @Test
    public void testGML2() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=gml2&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
        dom = this.getAsDOM("wfs?request=getfeature&version=1.1.0&outputFormat=gml2&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
        dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=text/xml; subtype%3Dgml/2.1.2&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
        dom = this.getAsDOM("wfs?request=getfeature&version=1.1.0&outputFormat=text/xml; subtype%3Dgml/2.1.2&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
    }

    @Test
    public void testGML2CoordinatesFormatting() throws Exception {
        this.enableCoordinatesFormatting();
        Document dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=gml2&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"-2.0000,-1.0000 2.0000,6.0000", (Object)dom.getElementsByTagName("gml:coordinates").item(0).getTextContent());
    }

    private void enableCoordinatesFormatting() {
        FeatureTypeInfo info = (FeatureTypeInfo)this.getGeoServer().getCatalog().getResourceByName((Name)new NameImpl(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()), FeatureTypeInfo.class);
        info.setNumDecimals(4);
        info.setForcedDecimal(true);
        info.setPadWithZeros(true);
        this.getGeoServer().getCatalog().save((ResourceInfo)info);
    }

    @Test
    public void testGML2GZIP() throws Exception {
    }

    @Test
    public void testGML3() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=gml3&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
        dom = this.getAsDOM("wfs?request=getfeature&version=1.1.0&outputFormat=gml3&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
        dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=text/xml; subtype%3Dgml/3.1.1&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
        dom = this.getAsDOM("wfs?request=getfeature&version=1.1.0&outputFormat=text/xml; subtype%3Dgml/3.1.1&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
        Assert.assertNull((Object)this.getFirstElementByTagName(dom, "gml:outerBoundaryIs"));
        Assert.assertNotNull((Object)this.getFirstElementByTagName(dom, "gml:exterior"));
    }

    @Test
    public void testGML3CoordinatesFormatting() throws Exception {
        this.enableCoordinatesFormatting();
        Document dom = this.getAsDOM("wfs?request=getfeature&version=1.0.0&outputFormat=gml3&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"-1.0000 0.0000 0.0000 1.0000 1.0000 0.0000 0.0000 -1.0000 -1.0000 0.0000", (Object)dom.getElementsByTagName("gml:posList").item(0).getTextContent());
    }

    @Test
    public void testGML32() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&version=2.0.0&outputFormat=gml32&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"http://www.opengis.net/wfs/2.0", (Object)dom.getDocumentElement().getNamespaceURI());
        Assert.assertEquals((Object)"FeatureCollection", (Object)dom.getDocumentElement().getLocalName());
    }

    @Test
    public void testGML32CoordinatesFormatting() throws Exception {
        this.enableCoordinatesFormatting();
        Document dom = this.getAsDOM("wfs?request=getfeature&version=2.0.0&outputFormat=gml32&typename=" + MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"0.0000 -1.0000 1.0000 0.0000 0.0000 1.0000 -1.0000 0.0000 0.0000 -1.0000", (Object)dom.getElementsByTagName("gml:posList").item(0).getTextContent());
    }
}

