/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geoserver.wfs.xml.GML3OutputFormat;
import org.geoserver.wfs.xml.v1_1_0.WFS;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class GML3FeatureProducerTest
extends WFSTestSupport {
    GML3OutputFormat producer() {
        FeatureTypeSchemaBuilder.GML3 sb = new FeatureTypeSchemaBuilder.GML3(this.getGeoServer());
        WFSConfiguration configuration = new WFSConfiguration(this.getGeoServer(), (FeatureTypeSchemaBuilder)sb, new WFS((FeatureTypeSchemaBuilder)sb));
        return new GML3OutputFormat(this.getGeoServer(), configuration);
    }

    Operation request(QName ... names) {
        Service service = this.getServiceDescriptor10();
        GetFeatureType type = WfsFactory.eINSTANCE.createGetFeatureType();
        type.setBaseUrl("http://localhost:8080/geoserver");
        for (QName name : names) {
            QueryType queryType = WfsFactory.eINSTANCE.createQueryType();
            queryType.setTypeName(Collections.singletonList(name));
            type.getQuery().add((Object)queryType);
        }
        Operation request = new Operation("wfs", service, null, new Object[]{type});
        return request;
    }

    @Test
    public void testSingle() throws Exception {
        SimpleFeatureSource source = this.getFeatureSource(MockData.SEVEN);
        FeatureCollection features = source.getFeatures();
        FeatureCollectionResponse fcType = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fcType.getFeature().add(features);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.producer().write(fcType, (OutputStream)output, this.request(MockData.SEVEN));
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Assert.assertEquals((long)7L, (long)document.getElementsByTagName("cdf:Seven").getLength());
    }

    @Test
    public void testMultipleSameNamespace() throws Exception {
        FeatureCollectionResponse fcType = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fcType.getFeature().add(this.getFeatureSource(MockData.SEVEN).getFeatures());
        fcType.getFeature().add(this.getFeatureSource(MockData.FIFTEEN).getFeatures());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.producer().write(fcType, (OutputStream)output, this.request(MockData.SEVEN, MockData.FIFTEEN));
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Assert.assertEquals((long)22L, (long)(document.getElementsByTagName("cdf:Seven").getLength() + document.getElementsByTagName("cdf:Fifteen").getLength()));
    }

    @Test
    public void testMultipleDifferentNamespace() throws Exception {
        FeatureCollectionResponse fcType = FeatureCollectionResponse.adapt((Object)WfsFactory.eINSTANCE.createFeatureCollectionType());
        fcType.getFeature().add(this.getFeatureSource(MockData.SEVEN).getFeatures());
        fcType.getFeature().add(this.getFeatureSource(MockData.POLYGONS).getFeatures());
        int npolys = this.getFeatureSource(MockData.POLYGONS).getFeatures().size();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.producer().write(fcType, (OutputStream)output, this.request(MockData.SEVEN, MockData.POLYGONS));
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        Assert.assertEquals((long)(7 + npolys), (long)(document.getElementsByTagName("cdf:Seven").getLength() + document.getElementsByTagName("cgf:Polygons").getLength()));
    }
}

