/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geotools.gml2.GML;
import org.geotools.xml.Schemas;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class FeatureTypeInfoSchemaBuilderTest
extends WFSTestSupport {
    protected QName UUID_TEST = new QName(MockData.CITE_URI, "uuid", MockData.CITE_PREFIX);
    protected XpathEngine xpath;

    @Test
    public void testBuildGml2() throws Exception {
        FeatureTypeSchemaBuilder.GML2 builder = new FeatureTypeSchemaBuilder.GML2(this.getGeoServer());
        FeatureTypeInfo lines = this.getFeatureTypeInfo(SystemTestData.LINES);
        XSDSchema schema = builder.build(new FeatureTypeInfo[]{lines}, null);
        Assert.assertNotNull((Object)schema);
        XSDElementDeclaration element = Schemas.getElementDeclaration((XSDSchema)schema, (QName)SystemTestData.LINES);
        Assert.assertNotNull((Object)element);
        Assert.assertTrue((boolean)(element.getType() instanceof XSDComplexTypeDefinition));
        XSDElementDeclaration id = Schemas.getChildElementDeclaration((XSDElementDeclaration)element, (QName)new QName(SystemTestData.CGF_URI, "id"));
        Assert.assertNotNull((Object)id);
        XSDElementDeclaration lineStringProperty = Schemas.getChildElementDeclaration((XSDElementDeclaration)element, (QName)new QName(SystemTestData.CGF_URI, "lineStringProperty"));
        Assert.assertNotNull((Object)lineStringProperty);
        XSDTypeDefinition lineStringPropertyType = lineStringProperty.getType();
        Assert.assertEquals((Object)"http://www.opengis.net/gml", (Object)lineStringPropertyType.getTargetNamespace());
        Assert.assertEquals((Object)GML.LINESTRINGPROPERTYTYPE.getLocalPart(), (Object)lineStringPropertyType.getName());
        XSDTypeDefinition geometryAssociationType = lineStringPropertyType.getBaseType();
        Assert.assertNotNull((Object)geometryAssociationType);
        Assert.assertEquals((Object)"http://www.opengis.net/gml", (Object)geometryAssociationType.getTargetNamespace());
        Assert.assertEquals((Object)GML.GEOMETRYASSOCIATIONTYPE.getLocalPart(), (Object)geometryAssociationType.getName());
    }

    @Override
    protected void setUpInternal(SystemTestData testData) throws Exception {
        super.setUpInternal(testData);
        testData.addVectorLayer(this.UUID_TEST, null, FeatureTypeInfoSchemaBuilderTest.class, this.getCatalog());
    }

    @Before
    public void setXPath() {
        this.xpath = XMLUnit.newXpathEngine();
    }

    @Test
    public void testUUID() throws Exception {
        Document dom = this.getAsDOM("wfs?service=wfs&version=1.1.0&request=DescribeFeatureType&typeName=" + this.getLayerId(this.UUID_TEST));
        Assert.assertEquals((Object)"1", (Object)this.xpath.evaluate("count(//xsd:element[@name='uuid' and @type='xsd:string'])", dom));
    }
}

