/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import java.io.ByteArrayInputStream;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetFeatureTest
extends WFS20TestSupport {
    @Before
    public void revert() throws Exception {
        this.revertLayer(SystemTestData.PRIMITIVEGEOFEATURE);
    }

    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        data.addVectorLayer(new QName(SystemTestData.SF_URI, "WithGMLProperties", SystemTestData.SF_PREFIX), Collections.EMPTY_MAP, org.geoserver.wfs.v1_1.GetFeatureTest.class, this.getCatalog());
        data.addVectorLayer(new QName(SystemTestData.SF_URI, "PrimitiveGeoFeatureId", SystemTestData.SF_PREFIX), Collections.EMPTY_MAP, TestData.class, this.getCatalog());
    }

    @Test
    public void testSkipNumberMatched() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("Fifteen");
        fti.setSkipNumberMatched(true);
        this.getCatalog().save((ResourceInfo)fti);
        Assert.assertEquals((Object)true, (Object)fti.getSkipNumberMatched());
        Document dom = this.getAsDOM("wfs?request=GetFeature&typenames=cdf:Fifteen&version=2.0.0&service=wfs");
        Assert.assertEquals((Object)"unknown", (Object)dom.getDocumentElement().getAttribute("numberMatched"));
        Assert.assertEquals((Object)"15", (Object)dom.getDocumentElement().getAttribute("numberReturned"));
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)"count(//cdf:Fifteen)", (Document)dom);
        dom = this.getAsDOM("wfs?request=GetFeature&typenames=cdf:Fifteen&version=2.0.0&service=wfs&resultType=hits");
        Assert.assertEquals((Object)"15", (Object)dom.getDocumentElement().getAttribute("numberMatched"));
        Assert.assertEquals((Object)"0", (Object)dom.getDocumentElement().getAttribute("numberReturned"));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//cdf:Fifteen)", (Document)dom);
        fti.setSkipNumberMatched(false);
        this.getCatalog().save((ResourceInfo)fti);
    }

    @Test
    public void testGet() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typenames=cdf:Fifteen&version=2.0.0&service=wfs");
        this.testGetFifteenAll("wfs?request=GetFeature&typenames=(cdf:Fifteen)&version=2.0.0&service=wfs");
    }

    @Test
    public void testAlternatePrefix() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typenames=abc:Fifteen&version=2.0.0&service=wfs&namespaces=xmlns(abc," + MockData.CDF_URI + ")");
        this.testGetFifteenAll("wfs?request=GetFeature&typenames=abc:Fifteen&version=2.0.0&service=wfs&namespaces=xmlns(abc," + MockData.CDF_URI + "),xmlns(wfs," + "http://www.opengis.net/wfs/2.0" + ")");
        this.testGetFifteenAll("wfs?request=GetFeature&typenames=Fifteen&version=2.0.0&service=wfs&namespaces=xmlns(" + MockData.CDF_URI + "),xmlns(wfs," + "http://www.opengis.net/wfs/2.0" + ")");
    }

    @Test
    public void testConcurrentGet() throws Exception {
        int i;
        ExecutorCompletionService<Object> es = new ExecutorCompletionService<Object>(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
        int REQUESTS = 200;
        for (i = 0; i < 200; ++i) {
            es.submit(() -> {
                this.testGetFifteenAll("wfs?request=GetFeature&typenames=cdf:Fifteen&version=2.0.0&service=wfs");
                return null;
            });
        }
        for (i = 0; i < 200; ++i) {
            es.take().get();
        }
    }

    @Test
    public void testConcurrentPost() throws Exception {
        ExecutorCompletionService<Object> es = new ExecutorCompletionService<Object>(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
        int REQUESTS = 200;
        for (int i = 0; i < 200; ++i) {
            es.submit(() -> {
                this.testPost();
                return null;
            });
        }
        long start = System.currentTimeMillis();
        for (int i = 0; i < 200; ++i) {
            es.take().get();
            if (i % 100 != 0) continue;
            long curr = System.currentTimeMillis();
            LOGGER.info(i + " - " + (curr - start));
            start = curr;
        }
    }

    @Test
    public void testGetTypeNames() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&typenames=(cdf:Fifteen)(cdf:Seven)&version=2.0.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)"count(//cdf:Fifteen)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"7", (String)"count(//cdf:Seven)", (Document)dom);
    }

    @Test
    public void testGetTypeName() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=2.0.0&service=wfs");
    }

    @Test
    public void testGetWithCount() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&typenames=cdf:Fifteen&version=2.0.0&service=wfs&count=5");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(//cdf:Fifteen)", (Document)dom);
        Assert.assertEquals((Object)"5", (Object)dom.getDocumentElement().getAttribute("numberReturned"));
        Assert.assertEquals((Object)"15", (Object)dom.getDocumentElement().getAttribute("numberMatched"));
    }

    @Test
    public void testGetWithCountAndStartIndex0() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&typenames=cdf:Fifteen&version=2.0.0&service=wfs&count=5&startIndex=0");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(//cdf:Fifteen)", (Document)dom);
        Assert.assertEquals((Object)"5", (Object)dom.getDocumentElement().getAttribute("numberReturned"));
        Assert.assertEquals((Object)"15", (Object)dom.getDocumentElement().getAttribute("numberMatched"));
    }

    @Test
    public void testGetWithCountAndStartIndexMiddle() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&typenames=cdf:Fifteen&version=2.0.0&service=wfs&count=5&startIndex=7");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"count(//cdf:Fifteen)", (Document)dom);
        Assert.assertEquals((Object)"5", (Object)dom.getDocumentElement().getAttribute("numberReturned"));
        Assert.assertEquals((Object)"15", (Object)dom.getDocumentElement().getAttribute("numberMatched"));
    }

    @Test
    public void testGetWithCountAndStartIndexEnd() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&typenames=cdf:Fifteen&version=2.0.0&service=wfs&count=5&startIndex=11");
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)"count(//cdf:Fifteen)", (Document)dom);
        Assert.assertEquals((Object)"4", (Object)dom.getDocumentElement().getAttribute("numberReturned"));
        Assert.assertEquals((Object)"15", (Object)dom.getDocumentElement().getAttribute("numberMatched"));
    }

    @Test
    public void testGetPropertyNameEmpty() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=2.0.0&service=wfs&propertyname=");
    }

    @Test
    public void testGetPropertyNameStar() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=2.0.0&service=wfs&propertyname=*");
    }

    private void testGetFifteenAll(String request) throws Exception {
        Document doc = this.getAsDOM(request);
        this.assertGML32(doc);
        NodeList features = doc.getElementsByTagName("cdf:Fifteen");
        Assert.assertFalse((features.getLength() == 0 ? 1 : 0) != 0);
        for (int i = 0; i < features.getLength(); ++i) {
            Element feature = (Element)features.item(i);
            Assert.assertTrue((boolean)feature.hasAttribute("gml:id"));
        }
    }

    @Test
    public void testGetWithFeatureId() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=cdf:Fifteen&version=2.0.0&service=wfs&featureid=Fifteen.2");
        this.assertGML32(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/wfs:member/cdf:Fifteen)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Fifteen.2", (String)"//wfs:FeatureCollection/wfs:member/cdf:Fifteen/@gml:id", (Document)doc);
        doc = this.getAsDOM("wfs?request=GetFeature&typeName=cite:NamedPlaces&version=2.0.0&service=wfs&featureId=NamedPlaces.1107531895891");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/wfs:member/cite:NamedPlaces)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"NamedPlaces.1107531895891", (String)"//wfs:FeatureCollection/wfs:member/cite:NamedPlaces/@gml:id", (Document)doc);
    }

    @Test
    public void testGetWithResourceId() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeNames=cdf:Fifteen&version=2.0.0&service=wfs&resourceid=Fifteen.2");
        this.assertGML32(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/wfs:member/cdf:Fifteen)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Fifteen.2", (String)"//wfs:FeatureCollection/wfs:member/cdf:Fifteen/@gml:id", (Document)doc);
        doc = this.getAsDOM("wfs?request=GetFeature&typeName=cite:NamedPlaces&version=2.0.0&service=wfs&resourceid=NamedPlaces.1107531895891");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/wfs:member/cite:NamedPlaces)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"NamedPlaces.1107531895891", (String)"//wfs:FeatureCollection/wfs:member/cite:NamedPlaces/@gml:id", (Document)doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWithInconsistentResourceId() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setCiteCompliant(true);
        gs.save((ServiceInfo)wfs);
        try {
            Document doc = this.getAsDOM("wfs?request=GetFeature&typeNames=sf:AggregateGeoFeature&version=2.0.0&service=wfs&resourceid=Fifteen.2", 400);
            this.checkOws11Exception(doc, "2.0.0", "InvalidParameterValue", "RESOURCEID");
        }
        finally {
            wfs.setCiteCompliant(false);
            gs.save((ServiceInfo)wfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetWithConsistentResourceId() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setCiteCompliant(true);
        gs.save((ServiceInfo)wfs);
        try {
            Document doc = this.getAsDOM("wfs?request=GetFeature&typeNames=cdf:Fifteen&version=2.0.0&service=wfs&resourceid=Fifteen.2", 200);
            this.assertGML32(doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/wfs:member/cdf:Fifteen)", (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"Fifteen.2", (String)"//wfs:FeatureCollection/wfs:member/cdf:Fifteen/@gml:id", (Document)doc);
        }
        finally {
            wfs.setCiteCompliant(false);
            gs.save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testGetWithIdentifier() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typeName=sf:PrimitiveGeoFeatureId&BBOX=57.0,-4.5,62.0,1.0,EPSG:4326");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//sf:PrimitiveGeoFeatureId)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"f002", (String)"//sf:PrimitiveGeoFeatureId/gml:identifier", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)MockData.SF_URI, (String)"//sf:PrimitiveGeoFeatureId/gml:identifier/@codeSpace", (Document)dom);
    }

    @Test
    public void testGetWithBBOX() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typeName=sf:PrimitiveGeoFeature&BBOX=57.0,-4.5,62.0,1.0,EPSG:4326");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//sf:PrimitiveGeoFeature)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:PrimitiveGeoFeature/gml:name[text() = 'name-f002']", (Document)dom);
    }

    @Test
    public void testGetWithFilter() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&typeName=sf:PrimitiveGeoFeature&FILTER=%3Cfes%3AFilter+xmlns%3Agml%3D%22http%3A%2F%2Fwww.opengis.net%2Fgml%2F3.2%22+xmlns%3Afes%3D%22http%3A%2F%2Fwww.opengis.net%2Ffes%2F2.0%22%3E%3Cfes%3ABBOX%3E%3Cgml%3AEnvelope+srsName%3D%22EPSG%3A4326%22%3E%3Cgml%3AlowerCorner%3E57.0+-4.5%3C%2Fgml%3AlowerCorner%3E%3Cgml%3AupperCorner%3E62.0+1.0%3C%2Fgml%3AupperCorner%3E%3C%2Fgml%3AEnvelope%3E%3C%2Ffes%3ABBOX%3E%3C%2Ffes%3AFilter%3E");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//sf:PrimitiveGeoFeature)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:PrimitiveGeoFeature/gml:name[text() = 'name-f002']", (Document)dom);
    }

    @Test
    public void testPost() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:wfs='http://www.opengis.net/wfs/2.0' > <wfs:Query typeNames='cdf:Other'> <wfs:PropertyName>cdf:string2</wfs:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        this.assertGML32(doc);
        NodeList features = doc.getElementsByTagName("cdf:Other");
        Assert.assertFalse((features.getLength() == 0 ? 1 : 0) != 0);
        for (int i = 0; i < features.getLength(); ++i) {
            Element feature = (Element)features.item(i);
            Assert.assertTrue((boolean)feature.hasAttribute("gml:id"));
        }
    }

    @Test
    public void testPostMultipleQueriesDifferentNamespaces() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:wfs='http://www.opengis.net/wfs/2.0' > <wfs:Query typeNames='cdf:Other'/> <wfs:Query typeNames='sf:PrimitiveGeoFeature'/> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        this.print(doc);
        this.assertGML32(doc);
    }

    @Test
    public void testPostFormEncoded() throws Exception {
        String request = "wfs?service=WFS&version=2.0.0&request=GetFeature&typename=sf:PrimitiveGeoFeature&namespace=xmlns(" + URLEncoder.encode("sf=http://cite.opengeospatial.org/gmlsf", "UTF-8") + ")";
        Document doc = this.postAsDOM(request);
        this.assertGML32(doc);
        Assert.assertEquals((long)5L, (long)doc.getElementsByTagName("sf:PrimitiveGeoFeature").getLength());
    }

    @Test
    public void testPostWithFilter() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' outputFormat='text/xml; subtype=gml/3.2' xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0'><wfs:Query typeNames=\"cdf:Other\"> <fes:Filter> <fes:PropertyIsEqualTo> <fes:ValueReference>cdf:integers</fes:ValueReference> <fes:Literal>7</fes:Literal> </fes:PropertyIsEqualTo> </fes:Filter> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        this.assertGML32(doc);
        NodeList features = doc.getElementsByTagName("cdf:Other");
        Assert.assertFalse((features.getLength() == 0 ? 1 : 0) != 0);
        for (int i = 0; i < features.getLength(); ++i) {
            Element feature = (Element)features.item(i);
            Assert.assertTrue((boolean)feature.hasAttribute("gml:id"));
        }
    }

    @Test
    public void testPostWithBboxFilter() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' outputFormat='text/xml; subtype=gml/3.2' xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:gml='http://www.opengis.net/gml/3.2' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0'><wfs:Query typeNames='sf:PrimitiveGeoFeature'><fes:Filter><fes:BBOX>   <fes:ValueReference>pointProperty</fes:ValueReference>   <gml:Envelope srsName='EPSG:4326'>      <gml:lowerCorner>57.0 -4.5</gml:lowerCorner>      <gml:upperCorner>62.0 1.0</gml:upperCorner>   </gml:Envelope></fes:BBOX></fes:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        this.assertGML32(doc);
        NodeList features = doc.getElementsByTagName("sf:PrimitiveGeoFeature");
        Assert.assertEquals((long)1L, (long)features.getLength());
    }

    @Test
    public void testPostWithBboxFilterOnBoundedBy() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' outputFormat='text/xml; subtype=gml/3.2' xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:gml='http://www.opengis.net/gml/3.2' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0'><wfs:Query typeNames='sf:PrimitiveGeoFeature'><fes:Filter><fes:BBOX>   <fes:ValueReference>gml:boundedBy</fes:ValueReference>   <gml:Envelope srsName='EPSG:4326'>      <gml:lowerCorner>57.0 -4.5</gml:lowerCorner>      <gml:upperCorner>62.0 1.0</gml:upperCorner>   </gml:Envelope></fes:BBOX></fes:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        this.assertGML32(doc);
        NodeList features = doc.getElementsByTagName("sf:PrimitiveGeoFeature");
        Assert.assertEquals((long)1L, (long)features.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostWithLessThanOnBoundedBy() throws Exception {
        GeoServer gs = this.getGeoServer();
        WFSInfo wfs = (WFSInfo)gs.getService(WFSInfo.class);
        wfs.setCiteCompliant(true);
        gs.save((ServiceInfo)wfs);
        try {
            String xml = "<wfs:GetFeature service='WFS' version='2.0.0' outputFormat='text/xml; subtype=gml/3.2' xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:gml='http://www.opengis.net/gml/3.2' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0'><wfs:Query typeNames='sf:PrimitiveGeoFeature'><fes:Filter><fes:PropertyIsLessThanOrEqualTo matchAction=\"Any\" matchCase=\"true\">\n    <fes:Literal>\n      <gml:Envelope xmlns:gml=\"http://www.opengis.net/gml/3.2\"\n        srsName=\"urn:ogc:def:crs:EPSG::4326\">\n        <gml:lowerCorner>-90 -180</gml:lowerCorner>\n        <gml:upperCorner>90 180</gml:upperCorner>\n      </gml:Envelope>\n    </fes:Literal>\n    <fes:ValueReference>gml:boundedBy</fes:ValueReference>\n  </fes:PropertyIsLessThanOrEqualTo></fes:Filter></wfs:Query></wfs:GetFeature>";
            MockHttpServletResponse response = this.postAsServletResponse("wfs", xml);
            Assert.assertEquals((long)500L, (long)response.getStatus());
            Document doc = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
            this.checkOws11Exception(doc, "2.0.0", "OperationProcessingFailed", "GetFeature");
        }
        finally {
            wfs.setCiteCompliant(false);
            gs.save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testPostWithFailingUrnBboxFilter() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0'  outputFormat='text/xml; subtype=gml/3.2' xmlns:sf='http://cite.opengeospatial.org/gmlsf' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'><wfs:Query typeNames=\"sf:PrimitiveGeoFeature\"><fes:Filter><fes:BBOX>   <fes:PropertyName>pointProperty</fes:PropertyName>   <gml:Envelope srsName='urn:ogc:def:crs:EPSG:6.11.2:4326'>      <gml:lowerCorner>57.0 -4.5</gml:lowerCorner>      <gml:upperCorner>62.0 1.0</gml:upperCorner>   </gml:Envelope></fes:BBOX></fes:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        this.assertGML32(doc);
        NodeList features = doc.getElementsByTagName("sf:PrimitiveGeoFeature");
        Assert.assertEquals((long)0L, (long)features.getLength());
    }

    @Test
    public void testPostWithMatchingUrnBboxFilter() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0'  outputFormat='text/xml; subtype=gml/3.2' xmlns:sf='http://cite.opengeospatial.org/gmlsf' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'><wfs:Query typeNames=\"sf:PrimitiveGeoFeature\"><fes:Filter><fes:BBOX>   <fes:PropertyName>pointProperty</fes:PropertyName>   <gml:Envelope srsName='urn:ogc:def:crs:EPSG:6.11.2:4326'>      <gml:lowerCorner>-4.5 57.0</gml:lowerCorner>      <gml:upperCorner>1.0 62.0</gml:upperCorner>   </gml:Envelope></fes:BBOX></fes:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        this.assertGML32(doc);
        NodeList features = doc.getElementsByTagName("sf:PrimitiveGeoFeature");
        Assert.assertEquals((long)1L, (long)features.getLength());
    }

    @Test
    public void testPostWithFunctionFilter() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0'  outputFormat='text/xml; subtype=gml/3.2' xmlns:sf='http://cite.opengeospatial.org/gmlsf' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:gml='http://www.opengis.net/gml/3.2'><wfs:Query typeNames=\"sf:PrimitiveGeoFeature\"><fes:Filter><fes:PropertyIsLessThan><fes:Function name='random'></fes:Function><fes:Literal>0.5</fes:Literal></fes:PropertyIsLessThan></fes:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        this.assertGML32(doc);
    }

    @Test
    public void testResultTypeHitsGet() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=2.0.0&resultType=hits&service=wfs");
        this.print(doc);
        this.assertGML32(doc);
        NodeList features = doc.getElementsByTagName("cdf:Fifteen");
        Assert.assertEquals((long)0L, (long)features.getLength());
        Assert.assertEquals((Object)"15", (Object)doc.getDocumentElement().getAttribute("numberMatched"));
    }

    @Test
    public void testResultTypeHitsGetWithCount() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=2.0.0&resultType=hits&service=wfs&count=2");
        this.print(doc);
        this.assertGML32(doc);
        NodeList features = doc.getElementsByTagName("cdf:Fifteen");
        Assert.assertEquals((long)0L, (long)features.getLength());
        Assert.assertEquals((Object)"15", (Object)doc.getDocumentElement().getAttribute("numberMatched"));
        String nextLink = doc.getDocumentElement().getAttribute("next");
        Assert.assertNotNull((Object)nextLink);
        Map kvp = KvpUtils.parseQueryString((String)nextLink);
        Assert.assertEquals((Object)"results", kvp.get("RESULTTYPE"));
        Assert.assertEquals((Object)"2", kvp.get("COUNT"));
        Assert.assertEquals((Object)"0", kvp.get("STARTINDEX"));
    }

    @Test
    public void testResultTypeHitsPost() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' outputFormat='text/xml; subtype=gml/3.2' xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs='http://www.opengis.net/wfs/2.0' resultType='hits'> <wfs:Query typeNames=\"cdf:Seven\"/> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        this.assertGML32(doc);
        NodeList features = doc.getElementsByTagName("cdf:Seven");
        Assert.assertEquals((long)0L, (long)features.getLength());
        Assert.assertEquals((Object)"7", (Object)doc.getDocumentElement().getAttribute("numberMatched"));
    }

    @Test
    public void testResultTypeHitsNumReturnedMatched() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' outputFormat='text/xml; subtype=gml/3.2' xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs='http://www.opengis.net/wfs/2.0' resultType='hits'> <wfs:Query typeNames=\"cdf:Seven\"/> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        this.assertGML32(doc);
        Assert.assertEquals((Object)"7", (Object)doc.getDocumentElement().getAttribute("numberMatched"));
        Assert.assertEquals((Object)"0", (Object)doc.getDocumentElement().getAttribute("numberReturned"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResultTypeHitsNumberMatched() throws Exception {
        WFSInfo wfs = this.getWFS();
        int oldMaxFeatures = wfs.getMaxFeatures();
        boolean hitsIgnoreMaxFeatures = wfs.isHitsIgnoreMaxFeatures();
        try {
            wfs.setMaxFeatures(1);
            wfs.setHitsIgnoreMaxFeatures(true);
            this.getGeoServer().save((ServiceInfo)wfs);
            Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Seven&version=2.0.0&resultType=hits&service=wfs");
            this.assertGML32(doc);
            this.print(doc);
            Assert.assertEquals((Object)"7", (Object)doc.getDocumentElement().getAttribute("numberMatched"));
            Assert.assertEquals((Object)"0", (Object)doc.getDocumentElement().getAttribute("numberReturned"));
            doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Seven&version=2.0.0&resultType=results&service=wfs");
            this.assertGML32(doc);
            Assert.assertEquals((Object)"7", (Object)doc.getDocumentElement().getAttribute("numberMatched"));
            Assert.assertEquals((Object)"1", (Object)doc.getDocumentElement().getAttribute("numberReturned"));
            doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Seven&version=2.0.0&resultType=hits&service=wfs");
            wfs.setHitsIgnoreMaxFeatures(false);
            this.getGeoServer().save((ServiceInfo)wfs);
            Assert.assertEquals((Object)"7", (Object)doc.getDocumentElement().getAttribute("numberMatched"));
            Assert.assertEquals((Object)"0", (Object)doc.getDocumentElement().getAttribute("numberReturned"));
            doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Seven&version=2.0.0&resultType=results&service=wfs");
            this.assertGML32(doc);
            Assert.assertEquals((Object)"7", (Object)doc.getDocumentElement().getAttribute("numberMatched"));
            Assert.assertEquals((Object)"1", (Object)doc.getDocumentElement().getAttribute("numberReturned"));
        }
        finally {
            wfs.setMaxFeatures(oldMaxFeatures);
            wfs.setHitsIgnoreMaxFeatures(hitsIgnoreMaxFeatures);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNumReturnedMatchedWithMaxFeatures() throws Exception {
        WFSInfo wfs = this.getWFS();
        int oldMaxFeatures = wfs.getMaxFeatures();
        boolean oldHitsIgnoreMaxFeatures = wfs.isHitsIgnoreMaxFeatures();
        try {
            wfs.setMaxFeatures(1);
            wfs.setHitsIgnoreMaxFeatures(true);
            this.getGeoServer().save((ServiceInfo)wfs);
            Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Seven&version=2.0.0&resultType=results&service=wfs");
            this.assertGML32(doc);
            Assert.assertEquals((Object)"7", (Object)doc.getDocumentElement().getAttribute("numberMatched"));
            Assert.assertEquals((Object)"1", (Object)doc.getDocumentElement().getAttribute("numberReturned"));
        }
        finally {
            wfs.setMaxFeatures(oldMaxFeatures);
            wfs.setHitsIgnoreMaxFeatures(oldHitsIgnoreMaxFeatures);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testWithSRS() throws Exception {
        String xml = "<wfs:GetFeature version='2.0.0' service='WFS' xmlns:wfs='http://www.opengis.net/wfs/2.0' ><wfs:Query xmlns:cdf='http://www.opengis.net/cite/data' typeNames='cdf:Other' srsName='urn:ogc:def:crs:EPSG:4326'/></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        this.assertGML32(dom);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("cdf:Other").getLength());
    }

    @Test
    public void testWithSillyLiteral() throws Exception {
        String xml = "<wfs:GetFeature version='2.0.0' service='WFS' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:gml='http://www.opengis.net/gml/3.2' xmlns:fes='http://www.opengis.net/fes/2.0'><wfs:Query  typeNames='cdf:Other' srsName='urn:ogc:def:crs:EPSG:4326'><fes:Filter>  <fes:PropertyIsEqualTo>   <fes:ValueReference>description</fes:ValueReference>   <fes:Literal>       <wfs:Native vendorId=\"foo\" safeToIgnore=\"true\"/>   </fes:Literal>   </fes:PropertyIsEqualTo> </fes:Filter></wfs:Query></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        this.assertGML32(dom);
        Assert.assertEquals((long)0L, (long)dom.getElementsByTagName("cdf:Other").getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostWithBoundsEnabled() throws Exception {
        WFSInfo wfs = this.getWFS();
        boolean oldFeatureBounding = wfs.isFeatureBounding();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            String xml = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0'> <wfs:Query typeNames='cdf:Other'> </wfs:Query> </wfs:GetFeature>";
            Document doc = this.postAsDOM("wfs", xml);
            this.assertGML32(doc);
            NodeList aggregatedBoundList = doc.getElementsByTagName("wfs:boundedBy");
            Assert.assertFalse((aggregatedBoundList.getLength() == 0 ? 1 : 0) != 0);
            NodeList features = doc.getElementsByTagName("cdf:Other");
            Assert.assertFalse((features.getLength() == 0 ? 1 : 0) != 0);
            for (int i = 0; i < features.getLength(); ++i) {
                Element feature = (Element)features.item(i);
                Assert.assertTrue((boolean)feature.hasAttribute("gml:id"));
                NodeList boundList = feature.getElementsByTagName("gml:boundedBy");
                Assert.assertEquals((long)1L, (long)boundList.getLength());
                Element boundedBy = (Element)boundList.item(0);
                NodeList boxList = boundedBy.getElementsByTagName("gml:Envelope");
                Assert.assertEquals((long)1L, (long)boxList.getLength());
                Element box = (Element)boxList.item(0);
                Assert.assertTrue((boolean)box.hasAttribute("srsName"));
            }
        }
        finally {
            wfs.setFeatureBounding(oldFeatureBounding);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPostWithBoundsDisabled() throws Exception {
        WFSInfo wfs = this.getWFS();
        boolean oldFeatureBounding = wfs.isFeatureBounding();
        wfs.setFeatureBounding(false);
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            String xml = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0'> <wfs:Query typeNames='cdf:Other'> </wfs:Query> </wfs:GetFeature>";
            Document doc = this.postAsDOM("wfs", xml);
            this.assertGML32(doc);
            NodeList aggregatedBoundList = doc.getElementsByTagName("wfs:boundedBy");
            Assert.assertTrue((aggregatedBoundList.getLength() == 0 ? 1 : 0) != 0);
            NodeList features = doc.getElementsByTagName("cdf:Other");
            Assert.assertFalse((features.getLength() == 0 ? 1 : 0) != 0);
            for (int i = 0; i < features.getLength(); ++i) {
                Element feature = (Element)features.item(i);
                Assert.assertTrue((boolean)feature.hasAttribute("gml:id"));
                NodeList boundList = feature.getElementsByTagName("gml:boundedBy");
                Assert.assertEquals((long)0L, (long)boundList.getLength());
            }
        }
        finally {
            wfs.setFeatureBounding(oldFeatureBounding);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    @Test
    public void testAfterFeatureTypeAdded() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=2.0.0&typename=sf:new");
        Assert.assertEquals((Object)"ExceptionReport", (Object)dom.getDocumentElement().getLocalName());
        ((SystemTestData)this.getTestData()).addVectorLayer(new QName(SystemTestData.SF_URI, "new", SystemTestData.SF_PREFIX), Collections.EMPTY_MAP, org.geoserver.wfs.v1_1.GetFeatureTest.class, this.getCatalog());
        dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=2.0.0&typename=sf:new");
        this.print(dom);
        this.assertGML32(dom);
    }

    @Test
    public void testWithGMLProperties() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=2.0.0&typename=sf:WithGMLProperties");
        this.assertGML32(dom);
        NodeList features = dom.getElementsByTagName("sf:WithGMLProperties");
        Assert.assertEquals((long)1L, (long)features.getLength());
        for (int i = 0; i < features.getLength(); ++i) {
            Element feature = (Element)features.item(i);
            Assert.assertEquals((Object)"one", (Object)this.getFirstElementByTagName(feature, "gml:name").getFirstChild().getNodeValue());
            Assert.assertEquals((Object)"1", (Object)this.getFirstElementByTagName(feature, "sf:foo").getFirstChild().getNodeValue());
            Element location = this.getFirstElementByTagName(feature, "gml:location");
            Assert.assertNotNull((Object)this.getFirstElementByTagName(location, "gml:Point"));
        }
    }

    @Test
    public void testLayerQualified() throws Exception {
        this.testGetFifteenAll("cdf/Fifteen/wfs?request=GetFeature&typename=cdf:Fifteen&version=2.0.0&service=wfs");
        Document dom = this.getAsDOM("cdf/Seven/wfs?request=GetFeature&typename=cdf:Fifteen&version=2.0.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
    }

    @Test
    public void testUserSuppliedNamespacePrefix() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=myPrefix:Fifteen&version=2.0.0&service=wfs&namespaces=xmlns(myPrefix," + URLEncoder.encode(MockData.FIFTEEN.getNamespaceURI(), "UTF-8") + ")");
    }

    @Test
    public void testUserSuppliedDefaultNamespace() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=Fifteen&version=2.0.0&service=wfs&namespace=xmlns(" + URLEncoder.encode(MockData.FIFTEEN.getNamespaceURI(), "UTF-8") + ")");
    }

    @Test
    public void testGML32OutputFormat() throws Exception {
        this.testGetFifteenAll("wfs?request=getfeature&typename=cdf:Fifteen&version=2.0.0&service=wfs&outputFormat=gml32");
    }

    @Test
    public void testGML32OutputFormatAlternate() throws Exception {
        this.testGetFifteenAll("wfs?request=getfeature&typename=cdf:Fifteen&version=2.0.0&service=wfs&outputFormat=application/gml%2Bxml; version%3D3.2");
    }

    @Test
    public void testGMLAttributeMapping() throws Exception {
        WFSInfo wfs = this.getWFS();
        GMLInfo gml = (GMLInfo)wfs.getGML().get(WFSInfo.Version.V_11);
        gml.setOverrideGMLAttributes(Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)wfs);
        Document dom = this.getAsDOM("ows?service=WFS&version=2.0.0&request=GetFeature&typename=" + this.getLayerId(MockData.PRIMITIVEGEOFEATURE));
        XMLAssert.assertXpathExists((String)"//gml:name", (Document)dom);
        XMLAssert.assertXpathExists((String)"//gml:description", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//sf:name", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//sf:description", (Document)dom);
        gml.setOverrideGMLAttributes(Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)wfs);
        dom = this.getAsDOM("ows?service=WFS&version=2.0.0&request=GetFeature&typename=" + this.getLayerId(MockData.PRIMITIVEGEOFEATURE));
        XMLAssert.assertXpathNotExists((String)"//gml:name", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//gml:description", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:name", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:description", (Document)dom);
        gml.setOverrideGMLAttributes(Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    @Test
    public void testStoredQuery() throws Exception {
        String xml = "<wfs:CreateStoredQuery service='WFS' version='2.0.0'    xmlns:wfs='http://www.opengis.net/wfs/2.0'    xmlns:fes='http://www.opengis.net/fes/2.0'    xmlns:gml='http://www.opengis.net/gml/3.2'    xmlns:myns='http://www.someserver.com/myns'    xmlns:sf='" + MockData.SF_URI + "'>   <wfs:StoredQueryDefinition id='myStoredQuery'>       <wfs:Parameter name='integers' type='xs:integer'/>       <wfs:QueryExpressionText            returnFeatureTypes='cdf:Other'            language='urn:ogc:def:queryLanguage:OGC-WFS::WFS_QueryExpression'            isPrivate='false'> <wfs:Query typeNames=\"cdf:Other\"> <fes:Filter> <fes:PropertyIsEqualTo> <fes:ValueReference>cdf:integers</fes:ValueReference> ${integers}</fes:PropertyIsEqualTo> </fes:Filter> </wfs:Query>       </wfs:QueryExpressionText>    </wfs:StoredQueryDefinition> </wfs:CreateStoredQuery>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:CreateStoredQueryResponse", (Object)dom.getDocumentElement().getNodeName());
        xml = "<wfs:GetFeature service='WFS' version='2.0.0'        xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0'>   <wfs:StoredQuery id='myStoredQuery'>       <wfs:Parameter name='integers'>        <fes:Literal>7</fes:Literal>      </wfs:Parameter>    </wfs:StoredQuery> </wfs:GetFeature>";
        dom = this.postAsDOM("wfs", xml);
        this.print(dom);
        this.assertGML32(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//cdf:Other)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//cdf:Other/cdf:integers[text() = '7']", (Document)dom);
    }

    @Test
    public void testDefaultStoredQueryGet() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&storedQueryId=" + StoredQuery.DEFAULT.getName() + "&ID=PrimitiveGeoFeature.f001");
        XMLAssert.assertXpathNotExists((String)"//wfs:FeatureCollection", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sf:PrimitiveGeoFeature)", (Document)dom);
        XMLAssert.assertXpathExists((String)"/sf:PrimitiveGeoFeature[@gml:id = 'PrimitiveGeoFeature.f001']", (Document)dom);
    }

    @Test
    public void testUnknownStoredQuery() throws Exception {
        Document dom = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&storedQueryId=foobar", 400);
        this.checkOws11Exception(dom, "2.0.0", "InvalidParameterValue", "STOREDQUERY_ID");
    }

    @Test
    public void testDefaultStoredQueryGetWorkspaceQualified() throws Exception {
        Document dom = this.getAsDOM("sf/wfs?request=GetFeature&version=2.0.0&storedQueryId=" + StoredQuery.DEFAULT.getName() + "&ID=PrimitiveGeoFeature.f001");
        XMLAssert.assertXpathNotExists((String)"//wfs:FeatureCollection", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sf:PrimitiveGeoFeature)", (Document)dom);
        XMLAssert.assertXpathExists((String)"/sf:PrimitiveGeoFeature[@gml:id = 'PrimitiveGeoFeature.f001']", (Document)dom);
    }

    @Test
    public void testDefaultStoredQueryPost() throws Exception {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<wfs:GetFeature xmlns:wfs=\"http://www.opengis.net/wfs/2.0\" service=\"WFS\" startIndex=\"0\" version=\"2.0.0\">\n\t<wfs:StoredQuery id=\"urn:ogc:def:query:OGC-WFS::GetFeatureById\">\n\t\t<wfs:Parameter name=\"id\">PrimitiveGeoFeature.f001</wfs:Parameter>\n\t</wfs:StoredQuery>\n</wfs:GetFeature>\n";
        Document dom = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//sf:PrimitiveGeoFeature)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:PrimitiveGeoFeature[@gml:id = 'PrimitiveGeoFeature.f001']", (Document)dom);
        dom = this.getAsDOM("wfs?request=GetFeature&version=2.0.0&storedQuery_Id=" + StoredQuery.DEFAULT.getName() + "&ID=PrimitiveGeoFeature.f001");
        XMLAssert.assertXpathNotExists((String)"//wfs:FeatureCollection", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/sf:PrimitiveGeoFeature)", (Document)dom);
        XMLAssert.assertXpathExists((String)"/sf:PrimitiveGeoFeature[@gml:id = 'PrimitiveGeoFeature.f001']", (Document)dom);
    }

    @Test
    public void testStoredQueryBBOX() throws Exception {
        String xml = "<wfs:CreateStoredQuery service='WFS' version='2.0.0'    xmlns:wfs='http://www.opengis.net/wfs/2.0'    xmlns:fes='http://www.opengis.net/fes/2.0'    xmlns:gml='http://www.opengis.net/gml/3.2'    xmlns:myns='http://www.someserver.com/myns'    xmlns:sf='" + MockData.SF_URI + "'>   <wfs:StoredQueryDefinition id='myStoredBBOXQuery'>       <wfs:Parameter name='BBOX' type='gml:Envelope'/>       <wfs:QueryExpressionText            returnFeatureTypes='sf:PrimitiveGeoFeature'            language='urn:ogc:def:queryLanguage:OGC-WFS::WFS_QueryExpression'            isPrivate='false'> <wfs:Query typeNames='sf:PrimitiveGeoFeature'> <fes:Filter> <fes:BBOX>   <fes:ValueReference>pointProperty</fes:ValueReference>    ${BBOX}</fes:BBOX></fes:Filter> </wfs:Query>       </wfs:QueryExpressionText>    </wfs:StoredQueryDefinition> </wfs:CreateStoredQuery>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:CreateStoredQueryResponse", (Object)dom.getDocumentElement().getNodeName());
        xml = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:gml='http://www.opengis.net/gml/3.2'       xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0'>   <wfs:StoredQuery id='myStoredBBOXQuery'>       <wfs:Parameter name='BBOX'>   <gml:Envelope srsName='EPSG:4326'>      <gml:lowerCorner>57.0 -4.5</gml:lowerCorner>      <gml:upperCorner>62.0 1.0</gml:upperCorner>   </gml:Envelope>      </wfs:Parameter>    </wfs:StoredQuery> </wfs:GetFeature>";
        dom = this.postAsDOM("wfs", xml);
        this.print(dom);
        this.assertGML32(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//sf:PrimitiveGeoFeature)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:PrimitiveGeoFeature/gml:name[text() = 'name-f002']", (Document)dom);
    }

    @Test
    public void testTemporalFilter() throws Exception {
        this.print(this.getAsDOM("wfs?version=2.0.0&service=wfs&request=getfeature&typename=sf:PrimitiveGeoFeature&propertyName=dateProperty,dateTimeProperty"));
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' outputFormat='text/xml; subtype=gml/3.2' xmlns:sf='" + MockData.SF_URI + "' xmlns:wfs='" + "http://www.opengis.net/wfs/2.0" + "' xmlns:fes='" + "http://www.opengis.net/fes/2.0" + "'><wfs:Query typeNames=\"sf:PrimitiveGeoFeature\"> <fes:Filter> <fes:After> <fes:ValueReference>dateTimeProperty</fes:ValueReference> <fes:Literal>2006-06-25T18:00:00-06:00</fes:Literal> </fes:After> </fes:Filter> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//sf:PrimitiveGeoFeature)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:PrimitiveGeoFeature[@gml:id = 'PrimitiveGeoFeature.f008']", (Document)dom);
        xml = "<wfs:GetFeature service='WFS' version='2.0.0' outputFormat='text/xml; subtype=gml/3.2' xmlns:sf='" + MockData.SF_URI + "' xmlns:wfs='" + "http://www.opengis.net/wfs/2.0" + "' xmlns:fes='" + "http://www.opengis.net/fes/2.0" + "'><wfs:Query typeNames=\"sf:PrimitiveGeoFeature\"> <fes:Filter> <fes:Before> <fes:ValueReference>dateTimeProperty</fes:ValueReference> <fes:Literal>2006-06-27T18:00:00-06:00</fes:Literal> </fes:Before> </fes:Filter> </wfs:Query> </wfs:GetFeature>";
        dom = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//sf:PrimitiveGeoFeature)", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:PrimitiveGeoFeature[@gml:id = 'PrimitiveGeoFeature.f008']", (Document)dom);
    }

    @Test
    public void testGetFeatureInvalidPropertyName() throws Exception {
        Document dom = this.getAsDOM("wfs?version=2.0.0&service=wfs&request=GetFeature&typename=sf:PrimitiveGeoFeature&propertyName=foo");
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"//ows:Exception[@exceptionCode = 'InvalidParameterValue']", (Document)dom);
    }

    @Test
    public void testGetFeatureWithMultiplePropertyName() throws Exception {
        Document dom = this.getAsDOM("wfs?version=2.0.0&service=wfs&request=GetFeature&typename=cdf:Fifteen,cdf:Seven");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(wfs:FeatureCollection/wfs:member)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(wfs:FeatureCollection/wfs:member/wfs:FeatureCollection)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)"count(wfs:FeatureCollection/wfs:member[position() = 1]/wfs:FeatureCollection//cdf:Fifteen)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"7", (String)"count(wfs:FeatureCollection/wfs:member[position() = 2]/wfs:FeatureCollection//cdf:Seven)", (Document)dom);
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:wfs='http://www.opengis.net/wfs/2.0' > <wfs:Query typeNames='cdf:Fifteen'/> <wfs:Query typeNames='cdf:Seven'/> </wfs:GetFeature>";
        dom = this.getAsDOM("wfs?version=2.0.0&service=wfs&request=GetFeature&typename=cdf:Fifteen,cdf:Seven");
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(wfs:FeatureCollection/wfs:member)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(wfs:FeatureCollection/wfs:member/wfs:FeatureCollection)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)"count(wfs:FeatureCollection/wfs:member[position() = 1]/wfs:FeatureCollection//cdf:Fifteen)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"7", (String)"count(wfs:FeatureCollection/wfs:member[position() = 2]/wfs:FeatureCollection//cdf:Seven)", (Document)dom);
    }

    @Test
    public void testSOAP11() throws Exception {
        String xml = "<soap:Envelope xmlns:soap='http://schemas.xmlsoap.org/soap/envelope/'>  <soap:Header/>  <soap:Body><wfs:GetFeature service='WFS' version='2.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:wfs='http://www.opengis.net/wfs/2.0' > <wfs:Query typeNames='cdf:Other'> <wfs:PropertyName>cdf:string2</wfs:PropertyName> </wfs:Query> </wfs:GetFeature> </soap:Body> </soap:Envelope> ";
        MockHttpServletResponse resp = this.postAsServletResponse("wfs", xml, "application/soap+xml");
        Assert.assertEquals((Object)"application/soap+xml", (Object)resp.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(resp.getContentAsByteArray()));
        Assert.assertEquals((Object)"http://schemas.xmlsoap.org/soap/envelope/", (Object)dom.getDocumentElement().getAttribute("xmlns:soap"));
    }

    @Test
    public void testSOAP12() throws Exception {
        String xml = "<soap:Envelope xmlns:soap='http://www.w3.org/2003/05/soap-envelope'>  <soap:Header/>  <soap:Body><wfs:GetFeature service='WFS' version='2.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:wfs='http://www.opengis.net/wfs/2.0' > <wfs:Query typeNames='cdf:Other'> <wfs:PropertyName>cdf:string2</wfs:PropertyName> </wfs:Query> </wfs:GetFeature> </soap:Body> </soap:Envelope> ";
        MockHttpServletResponse resp = this.postAsServletResponse("wfs", xml, "application/soap+xml");
        Assert.assertEquals((Object)"application/soap+xml", (Object)resp.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(resp.getContentAsByteArray()));
        Assert.assertEquals((Object)"http://www.w3.org/2003/05/soap-envelope", (Object)dom.getDocumentElement().getAttribute("xmlns:soap"));
    }

    @Test
    public void testSOAPWithEntity() throws Exception {
        String xml = "<!DOCTYPE Envelope [<!ELEMENT Envelope ANY><!ENTITY xxe SYSTEM \"file:///this/file/does/not/exist\">]><soap:Envelope xmlns:soap='http://www.w3.org/2003/05/soap-envelope'>  <soap:Header/>  <soap:Body><wfs:GetFeature service='WFS' version='2.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:wfs='http://www.opengis.net/wfs/2.0' > <wfs:Query typeNames='cdf:Other'> <wfs:PropertyName>&xxe;</wfs:PropertyName> </wfs:Query> </wfs:GetFeature> </soap:Body> </soap:Envelope> ";
        MockHttpServletResponse resp = this.postAsServletResponse("wfs", xml, "application/soap+xml");
        Assert.assertEquals((Object)"application/soap+xml", (Object)resp.getContentType());
        String message = resp.getContentAsString();
        Assert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)"Entity resolution disallowed"));
    }

    @Test
    public void testBogusSrsName() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:wfs='http://www.opengis.net/wfs/2.0' > <wfs:Query typeNames='cdf:Other' srsName='EPSG:XYZ'> <wfs:PropertyName>cdf:string2</wfs:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidParameterValue", (String)"//ows:Exception/@exceptionCode", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"srsName", (String)"//ows:Exception/@locator", (Document)dom);
        dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=getFeature&typeName=cdf:Other&srsName=EPSG:XYZ");
        Assert.assertEquals((Object)"ows:ExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidParameterValue", (String)"//ows:Exception/@exceptionCode", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"srsName", (String)"//ows:Exception/@locator", (Document)dom);
    }

    @Test
    public void testQueryHandleInExceptionReport() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' > <wfs:Query typeNames='cdf:Other' srsName='EPSG:XYZ' handle='myHandle'> <fes:Filter><fes:PropertyIsEqualTo><fes:ValueReference>foobar</fes:ValueReference><fes:Literal>xyz</fes:Literal></fes:PropertyIsEqualTo></fes:Filter></wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"myHandle", (String)"//ows:Exception/@locator", (Document)dom);
    }

    @Test
    public void testBogusTypeNames() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:wfs='http://www.opengis.net/wfs/2.0' > <wfs:Query typeNames='foobbar'> </wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidParameterValue", (String)"//ows:Exception/@exceptionCode", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"typeName", (String)"//ows:Exception/@locator", (Document)dom);
        dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=getFeature&typeNames=foobar");
        XMLAssert.assertXpathEvaluatesTo((String)"InvalidParameterValue", (String)"//ows:Exception/@exceptionCode", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"typeName", (String)"//ows:Exception/@locator", (Document)dom);
    }

    @Test
    public void testInvalidRequest() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:fes='http://www.opengis.net/fes/2.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' > <wfs:Query typeNames='cdf:Other' srsName='EPSG:XYZ' handle='myHandle'> <fes:Filter><fes:PropertyIsEqualTo><fes:ValueReference>foobar</fes:ValueReference><fes:Literal>xyz</fes:Literal></fes:PropertyIsEqualTo></fes:foo></wfs:Query> </wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"OperationParsingFailed", (String)"//ows:Exception/@exceptionCode", (Document)dom);
    }

    @Test
    public void testWfs11AndGML32() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=cdf:Fifteen&version=1.1.0&service=wfs&featureid=Fifteen.2&outputFormat=gml32");
        this.assertGML32(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/wfs:member/cdf:Fifteen)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Fifteen.2", (String)"//wfs:FeatureCollection/wfs:member/cdf:Fifteen/@gml:id", (Document)doc);
    }

    @Test
    public void testGml32MimeType() throws Exception {
        String url = "wfs?request=GetFeature&typeName=cdf:Fifteen&version=2.0&service=wfs&featureid=Fifteen.2&outputFormat=gml32";
        MockHttpServletResponse response = this.getAsServletResponse(url);
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"application/gml+xml; version=3.2"));
        this.setGmlMimeTypeOverride("text/xml");
        response = this.getAsServletResponse(url);
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"text/xml"));
        this.setGmlMimeTypeOverride(null);
        String xml = "<wfs:GetFeature service='WFS' version='2.0.0'                xmlns:cdf='http://www.opengis.net/cite/data'                xmlns:wfs='http://www.opengis.net/wfs/2.0'>    <wfs:Query typeNames='cdf:Other'>        <wfs:PropertyName>cdf:string2</wfs:PropertyName>    </wfs:Query></wfs:GetFeature>";
        response = this.postAsServletResponse("wfs", xml);
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"application/gml+xml; version=3.2"));
        this.setGmlMimeTypeOverride("text/xml");
        response = this.postAsServletResponse("wfs", xml);
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"text/xml"));
    }

    private void checkPropertyIsLikeMatchCase(Boolean matchCase, int expectedBuildings) throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"2.0.0\"         xmlns:wfs=\"http://www.opengis.net/wfs/2.0\"         xmlns:fes=\"http://www.opengis.net/fes/2.0\"         xmlns:cite=\"http://www.opengis.net/cite\">    <wfs:Query typeNames=\"cite:Buildings\">        <fes:Filter>            <fes:PropertyIsLike wildCard=\"*\" singleChar=\"%\" escapeChar=\"!\"" + (matchCase == null ? "" : " matchCase=\"" + matchCase + "\"") + ">                <fes:ValueReference>cite:ADDRESS</fes:ValueReference>                <fes:Literal>* MAIN STREET</fes:Literal>            </fes:PropertyIsLike>        </fes:Filter>    </wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        Assert.assertEquals((Object)"wfs:FeatureCollection", (Object)doc.getDocumentElement().getNodeName());
        Assert.assertEquals((long)expectedBuildings, (long)doc.getElementsByTagName("cite:Buildings").getLength());
    }

    @Test
    public void testPropertyIsLikeWithoutMatchCase() throws Exception {
        this.checkPropertyIsLikeMatchCase(null, 0);
    }

    @Test
    public void testPropertyIsLikeMatchCaseTrue() throws Exception {
        this.checkPropertyIsLikeMatchCase(true, 0);
    }

    @Test
    public void testPropertyIsLikeMatchCaseFalse() throws Exception {
        this.checkPropertyIsLikeMatchCase(false, 2);
    }

    @Test
    public void testNumberOfDecimals() throws Exception {
        int oldDecimals = this.setDecimals(MockData.NAMED_PLACES, 3);
        try {
            Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=cite:NamedPlaces&version=2.0.0&service=wfs&featureId=NamedPlaces.1107531895891");
            XMLAssert.assertXpathEvaluatesTo((String)"-0.001 0.002 -0.001 0.002 -0.001 0.003 -0.001 0.003 -0.001 0.002", (String)"//gml:posList", (Document)doc);
            this.setDecimals(MockData.NAMED_PLACES, 4);
            doc = this.getAsDOM("wfs?request=GetFeature&typeName=cite:NamedPlaces&version=2.0.0&service=wfs&featureId=NamedPlaces.1107531895891");
            XMLAssert.assertXpathEvaluatesTo((String)"-0.0011 0.0017 -6.0E-4 0.0017 -6.0E-4 0.0025 -0.0011 0.0025 -0.0011 0.0017", (String)"//gml:posList", (Document)doc);
        }
        finally {
            this.setDecimals(MockData.NAMED_PLACES, oldDecimals);
        }
    }

    private int setDecimals(QName name, int numDecimals) {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ft = catalog.getFeatureTypeByName(this.getLayerId(name));
        int decimals = ft.getNumDecimals();
        ft.setNumDecimals(numDecimals);
        catalog.save((ResourceInfo)ft);
        return decimals;
    }
}

