/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.v2_0.FESConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.junit.Assert;
import org.junit.Test;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.Identifier;
import org.w3c.dom.Document;

public class GetFeaturePagingTest
extends WFS20TestSupport {
    @Override
    protected void setUpInternal(SystemTestData data) throws Exception {
        Catalog cat = this.getCatalog();
        DataStoreInfo ds = cat.getFactory().createDataStore();
        ds.setName("foo");
        ds.setWorkspace(cat.getDefaultWorkspace());
        ds.setEnabled(true);
        Map params = ds.getConnectionParameters();
        params.put("dbtype", "h2");
        params.put("database", ((SystemTestData)this.getTestData()).getDataDirectoryRoot().getAbsolutePath());
        cat.add((StoreInfo)ds);
        SimpleFeatureSource fs1 = this.getFeatureSource(SystemTestData.FIFTEEN);
        SimpleFeatureSource fs2 = this.getFeatureSource(SystemTestData.SEVEN);
        DataStore store = (DataStore)ds.getDataStore(null);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)fs1.getSchema());
        tb.add("num", Integer.class);
        tb.remove("boundedBy");
        store.createSchema((FeatureType)tb.buildFeatureType());
        tb.init((SimpleFeatureType)fs2.getSchema());
        tb.add("num", Integer.class);
        tb.remove("boundedBy");
        store.createSchema((FeatureType)tb.buildFeatureType());
        CatalogBuilder cb = new CatalogBuilder(cat);
        cb.setStore((StoreInfo)ds);
        FeatureStore fs = (FeatureStore)store.getFeatureSource("Fifteen");
        this.addFeatures(fs, fs1.getFeatures());
        FeatureTypeInfo ft = cb.buildFeatureType((FeatureSource)fs);
        cat.add((ResourceInfo)ft);
        fs = (FeatureStore)store.getFeatureSource("Seven");
        this.addFeatures(fs, fs2.getFeatures());
        ft = cb.buildFeatureType((FeatureSource)fs);
        cat.add((ResourceInfo)ft);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFeatures(FeatureStore fs, FeatureCollection features) throws Exception {
        SimpleFeatureBuilder b = new SimpleFeatureBuilder((SimpleFeatureType)fs.getSchema());
        DefaultFeatureCollection toAdd = new DefaultFeatureCollection(null, null);
        try (FeatureIterator it = features.features();){
            SimpleFeature f = null;
            int i = 0;
            while (it.hasNext()) {
                f = (SimpleFeature)it.next();
                b.init(f);
                b.add(f.getAttribute("pointProperty"));
                b.add((Object)i++);
                toAdd.add(b.buildFeature(null));
            }
        }
        fs.addFeatures((FeatureCollection)toAdd);
    }

    @Test
    public void testSingleType() throws Exception {
        this.doTestSingleType("gs:Fifteen");
        this.doTestSingleType("cdf:Fifteen");
    }

    void doTestSingleType(String typeName) throws Exception {
        Document doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=10");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=16");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=0");
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=1&count=1");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=16&count=1");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + typeName + ")"), (Document)doc);
    }

    @Test
    public void testStartIndexSimplePOST() throws Exception {
        this.doTestStartIndexSimplePOST("gs:Fifteen");
        this.doTestStartIndexSimplePOST("cdf:Fifteen");
    }

    void doTestStartIndexSimplePOST(String typeName) throws Exception {
        Document doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 10, -1));
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 16, -1));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 0, -1));
        XMLAssert.assertXpathEvaluatesTo((String)"15", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 1, 1));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 16, 1));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + typeName + ")"), (Document)doc);
    }

    String startIndexSimpleXML(String typeName, int startIndex, int count) {
        String xml = "<GetFeature version='2.0.0'";
        if (startIndex > -1) {
            xml = xml + " startIndex='" + startIndex + "'";
        }
        if (count > -1) {
            xml = xml + " count='" + count + "'";
        }
        xml = xml + "> <Query typeNames='" + typeName + "'> </Query></GetFeature>";
        return xml;
    }

    @Test
    public void testStartIndexMultipleTypes() throws Exception {
        this.doTestStartIndexMultipleTypes("gs:Fifteen", "gs:Seven");
        this.doTestStartIndexMultipleTypes("cdf:Fifteen", "cdf:Seven");
    }

    public void doTestStartIndexMultipleTypes(String fifteen, String seven) throws Exception {
        String typeNames = fifteen + "," + seven;
        Document doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeNames + "&startIndex=10");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"7", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeNames + "&startIndex=16");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"6", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeNames + "&startIndex=10&count=5");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeNames + "&startIndex=10&count=6");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeNames + "&startIndex=25");
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + seven + ")"), (Document)doc);
    }

    @Test
    public void testStartIndexMultipleTypesPOST() throws Exception {
        this.doTestStartIndexMultipleTypesPOST("gs:Fifteen", "gs:Seven");
        this.doTestStartIndexMultipleTypesPOST("cdf:Fifteen", "cdf:Seven");
    }

    public void doTestStartIndexMultipleTypesPOST(String fifteen, String seven) throws Exception {
        Document doc = this.postAsDOM("wfs", this.startIndexMultiXML(fifteen, seven, 10, -1));
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"7", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexMultiXML(fifteen, seven, 16, -1));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"6", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexMultiXML(fifteen, seven, 10, 5));
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexMultiXML(fifteen, seven, 10, 6));
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + seven + ")"), (Document)doc);
        doc = this.postAsDOM("wfs", this.startIndexMultiXML(fifteen, seven, 25, -1));
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + fifteen + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + seven + ")"), (Document)doc);
    }

    String startIndexMultiXML(String fifteen, String seven, int startIndex, int count) {
        String xml = "<GetFeature version=\"2.0.0\" startIndex='" + startIndex + "'";
        if (count > -1) {
            xml = xml + " count='" + count + "'";
        }
        xml = xml + "> <Query typeNames='" + fifteen + "'> </Query> <Query typeNames='" + seven + "'> </Query></GetFeature>";
        return xml;
    }

    @Test
    public void testWithFilter() throws Exception {
        this.doTestWithFilter("gs:Fifteen");
        this.doTestWithFilter("cdf:Fifteen");
    }

    public void doTestWithFilter(String typeName) throws Exception {
        Document doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=10");
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + typeName + ")"), (Document)doc);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=10&count=4");
        XMLAssert.assertXpathEvaluatesTo((String)"4", (String)("count(//" + typeName + ")"), (Document)doc);
        String xml = String.format("<GetFeature version='2.0.0' startIndex='%d' count='%d'><Query typeNames = '%s'/></GetFeature>", 10, 100, typeName);
        doc = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)("count(//" + typeName + ")"), (Document)doc);
        xml = String.format("<GetFeature version='2.0.0' xmlns:gml='http://www.opengis.net/gml/2.0' xmlns:fes='http://www.opengis.net/fes/2.0' startIndex='%d' count='%d'><Query typeNames = '%s'>  <fes:Filter>   <fes:ResourceId rid='%s'></fes:ResourceId>   <fes:ResourceId rid='%s'></fes:ResourceId>   <fes:ResourceId rid='%s'></fes:ResourceId>  </fes:Filter></Query></GetFeature>", 1, 100, typeName, "Fifteen.3", "Fifteen.4", "Fifteen.5");
        doc = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)("count(//" + typeName + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)("count(//" + typeName + "[@gml:id='Fifteen.3'])"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + "[@gml:id='Fifteen.4'])"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + "[@gml:id='Fifteen.5'])"), (Document)doc);
    }

    @Test
    public void testNextPreviousGET() throws Exception {
        this.doTestNextPreviousGET("gs:Fifteen");
        this.doTestNextPreviousGET("cdf:Fifteen");
    }

    @Test
    public void testNextPreviousSkipNumberMatchedGET() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("Fifteen");
        fti.setSkipNumberMatched(true);
        this.getCatalog().save((ResourceInfo)fti);
        try {
            Assert.assertEquals((Object)true, (Object)fti.getSkipNumberMatched());
            this.doTestNextPreviousGET("gs:Fifteen");
            this.doTestNextPreviousGET("cdf:Fifteen");
        }
        finally {
            fti.setSkipNumberMatched(false);
            this.getCatalog().save((ResourceInfo)fti);
        }
    }

    public void doTestNextPreviousGET(String typeName) throws Exception {
        Document doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&count=5");
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("previous"));
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("next"));
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=0&count=5");
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("previous"));
        this.assertStartIndexCount(doc, "next", 5, 5);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=5&count=7");
        this.assertStartIndexCount(doc, "previous", 0, 5);
        this.assertStartIndexCount(doc, "next", 12, 7);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=12&count=7");
        this.assertStartIndexCount(doc, "previous", 5, 7);
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("next"));
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=15");
        this.assertStartIndexCount(doc, "previous", 0, 15);
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("next"));
    }

    public void doTestNextPreviousMultipleTypesGET(String fifteen, String seven) throws Exception {
        Document doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + fifteen + "&count=5");
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("previous"));
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("next"));
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + fifteen + "&startIndex=0&count=5");
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("previous"));
        this.assertStartIndexCount(doc, "next", 5, 5);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + fifteen + "&startIndex=5&count=7");
        this.assertStartIndexCount(doc, "previous", 0, 5);
        this.assertStartIndexCount(doc, "next", 12, 3);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + seven + "&startIndex=15");
        this.assertStartIndexCount(doc, "previous", 0, 15);
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("next"));
    }

    @Test
    public void testNextPreviousPOST() throws Exception {
        this.doTestNextPreviousPOST("gs:Fifteen");
        this.doTestNextPreviousPOST("cdf:Fifteen");
    }

    public void doTestNextPreviousPOST(String typeName) throws Exception {
        Document doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, -1, 5));
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("previous"));
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("next"));
        doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 0, 5));
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("previous"));
        this.assertStartIndexCount(doc, "next", 5, 5);
        doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 5, 7));
        this.assertStartIndexCount(doc, "previous", 0, 5);
        this.assertStartIndexCount(doc, "next", 12, 7);
        doc = this.postAsDOM("wfs", this.startIndexSimpleXML(typeName, 15, -1));
        this.assertStartIndexCount(doc, "previous", 0, 15);
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("next"));
    }

    void assertStartIndexCount(Document doc, String att, int startIndex, int count) {
        Assert.assertTrue((boolean)doc.getDocumentElement().hasAttribute(att));
        String s = doc.getDocumentElement().getAttribute(att);
        String[] kvp = s.split("\\?")[1].split("&");
        int actualStartIndex = -1;
        int actualCount = -1;
        for (int i = 0; i < kvp.length; ++i) {
            String k = kvp[i].split("=")[0];
            String v = kvp[i].split("=")[1];
            if ("startIndex".equalsIgnoreCase(k)) {
                actualStartIndex = Integer.parseInt(v);
            }
            if (!"count".equalsIgnoreCase(k)) continue;
            actualCount = Integer.parseInt(v);
        }
        Assert.assertEquals((long)startIndex, (long)actualStartIndex);
        Assert.assertEquals((long)count, (long)actualCount);
    }

    @Test
    public void testNextPreviousLinksPOST() throws Exception {
        this.doTestNextPreviousLinksPOST("gs:Fifteen");
    }

    public void doTestNextPreviousLinksPOST(String typeName) throws Exception {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Id filter = ff.id(new LinkedHashSet<FeatureId>(Arrays.asList(ff.featureId("Fifteen.5"), ff.featureId("Fifteen.6"), ff.featureId("Fifteen.7"), ff.featureId("Fifteen.8"), ff.featureId("Fifteen.9"))));
        String xml = String.format("<GetFeature version='2.0.0' xmlns:gml='http://www.opengis.net/gml/2.0' xmlns:fes='http://www.opengis.net/fes/2.0' startIndex='%d' count='%d'><Query typeNames = '%s'>  <fes:Filter>   <fes:ResourceId rid='%s'></fes:ResourceId>   <fes:ResourceId rid='%s'></fes:ResourceId>   <fes:ResourceId rid='%s'></fes:ResourceId>   <fes:ResourceId rid='%s'></fes:ResourceId>   <fes:ResourceId rid='%s'></fes:ResourceId>  </fes:Filter></Query></GetFeature>", 0, 2, typeName, "Fifteen.5", "Fifteen.6", "Fifteen.7", "Fifteen.8", "Fifteen.9");
        Document doc = this.postAsDOM("wfs", xml);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)("count(//" + typeName + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + "[@gml:id='Fifteen.5'])"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + "[@gml:id='Fifteen.6'])"), (Document)doc);
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("previous"));
        Assert.assertTrue((boolean)doc.getDocumentElement().hasAttribute("next"));
        String next = doc.getDocumentElement().getAttribute("next");
        this.assertKvp(2, 2, typeName, (Filter)filter, (Map)this.toKvpMap(next));
        doc = this.getAsDOM(next.substring(next.indexOf("wfs")));
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)("count(//" + typeName + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + "[@gml:id='Fifteen.7'])"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + "[@gml:id='Fifteen.8'])"), (Document)doc);
        Assert.assertTrue((boolean)doc.getDocumentElement().hasAttribute("previous"));
        Assert.assertTrue((boolean)doc.getDocumentElement().hasAttribute("next"));
        String prev = doc.getDocumentElement().getAttribute("previous");
        this.assertKvp(0, 2, typeName, (Filter)filter, (Map)this.toKvpMap(prev));
        next = doc.getDocumentElement().getAttribute("next");
        this.assertKvp(4, 2, typeName, (Filter)filter, (Map)this.toKvpMap(next));
        doc = this.getAsDOM(next.substring(next.indexOf("wfs")));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + ")"), (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//" + typeName + "[@gml:id='Fifteen.9'])"), (Document)doc);
        Assert.assertTrue((boolean)doc.getDocumentElement().hasAttribute("previous"));
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("next"));
        prev = doc.getDocumentElement().getAttribute("previous");
        this.assertKvp(2, 2, typeName, (Filter)filter, (Map)this.toKvpMap(prev));
    }

    void assertKvp(int startIndex, int count, String typeName, Filter filter, Map kvp) throws Exception {
        Assert.assertEquals((Object)String.valueOf(startIndex), kvp.get("STARTINDEX"));
        Assert.assertEquals((Object)String.valueOf(count), kvp.get("COUNT"));
        Assert.assertEquals((Object)("(" + typeName + ")"), (Object)URLDecoder.decode((String)kvp.get("TYPENAMES")));
        Assert.assertNotNull(kvp.get("FILTER"));
        this.assertFilter(filter, URLDecoder.decode((String)kvp.get("FILTER")));
    }

    void assertFilter(Filter expected, String filter) throws Exception {
        filter = filter.substring(1, filter.length() - 1);
        Filter f = (Filter)new Parser((Configuration)new FESConfiguration()).parse((InputStream)new ByteArrayInputStream(filter.getBytes()));
        if (expected instanceof Id) {
            HashSet<String> s1 = new HashSet<String>();
            for (Identifier id : ((Id)expected).getIdentifiers()) {
                s1.add(id.toString());
            }
            HashSet<String> s2 = new HashSet<String>();
            for (Identifier id : ((Id)f).getIdentifiers()) {
                s2.add(id.toString());
            }
            Assert.assertEquals(s1, s2);
        } else {
            Assert.assertEquals((Object)expected, (Object)f);
        }
    }

    KvpMap toKvpMap(String url) {
        url = url.substring(url.indexOf(63) + 1);
        String[] kvps = url.split("\\&");
        KvpMap map = new KvpMap();
        for (String kvp : kvps) {
            map.put((Object)kvp.split("=")[0], (Object)kvp.split("=")[1]);
        }
        return map;
    }

    @Test
    public void testSortingGET() throws Exception {
        Document dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=GetFeature&typeName=gs:Fifteen&sortBy=num ASC&count=1");
        XMLAssert.assertXpathExists((String)"//gs:Fifteen/gs:num[text() = '0']", (Document)dom);
        dom = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=GetFeature&typeName=gs:Fifteen&sortBy=num DESC&count=1");
        XMLAssert.assertXpathExists((String)"//gs:Fifteen/gs:num[text() = '14']", (Document)dom);
    }

    @Test
    public void testNextPreviousHitsGET() throws Exception {
        this.doTestNextPreviousHitsGET("gs:Fifteen");
        this.doTestNextPreviousHitsGET("cdf:Fifteen");
    }

    public void doTestNextPreviousHitsGET(String typeName) throws Exception {
        Document doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&count=5&resulttype=hits");
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("previous"));
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=0&count=5&resulttype=hits");
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("previous"));
        this.assertStartIndexCount(doc, "next", 0, 5);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=5&count=7&resulttype=hits");
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("previous"));
        this.assertStartIndexCount(doc, "next", 0, 7);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=12&count=7&resulttype=hits");
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("previous"));
        this.assertStartIndexCount(doc, "next", 0, 7);
        doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=" + typeName + "&startIndex=15&resulttype=hits");
        Assert.assertFalse((boolean)doc.getDocumentElement().hasAttribute("previous"));
        this.assertStartIndexCount(doc, "next", 0, -1);
    }

    @Test
    public void testCountZero() throws Exception {
        Document doc = this.getAsDOM("/wfs?request=GetFeature&version=2.0.0&service=wfs&typename=gs:Fifteen&count=0");
        XMLAssert.assertXpathExists((String)"/wfs:FeatureCollection", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"/wfs:FeatureCollection/@numberMatched", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"/wfs:FeatureCollection/@numberReturned", (Document)doc);
    }
}

