/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import java.io.ByteArrayInputStream;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DescribeFeatureTypeTest
extends WFS20TestSupport {
    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        DataStoreInfo di = this.getCatalog().getDataStoreByName(CiteTestData.CITE_PREFIX);
        di.setEnabled(false);
        this.getCatalog().save((StoreInfo)di);
    }

    @Override
    protected void setUpNamespaces(Map<String, String> namespaces) {
        super.setUpNamespaces(namespaces);
        namespaces.put("soap", "http://www.w3.org/2003/05/soap-envelope");
    }

    @Test
    public void testGet() throws Exception {
        String typeName = this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE);
        MockHttpServletResponse response = this.getAsServletResponse("wfs?service=WFS&version=2.0.0&request=DescribeFeatureType&typeName=" + typeName);
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"application/gml+xml; version=3.2"));
        Document doc = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        this.assertSchema(doc, CiteTestData.PRIMITIVEGEOFEATURE);
        this.setGmlMimeTypeOverride("text/xml");
        response = this.getAsServletResponse("wfs?service=WFS&version=2.0.0&request=DescribeFeatureType&typeName=" + typeName);
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"text/xml"));
    }

    @Test
    public void testGetPluralKey() throws Exception {
        String typeName = this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE);
        MockHttpServletResponse response = this.getAsServletResponse("wfs?service=WFS&version=2.0.0&request=DescribeFeatureType&typeNames=" + typeName);
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"application/gml+xml; version=3.2"));
        Document doc = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        this.assertSchema(doc, CiteTestData.PRIMITIVEGEOFEATURE);
        this.setGmlMimeTypeOverride("text/xml");
        response = this.getAsServletResponse("wfs?service=WFS&version=2.0.0&request=DescribeFeatureType&typeName=" + typeName);
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"text/xml"));
    }

    @Test
    public void testConcurrentGet() throws Exception {
        int i;
        String typeName = this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE);
        ExecutorCompletionService<Object> es = new ExecutorCompletionService<Object>(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
        int REQUESTS = 200;
        for (i = 0; i < 200; ++i) {
            es.submit(() -> {
                Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=DescribeFeatureType&typeName=" + typeName);
                this.assertSchema(doc, CiteTestData.PRIMITIVEGEOFEATURE);
                return null;
            });
        }
        for (i = 0; i < 200; ++i) {
            es.take().get();
        }
    }

    @Test
    public void testPost() throws Exception {
        String typeName = this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE);
        String xml = "<wfs:DescribeFeatureType service='WFS' version='2.0.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:sf='" + CiteTestData.PRIMITIVEGEOFEATURE.getNamespaceURI() + "'> <wfs:TypeName>" + typeName + "</wfs:TypeName></wfs:DescribeFeatureType>";
        MockHttpServletResponse response = this.postAsServletResponse("wfs", xml);
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"application/gml+xml; version=3.2"));
        Document doc = this.dom(new ByteArrayInputStream(response.getContentAsString().getBytes()));
        this.assertSchema(doc, CiteTestData.PRIMITIVEGEOFEATURE);
        this.setGmlMimeTypeOverride("text/xml");
        response = this.postAsServletResponse("wfs", xml);
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"text/xml"));
    }

    @Test
    public void testConcurrentPost() throws Exception {
        int i;
        String typeName = this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE);
        ExecutorCompletionService<Object> es = new ExecutorCompletionService<Object>(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
        int REQUESTS = 200;
        for (i = 0; i < 200; ++i) {
            es.submit(() -> {
                Document doc = this.getAsDOM("wfs?service=WFS&version=2.0.0&request=DescribeFeatureType&typeName=" + typeName);
                this.assertSchema(doc, CiteTestData.PRIMITIVEGEOFEATURE);
                return null;
            });
        }
        for (i = 0; i < 200; ++i) {
            long start = System.currentTimeMillis();
            es.take().get();
            if (i % 100 != 0) continue;
            long curr = System.currentTimeMillis();
            LOGGER.info(i + " - " + (curr - start));
            start = curr;
        }
    }

    void assertSchema(Document doc, QName ... types) throws Exception {
        Assert.assertEquals((Object)"xsd:schema", (Object)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathExists((String)"//xsd:import[@namespace='http://www.opengis.net/gml/3.2']", (Document)doc);
        for (QName type : types) {
            String eName = type.getLocalPart();
            String tName = eName + "Type";
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//xsd:complexType[@name='" + tName + "'])"), (Document)doc);
            XMLAssert.assertXpathEvaluatesTo((String)"1", (String)("count(//xsd:element[@name='" + eName + "'])"), (Document)doc);
        }
    }

    @Test
    public void testDateMappings() throws Exception {
        String typeName = this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE);
        String xml = "<wfs:DescribeFeatureType service='WFS' version='2.0.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:sf='" + CiteTestData.PRIMITIVEGEOFEATURE.getNamespaceURI() + "'> <wfs:TypeName>" + typeName + "</wfs:TypeName></wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        this.assertSchema(doc, CiteTestData.PRIMITIVEGEOFEATURE);
        NodeList elements = doc.getElementsByTagName("xsd:element");
        boolean date = false;
        boolean dateTime = false;
        for (int i = 0; i < elements.getLength(); ++i) {
            Element e = (Element)elements.item(i);
            if ("dateProperty".equals(e.getAttribute("name"))) {
                date = "xsd:date".equals(e.getAttribute("type"));
            }
            if (!"dateTimeProperty".equals(e.getAttribute("name"))) continue;
            dateTime = "xsd:dateTime".equals(e.getAttribute("type"));
        }
        Assert.assertTrue((boolean)date);
        Assert.assertTrue((boolean)dateTime);
    }

    @Test
    public void testNoNamespaceDeclaration() throws Exception {
        String typeName = this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE);
        String xml = "<wfs:DescribeFeatureType service='WFS' version='2.0.0' xmlns:wfs='http://www.opengis.net/wfs/2.0'> <wfs:TypeName>" + typeName + "</wfs:TypeName></wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        this.assertSchema(doc, CiteTestData.PRIMITIVEGEOFEATURE);
    }

    @Test
    public void testMultipleTypesImport() throws Exception {
        String typeName1 = this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE);
        String typeName2 = this.getLayerId(CiteTestData.GENERICENTITY);
        String xml = "<wfs:DescribeFeatureType service='WFS' version='2.0.0' xmlns:wfs='http://www.opengis.net/wfs/2.0'> <wfs:TypeName>" + typeName1 + "</wfs:TypeName> <wfs:TypeName>" + typeName2 + "</wfs:TypeName></wfs:DescribeFeatureType>";
        Document doc = this.postAsDOM("wfs", xml);
        this.assertSchema(doc, CiteTestData.PRIMITIVEGEOFEATURE, CiteTestData.GENERICENTITY);
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        boolean seenComplexType = false;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("xsd:complexType")) {
                seenComplexType = true;
                continue;
            }
            if (!seenComplexType || !node.getNodeName().equals("xsd:import")) continue;
            Assert.fail((String)"All xsd:import must occur before all xsd:complexType");
        }
    }

    @Test
    public void testUserSuppliedTypeNameNamespace() throws Exception {
        QName typeName = CiteTestData.POLYGONS;
        String path = "ows?service=WFS&version=2.0.0&request=DescribeFeatureType&typeName=myPrefix:" + typeName.getLocalPart() + "&namespaces=xmlns(myPrefix," + URLEncoder.encode(typeName.getNamespaceURI(), "UTF-8") + ")";
        Document doc = this.getAsDOM(path);
        this.assertSchema(doc, CiteTestData.POLYGONS);
    }

    @Test
    public void testUserSuppliedTypeNameDefaultNamespace() throws Exception {
        QName typeName = CiteTestData.POLYGONS;
        String path = "ows?service=WFS&version=2.0.0&request=DescribeFeatureType&typeName=" + typeName.getLocalPart() + "&namespace=xmlns(" + URLEncoder.encode(typeName.getNamespaceURI(), "UTF-8") + ")";
        Document doc = this.getAsDOM(path);
        this.assertSchema(doc, CiteTestData.POLYGONS);
    }

    @Test
    public void testMissingNameNamespacePrefix() throws Exception {
        QName typeName = CiteTestData.POLYGONS;
        String path = "ows?service=WFS&version=2.0.0&request=DescribeFeatureType&typeName=" + typeName.getLocalPart();
        Document doc = this.getAsDOM(path);
        this.assertSchema(doc, CiteTestData.POLYGONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCiteCompliance() throws Exception {
        QName typeName = CiteTestData.STREAMS;
        Catalog catalog = this.getCatalog();
        NamespaceInfo defaultNs = catalog.getDefaultNamespace();
        GeoServer geoServer = this.getGeoServer();
        WFSInfo service = (WFSInfo)geoServer.getService(WFSInfo.class);
        try {
            catalog.setDefaultNamespace(catalog.getNamespaceByURI(typeName.getNamespaceURI()));
            FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
            typeInfo.setEnabled(true);
            catalog.save((ResourceInfo)typeInfo);
            DataStoreInfo store = typeInfo.getStore();
            store.setEnabled(true);
            catalog.save((StoreInfo)store);
            String path = "ows?service=WFS&version=2.0.0&request=DescribeFeatureType&typeName=" + typeName.getLocalPart();
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
            Document doc = this.getAsDOM(path);
            this.print(doc);
            this.assertSchema(doc, typeName);
            service.setCiteCompliant(true);
            geoServer.save((ServiceInfo)service);
            doc = this.getAsDOM(path, 400);
            Assert.assertEquals((Object)"ows:ExceptionReport", (Object)doc.getDocumentElement().getNodeName());
        }
        finally {
            catalog.setDefaultNamespace(defaultNs);
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPrefixedGetStrictCite() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        WFSInfo service = (WFSInfo)geoServer.getService(WFSInfo.class);
        try {
            service.setCiteCompliant(true);
            geoServer.save((ServiceInfo)service);
            QName typeName = CiteTestData.POLYGONS;
            String path = "ows?service=WFS&version=2.0.0&request=DescribeFeatureType&typeName=" + this.getLayerId(typeName);
            Document doc = this.getAsDOM(path);
            this.assertSchema(doc, CiteTestData.POLYGONS);
        }
        finally {
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
        }
    }

    @Test
    public void testGML32OutputFormat() throws Exception {
        Document dom = this.getAsDOM("ows?service=WFS&version=2.0.0&request=DescribeFeatureType&outputFormat=text/xml;+subtype%3Dgml/3.2&typename=" + this.getLayerId(CiteTestData.POLYGONS));
        this.assertSchema(dom, CiteTestData.POLYGONS);
    }

    @Test
    public void testGMLAttributeMapping() throws Exception {
        WFSInfo wfs = this.getWFS();
        GMLInfo gml = (GMLInfo)wfs.getGML().get(WFSInfo.Version.V_11);
        gml.setOverrideGMLAttributes(Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)wfs);
        Document dom = this.getAsDOM("ows?service=WFS&version=2.0.0&request=DescribeFeatureType&typename=" + this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        this.assertSchema(dom, CiteTestData.PRIMITIVEGEOFEATURE);
        XMLAssert.assertXpathNotExists((String)"//xsd:element[@name = 'name']", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//xsd:element[@name = 'description']", (Document)dom);
        gml.setOverrideGMLAttributes(Boolean.valueOf(true));
        dom = this.getAsDOM("ows?service=WFS&version=2.0.0&request=DescribeFeatureType&typename=" + this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE));
        this.assertSchema(dom, CiteTestData.PRIMITIVEGEOFEATURE);
        XMLAssert.assertXpathExists((String)"//xsd:element[@name = 'name']", (Document)dom);
        XMLAssert.assertXpathExists((String)"//xsd:element[@name = 'description']", (Document)dom);
    }

    @Test
    public void testSOAP() throws Exception {
        String xml = "<soap:Envelope xmlns:soap='http://www.w3.org/2003/05/soap-envelope'>  <soap:Header/>  <soap:Body><wfs:DescribeFeatureType service='WFS' version='2.0.0' xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:sf='" + CiteTestData.PRIMITIVEGEOFEATURE.getNamespaceURI() + "'> <wfs:TypeName>" + this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE) + "</wfs:TypeName></wfs:DescribeFeatureType> </soap:Body> </soap:Envelope> ";
        MockHttpServletResponse resp = this.postAsServletResponse("wfs", xml, "application/soap+xml");
        Assert.assertEquals((Object)"application/soap+xml", (Object)resp.getContentType());
        Document dom = this.dom(new ByteArrayInputStream(resp.getContentAsString().getBytes()));
        Assert.assertEquals((Object)"soap:Envelope", (Object)dom.getDocumentElement().getNodeName());
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"xsd:base64", (String)"//soap:Body/@type", (Document)dom);
        Assert.assertEquals((long)1L, (long)dom.getElementsByTagName("wfs:DescribeFeatureTypeResponse").getLength());
        String base64 = dom.getElementsByTagName("wfs:DescribeFeatureTypeResponse").item(0).getFirstChild().getNodeValue();
        byte[] decoded = Base64.decodeBase64((byte[])base64.getBytes());
        dom = this.dom(new ByteArrayInputStream(decoded));
        Assert.assertEquals((Object)"xsd:schema", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testNoWfsSchemaImport() throws Exception {
        String typeName = this.getLayerId(CiteTestData.PRIMITIVEGEOFEATURE);
        MockHttpServletResponse response = this.getAsServletResponse("wfs?service=WFS&version=2.0.0&request=DescribeFeatureType&typeNames=" + typeName);
        Assert.assertThat((Object)response.getContentType(), (Matcher)CoreMatchers.is((Object)"application/gml+xml; version=3.2"));
        Document doc = this.dom(response, true);
        this.assertSchema(doc, CiteTestData.PRIMITIVEGEOFEATURE);
        XMLAssert.assertXpathNotExists((String)"//xsd:import[@namespace='http://www.opengis.net/wfs/2.0']", (Document)doc);
    }
}

