/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v2_0;

import java.util.Collections;
import javax.xml.namespace.QName;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.v2_0.WFS20TestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class BoundingBox3DTest
extends WFS20TestSupport {
    @Override
    protected void setUpInternal(SystemTestData dataDirectory) throws Exception {
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(false);
        this.getGeoServer().save((ServiceInfo)wfs);
        dataDirectory.addVectorLayer(new QName(SystemTestData.SF_URI, "With3D", SystemTestData.SF_PREFIX), Collections.EMPTY_MAP, org.geoserver.wfs.v1_1.BoundingBox3DTest.class, this.getCatalog());
    }

    @Test
    public void testBBox1() throws Exception {
        Document doc = this.getAsDOM("wfs?request=getfeature&service=wfs&version=2.0.0&typename=sf:With3D&bbox=-200,-200,0,200,200,50");
        this.assertGML32(doc);
        NodeList features = doc.getElementsByTagName("sf:With3D");
        Assert.assertEquals((long)1L, (long)features.getLength());
        Assert.assertEquals((Object)features.item(0).getAttributes().getNamedItem("gml:id").getNodeValue(), (Object)"fid1");
    }

    @Test
    public void testBBox2() throws Exception {
        Document doc = this.getAsDOM("wfs?request=getfeature&service=wfs&version=2.0.0&typename=sf:With3D&bbox=-200,-200,50,200,200,100");
        this.assertGML32(doc);
        NodeList features = doc.getElementsByTagName("sf:With3D");
        Assert.assertEquals((long)1L, (long)features.getLength());
        Assert.assertEquals((Object)features.item(0).getAttributes().getNamedItem("gml:id").getNodeValue(), (Object)"fid2");
    }
}

