/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.util.Collections;
import net.opengis.ows10.Ows10Factory;
import net.opengis.wfs.GetCapabilitiesType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.wfs.CapabilitiesTransformer;
import org.geoserver.wfs.GetCapabilities;
import org.geoserver.wfs.WFSTestSupport;
import org.geoserver.wfs.request.GetCapabilitiesRequest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VersionNegotiationTest
extends WFSTestSupport {
    static GetCapabilities getCaps;
    static WfsFactory factory;
    static Ows10Factory owsFactory;

    @Before
    public void initialise() {
        getCaps = new GetCapabilities(this.getWFS(), this.getCatalog(), Collections.emptyList());
        factory = WfsFactory.eINSTANCE;
        owsFactory = Ows10Factory.eINSTANCE;
    }

    @Test
    public void test0() throws Exception {
        GetCapabilitiesType request = factory.createGetCapabilitiesType();
        request.setService("WFS");
        request.setAcceptVersions(owsFactory.createAcceptVersionsType());
        request.getAcceptVersions().getVersion().add((Object)"1.0.0");
        request.getAcceptVersions().getVersion().add((Object)"1.1.0");
        CapabilitiesTransformer tx = getCaps.run(GetCapabilitiesRequest.adapt((Object)request));
        Assert.assertTrue((boolean)(tx instanceof CapabilitiesTransformer.WFS1_1));
    }

    @Test
    public void test1() throws Exception {
        GetCapabilitiesType request = factory.createGetCapabilitiesType();
        request.setService("WFS");
        request.setAcceptVersions(owsFactory.createAcceptVersionsType());
        request.getAcceptVersions().getVersion().add((Object)"1.0.0");
        CapabilitiesTransformer tx = getCaps.run(GetCapabilitiesRequest.adapt((Object)request));
        Assert.assertTrue((boolean)(tx instanceof CapabilitiesTransformer.WFS1_0));
    }

    @Test
    public void test2() throws Exception {
        GetCapabilitiesType request = factory.createGetCapabilitiesType();
        request.setService("WFS");
        request.setAcceptVersions(owsFactory.createAcceptVersionsType());
        request.getAcceptVersions().getVersion().add((Object)"1.1.0");
        CapabilitiesTransformer tx = getCaps.run(GetCapabilitiesRequest.adapt((Object)request));
        Assert.assertTrue((boolean)(tx instanceof CapabilitiesTransformer.WFS1_1));
    }

    @Test
    public void test5() throws Exception {
        GetCapabilitiesType request = factory.createGetCapabilitiesType();
        request.setService("WFS");
        request.setAcceptVersions(owsFactory.createAcceptVersionsType());
        request.getAcceptVersions().getVersion().add((Object)"0.0.0");
        CapabilitiesTransformer tx = getCaps.run(GetCapabilitiesRequest.adapt((Object)request));
        Assert.assertTrue((boolean)(tx instanceof CapabilitiesTransformer.WFS1_0));
    }

    @Test
    public void test6() throws Exception {
        GetCapabilitiesType request = factory.createGetCapabilitiesType();
        request.setService("WFS");
        request.setAcceptVersions(owsFactory.createAcceptVersionsType());
        request.getAcceptVersions().getVersion().add((Object)"1.1.1");
        CapabilitiesTransformer tx = getCaps.run(GetCapabilitiesRequest.adapt((Object)request));
        Assert.assertTrue((boolean)(tx instanceof CapabilitiesTransformer.WFS1_1));
    }

    @Test
    public void test7() throws Exception {
        GetCapabilitiesType request = factory.createGetCapabilitiesType();
        request.setService("WFS");
        request.setAcceptVersions(owsFactory.createAcceptVersionsType());
        request.getAcceptVersions().getVersion().add((Object)"1.0.5");
        CapabilitiesTransformer tx = getCaps.run(GetCapabilitiesRequest.adapt((Object)request));
        Assert.assertTrue((boolean)(tx instanceof CapabilitiesTransformer.WFS1_0));
    }
}

